/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.gerrit;

import com.google.common.base.MoreObjects;
import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritManagement;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import me.redaalaoui.gerrit_rest_java_client.rest.GerritAuthData;
import me.redaalaoui.gerrit_rest_java_client.rest.GerritRestApiFactory;
import me.redaalaoui.gerrit_rest_java_client.rest.http.HttpClientBuilderExtension;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.GerritApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.RestApiException;
import org.jenkinsci.plugins.sonargerrit.gerrit.GerritConnectionInfo;
import org.jenkinsci.plugins.sonargerrit.gerrit.GerritRevision;
import org.jenkinsci.plugins.sonargerrit.util.DataHelper;
import org.jenkinsci.plugins.sonargerrit.util.Localization;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class GerritConnector {
    private final GerritConnectionInfo connectionInfo;
    private final GerritApi gerritApi;

    private GerritConnector(GerritConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        String serverName = connectionInfo.getServerName();
        IGerritHudsonTriggerConfig gerritConfig = GerritManagement.getConfig((String)serverName);
        DataHelper.checkNotNull(gerritConfig, "jenkins.plugin.error.gerrit.config.empty");
        String gerritFrontEndUrl = gerritConfig.getGerritFrontEndUrl();
        this.checkRestApiAllowed(gerritConfig.isUseRestApi());
        String username = this.getUsername(connectionInfo.getUsername(), gerritConfig);
        String password = this.getPassword(connectionInfo.getPassword(), gerritConfig);
        DataHelper.checkNotEmpty(username, "jenkins.plugin.error.gerrit.user.empty");
        GerritRestApiFactory gerritRestApiFactory = new GerritRestApiFactory();
        GerritAuthData.Basic authData = new GerritAuthData.Basic(gerritFrontEndUrl, username, password, true);
        this.gerritApi = gerritRestApiFactory.create((GerritAuthData)authData, new HttpClientBuilderExtension[0]);
    }

    public static GerritConnector connect(GerritConnectionInfo connectionInfo) {
        return new GerritConnector(connectionInfo);
    }

    public GerritRevision fetchRevision() throws RestApiException {
        return GerritRevision.load(this.gerritApi.changes().id(this.connectionInfo.getChangeNumber()).revision(this.connectionInfo.getPatchsetNumber()));
    }

    private void checkRestApiAllowed(boolean useRestApi) {
        if (!useRestApi) {
            throw new IllegalStateException(Localization.getLocalized("jenkins.plugin.error.gerrit.restapi.off"));
        }
    }

    private String getUsername(String username, IGerritHudsonTriggerConfig gerritConfig) {
        return (String)MoreObjects.firstNonNull((Object)username, (Object)gerritConfig.getGerritHttpUserName());
    }

    private String getPassword(String password, IGerritHudsonTriggerConfig gerritConfig) {
        return (String)MoreObjects.firstNonNull((Object)password, (Object)gerritConfig.getGerritHttpPassword());
    }
}

