/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.gerrit;

import org.jenkinsci.plugins.sonargerrit.sonar.Issue;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class CustomIssueFormatter {
    private final Issue issue;
    private final String text;

    public CustomIssueFormatter(Issue issue, String text) {
        this.issue = issue;
        this.text = text;
    }

    public String getMessage() {
        String res = this.text;
        for (Tag tag : Tag.values()) {
            if (!res.contains(tag.getName())) continue;
            res = res.replace(tag.getName(), this.getValueToReplace(tag));
        }
        return res;
    }

    private String getValueToReplace(Tag tag) {
        switch (tag.ordinal()) {
            case 0: {
                return this.issue.getKey();
            }
            case 1: {
                return this.issue.getComponent();
            }
            case 2: {
                return this.issue.getMessage();
            }
            case 3: {
                return this.issue.getSeverity().name();
            }
            case 4: {
                return this.issue.getRule();
            }
            case 5: {
                return this.issue.getRuleUrl();
            }
            case 6: {
                return this.issue.getStatus();
            }
            case 7: {
                return this.issue.getCreationDate().toString();
            }
        }
        throw new IllegalArgumentException("Unexpected tag " + String.valueOf((Object)tag));
    }

    public static enum Tag {
        KEY("<key>"),
        COMPONENT("<component>"),
        MESSAGE("<message>"),
        SEVERITY("<severity>"),
        RULE("<rule>"),
        RULE_URL("<rule_url>"),
        STATUS("<status>"),
        CREATION_DATE("<creation_date>");

        private final String name;

        private Tag(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

