/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Multimap;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.NotifyHandling;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.ReviewInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.RestApiException;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.sonargerrit.TaskListenerLogger;
import org.jenkinsci.plugins.sonargerrit.gerrit.GerritAuthenticationConfig;
import org.jenkinsci.plugins.sonargerrit.gerrit.GerritConnectionInfo;
import org.jenkinsci.plugins.sonargerrit.gerrit.GerritConnector;
import org.jenkinsci.plugins.sonargerrit.gerrit.GerritReviewBuilder;
import org.jenkinsci.plugins.sonargerrit.gerrit.GerritRevision;
import org.jenkinsci.plugins.sonargerrit.gerrit.NotificationConfig;
import org.jenkinsci.plugins.sonargerrit.gerrit.ReviewConfig;
import org.jenkinsci.plugins.sonargerrit.gerrit.ScoreConfig;
import org.jenkinsci.plugins.sonargerrit.sonar.Inspection;
import org.jenkinsci.plugins.sonargerrit.sonar.InspectionReport;
import org.jenkinsci.plugins.sonargerrit.sonar.Issue;
import org.jenkinsci.plugins.sonargerrit.sonar.IssueFilter;
import org.jenkinsci.plugins.sonargerrit.sonar.IssueFilterConfig;
import org.jenkinsci.plugins.sonargerrit.sonar.Severity;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SubJobConfig;
import org.jenkinsci.plugins.sonargerrit.util.BackCompatibilityHelper;
import org.jenkinsci.plugins.sonargerrit.util.Localization;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SonarToGerritPublisher
extends Notifier
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(SonarToGerritPublisher.class.getName());
    @Nonnull
    private Inspection inspectionConfig = new Inspection();
    @Nonnull
    private NotificationConfig notificationConfig = new NotificationConfig();
    @Nonnull
    private ReviewConfig reviewConfig = new ReviewConfig();
    private ScoreConfig scoreConfig = null;
    private GerritAuthenticationConfig authConfig = null;
    private final BackCompatibilityHelper backCompatibilityHelper = new BackCompatibilityHelper(this);

    @DataBoundConstructor
    public SonarToGerritPublisher() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @NonNull EnvVars env, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        GerritTrigger trigger = GerritTrigger.getTrigger((Job)run.getParent());
        GerritConnectionInfo connectionInfo = new GerritConnectionInfo((Map<String, String>)env, trigger, this.authConfig, (Item)run.getParent());
        try {
            boolean postScore;
            GerritRevision revision = GerritConnector.connect(connectionInfo).fetchRevision();
            InspectionReport report = this.inspectionConfig.analyse(run, listener, revision, filePath);
            Map<String, Set<Integer>> fileToChangedLines = revision.getFileToChangedLines();
            Multimap<String, Issue> file2issuesToComment = this.getFilteredFileToIssueMultimap(this.reviewConfig.getIssueFilterConfig(), report, fileToChangedLines);
            TaskListenerLogger.logMessage(listener, LOGGER, Level.INFO, "jenkins.plugin.issues.to.comment", file2issuesToComment.entries().size());
            Multimap<String, Issue> file2issuesToScore = null;
            boolean bl = postScore = this.scoreConfig != null;
            if (postScore) {
                file2issuesToScore = this.getFilteredFileToIssueMultimap(this.scoreConfig.getIssueFilterConfig(), report, fileToChangedLines);
                TaskListenerLogger.logMessage(listener, LOGGER, Level.INFO, "jenkins.plugin.issues.to.score", file2issuesToScore.entries().size());
            }
            ReviewInput reviewInput = new GerritReviewBuilder(file2issuesToComment, file2issuesToScore, this.reviewConfig, this.scoreConfig, this.notificationConfig).buildReview();
            revision.sendReview(reviewInput);
            TaskListenerLogger.logMessage(listener, LOGGER, Level.INFO, "jenkins.plugin.review.sent", new Object[0]);
        }
        catch (RestApiException e) {
            LOGGER.log(Level.SEVERE, e, () -> "Unable to post review: " + e.getMessage());
            throw new AbortException("Unable to post review: " + e.getMessage());
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LOGGER.log(Level.SEVERE, e, e::getMessage);
            throw new IOException(e.getMessage(), e);
        }
    }

    private Multimap<String, Issue> getFilteredFileToIssueMultimap(IssueFilterConfig filterConfig, InspectionReport report, Map<String, Set<Integer>> fileToChangedLines) {
        IssueFilter commentFilter = new IssueFilter(filterConfig, report.getIssues(), fileToChangedLines);
        Iterable<Issue> issuesToComment = commentFilter.filter();
        return Issue.asMultimap(issuesToComment);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Nonnull
    public Inspection getInspectionConfig() {
        return this.inspectionConfig;
    }

    @Nonnull
    public NotificationConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    @Nonnull
    public ReviewConfig getReviewConfig() {
        return this.reviewConfig;
    }

    public ScoreConfig getScoreConfig() {
        return this.scoreConfig;
    }

    public GerritAuthenticationConfig getAuthConfig() {
        return this.authConfig;
    }

    @DataBoundSetter
    public void setInspectionConfig(Inspection inspectionConfig) {
        this.inspectionConfig = (Inspection)((Object)MoreObjects.firstNonNull((Object)((Object)inspectionConfig), (Object)((Object)new Inspection())));
    }

    @DataBoundSetter
    public void setNotificationConfig(NotificationConfig notificationConfig) {
        this.notificationConfig = (NotificationConfig)((Object)MoreObjects.firstNonNull((Object)((Object)notificationConfig), (Object)((Object)new NotificationConfig())));
    }

    @DataBoundSetter
    public void setReviewConfig(ReviewConfig reviewConfig) {
        this.reviewConfig = (ReviewConfig)((Object)MoreObjects.firstNonNull((Object)((Object)reviewConfig), (Object)((Object)new ReviewConfig())));
    }

    @DataBoundSetter
    public void setScoreConfig(ScoreConfig scoreConfig) {
        this.scoreConfig = scoreConfig;
    }

    @DataBoundSetter
    public void setAuthConfig(GerritAuthenticationConfig authConfig) {
        this.authConfig = authConfig;
    }

    @Deprecated
    @DataBoundSetter
    public void setSonarURL(String sonarURL) {
        this.backCompatibilityHelper.setSonarURL(sonarURL);
    }

    @Deprecated
    @DataBoundSetter
    public void setSubJobConfigs(List<SubJobConfig> subJobConfigs) {
        this.backCompatibilityHelper.setSubJobConfigs(subJobConfigs);
    }

    @Deprecated
    @DataBoundSetter
    public void setSeverity(String severity) {
        this.backCompatibilityHelper.setSeverity(severity);
    }

    @Deprecated
    @DataBoundSetter
    public void setNewIssuesOnly(boolean newIssuesOnly) {
        this.backCompatibilityHelper.setNewIssuesOnly(newIssuesOnly);
    }

    @Deprecated
    @DataBoundSetter
    public void setChangedLinesOnly(boolean changedLinesOnly) {
        this.backCompatibilityHelper.setChangedLinesOnly(changedLinesOnly);
    }

    @Deprecated
    @DataBoundSetter
    public void setNoIssuesToPostText(String noIssuesToPost) {
        this.backCompatibilityHelper.setNoIssuesToPostText(noIssuesToPost);
    }

    @Deprecated
    @DataBoundSetter
    public void setSomeIssuesToPostText(String someIssuesToPost) {
        this.backCompatibilityHelper.setSomeIssuesToPostText(someIssuesToPost);
    }

    @Deprecated
    @DataBoundSetter
    public void setIssueComment(String issueComment) {
        this.backCompatibilityHelper.setIssueComment(issueComment);
    }

    @Deprecated
    @DataBoundSetter
    public void setOverrideCredentials(boolean overrideCredentials) {
        this.backCompatibilityHelper.setOverrideCredentials(overrideCredentials);
    }

    @Deprecated
    @DataBoundSetter
    public void setPostScore(boolean postScore) {
        this.backCompatibilityHelper.setPostScore(postScore);
    }

    @Deprecated
    @DataBoundSetter
    public void setCategory(String category) {
        this.backCompatibilityHelper.setCategory(category);
    }

    @Deprecated
    @DataBoundSetter
    public void setNoIssuesScore(String score) {
        this.backCompatibilityHelper.setNoIssuesScore(score);
    }

    @Deprecated
    @DataBoundSetter
    public void setIssuesScore(String score) {
        this.backCompatibilityHelper.setIssuesScore(score);
    }

    @Deprecated
    @DataBoundSetter
    public void setNoIssuesNotification(String notification) {
        this.backCompatibilityHelper.setNoIssuesNotification(notification);
    }

    @Deprecated
    @DataBoundSetter
    public void setIssuesNotification(String notification) {
        this.backCompatibilityHelper.setIssuesNotification(notification);
    }

    @Deprecated
    @DataBoundSetter
    public void setProjectPath(String path) {
        this.backCompatibilityHelper.setProjectPath(path);
    }

    @Deprecated
    @DataBoundSetter
    public void setPath(String path) {
        this.backCompatibilityHelper.setPath(path);
    }

    @Deprecated
    public String getSonarURL() {
        return this.backCompatibilityHelper.getSonarURL();
    }

    @Deprecated
    public Collection<SubJobConfig> getSubJobConfigs() {
        return this.backCompatibilityHelper.getSubJobConfigs();
    }

    @Deprecated
    public String getSeverity() {
        return this.backCompatibilityHelper.getSeverity();
    }

    @Deprecated
    public boolean isNewIssuesOnly() {
        return this.backCompatibilityHelper.isNewIssuesOnly();
    }

    @Deprecated
    public boolean isChangedLinesOnly() {
        return this.backCompatibilityHelper.isChangedLinesOnly();
    }

    @Deprecated
    public String getNoIssuesToPostText() {
        return this.backCompatibilityHelper.getNoIssuesToPostText();
    }

    @Deprecated
    public String getSomeIssuesToPostText() {
        return this.backCompatibilityHelper.getSomeIssuesToPostText();
    }

    @Deprecated
    public String getIssueComment() {
        return this.backCompatibilityHelper.getIssueComment();
    }

    @Deprecated
    public boolean isOverrideCredentials() {
        return this.backCompatibilityHelper.isOverrideCredentials();
    }

    @Deprecated
    @DataBoundSetter
    public void setHttpUsername(String httpUsername) {
        this.backCompatibilityHelper.setHttpUsername(httpUsername);
    }

    @Deprecated
    public String getHttpUsername() {
        return this.backCompatibilityHelper.getHttpUsername();
    }

    @Deprecated
    @DataBoundSetter
    public void setHttpPassword(String httpPassword) {
        this.backCompatibilityHelper.setHttpPassword(httpPassword);
    }

    @Deprecated
    public String getHttpPassword() {
        return this.backCompatibilityHelper.getHttpPassword();
    }

    @Deprecated
    public boolean isPostScore() {
        return this.backCompatibilityHelper.isPostScore();
    }

    @Deprecated
    public String getCategory() {
        return this.backCompatibilityHelper.getCategory();
    }

    @Deprecated
    public String getNoIssuesScore() {
        return this.backCompatibilityHelper.getNoIssuesScore();
    }

    @Deprecated
    public String getIssuesScore() {
        return this.backCompatibilityHelper.getIssuesScore();
    }

    @Deprecated
    public String getNoIssuesNotification() {
        return this.backCompatibilityHelper.getNoIssuesNotification();
    }

    @Deprecated
    public String getIssuesNotification() {
        return this.backCompatibilityHelper.getIssuesNotification();
    }

    @Deprecated
    public String getProjectPath() {
        return this.backCompatibilityHelper.getProjectPath();
    }

    @Deprecated
    public String getPath() {
        return this.backCompatibilityHelper.getPath();
    }

    @Symbol(value={"sonarToGerrit"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final NotifyHandling NOTIFICATION_RECIPIENT_NO_ISSUES = NotifyHandling.NONE;
        public static final NotifyHandling NOTIFICATION_RECIPIENT_SOME_ISSUES = NotifyHandling.OWNER;
        public static final NotifyHandling NOTIFICATION_RECIPIENT_NEGATIVE_SCORE = NotifyHandling.OWNER;
        public static final String PROJECT_PATH = "";
        public static final String SONAR_REPORT_PATH = "target/sonar/sonar-report.json";
        public static final String SONAR_URL = "http://localhost:9000";
        public static final String DEFAULT_INSPECTION_CONFIG_TYPE = "base";
        public static final boolean AUTO_MATCH_INSPECTION_AND_REVISION_PATHS = false;
        public static final String NO_ISSUES_TEXT = Localization.getLocalized("jenkins.plugin.default.review.title.no.issues");
        public static final String SOME_ISSUES_TEXT = Localization.getLocalized("jenkins.plugin.default.review.title.issues");
        public static final String ISSUE_COMMENT_TEXT = Localization.getLocalized("jenkins.plugin.default.review.body");
        public static final boolean ISSUE_OMIT_DUPLICATE_COMMENTS = false;
        public static final String CATEGORY = "Code-Review";
        public static final Integer NO_ISSUES_SCORE = 1;
        public static final Integer SOME_ISSUES_SCORE = -1;
        public static final String SEVERITY = Severity.INFO.name();
        public static final boolean NEW_ISSUES_ONLY = false;
        public static final boolean CHANGED_LINES_ONLY = false;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Localization.getLocalized("jenkins.plugin.build.step.name");
        }
    }
}

