/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.ProjectApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.ProjectInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.client.ProjectState;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.ProjectInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.NotImplementedException;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.RestApiException;

public interface Projects {
    public ProjectApi name(String var1) throws RestApiException;

    public ProjectApi create(String var1) throws RestApiException;

    public ProjectApi create(ProjectInput var1) throws RestApiException;

    public ListRequest list();

    public QueryRequest query();

    public QueryRequest query(String var1);

    public static class NotImplemented
    implements Projects {
        @Override
        public ProjectApi name(String name) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ProjectApi create(ProjectInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ProjectApi create(String name) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ListRequest list() {
            throw new NotImplementedException();
        }

        @Override
        public QueryRequest query() {
            throw new NotImplementedException();
        }

        @Override
        public QueryRequest query(String query) {
            throw new NotImplementedException();
        }
    }

    public static abstract class QueryRequest {
        private String query;
        private int limit;
        private int start;

        public abstract List<ProjectInfo> get() throws RestApiException;

        public QueryRequest withQuery(String query) {
            this.query = query;
            return this;
        }

        public QueryRequest withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public QueryRequest withStart(int start) {
            this.start = start;
            return this;
        }

        public String getQuery() {
            return this.query;
        }

        public int getLimit() {
            return this.limit;
        }

        public int getStart() {
            return this.start;
        }
    }

    public static abstract class ListRequest {
        private final List<String> branches = new ArrayList<String>();
        private boolean description;
        private String prefix;
        private String substring;
        private String regex;
        private int limit;
        private int start;
        private boolean showTree;
        private boolean all;
        private FilterType type = FilterType.ALL;
        private ProjectState state = null;

        public List<ProjectInfo> get() throws RestApiException {
            SortedMap<String, ProjectInfo> map = this.getAsMap();
            ArrayList<ProjectInfo> result = new ArrayList<ProjectInfo>(map.size());
            for (Map.Entry e : map.entrySet()) {
                ((ProjectInfo)e.getValue()).name = (String)e.getKey();
                result.add((ProjectInfo)e.getValue());
            }
            return Collections.unmodifiableList(result);
        }

        public abstract SortedMap<String, ProjectInfo> getAsMap() throws RestApiException;

        public ListRequest withDescription(boolean description) {
            this.description = description;
            return this;
        }

        public ListRequest withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public ListRequest withSubstring(String substring) {
            this.substring = substring;
            return this;
        }

        public ListRequest withRegex(String regex) {
            this.regex = regex;
            return this;
        }

        public ListRequest withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public ListRequest withStart(int start) {
            this.start = start;
            return this;
        }

        public ListRequest addShowBranch(String branch) {
            this.branches.add(branch);
            return this;
        }

        public ListRequest withTree(boolean show) {
            this.showTree = show;
            return this;
        }

        public ListRequest withType(FilterType type) {
            this.type = type != null ? type : FilterType.ALL;
            return this;
        }

        public ListRequest withAll(boolean all) {
            this.all = all;
            return this;
        }

        public ListRequest withState(ProjectState state) {
            this.state = state;
            return this;
        }

        public boolean getDescription() {
            return this.description;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSubstring() {
            return this.substring;
        }

        public String getRegex() {
            return this.regex;
        }

        public int getLimit() {
            return this.limit;
        }

        public int getStart() {
            return this.start;
        }

        public List<String> getBranches() {
            return Collections.unmodifiableList(this.branches);
        }

        public boolean getShowTree() {
            return this.showTree;
        }

        public FilterType getFilterType() {
            return this.type;
        }

        public boolean isAll() {
            return this.all;
        }

        public ProjectState getState() {
            return this.state;
        }

        public static enum FilterType {
            CODE,
            PERMISSIONS,
            ALL;

        }
    }
}

