/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.AddReviewerInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.AttentionSetInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.NotifyHandling;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.NotifyInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.RecipientType;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.client.Comment;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.client.ReviewerState;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.FixSuggestionInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.DefaultInput;

public class ReviewInput {
    @DefaultInput
    public String message;
    public String tag;
    public Map<String, Short> labels;
    public Map<String, List<CommentInput>> comments;
    public Map<String, List<RobotCommentInput>> robotComments;
    public DraftHandling drafts;
    public NotifyHandling notify;
    public Map<RecipientType, NotifyInfo> notifyDetails;
    public boolean omitDuplicateComments;
    public String onBehalfOf;
    public List<AddReviewerInput> reviewers;
    public boolean workInProgress;
    public boolean ready;
    public List<AttentionSetInput> addToAttentionSet;
    public List<AttentionSetInput> removeFromAttentionSet;
    public boolean ignoreAutomaticAttentionSetRules;

    public ReviewInput message(String msg) {
        this.message = msg != null && !msg.isEmpty() ? msg : null;
        return this;
    }

    public ReviewInput label(String name, short value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (this.labels == null) {
            this.labels = new LinkedHashMap<String, Short>(4);
        }
        this.labels.put(name, value);
        return this;
    }

    public ReviewInput label(String name, int value) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.label(name, (short)value);
    }

    public ReviewInput label(String name) {
        return this.label(name, (short)1);
    }

    public ReviewInput reviewer(String reviewer) {
        return this.reviewer(reviewer, ReviewerState.REVIEWER, false);
    }

    public ReviewInput reviewer(String reviewer, ReviewerState state, boolean confirmed) {
        AddReviewerInput input = new AddReviewerInput();
        input.reviewer = reviewer;
        input.state = state;
        input.confirmed = confirmed;
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<AddReviewerInput>();
        }
        this.reviewers.add(input);
        return this;
    }

    public ReviewInput addUserToAttentionSet(String user, String reason) {
        AttentionSetInput input = new AttentionSetInput();
        input.user = user;
        input.reason = reason;
        if (this.addToAttentionSet == null) {
            this.addToAttentionSet = new ArrayList<AttentionSetInput>();
        }
        this.addToAttentionSet.add(input);
        return this;
    }

    public ReviewInput removeUserFromAttentionSet(String user, String reason) {
        AttentionSetInput input = new AttentionSetInput();
        input.user = user;
        input.reason = reason;
        if (this.removeFromAttentionSet == null) {
            this.removeFromAttentionSet = new ArrayList<AttentionSetInput>();
        }
        this.removeFromAttentionSet.add(input);
        return this;
    }

    public ReviewInput blockAutomaticAttentionSetRules() {
        this.ignoreAutomaticAttentionSetRules = true;
        return this;
    }

    public ReviewInput setWorkInProgress(boolean workInProgress) {
        this.workInProgress = workInProgress;
        this.ready = !workInProgress;
        return this;
    }

    public ReviewInput setReady(boolean ready) {
        this.ready = ready;
        this.workInProgress = !ready;
        return this;
    }

    public static ReviewInput recommend() {
        return new ReviewInput().label("Code-Review", 1);
    }

    public static ReviewInput dislike() {
        return new ReviewInput().label("Code-Review", -1);
    }

    public static ReviewInput noScore() {
        return new ReviewInput().label("Code-Review", 0);
    }

    public static ReviewInput approve() {
        return new ReviewInput().label("Code-Review", 2);
    }

    public static ReviewInput reject() {
        return new ReviewInput().label("Code-Review", -2);
    }

    public static ReviewInput create() {
        return new ReviewInput();
    }

    public static class RobotCommentInput
    extends CommentInput {
        public String robotId;
        public String robotRunId;
        public String url;
        public Map<String, String> properties;
        public List<FixSuggestionInfo> fixSuggestions;
    }

    public static class CommentInput
    extends Comment {
    }

    public static enum DraftHandling {
        KEEP,
        PUBLISH,
        PUBLISH_ALL_REVISIONS;

    }
}

