/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.rest.http.projects;

import java.util.SortedMap;
import java.util.TreeMap;
import me.redaalaoui.gerrit_rest_java_client.rest.http.GerritRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.projects.BranchInfoParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.projects.ProjectApiRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.projects.ProjectsParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.projects.TagInfoParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.util.UrlUtils;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.common.base.Strings;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.ProjectApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.ProjectInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.Projects;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.ProjectInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.RestApiException;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.Url;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonElement;

public class ProjectsRestClient
extends Projects.NotImplemented
implements Projects {
    private final GerritRestClient gerritRestClient;
    private final ProjectsParser projectsParser;
    private final BranchInfoParser branchInfoParser;
    private final TagInfoParser tagInfoParser;

    public ProjectsRestClient(GerritRestClient gerritRestClient, ProjectsParser projectsParser, BranchInfoParser branchInfoParser, TagInfoParser tagInfoParser) {
        this.gerritRestClient = gerritRestClient;
        this.projectsParser = projectsParser;
        this.branchInfoParser = branchInfoParser;
        this.tagInfoParser = tagInfoParser;
    }

    @Override
    public Projects.ListRequest list() {
        return new Projects.ListRequest(){

            @Override
            public SortedMap<String, ProjectInfo> getAsMap() throws RestApiException {
                return ProjectsRestClient.this.list(this);
            }
        };
    }

    @Override
    public ProjectApi name(String name) throws RestApiException {
        return new ProjectApiRestClient(this.gerritRestClient, this.projectsParser, this.branchInfoParser, this.tagInfoParser, name);
    }

    private SortedMap<String, ProjectInfo> list(Projects.ListRequest listParameter) throws RestApiException {
        JsonElement result;
        Projects.ListRequest.FilterType filterType;
        String query = "";
        if (listParameter.getDescription()) {
            query = UrlUtils.appendToUrlQuery(query, "d");
        }
        if (listParameter.getShowTree()) {
            query = UrlUtils.appendToUrlQuery(query, "t");
        }
        if (!Strings.isNullOrEmpty(listParameter.getPrefix())) {
            query = UrlUtils.appendToUrlQuery(query, "p=" + listParameter.getPrefix());
        }
        if (listParameter.getLimit() > 0) {
            query = UrlUtils.appendToUrlQuery(query, "n=" + listParameter.getLimit());
        }
        if (listParameter.getStart() > 0) {
            query = UrlUtils.appendToUrlQuery(query, "S=" + listParameter.getStart());
        }
        if ((filterType = listParameter.getFilterType()) != null && filterType != Projects.ListRequest.FilterType.ALL) {
            query = UrlUtils.appendToUrlQuery(query, "type=" + (Object)((Object)filterType));
        }
        String url = "/projects/";
        if (!Strings.isNullOrEmpty(query)) {
            url = url + '?' + query;
        }
        if ((result = this.gerritRestClient.getRequest(url)) == null) {
            return new TreeMap<String, ProjectInfo>();
        }
        return this.projectsParser.parseProjectInfos(result);
    }

    @Override
    public ProjectApi create(String name) throws RestApiException {
        ProjectInput projectInput = new ProjectInput();
        projectInput.name = name;
        return this.create(projectInput);
    }

    @Override
    public ProjectApi create(ProjectInput in) throws RestApiException {
        if (in.name == null) {
            throw new IllegalArgumentException("Name must be set in project creation input.");
        }
        String url = String.format("/projects/%s", Url.encode(in.name));
        String projectInput = this.projectsParser.generateProjectInput(in);
        JsonElement result = this.gerritRestClient.putRequest(url, projectInput);
        ProjectInfo info = this.projectsParser.parseSingleProjectInfo(result);
        return new ProjectApiRestClient(this.gerritRestClient, this.projectsParser, this.branchInfoParser, this.tagInfoParser, info.name);
    }
}

