/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.rest.http.projects;

import java.util.List;
import me.redaalaoui.gerrit_rest_java_client.rest.http.GerritRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.projects.BranchApiRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.projects.BranchInfoParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.projects.LabelApiRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.projects.ProjectsParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.projects.TagApiRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.projects.TagInfoParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.util.UrlUtils;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.common.base.Strings;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.access.ProjectAccessInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.access.ProjectAccessInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.BranchApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.BranchInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.LabelApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.ProjectApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.ProjectInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.TagApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.TagInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.ProjectInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.NotImplementedException;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.RestApiException;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.Url;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonElement;

public class ProjectApiRestClient
extends ProjectApi.NotImplemented
implements ProjectApi {
    private final GerritRestClient gerritRestClient;
    private final ProjectsParser projectsParser;
    private final BranchInfoParser branchInfoParser;
    private final TagInfoParser tagInfoParser;
    private final String name;

    public ProjectApiRestClient(GerritRestClient gerritRestClient, ProjectsParser projectsParser, BranchInfoParser branchInfoParser, TagInfoParser tagInfoParser, String name) {
        this.gerritRestClient = gerritRestClient;
        this.projectsParser = projectsParser;
        this.branchInfoParser = branchInfoParser;
        this.tagInfoParser = tagInfoParser;
        this.name = name;
    }

    @Override
    public ProjectInfo get() {
        try {
            JsonElement jsonElement = this.gerritRestClient.getRequest(this.projectsUrl());
            return this.projectsParser.parseSingleProjectInfo(jsonElement);
        }
        catch (RestApiException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ProjectApi create() throws RestApiException {
        this.gerritRestClient.putRequest(this.projectsUrl());
        return this;
    }

    @Override
    public ProjectApi create(ProjectInput in) throws RestApiException {
        String body = this.gerritRestClient.getGson().toJson(in);
        this.gerritRestClient.putRequest(this.projectsUrl(), body);
        return this;
    }

    @Override
    public ProjectApi.ListRefsRequest<BranchInfo> branches() {
        return new ProjectApi.ListRefsRequest<BranchInfo>(){

            @Override
            public List<BranchInfo> get() throws RestApiException {
                return ProjectApiRestClient.this.getBranches(this);
            }
        };
    }

    @Override
    public BranchApi branch(String ref) throws RestApiException {
        return new BranchApiRestClient(this.gerritRestClient, this.branchInfoParser, this, ref);
    }

    private List<BranchInfo> getBranches(ProjectApi.ListRefsRequest<BranchInfo> lbr) throws RestApiException {
        String request = this.projectsUrl() + this.branchesUrl(lbr);
        JsonElement branches = this.gerritRestClient.getRequest(request);
        return this.branchInfoParser.parseBranchInfos(branches);
    }

    @Override
    public ProjectApi.ListRefsRequest<TagInfo> tags() {
        return new ProjectApi.ListRefsRequest<TagInfo>(){

            @Override
            public List<TagInfo> get() throws RestApiException {
                return ProjectApiRestClient.this.getTagInfos(this);
            }
        };
    }

    @Override
    public TagApi tag(String ref) throws RestApiException {
        return new TagApiRestClient(this.gerritRestClient, this.tagInfoParser, this, ref);
    }

    private List<TagInfo> getTagInfos(ProjectApi.ListRefsRequest<TagInfo> lrr) throws RestApiException {
        String request = this.projectsUrl() + this.tagsUrl(lrr);
        JsonElement tags = this.gerritRestClient.getRequest(request);
        return this.tagInfoParser.parseTagInfos(tags);
    }

    @Override
    public ProjectAccessInfo access() throws RestApiException {
        String request = this.projectsUrl() + "/access";
        JsonElement result = this.gerritRestClient.getRequest(request);
        return this.projectsParser.parseProjectAccessInfo(result);
    }

    @Override
    public ProjectAccessInfo access(ProjectAccessInput p) throws RestApiException {
        String request = this.projectsUrl() + "/access";
        String params = this.projectsParser.generateProjectAccessInput(p);
        JsonElement result = this.gerritRestClient.postRequest(request, params);
        return this.projectsParser.parseProjectAccessInfo(result);
    }

    @Override
    public LabelApi label(String labelName) throws RestApiException {
        return new LabelApiRestClient(this.gerritRestClient, this, labelName);
    }

    protected String projectsUrl() {
        return "/projects/" + Url.encode(this.name);
    }

    private String branchesUrl(ProjectApi.ListRefsRequest<BranchInfo> lbr) {
        String query = "";
        if (lbr.getLimit() != 0) {
            query = UrlUtils.appendToUrlQuery(query, "n=" + lbr.getLimit());
        }
        if (lbr.getStart() != 0) {
            query = UrlUtils.appendToUrlQuery(query, "s=" + lbr.getStart());
        }
        if (!Strings.isNullOrEmpty(lbr.getSubstring())) {
            query = UrlUtils.appendToUrlQuery(query, "m=" + lbr.getSubstring());
        }
        if (!Strings.isNullOrEmpty(lbr.getRegex())) {
            query = UrlUtils.appendToUrlQuery(query, "r=" + lbr.getRegex());
        }
        String url = "/branches";
        if (!Strings.isNullOrEmpty(query)) {
            url = url + '?' + query;
        }
        return url;
    }

    private String tagsUrl(ProjectApi.ListRefsRequest<TagInfo> lrr) {
        String query = "";
        if (lrr.getLimit() != 0) {
            query = UrlUtils.appendToUrlQuery(query, "n=" + lrr.getLimit());
        }
        if (lrr.getStart() != 0) {
            query = UrlUtils.appendToUrlQuery(query, "s=" + lrr.getStart());
        }
        if (!Strings.isNullOrEmpty(lrr.getSubstring()) || !Strings.isNullOrEmpty(lrr.getRegex())) {
            throw new NotImplementedException();
        }
        String url = "/tags";
        if (!Strings.isNullOrEmpty(query)) {
            url = url + '?' + query;
        }
        return url;
    }
}

