/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.rest.http.projects;

import java.io.IOException;
import me.redaalaoui.gerrit_rest_java_client.rest.RestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.GerritRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.projects.BranchInfoParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.projects.ProjectApiRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.util.BinaryResultUtils;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.common.collect.Iterables;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.BranchApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.BranchInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.projects.BranchInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.BinaryResult;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.RestApiException;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.Url;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonElement;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class BranchApiRestClient
extends BranchApi.NotImplemented
implements BranchApi {
    private final GerritRestClient gerritRestClient;
    private final BranchInfoParser branchInfoParser;
    private final ProjectApiRestClient projectApiRestClient;
    private final String name;

    public BranchApiRestClient(GerritRestClient gerritRestClient, BranchInfoParser branchInfoParser, ProjectApiRestClient projectApiRestClient, String name) {
        this.gerritRestClient = gerritRestClient;
        this.branchInfoParser = branchInfoParser;
        this.projectApiRestClient = projectApiRestClient;
        this.name = name;
    }

    @Override
    public BranchApi create(BranchInput in) throws RestApiException {
        String json = this.gerritRestClient.getGson().toJson(in);
        this.gerritRestClient.putRequest(this.branchUrl(), json);
        return this;
    }

    @Override
    public BranchInfo get() throws RestApiException {
        JsonElement jsonElement = this.gerritRestClient.getRequest(this.branchUrl());
        return Iterables.getOnlyElement(this.branchInfoParser.parseBranchInfos(jsonElement));
    }

    @Override
    public void delete() throws RestApiException {
        this.gerritRestClient.deleteRequest(this.branchUrl());
    }

    @Override
    public BinaryResult file(String path) throws RestApiException {
        String encodedPath = Url.encode(path);
        String request = this.branchUrl() + "/files/" + encodedPath + "/content";
        try {
            HttpResponse response = this.gerritRestClient.request(request, null, RestClient.HttpVerb.GET, new Header[0]);
            return BinaryResultUtils.createBinaryResult(response);
        }
        catch (IOException e) {
            throw RestApiException.wrap("Failed to get file content.", e);
        }
    }

    protected String branchUrl() {
        return this.projectApiRestClient.projectsUrl() + "/branches/" + this.name;
    }
}

