/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.rest.http.groups;

import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import me.redaalaoui.gerrit_rest_java_client.rest.http.GerritRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.groups.GroupApiRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.groups.GroupsParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.util.UrlUtils;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.common.base.Strings;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.groups.GroupApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.groups.GroupInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.groups.Groups;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.GroupInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.NotImplementedException;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.RestApiException;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.Url;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonElement;

public class GroupsRestClient
extends Groups.NotImplemented
implements Groups {
    private final GerritRestClient gerritRestClient;
    private final GroupsParser groupsParser;

    public GroupsRestClient(GerritRestClient gerritRestClient, GroupsParser groupsParser) {
        this.gerritRestClient = gerritRestClient;
        this.groupsParser = groupsParser;
    }

    @Override
    public GroupApi id(String id) throws RestApiException {
        return new GroupApiRestClient(this.gerritRestClient, this.groupsParser, id);
    }

    @Override
    public GroupApi create(String name) throws RestApiException {
        GroupInput groupInput = new GroupInput();
        groupInput.name = name;
        return this.create(groupInput);
    }

    @Override
    public GroupApi create(GroupInput input) throws RestApiException {
        String restPath = GroupApiRestClient.getBaseRequestPath() + "/" + Url.encode(input.name);
        String body = this.gerritRestClient.getGson().toJson(input);
        JsonElement result = this.gerritRestClient.putRequest(restPath, body);
        GroupInfo info = this.groupsParser.parseGroupInfo(result);
        return new GroupApiRestClient(this.gerritRestClient, this.groupsParser, info.id);
    }

    @Override
    public Groups.ListRequest list() {
        return new Groups.ListRequest(){

            public SortedMap<String, GroupInfo> getAsMap() throws RestApiException {
                TreeMap<String, GroupInfo> map = new TreeMap<String, GroupInfo>();
                List list = GroupsRestClient.this.list(this);
                if (list != null) {
                    for (GroupInfo group : list) {
                        map.put(group.id, group);
                    }
                }
                return map;
            }
        };
    }

    private List<GroupInfo> list(Groups.ListRequest listParameter) throws RestApiException {
        JsonElement result;
        String query = "";
        if (listParameter.getLimit() > 0) {
            query = UrlUtils.appendToUrlQuery(query, "n=" + listParameter.getLimit());
        }
        if (listParameter.getStart() > 0) {
            query = UrlUtils.appendToUrlQuery(query, "S=" + listParameter.getStart());
        }
        if (listParameter.getOwned()) {
            query = UrlUtils.appendToUrlQuery(query, "owned");
        }
        if (!Strings.isNullOrEmpty(listParameter.getSuggest())) {
            query = UrlUtils.appendToUrlQuery(query, "suggest=" + listParameter.getSuggest());
        }
        if (listParameter.getVisibleToAll()) {
            throw new NotImplementedException();
        }
        if (!listParameter.getOptions().isEmpty()) {
            throw new NotImplementedException();
        }
        if (!listParameter.getProjects().isEmpty()) {
            throw new NotImplementedException();
        }
        if (!listParameter.getGroups().isEmpty()) {
            throw new NotImplementedException();
        }
        if (!Strings.isNullOrEmpty(listParameter.getUser())) {
            throw new NotImplementedException();
        }
        if (!Strings.isNullOrEmpty(listParameter.getSubstring())) {
            throw new NotImplementedException();
        }
        String url = GroupApiRestClient.getBaseRequestPath() + "/";
        if (!Strings.isNullOrEmpty(query)) {
            url = url + '?' + query;
        }
        if ((result = this.gerritRestClient.getRequest(url)) == null) {
            return Collections.emptyList();
        }
        return this.groupsParser.parseGroupInfos(result);
    }

    @Override
    public Groups.QueryRequest query() {
        return new Groups.QueryRequest(){

            @Override
            public List<GroupInfo> get() throws RestApiException {
                return GroupsRestClient.this.query(this);
            }
        };
    }

    protected List<GroupInfo> query(Groups.QueryRequest queryRequest) throws RestApiException {
        JsonElement result;
        String query = "";
        if (!Strings.isNullOrEmpty(queryRequest.getQuery())) {
            query = UrlUtils.appendToUrlQuery(query, "query=" + queryRequest.getQuery());
        }
        if (queryRequest.getLimit() > 0) {
            query = UrlUtils.appendToUrlQuery(query, "limit=" + queryRequest.getLimit());
        }
        if (queryRequest.getStart() > 0) {
            query = UrlUtils.appendToUrlQuery(query, "start=" + queryRequest.getStart());
        }
        if (!queryRequest.getOptions().isEmpty()) {
            throw new NotImplementedException();
        }
        String url = GroupApiRestClient.getBaseRequestPath() + "/";
        if (!Strings.isNullOrEmpty(query)) {
            url = url + '?' + query;
        }
        if ((result = this.gerritRestClient.getRequest(url)) == null) {
            return Collections.emptyList();
        }
        return this.groupsParser.parseGroupInfos(result);
    }

    @Override
    public Groups.QueryRequest query(String query) {
        return this.query().withQuery(query);
    }
}

