/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.rest.http.groups;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.common.reflect.TypeToken;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.AccountInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.GroupInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.Gson;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonElement;

public class GroupsParser {
    private static final Type GROUP_MAP_TYPE = new TypeToken<SortedMap<String, GroupInfo>>(){}.getType();
    private static final Type GROUP_LIST_TYPE = new TypeToken<List<GroupInfo>>(){}.getType();
    private static final Type ACCOUNT_LIST_TYPE = new TypeToken<List<AccountInfo>>(){}.getType();
    private final Gson gson;

    public GroupsParser(Gson gson) {
        this.gson = gson;
    }

    public GroupInfo parseGroupInfo(JsonElement result) {
        return this.gson.fromJson(result, GroupInfo.class);
    }

    public AccountInfo parseGroupMember(JsonElement result) {
        return this.gson.fromJson(result, AccountInfo.class);
    }

    public List<GroupInfo> parseGroupInfos(JsonElement result) {
        if (result.isJsonArray()) {
            return (List)this.gson.fromJson(result, GROUP_LIST_TYPE);
        }
        SortedMap map = (SortedMap)this.gson.fromJson(result, GROUP_MAP_TYPE);
        for (Map.Entry entry : map.entrySet()) {
            ((GroupInfo)entry.getValue()).name = (String)entry.getKey();
        }
        return new ArrayList<GroupInfo>(map.values());
    }

    public List<AccountInfo> parseGroupMembers(JsonElement result) {
        if (!result.isJsonArray()) {
            return Collections.singletonList(this.parseGroupMember(result));
        }
        return (List)this.gson.fromJson(result, ACCOUNT_LIST_TYPE);
    }
}

