/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.rest.http.groups;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.redaalaoui.gerrit_rest_java_client.rest.http.GerritRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.groups.GroupsParser;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.groups.GroupApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.AccountInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.GroupInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.RestApiException;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.Url;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonElement;

public class GroupApiRestClient
extends GroupApi.NotImplemented
implements GroupApi {
    private static final String BASE_URL = "/groups";
    private final GroupsParser groupsParser;
    private final GerritRestClient gerritRestClient;
    private final String groupId;

    public GroupApiRestClient(GerritRestClient gerritRestClient, GroupsParser groupsParser, String id) {
        this.gerritRestClient = gerritRestClient;
        this.groupsParser = groupsParser;
        this.groupId = id;
    }

    public static String getBaseRequestPath() {
        return BASE_URL;
    }

    public static String getRequestPath(String id) {
        return "/groups/" + Url.encode(id);
    }

    protected String getRequestPath() {
        return GroupApiRestClient.getRequestPath(this.groupId);
    }

    @Override
    public GroupInfo get() throws RestApiException {
        String restPath = this.getRequestPath();
        JsonElement result = this.gerritRestClient.getRequest(restPath);
        return this.groupsParser.parseGroupInfo(result);
    }

    @Override
    public GroupInfo detail() throws RestApiException {
        String restPath = this.getRequestPath() + "/detail";
        JsonElement result = this.gerritRestClient.getRequest(restPath);
        return this.groupsParser.parseGroupInfo(result);
    }

    @Override
    public String name() throws RestApiException {
        String restPath = this.getRequestPath() + "/name";
        return this.gerritRestClient.getRequest(restPath).getAsString();
    }

    @Override
    public void name(String name) throws RestApiException {
        String restPath = this.getRequestPath() + "/name";
        this.gerritRestClient.putRequest(restPath, name);
    }

    @Override
    public GroupInfo owner() throws RestApiException {
        String restPath = this.getRequestPath() + "/owner";
        JsonElement result = this.gerritRestClient.getRequest(restPath);
        return this.groupsParser.parseGroupInfo(result);
    }

    @Override
    public void owner(String owner) throws RestApiException {
        String restPath = this.getRequestPath() + "/owner";
        this.gerritRestClient.putRequest(restPath, owner);
    }

    @Override
    public String description() throws RestApiException {
        String restPath = this.getRequestPath() + "/description";
        return this.gerritRestClient.getRequest(restPath).getAsString();
    }

    @Override
    public void description(String description) throws RestApiException {
        String restPath = this.getRequestPath() + "/description";
        this.gerritRestClient.putRequest(restPath, description);
    }

    @Override
    public List<AccountInfo> members() throws RestApiException {
        return this.members(false);
    }

    @Override
    public List<AccountInfo> members(boolean recursive) throws RestApiException {
        String restPath = this.getRequestPath() + "/members";
        if (recursive) {
            restPath = restPath + "?recursive";
        }
        JsonElement result = this.gerritRestClient.getRequest(restPath);
        return this.groupsParser.parseGroupMembers(result);
    }

    @Override
    public void addMembers(String ... members) throws RestApiException {
        String restPath = this.getRequestPath() + "/members";
        Map<String, List<String>> memberMap = Collections.singletonMap("members", Arrays.asList(members));
        String json = this.gerritRestClient.getGson().toJson(memberMap);
        this.gerritRestClient.postRequest(restPath, json);
    }

    @Override
    public List<GroupInfo> includedGroups() throws RestApiException {
        String restPath = this.getRequestPath() + "/groups/";
        JsonElement result = this.gerritRestClient.getRequest(restPath);
        return this.groupsParser.parseGroupInfos(result);
    }

    @Override
    public void addGroups(String ... groups) throws RestApiException {
        String restPath = this.getRequestPath() + BASE_URL;
        Map<String, List<String>> groupMap = Collections.singletonMap("groups", Arrays.asList(groups));
        String json = this.gerritRestClient.getGson().toJson(groupMap);
        this.gerritRestClient.postRequest(restPath, json);
    }

    @Override
    public void removeGroups(String ... groups) throws RestApiException {
        String restPath = this.getRequestPath() + "/groups.delete";
        Map<String, List<String>> groupMap = Collections.singletonMap("groups", Arrays.asList(groups));
        String json = this.gerritRestClient.getGson().toJson(groupMap);
        this.gerritRestClient.postRequest(restPath, json);
    }

    @Override
    public void removeMembers(String ... members) throws RestApiException {
        String restPath = this.getRequestPath() + "/members.delete";
        Map<String, List<String>> memberMap = Collections.singletonMap("members", Arrays.asList(members));
        String json = this.gerritRestClient.getGson().toJson(memberMap);
        this.gerritRestClient.postRequest(restPath, json);
    }
}

