/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.common.reflect.TypeToken;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.AddReviewerResult;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.ReviewerInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.SuggestedReviewerInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.Gson;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonElement;

public class ReviewerInfosParser {
    private static final Type REVIEWER_INFO = new TypeToken<List<ReviewerInfo>>(){}.getType();
    private static final Type SUGGESTED_REVIEWER_INFO = new TypeToken<List<SuggestedReviewerInfo>>(){}.getType();
    private final Gson gson;

    public ReviewerInfosParser(Gson gson) {
        this.gson = gson;
    }

    public List<ReviewerInfo> parseReviewerInfos(JsonElement result) {
        if (!result.isJsonArray()) {
            return Collections.singletonList(this.gson.fromJson(result, ReviewerInfo.class));
        }
        return (List)this.gson.fromJson(result, REVIEWER_INFO);
    }

    public List<SuggestedReviewerInfo> parseSuggestReviewerInfos(JsonElement result) {
        if (!result.isJsonArray()) {
            return Collections.singletonList(this.gson.fromJson(result, SuggestedReviewerInfo.class));
        }
        return (List)this.gson.fromJson(result, SUGGESTED_REVIEWER_INFO);
    }

    public AddReviewerResult parseAddReviewerResult(JsonElement result) {
        return this.gson.fromJson(result, AddReviewerResult.class);
    }
}

