/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.common.reflect.TypeToken;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.ActionInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.CommitInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.DiffInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.EditInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.Gson;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonElement;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonObject;

public class CommitInfosParser {
    private static final Type ACTION_TYPE = new TypeToken<TreeMap<String, ActionInfo>>(){}.getType();
    private static final Type COMMIT_INFO_TYPE = new TypeToken<List<CommitInfo>>(){}.getType();
    private static final Type EDIT_INFO_TYPE = new TypeToken<List<EditInfo>>(){}.getType();
    private final Gson gson;

    public CommitInfosParser(Gson gson) {
        this.gson = gson;
    }

    public SortedMap<String, ActionInfo> parseActionInfos(JsonElement result) {
        return (SortedMap)this.gson.fromJson(result, ACTION_TYPE);
    }

    public DiffInfo parseDiffInfo(JsonElement jsonElement) {
        return this.gson.fromJson(jsonElement, DiffInfo.class);
    }

    public List<CommitInfo> parseCommitInfos(JsonElement result) {
        if (!result.isJsonArray()) {
            return Collections.singletonList(this.gson.fromJson(result, CommitInfo.class));
        }
        return (List)this.gson.fromJson(result, COMMIT_INFO_TYPE);
    }

    public CommitInfo parseSingleCommitInfo(JsonObject result) {
        return this.gson.fromJson((JsonElement)result, CommitInfo.class);
    }

    public List<EditInfo> parseEditInfos(JsonElement result) {
        if (!result.isJsonArray()) {
            return Collections.singletonList(this.gson.fromJson(result, EditInfo.class));
        }
        return (List)this.gson.fromJson(result, EDIT_INFO_TYPE);
    }
}

