/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.common.reflect.TypeToken;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.IncludedInInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.ChangeInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.ChangeInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.Gson;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonElement;

public class ChangeInfosParser {
    private static final Type CHANGEINFO_TYPE = new TypeToken<List<ChangeInfo>>(){}.getType();
    private static final Type HASHTAG_TYPE = new TypeToken<Set<String>>(){}.getType();
    private final Gson gson;

    public ChangeInfosParser(Gson gson) {
        this.gson = gson;
    }

    public List<ChangeInfo> parseChangeInfos(JsonElement result) {
        if (!result.isJsonArray()) {
            return Collections.singletonList(this.parseSingleChangeInfo(result));
        }
        return (List)this.gson.fromJson(result, CHANGEINFO_TYPE);
    }

    public ChangeInfo parseSingleChangeInfo(JsonElement result) {
        return this.gson.fromJson(result, ChangeInfo.class);
    }

    public String generateChangeInput(ChangeInput input) {
        return this.gson.toJson((Object)input, (Type)((Object)ChangeInput.class));
    }

    public Set<String> parseHashtags(JsonElement result) {
        return (Set)this.gson.fromJson(result, HASHTAG_TYPE);
    }

    public IncludedInInfo parseIncludedInInfos(JsonElement jsonElement) {
        return this.gson.fromJson(jsonElement, IncludedInInfo.class);
    }
}

