/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.rest.http.changes;

import me.redaalaoui.gerrit_rest_java_client.rest.http.GerritRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.ChangeApiRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.RevisionApiRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.CommentsParser;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.DraftApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.DraftInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.CommentInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.RestApiException;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonElement;

public class DraftApiRestClient
extends DraftApi.NotImplemented
implements DraftApi {
    private final GerritRestClient gerritRestClient;
    private final ChangeApiRestClient changeApiRestClient;
    private final RevisionApiRestClient revisionApiRestClient;
    private final CommentsParser commentsParser;
    private final CommentInfo commentInfo;
    private final String id;

    public DraftApiRestClient(GerritRestClient gerritRestClient, ChangeApiRestClient changeApiRestClient, RevisionApiRestClient revisionApiRestClient, CommentsParser commentsParser, CommentInfo commentInfo) {
        this.gerritRestClient = gerritRestClient;
        this.changeApiRestClient = changeApiRestClient;
        this.revisionApiRestClient = revisionApiRestClient;
        this.commentsParser = commentsParser;
        this.commentInfo = commentInfo;
        this.id = null;
    }

    public DraftApiRestClient(GerritRestClient gerritRestClient, ChangeApiRestClient changeApiRestClient, RevisionApiRestClient revisionApiRestClient, CommentsParser commentsParser, String id) {
        this.gerritRestClient = gerritRestClient;
        this.changeApiRestClient = changeApiRestClient;
        this.revisionApiRestClient = revisionApiRestClient;
        this.commentsParser = commentsParser;
        this.id = id;
        this.commentInfo = null;
    }

    @Override
    public CommentInfo update(DraftInput in) throws RestApiException {
        String json = this.gerritRestClient.getGson().toJson(in);
        JsonElement jsonElement = this.gerritRestClient.putRequest(this.getUrl(), json);
        return this.commentsParser.parseSingleCommentInfo(jsonElement.getAsJsonObject());
    }

    @Override
    public void delete() throws RestApiException {
        this.gerritRestClient.deleteRequest(this.getUrl());
    }

    @Override
    public CommentInfo get() throws RestApiException {
        if (this.commentInfo != null) {
            return this.commentInfo;
        }
        JsonElement jsonElement = this.gerritRestClient.getRequest(this.getUrl());
        return this.commentsParser.parseSingleCommentInfo(jsonElement.getAsJsonObject());
    }

    private String getUrl() {
        return "/changes/" + this.changeApiRestClient.id() + "/revisions/" + this.revisionApiRestClient.revision() + "/drafts/" + (this.commentInfo != null ? this.commentInfo.id : this.id);
    }
}

