/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.rest.http.changes;

import java.util.List;
import me.redaalaoui.gerrit_rest_java_client.rest.http.GerritRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.accounts.AccountsParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.ChangeApiRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.ChangeInfosParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.CommentsParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.CommitInfosParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.FileInfoParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.MergeableInfoParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.ReviewInfoParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.ReviewResultParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.ReviewerInfosParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.util.UrlUtils;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.common.base.Strings;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.ChangeApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.Changes;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.client.ListChangesOption;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.ChangeInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.ChangeInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.RestApiException;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.Url;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonElement;

public class ChangesRestClient
extends Changes.NotImplemented
implements Changes {
    private final GerritRestClient gerritRestClient;
    private final ChangeInfosParser changeInfosParser;
    private final CommentsParser commentsParser;
    private final FileInfoParser fileInfoParser;
    private final ReviewerInfosParser reviewerInfosParser;
    private final ReviewResultParser reviewResultParser;
    private final CommitInfosParser commitInfosParser;
    private final AccountsParser accountsParser;
    private final MergeableInfoParser mergeableInfoParser;
    private final ReviewInfoParser reviewInfoParser;

    public ChangesRestClient(GerritRestClient gerritRestClient, ChangeInfosParser changeInfosParser, CommentsParser commentsParser, FileInfoParser fileInfoParser, ReviewerInfosParser reviewerInfosParser, ReviewResultParser reviewResultParser, CommitInfosParser commitInfosParser, AccountsParser accountsParser, MergeableInfoParser mergeableInfoParser, ReviewInfoParser reviewInfoParser) {
        this.gerritRestClient = gerritRestClient;
        this.changeInfosParser = changeInfosParser;
        this.commentsParser = commentsParser;
        this.fileInfoParser = fileInfoParser;
        this.reviewerInfosParser = reviewerInfosParser;
        this.reviewResultParser = reviewResultParser;
        this.commitInfosParser = commitInfosParser;
        this.accountsParser = accountsParser;
        this.mergeableInfoParser = mergeableInfoParser;
        this.reviewInfoParser = reviewInfoParser;
    }

    @Override
    public Changes.QueryRequest query() {
        return new Changes.QueryRequest(){

            @Override
            public List<ChangeInfo> get() throws RestApiException {
                return ChangesRestClient.this.get(this);
            }
        };
    }

    @Override
    public Changes.QueryRequest query(String query) {
        return this.query().withQuery(query);
    }

    private List<ChangeInfo> get(Changes.QueryRequest queryRequest) throws RestApiException {
        String query = "";
        if (!Strings.isNullOrEmpty(queryRequest.getQuery())) {
            query = UrlUtils.appendToUrlQuery(query, "q=" + queryRequest.getQuery());
        }
        if (queryRequest.getLimit() > 0) {
            query = UrlUtils.appendToUrlQuery(query, "n=" + queryRequest.getLimit());
        }
        if (queryRequest.getStart() > 0) {
            query = UrlUtils.appendToUrlQuery(query, "S=" + queryRequest.getStart());
        }
        if (!Strings.isNullOrEmpty(queryRequest.getSortkey())) {
            query = UrlUtils.appendToUrlQuery(query, "N=" + queryRequest.getSortkey());
        }
        for (ListChangesOption option : queryRequest.getOptions()) {
            query = UrlUtils.appendToUrlQuery(query, "o=" + option);
        }
        String url = "/changes/";
        if (!Strings.isNullOrEmpty(query)) {
            url = url + '?' + query;
        }
        JsonElement jsonElement = this.gerritRestClient.getRequest(url);
        return this.changeInfosParser.parseChangeInfos(jsonElement);
    }

    @Override
    public ChangeApi id(int id) throws RestApiException {
        return this.id(Integer.toString(id));
    }

    @Override
    public ChangeApi id(String id) throws RestApiException {
        return new ChangeApiRestClient(this.gerritRestClient, this, this.changeInfosParser, this.commentsParser, this.fileInfoParser, this.reviewResultParser, this.reviewerInfosParser, this.commitInfosParser, this.accountsParser, this.mergeableInfoParser, this.reviewInfoParser, id);
    }

    @Override
    public ChangeApi id(String project, int id) throws RestApiException {
        return this.id(String.format("%s~%s", Url.encode(project), id));
    }

    @Override
    public ChangeApi id(String project, String branch, String id) throws RestApiException {
        return this.id(String.format("%s~%s~%s", Url.encode(project), Url.encode(branch), id));
    }

    @Override
    public ChangeApi create(ChangeInput in) throws RestApiException {
        if (in.branch == null) {
            throw new IllegalArgumentException("Branch must be set in change creation input.");
        }
        String url = "/changes/";
        String changeInput = this.changeInfosParser.generateChangeInput(in);
        JsonElement result = this.gerritRestClient.postRequest(url, changeInput);
        ChangeInfo info = this.changeInfosParser.parseSingleChangeInfo(result);
        return this.id(info._number);
    }
}

