/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.gerrit_rest_java_client.rest.http.changes;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.redaalaoui.gerrit_rest_java_client.rest.http.GerritRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.accounts.AccountsParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.ChangeEditApiRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.ChangesRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.ListChangesOptionByVersion;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.RevisionApiRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.ChangeInfosParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.CommentsParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.CommitInfosParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.FileInfoParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.MergeableInfoParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.ReviewInfoParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.ReviewResultParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.changes.parsers.ReviewerInfosParser;
import me.redaalaoui.gerrit_rest_java_client.rest.http.config.ServerRestClient;
import me.redaalaoui.gerrit_rest_java_client.rest.http.util.UrlUtils;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.common.base.Strings;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.common.collect.Iterables;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.AbandonInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.AddReviewerInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.AddReviewerResult;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.ChangeApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.ChangeEditApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.FixInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.HashtagsInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.IncludedInInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.MoveInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.RestoreInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.RevertInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.ReviewerInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.RevisionApi;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.client.ListChangesOption;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.AccountInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.ChangeInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.ChangeMessageInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.CommentInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.CommitMessageInput;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.EditInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.RevertSubmissionInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.RobotCommentInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.common.SuggestedReviewerInfo;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.RestApiException;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.restapi.Url;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gson.JsonElement;

public class ChangeApiRestClient
extends ChangeApi.NotImplemented
implements ChangeApi {
    private final GerritRestClient gerritRestClient;
    private final ChangesRestClient changesRestClient;
    private final ChangeInfosParser changeInfosParser;
    private final CommentsParser commentsParser;
    private final FileInfoParser fileInfoParser;
    private final ReviewResultParser reviewResultParser;
    private final ReviewerInfosParser reviewerInfosParser;
    private final CommitInfosParser commitInfosParser;
    private final AccountsParser accountsParser;
    private final MergeableInfoParser mergeableInfoParser;
    private final ReviewInfoParser reviewInfoParser;
    private final String id;
    private final ServerRestClient serverRestClient;

    public ChangeApiRestClient(GerritRestClient gerritRestClient, ChangesRestClient changesRestClient, ChangeInfosParser changeInfosParser, CommentsParser commentsParser, FileInfoParser fileInfoParser, ReviewResultParser reviewResultParser, ReviewerInfosParser reviewerInfosParser, CommitInfosParser commitInfosParser, AccountsParser accountsParser, MergeableInfoParser mergeableInfoParser, ReviewInfoParser reviewInfoParser, String id) {
        this.gerritRestClient = gerritRestClient;
        this.changesRestClient = changesRestClient;
        this.changeInfosParser = changeInfosParser;
        this.commentsParser = commentsParser;
        this.fileInfoParser = fileInfoParser;
        this.reviewResultParser = reviewResultParser;
        this.reviewerInfosParser = reviewerInfosParser;
        this.commitInfosParser = commitInfosParser;
        this.accountsParser = accountsParser;
        this.mergeableInfoParser = mergeableInfoParser;
        this.reviewInfoParser = reviewInfoParser;
        this.id = id;
        this.serverRestClient = new ServerRestClient(gerritRestClient);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public RevisionApi current() throws RestApiException {
        return this.revision("current");
    }

    @Override
    public RevisionApi revision(int id) throws RestApiException {
        return this.revision(Integer.toString(id));
    }

    @Override
    public RevisionApi revision(String id) throws RestApiException {
        return new RevisionApiRestClient(this.gerritRestClient, this, this.commentsParser, this.fileInfoParser, this.reviewResultParser, this.commitInfosParser, this.mergeableInfoParser, this.reviewInfoParser, id);
    }

    @Override
    public void abandon() throws RestApiException {
        this.abandon(new AbandonInput());
    }

    @Override
    public void abandon(AbandonInput abandonInput) throws RestApiException {
        String request = this.getRequestPath() + "/abandon";
        String json = this.gerritRestClient.getGson().toJson(abandonInput);
        this.gerritRestClient.postRequest(request, json);
    }

    @Override
    public void restore() throws RestApiException {
        this.restore(new RestoreInput());
    }

    @Override
    public void restore(RestoreInput restoreInput) throws RestApiException {
        String request = this.getRequestPath() + "/restore";
        String json = this.gerritRestClient.getGson().toJson(restoreInput);
        this.gerritRestClient.postRequest(request, json);
    }

    @Override
    public void move(String destinationBranch) throws RestApiException {
        MoveInput moveInput = new MoveInput();
        moveInput.destinationBranch = destinationBranch;
        this.move(moveInput);
    }

    @Override
    public void move(MoveInput moveInput) throws RestApiException {
        String request = this.getRequestPath() + "/move";
        String json = this.gerritRestClient.getGson().toJson(moveInput);
        this.gerritRestClient.postRequest(request, json);
    }

    @Override
    public ChangeApi revert() throws RestApiException {
        return this.revert(new RevertInput());
    }

    @Override
    public ChangeApi revert(RevertInput revertInput) throws RestApiException {
        String request = this.getRequestPath() + "/revert";
        String json = this.gerritRestClient.getGson().toJson(revertInput);
        ChangeInfo newChangeInfo = this.changeInfosParser.parseSingleChangeInfo(this.gerritRestClient.postRequest(request, json));
        return new ChangeApiRestClient(this.gerritRestClient, this.changesRestClient, this.changeInfosParser, this.commentsParser, this.fileInfoParser, this.reviewResultParser, this.reviewerInfosParser, this.commitInfosParser, this.accountsParser, this.mergeableInfoParser, this.reviewInfoParser, newChangeInfo.id);
    }

    @Override
    public RevertSubmissionInfo revertSubmission() throws RestApiException {
        return this.revertSubmission(new RevertInput());
    }

    @Override
    public RevertSubmissionInfo revertSubmission(RevertInput in) throws RestApiException {
        String request = this.getRequestPath() + "/revert_submission";
        String json = this.gerritRestClient.getGson().toJson(in);
        JsonElement revertedChanges = this.gerritRestClient.postRequest(request, json);
        RevertSubmissionInfo revertSubmissionInfo = new RevertSubmissionInfo();
        revertSubmissionInfo.revertChanges = this.changeInfosParser.parseChangeInfos(revertedChanges);
        return revertSubmissionInfo;
    }

    @Override
    public void publish() throws RestApiException {
        String request = this.getRequestPath() + "/publish";
        this.gerritRestClient.postRequest(request);
    }

    @Override
    public void delete() throws RestApiException {
        String request = this.getRequestPath();
        this.gerritRestClient.deleteRequest(request);
    }

    @Override
    public String topic() throws RestApiException {
        String request = this.getRequestPath() + "/topic";
        return this.gerritRestClient.getRequest(request).getAsString();
    }

    @Override
    public void topic(String topic) throws RestApiException {
        String request = this.getRequestPath() + "/topic";
        Map<String, String> topicInput = Collections.singletonMap("topic", topic);
        String json = this.gerritRestClient.getGson().toJson(topicInput);
        this.gerritRestClient.putRequest(request, json);
    }

    @Override
    public IncludedInInfo includedIn() throws RestApiException {
        String request = this.getRequestPath() + "/in";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.changeInfosParser.parseIncludedInInfos(jsonElement);
    }

    @Override
    @Deprecated
    public List<ReviewerInfo> listReviewers() throws RestApiException {
        return this.reviewers();
    }

    @Override
    public List<ReviewerInfo> reviewers() throws RestApiException {
        String request = this.getRequestPath() + "/reviewers";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.reviewerInfosParser.parseReviewerInfos(jsonElement);
    }

    @Override
    public AddReviewerResult addReviewer(AddReviewerInput in) throws RestApiException {
        String request = this.getRequestPath() + "/reviewers";
        String json = this.gerritRestClient.getGson().toJson(in);
        JsonElement reviewerResult = this.gerritRestClient.postRequest(request, json);
        return this.reviewerInfosParser.parseAddReviewerResult(reviewerResult);
    }

    @Override
    public AddReviewerResult addReviewer(String in) throws RestApiException {
        AddReviewerInput input = new AddReviewerInput();
        input.reviewer = in;
        return this.addReviewer(input);
    }

    @Override
    public ChangeApi.SuggestedReviewersRequest suggestReviewers() throws RestApiException {
        return new ChangeApi.SuggestedReviewersRequest(){

            @Override
            public List<SuggestedReviewerInfo> get() throws RestApiException {
                return ChangeApiRestClient.this.suggestReviewers(this);
            }
        };
    }

    @Override
    public ChangeApi.SuggestedReviewersRequest suggestReviewers(String query) throws RestApiException {
        return this.suggestReviewers().withQuery(query).withLimit(-1);
    }

    private List<SuggestedReviewerInfo> suggestReviewers(ChangeApi.SuggestedReviewersRequest r) throws RestApiException {
        String encodedQuery = Url.encode(r.getQuery());
        return this.getSuggestedReviewers(String.format("q=%s&n=%s", encodedQuery, r.getLimit()));
    }

    private List<SuggestedReviewerInfo> getSuggestedReviewers(String queryPart) throws RestApiException {
        String request = this.getRequestPath() + String.format("/suggest_reviewers?%s", queryPart);
        JsonElement suggestedReviewers = this.gerritRestClient.getRequest(request);
        return this.reviewerInfosParser.parseSuggestReviewerInfos(suggestedReviewers);
    }

    @Override
    public ChangeInfo get(EnumSet<ListChangesOption> options) throws RestApiException {
        String query = "";
        for (ListChangesOption option : options) {
            query = UrlUtils.appendToUrlQuery(query, "o=" + option);
        }
        String url = this.getRequestPath();
        if (!Strings.isNullOrEmpty(query)) {
            url = url + '?' + query;
        }
        JsonElement jsonElement = this.gerritRestClient.getRequest(url);
        return this.changeInfosParser.parseSingleChangeInfo(jsonElement);
    }

    @Override
    public ChangeInfo get() throws RestApiException {
        return this.get(ListChangesOptionByVersion.allSupported(this.serverRestClient.getVersionCached()));
    }

    @Override
    public ChangeInfo info() throws RestApiException {
        return this.get(EnumSet.noneOf(ListChangesOption.class));
    }

    @Override
    public EditInfo getEdit() throws RestApiException {
        String request = this.getRequestPath() + "/edit";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return Iterables.getOnlyElement(this.commitInfosParser.parseEditInfos(jsonElement));
    }

    @Override
    public ChangeEditApi edit() throws RestApiException {
        return new ChangeEditApiRestClient(this.gerritRestClient, this.id);
    }

    @Override
    public void setMessage(String message) throws RestApiException {
        CommitMessageInput commitMessageInput = new CommitMessageInput();
        commitMessageInput.message = message;
        this.setMessage(commitMessageInput);
    }

    @Override
    public void setMessage(CommitMessageInput in) throws RestApiException {
        String request = this.getRequestPath() + "/message";
        String json = this.gerritRestClient.getGson().toJson(in);
        this.gerritRestClient.postRequest(request, json);
    }

    @Override
    public void setHashtags(HashtagsInput input) throws RestApiException {
        String request = this.getRequestPath() + "/hashtags";
        String json = this.gerritRestClient.getGson().toJson(input);
        this.gerritRestClient.postRequest(request, json);
    }

    @Override
    public Set<String> getHashtags() throws RestApiException {
        String request = this.getRequestPath() + "/hashtags";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.changeInfosParser.parseHashtags(jsonElement);
    }

    @Override
    public AccountInfo getAssignee() throws RestApiException {
        String request = this.getRequestPath() + "/assignee";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.accountsParser.parseAccountInfo(jsonElement);
    }

    @Override
    public List<AccountInfo> getPastAssignees() throws RestApiException {
        String request = this.getRequestPath() + "/past_assignees";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.accountsParser.parseAccountInfos(jsonElement);
    }

    @Override
    public ChangeInfo check() throws RestApiException {
        String request = this.getRequestPath() + "/check";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.changeInfosParser.parseSingleChangeInfo(jsonElement);
    }

    @Override
    public ChangeInfo check(FixInput in) throws RestApiException {
        String request = this.getRequestPath() + "/check";
        String json = this.gerritRestClient.getGson().toJson(in);
        JsonElement jsonElement = this.gerritRestClient.postRequest(request, json);
        return this.changeInfosParser.parseSingleChangeInfo(jsonElement);
    }

    @Override
    public Map<String, List<CommentInfo>> comments() throws RestApiException {
        String request = this.getRequestPath() + "/comments";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.commentsParser.parseCommentInfos(jsonElement);
    }

    @Override
    public Map<String, List<RobotCommentInfo>> robotComments() throws RestApiException {
        String request = this.getRequestPath() + "/robotcomments";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.commentsParser.parseRobotCommentInfos(jsonElement);
    }

    @Override
    public Map<String, List<CommentInfo>> drafts() throws RestApiException {
        String request = this.getRequestPath() + "/drafts";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.commentsParser.parseCommentInfos(jsonElement);
    }

    @Override
    public void index() throws RestApiException {
        String request = this.getRequestPath() + "/index";
        this.gerritRestClient.postRequest(request);
    }

    @Override
    public List<ChangeInfo> submittedTogether() throws RestApiException {
        String url = this.getRequestPath() + "/submitted_together";
        JsonElement jsonElement = this.gerritRestClient.getRequest(url);
        return this.changeInfosParser.parseChangeInfos(jsonElement);
    }

    @Override
    public List<ChangeMessageInfo> messages() throws RestApiException {
        String request = this.getRequestPath() + "/messages";
        JsonElement jsonElement = this.gerritRestClient.getRequest(request);
        return this.commentsParser.parseChangeMessageInfos(jsonElement);
    }

    @Override
    public void ignore(boolean ignore) throws RestApiException {
        String path = ignore ? "/ignore" : "/unignore";
        String request = this.getRequestPath() + path;
        this.gerritRestClient.putRequest(request);
    }

    protected String getRequestPath() {
        return "/changes/" + this.id;
    }
}

