/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.simpleprioritysorter;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.queue.QueueSorter;
import io.jenkins.plugins.simpleprioritysorter.BasicPriorityProperty;
import java.util.Comparator;
import java.util.List;

@Extension
public class BasicPrioritySorter
extends QueueSorter {
    private static final int DEFAULT_PRIORITY = 10;

    public void sortBuildableItems(List<Queue.BuildableItem> items) {
        items.sort(Comparator.comparingInt(this::getPriority));
    }

    private int getPriority(Queue.BuildableItem item) {
        if (!(item.task instanceof Job)) {
            return 10;
        }
        Job job = (Job)item.task;
        BasicPriorityProperty prop = (BasicPriorityProperty)job.getProperty(BasicPriorityProperty.class);
        return prop != null ? prop.getPriority() : 10;
    }
}

