/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sidebar_link;

import hudson.util.FormValidation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class LinkProtection {
    private static final Set<String> ALLOWED_URI_SCHEMES = new HashSet<String>();

    LinkProtection() {
    }

    @Nonnull
    public static String getAllowedUriSchemes() {
        return String.join((CharSequence)",", ALLOWED_URI_SCHEMES);
    }

    @CheckReturnValue
    @Nonnull
    public static FormValidation verifyUrl(@CheckForNull String urlString) {
        String toCheck;
        URI uri;
        if (urlString == null || urlString.isBlank()) {
            return FormValidation.warning((String)"The provided URL is blank or empty");
        }
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException ex) {
            return FormValidation.error((Throwable)ex, (String)("The provided URL is malformed: " + urlString));
        }
        String scheme = uri.getScheme();
        if (scheme != null && !ALLOWED_URI_SCHEMES.contains(toCheck = scheme.toLowerCase())) {
            StringBuilder bldr = new StringBuilder("URI scheme \"");
            bldr.append(toCheck).append("\" is not allowed. Allowed schemes: ");
            bldr.append(LinkProtection.getAllowedUriSchemes());
            return FormValidation.error((String)bldr.toString());
        }
        if (uri.isAbsolute()) {
            return FormValidation.ok((String)"This is a valid absolute URL. The destination may not exist");
        }
        return FormValidation.ok((String)"This is a valid relative URL. The destination may not exist");
    }

    static {
        String customSchemes = System.getProperty(LinkProtection.class.getName() + ".whitelistedSchemes");
        if (customSchemes != null) {
            String[] schemes = customSchemes.split("\\s*,\\s*");
            ALLOWED_URI_SCHEMES.addAll(Arrays.asList(schemes));
        } else {
            ALLOWED_URI_SCHEMES.addAll(Arrays.asList("http", "https", "ftp", "ftps", "mailto", "news", "irc", "gopher", "nntp", "feed", "telnet", "mms", "rtsp", "svn", "tel", "fax", "xmpp"));
        }
    }
}

