/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.utils;

import hudson.ProxyConfiguration;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.bind.DatatypeConverter;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;

public final class CommUtils {
    private static Charset charSet = StandardCharsets.UTF_8;
    private static String defaultContentType = "application/json; charset=" + charSet.name();
    private static int connectTimeout = 5000;

    private CommUtils() {
    }

    public static JSONObject callSafe(String method, String urlString, JSONObject params, String data, String username, String password, String contentType, String transactionSource) throws IOException, MalformedURLException, IllegalArgumentException, Exception {
        if (contentType == null) {
            contentType = defaultContentType;
        }
        if (params == null) {
            CommUtils.printDebug("call", new String[]{"method", "urlString", "params", "data"}, new String[]{method, urlString, "", data}, Level.FINE);
        } else {
            CommUtils.printDebug("call", new String[]{"method", "urlString", "params", "data"}, new String[]{method, urlString, params.toString(), data}, Level.FINE);
        }
        JSONObject jsonResult = null;
        switch (method) {
            case "GET": {
                jsonResult = CommUtils._send(urlString, params, data, username, password, DevOpsConstants.REST_GET_METHOD.toString(), contentType, transactionSource);
                break;
            }
            case "POST": {
                jsonResult = CommUtils._send(urlString, params, data, username, password, DevOpsConstants.REST_POST_METHOD.toString(), contentType, transactionSource);
                break;
            }
            case "PUT": {
                jsonResult = CommUtils._send(urlString, params, data, username, password, DevOpsConstants.REST_PUT_METHOD.toString(), contentType, transactionSource);
                break;
            }
            case "DELETE": {
                jsonResult = CommUtils._send(urlString, params, data, username, password, DevOpsConstants.REST_DELETE_METHOD.toString(), contentType, transactionSource);
                break;
            }
            default: {
                CommUtils.printDebug("call", new String[]{"message"}, new String[]{"Invalid method name"}, Level.WARNING);
            }
        }
        return jsonResult;
    }

    public static JSONObject call(String method, String urlString, JSONObject params, String data, String username, String password, String contentType, String transactionSource) {
        if (contentType == null) {
            contentType = defaultContentType;
        }
        if (params == null) {
            CommUtils.printDebug("call", new String[]{"method", "urlString", "params", "data"}, new String[]{method, urlString, "", data}, Level.FINE);
        } else {
            CommUtils.printDebug("call", new String[]{"method", "urlString", "params", "data"}, new String[]{method, urlString, params.toString(), data}, Level.FINE);
        }
        JSONObject jsonResult = null;
        try {
            switch (method) {
                case "GET": {
                    jsonResult = CommUtils._send(urlString, params, data, username, password, DevOpsConstants.REST_GET_METHOD.toString(), contentType, transactionSource);
                    break;
                }
                case "POST": {
                    jsonResult = CommUtils._send(urlString, params, data, username, password, DevOpsConstants.REST_POST_METHOD.toString(), contentType, transactionSource);
                    break;
                }
                case "PUT": {
                    jsonResult = CommUtils._send(urlString, params, data, username, password, DevOpsConstants.REST_PUT_METHOD.toString(), contentType, transactionSource);
                    break;
                }
                case "DELETE": {
                    jsonResult = CommUtils._send(urlString, params, data, username, password, DevOpsConstants.REST_DELETE_METHOD.toString(), contentType, transactionSource);
                    break;
                }
                default: {
                    CommUtils.printDebug("call", new String[]{"message"}, new String[]{"Invalid method name"}, Level.WARNING);
                }
            }
            return jsonResult;
        }
        catch (MalformedURLException e) {
            CommUtils.printDebug("call", new String[]{"MalformedURLException"}, new String[]{e.getMessage()}, Level.SEVERE);
            return null;
        }
        catch (IllegalArgumentException e) {
            CommUtils.printDebug("call", new String[]{"IllegalArgumentException"}, new String[]{e.getMessage()}, Level.SEVERE);
            return null;
        }
        catch (IOException e) {
            CommUtils.printDebug("call", new String[]{"IOException"}, new String[]{e.getMessage()}, Level.SEVERE);
            return CommUtils.getErrorMessage("IOException: " + e.getMessage());
        }
        catch (Exception e) {
            CommUtils.printDebug("call", new String[]{"Exception"}, new String[]{e.getMessage()}, Level.SEVERE);
            return null;
        }
    }

    public static JSONObject callV2Support(String method, String urlString, JSONObject params, String data, String username, String password, String contentType, String transactionSource, Map<String, String> tokenDetails) {
        if (contentType == null) {
            contentType = defaultContentType;
        }
        if (params == null) {
            CommUtils.printDebug("callV2Support", new String[]{"method", "urlString", "params", "data"}, new String[]{method, urlString, "", data}, Level.FINE);
        } else {
            CommUtils.printDebug("callV2Support", new String[]{"method", "urlString", "params", "data"}, new String[]{method, urlString, params.toString(), data}, Level.FINE);
        }
        JSONObject jsonResult = null;
        try {
            switch (method) {
                case "GET": {
                    jsonResult = CommUtils._sendV2Support(urlString, params, data, username, password, DevOpsConstants.REST_GET_METHOD.toString(), contentType, transactionSource, tokenDetails);
                    break;
                }
                case "POST": {
                    jsonResult = CommUtils._sendV2Support(urlString, params, data, username, password, DevOpsConstants.REST_POST_METHOD.toString(), contentType, transactionSource, tokenDetails);
                    break;
                }
                case "PUT": {
                    jsonResult = CommUtils._sendV2Support(urlString, params, data, username, password, DevOpsConstants.REST_PUT_METHOD.toString(), contentType, transactionSource, tokenDetails);
                    break;
                }
                case "DELETE": {
                    jsonResult = CommUtils._sendV2Support(urlString, params, data, username, password, DevOpsConstants.REST_DELETE_METHOD.toString(), contentType, transactionSource, tokenDetails);
                    break;
                }
                default: {
                    CommUtils.printDebug("callV2Support", new String[]{"message"}, new String[]{"Invalid method name"}, Level.WARNING);
                }
            }
            return jsonResult;
        }
        catch (MalformedURLException e) {
            CommUtils.printDebug("callV2Support", new String[]{"MalformedURLException"}, new String[]{e.getMessage()}, Level.SEVERE);
            return null;
        }
        catch (IllegalArgumentException e) {
            CommUtils.printDebug("callV2Support", new String[]{"IllegalArgumentException"}, new String[]{e.getMessage()}, Level.SEVERE);
            return null;
        }
        catch (IOException e) {
            CommUtils.printDebug("callV2Support", new String[]{"IOException"}, new String[]{e.getMessage()}, Level.SEVERE);
            return CommUtils.getErrorMessage("IOException: " + e.getMessage());
        }
        catch (Exception e) {
            CommUtils.printDebug("callV2Support", new String[]{"Exception"}, new String[]{e.getMessage()}, Level.SEVERE);
            return null;
        }
    }

    private static JSONObject getErrorMessage(String message) {
        JSONObject resultJSON = new JSONObject();
        resultJSON.put(DevOpsConstants.COMMON_RESULT_FAILURE.toString(), (Object)message);
        return resultJSON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject _send(String urlString, JSONObject params, String data, String username, String password, String method, String contentType, String transactionSource) throws IOException, MalformedURLException, IllegalArgumentException, Exception {
        JSONObject jsonResult = null;
        URL url = new URL(CommUtils._appendParams(urlString, params));
        if (!url.getProtocol().startsWith("http")) {
            throw new IllegalArgumentException("Not an http(s) url: " + url);
        }
        ProxyConfiguration pc = ProxyConfiguration.load();
        HttpURLConnection conn = pc != null ? (HttpURLConnection)ProxyConfiguration.open((URL)url) : (HttpURLConnection)url.openConnection();
        byte[] message = (username + ":" + password).getBytes(charSet);
        String encoded = DatatypeConverter.printBase64Binary((byte[])message);
        conn.setRequestProperty("Authorization", "Basic " + encoded);
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("X-Transaction-Source", transactionSource);
        conn.setConnectTimeout(connectTimeout);
        conn.setRequestMethod(method);
        if (method.equals(DevOpsConstants.REST_POST_METHOD.toString()) || method.equals(DevOpsConstants.REST_PUT_METHOD.toString())) {
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(data.getBytes(charSet));
            }
        }
        jsonResult = CommUtils._readResponse(conn);
        return jsonResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject _sendV2Support(String urlString, JSONObject params, String data, String username, String password, String method, String contentType, String transactionSource, Map<String, String> tokenDetails) throws IOException, MalformedURLException, IllegalArgumentException, Exception {
        JSONObject jsonResult = null;
        URL url = new URL(CommUtils._appendParams(urlString, params));
        if (!url.getProtocol().startsWith("http")) {
            throw new IllegalArgumentException("Not an http(s) url: " + url);
        }
        ProxyConfiguration pc = ProxyConfiguration.load();
        HttpURLConnection conn = pc != null ? (HttpURLConnection)ProxyConfiguration.open((URL)url) : (HttpURLConnection)url.openConnection();
        if (null != tokenDetails && !tokenDetails.isEmpty() && tokenDetails.containsKey(DevOpsConstants.TOKEN_VALUE.toString())) {
            String token = tokenDetails.get(DevOpsConstants.TOKEN_VALUE.toString());
            String toolId = "";
            toolId = params.containsKey((Object)DevOpsConstants.TOOL_ID_ATTR.toString()) ? params.getString(DevOpsConstants.TOOL_ID_ATTR.toString()) : (params.containsKey((Object)DevOpsConstants.ORCHESTRATION_TOOL_ID_ATTR.toString()) ? params.getString(DevOpsConstants.ORCHESTRATION_TOOL_ID_ATTR.toString()) : tokenDetails.get(DevOpsConstants.TOOL_ID_ATTR.toString()));
            conn.setRequestProperty("Authorization", "sn_devops.DevOpsToken " + toolId + ":" + token);
        } else {
            byte[] message = (username + ":" + password).getBytes(charSet);
            String encoded = DatatypeConverter.printBase64Binary((byte[])message);
            conn.setRequestProperty("Authorization", "Basic " + encoded);
        }
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("X-Transaction-Source", transactionSource);
        conn.setConnectTimeout(connectTimeout);
        conn.setRequestMethod(method);
        if (method.equals(DevOpsConstants.REST_POST_METHOD.toString()) || method.equals(DevOpsConstants.REST_PUT_METHOD.toString())) {
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(data.getBytes(charSet));
            }
        }
        jsonResult = CommUtils._readResponse(conn);
        return jsonResult;
    }

    private static String _appendParams(String urlString, JSONObject params) {
        CommUtils.printDebug("_appendParams", null, null, Level.FINE);
        if (params != null) {
            StringBuffer sb = new StringBuffer(urlString);
            sb.append("?");
            Iterator keys = params.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = params.getString(key);
                try {
                    String query = String.format(key + "=%s", URLEncoder.encode(val, charSet.name()));
                    sb.append(query);
                    if (!keys.hasNext()) continue;
                    sb.append("&");
                }
                catch (UnsupportedEncodingException e) {
                    CommUtils.printDebug("_appendParams", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
                }
            }
            urlString = sb.toString();
        }
        CommUtils.printDebug("_appendParams", new String[]{"urlString"}, new String[]{urlString}, Level.FINE);
        return urlString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject _readResponse(HttpURLConnection conn) throws IOException {
        CommUtils.printDebug("_readResponse", null, null, Level.FINE);
        JSONObject jsonResult = null;
        InputStream in = null;
        String result = null;
        try {
            in = conn.getResponseCode() > 299 ? conn.getErrorStream() : new BufferedInputStream(conn.getInputStream());
            result = IOUtils.toString((InputStream)in, (Charset)charSet);
        }
        finally {
            if (in != null) {
                in.close();
            }
            conn.disconnect();
        }
        if (result != null && !result.isEmpty()) {
            jsonResult = JSONObject.fromObject((Object)result);
        }
        if (jsonResult != null) {
            CommUtils.printDebug("_readResponse", new String[]{"jsonResult"}, new String[]{jsonResult.toString()}, Level.FINE);
        }
        return jsonResult;
    }

    private static void printDebug(String methodName, String[] variables, String[] values, Level logLevel) {
        GenericUtils.printDebug(CommUtils.class.getName(), methodName, variables, values, logLevel);
    }
}

