/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps.executions;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.config.DevOpsConfigurationEntry;
import io.jenkins.plugins.config.DevOpsJobProperty;
import io.jenkins.plugins.model.DevOpsModel;
import io.jenkins.plugins.model.DevOpsPipelineInfoConfig;
import io.jenkins.plugins.pipeline.steps.DevOpsPipelineMapStep;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.util.logging.Level;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;

public class DevOpsPipelineMapStepExecution
extends SynchronousStepExecution<Boolean> {
    private static final long serialVersionUID = 1L;
    private DevOpsPipelineMapStep step;

    public DevOpsPipelineMapStepExecution(StepContext context, DevOpsPipelineMapStep step) {
        super(context);
        this.step = step;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Boolean run() throws Exception {
        try {
            this.printDebug("run", null, null, Level.FINE);
            DevOpsModel model = new DevOpsModel();
            Run run = (Run)this.getContext().get(Run.class);
            EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
            DevOpsJobProperty jobProperties = model.getJobProperty(run.getParent());
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            Boolean result = false;
            if (!this.step.isEnabled()) {
                String message = "[ServiceNow DevOps] Step association is disabled.";
                listener.getLogger().println(message);
                this.printDebug("run", new String[]{"step mapping disabled"}, new String[]{message}, Level.FINE);
                return true;
            }
            String pronoun = run.getParent().getPronoun();
            boolean pipelineTrack = model.checkIsTrackingCache(run.getParent(), run.getId());
            boolean isPullRequestPipeline = pronoun.equalsIgnoreCase(DevOpsConstants.PULL_REQUEST_PRONOUN.toString());
            DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntryOrDefault(this.step.getConfigurationName());
            if (devopsConfig == null) {
                return GenericUtils.handleConfigurationNotFound(this.step, jobProperties, listener, this.getContext(), false, this.step.isIgnoreErrors());
            }
            String devopsConfigMessage = String.format("[ServiceNow DevOps] Using DevOps configuration %s", devopsConfig.getName());
            listener.getLogger().println(devopsConfigMessage);
            DevOpsModel.DevOpsPipelineInfo pipelineInfo = model.checkIsTracking(run.getParent(), run.getId(), (String)envVars.get((Object)"BRANCH_NAME"));
            DevOpsPipelineInfoConfig pipelineInfoConfig = GenericUtils.getPipelineInfoConfigFromConfigEntry(pipelineInfo, devopsConfig);
            if (pipelineTrack && pipelineInfoConfig != null && pipelineInfoConfig.isTrack() && (isPullRequestPipeline && devopsConfig.getTrackPullRequestPipelinesCheck() || !isPullRequestPipeline)) {
                boolean _result = model.handleStepMapping(run, run.getParent(), this, envVars);
                this.printDebug("run", new String[]{"_result"}, new String[]{String.valueOf(_result)}, Level.FINE);
                result = _result;
                if (_result) {
                    listener.getLogger().println("[ServiceNow DevOps] Step associated successfully");
                    this.printDebug("run", new String[]{"message"}, new String[]{"Step associated successfully"}, Level.FINE);
                    return result;
                }
                this.printDebug("run", new String[]{"message"}, new String[]{"Step could not be associated"}, Level.FINE);
                String message = "[ServiceNow DevOps] Step could not be associated, perhaps you need to set the Orchestration pipeline on the Pipeline and Orchestration stage on the Pipeline Steps";
                listener.getLogger().println(message);
                if (!jobProperties.isIgnoreSNErrors() && !this.step.isIgnoreErrors()) {
                    run.setResult(Result.FAILURE);
                    throw new AbortException(message);
                }
                listener.getLogger().println("[ServiceNow DevOps] Step association error ignored.");
                return result;
            }
            if (pipelineInfoConfig == null) return result;
            if (pipelineInfoConfig.isTrack()) return result;
            listener.getLogger().println("[ServiceNow DevOps] Pipeline is not tracked");
            return result;
        }
        catch (Exception e) {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            listener.getLogger().println("[ServiceNow DevOps] Error occured while step mapping,Exception: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public DevOpsPipelineMapStep getStep() {
        return this.step;
    }

    private void printDebug(String methodName, String[] variables, String[] values, Level logLevel) {
        GenericUtils.printDebug(DevOpsPipelineMapStepExecution.class.getName(), methodName, variables, values, logLevel);
    }
}

