/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps.executions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.config.DevOpsJobProperty;
import io.jenkins.plugins.model.CDMSnapshot;
import io.jenkins.plugins.model.DevOpsModel;
import io.jenkins.plugins.pipeline.steps.DevOpsConfigGetSnapshotsStep;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.ConnectException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DevOpsConfigGetSnapshotsStepExecution
extends SynchronousNonBlockingStepExecution<String> {
    private static final long serialVersionUID = 1L;
    private static final String RETRY = "retry";
    private static final long startDelayInMilliseconds = 114L;
    private static final long maxDelayInMilliseconds = 466944L;
    private static final int maxNumberOfRetries = 14;
    private int notValidatedRetryCount = 60;
    private boolean checkForNotValidated = true;
    private DevOpsConfigGetSnapshotsStep step;
    private ObjectMapper mapper = new ObjectMapper();
    public String appSysId = "";

    public DevOpsConfigGetSnapshotsStepExecution(StepContext context, DevOpsConfigGetSnapshotsStep step) {
        super(context);
        this.step = step;
    }

    protected String run() throws Exception {
        Run run = (Run)this.getContext().get(Run.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
        DevOpsModel model = new DevOpsModel();
        DevOpsJobProperty jobProperties = model.getJobProperty(run.getParent());
        List<CDMSnapshot> result = new ArrayList<CDMSnapshot>();
        boolean noDeployablesImpacted = false;
        int noOfDeployablesImpacted = 0;
        boolean noDeployablesAssociatedWithApp = false;
        try {
            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Config status step execution starts");
            if (this.validateStepInputs().booleanValue()) {
                List<String> deployableNames;
                JSONObject appDetails = null;
                appDetails = model.checkForValidApp(this.step.getApplicationName());
                JSONArray appResult = appDetails.getJSONArray(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
                if (appResult.size() == 0) {
                    GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Failed to find application with given name");
                    throw new AbortException("Failed to find application with given name");
                }
                this.appSysId = appResult.getJSONObject(0).getString("sys_id");
                if (this.appSysId == null) {
                    GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Failed to find application with given name");
                    throw new AbortException("Failed to find application with given name");
                }
                String appName = "";
                String changesetSysId = "";
                if (!StringUtils.isEmpty((CharSequence)this.step.getChangesetNumber())) {
                    Callable<String> callable = () -> {
                        String retryStatus = "success";
                        JSONObject changesetDetails = model.getChangesetId(this.step.getChangesetNumber());
                        JSONArray details = changesetDetails.getJSONArray(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
                        if (details.size() == 0) {
                            return retryStatus;
                        }
                        JSONObject changesetSysIdObj = details.getJSONObject(0);
                        String changesetState = changesetSysIdObj.getString(DevOpsConstants.COMMON_RESPONSE_STATE.toString());
                        if (changesetState.equals("open") || changesetState.equals("commit_failed") || changesetState.equals("blocked") || changesetState.equals("committed")) {
                            return retryStatus;
                        }
                        GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Waiting for changeset to get committed");
                        retryStatus = RETRY;
                        return retryStatus;
                    };
                    this.pollWithCallable(listener, callable, model);
                    JSONObject committedChangeset = model.getChangesetId(this.step.getChangesetNumber());
                    JSONArray changesetDetail = committedChangeset.getJSONArray(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
                    if (changesetDetail.size() == 0) {
                        GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - No changeset record found for input parameters");
                        throw new AbortException("No changeset record found for input parameters");
                    }
                    JSONObject changesetObj = changesetDetail.getJSONObject(0);
                    String state = changesetObj.getString("state");
                    appName = changesetObj.getString("cdm_application.node.name");
                    changesetSysId = changesetObj.getString("sys_id");
                    if (!state.equalsIgnoreCase("committed")) {
                        if (state.equalsIgnoreCase("open")) {
                            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - ERROR: Unable to return snapshots for an open changeset. Please ensure the changeset is committed before trying to get status of possibly created snapshots");
                            throw new AbortException("snDevOpsConfigGetSnapshots - ERROR: Unable to return snapshots for an open changeset. Please ensure the changeset is committed before trying to get status of possibly created snapshots");
                        }
                        if (state.equalsIgnoreCase("blocked")) {
                            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - ERROR: unable to return snapshots since the changeset is currently blocked. Please review the conflict details in DevOps Config and retry upload of your config data");
                            throw new AbortException("snDevOpsConfigGetSnapshots - ERROR: unable to return snapshots since the changeset is currently blocked. Please review the conflict details in DevOps Config and retry upload of your config data");
                        }
                        if (state.equalsIgnoreCase("commit_failed")) {
                            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - ERROR: unable to return snapshots since the changeset failed to commit. Please review the details in DevOps Config and retry upload of your configuration data");
                            throw new AbortException("snDevOpsConfigGetSnapshots - ERROR: unable to return snapshots since the changeset failed to commit. Please review the details in DevOps Config and retry upload of your configuration data");
                        }
                        GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Changeset provided is not yet commited - State of changeset - " + state);
                        throw new AbortException("snDevOpsConfigGetSnapshots - Changeset provided is not yet commited - State of changeset - " + state);
                    }
                    if (!this.step.getApplicationName().equalsIgnoreCase(appName)) {
                        GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Changeset provided is not associated with application : " + this.step.getApplicationName());
                        throw new AbortException("Changeset provided is not associated with application");
                    }
                }
                if ((noOfDeployablesImpacted = (deployableNames = this.getDeployableNames(model, changesetSysId, listener)).size()) == 0) {
                    if (!this.step.getContinueWithLatest()) {
                        GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - No deployables are impacted. Ignoring polling for snapshot");
                        noDeployablesImpacted = true;
                        throw new AbortException("No deployables are impacted. Ignoring polling for snapshot");
                    }
                    GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - No snapshots created. Returning the latest snapshots that have passed validation instead.");
                    List<Object> deployables = new ArrayList();
                    if (this.step.getDeployableName() == null || this.step.getDeployableName().equals("")) {
                        deployables = this.fetchDeployablesAssociatedWithApplication(this.appSysId, listener);
                        if (deployables.size() == 0) {
                            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - No deployables found for given application");
                            noDeployablesImpacted = true;
                            noDeployablesAssociatedWithApp = true;
                            throw new AbortException("No deployables found for given application");
                        }
                    } else {
                        deployables.add(this.step.getDeployableName());
                    }
                    result = this.fetchLatestSnapshots(this.appSysId, deployables, this.step.getIsValidated());
                } else {
                    if (!StringUtils.isEmpty((CharSequence)this.step.getDeployableName())) {
                        if (!deployableNames.contains(this.step.getDeployableName().toLowerCase())) {
                            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Deployable provided is not impacted under given changeset. Ignoring polling for snapshot");
                            noDeployablesImpacted = true;
                            throw new AbortException("Deployable provided is not impacted under given changeset");
                        }
                        deployableNames.clear();
                        deployableNames.add(this.step.getDeployableName());
                    }
                    result = StringUtils.isEmpty((CharSequence)this.step.getChangesetNumber()) ? this.processSnapshotsByPollingValidationStatus(this.appSysId, deployableNames, listener) : this.processSnapshotsByPollingCreationAndValidationStatus(this.appSysId, deployableNames, this.step.getChangesetNumber());
                    run.setResult(Result.SUCCESS);
                }
            } else {
                if (!jobProperties.isIgnoreSNErrors() || this.step.getMarkFailed()) {
                    run.setResult(Result.FAILURE);
                    throw new AbortException("snDevOpsConfigGetSnapshots  - Missing parameters.");
                }
                GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Validation of step inputs failed");
            }
        }
        catch (IOException | IndexOutOfBoundsException | InterruptedException | ParserConfigurationException | TransformerException | JSONException e) {
            if (!noDeployablesImpacted) {
                if (e instanceof AbortException && (!jobProperties.isIgnoreSNErrors() || this.step.getMarkFailed())) {
                    run.setResult(Result.FAILURE);
                    throw e;
                }
                GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Exception in run method");
            }
            if (!noDeployablesAssociatedWithApp) {
                if (StringUtils.isEmpty((CharSequence)this.step.getDeployableName()) && noOfDeployablesImpacted == 0 || !StringUtils.isEmpty((CharSequence)this.step.getDeployableName()) && noOfDeployablesImpacted == 0) {
                    GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - No snapshots got generated as no deployables are impacted");
                } else {
                    GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - No snapshot was generated because the specified deployable was not impacted or the deployable provided was invalid");
                }
            }
            return this.mapper.writeValueAsString(result);
        }
        String resultString = null;
        if (this.step.getIsValidated()) {
            result = result.stream().filter(snapshot -> snapshot.getValidation().equals("passed") || snapshot.getValidation().equals("passed_with_exception")).collect(Collectors.toList());
        }
        try {
            if (result.size() != 0) {
                result = this.addDeployableDetails(result);
                List<CDMSnapshot> resultWithValidation = null;
                GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Preparing to fetch policy validation results for snapshots");
                resultWithValidation = this.generateTestResults(result, workspace, listener, envVars);
                resultString = this.mapper.writeValueAsString(resultWithValidation);
                GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots -  Result " + resultString);
                return resultString;
            }
            if (!jobProperties.isIgnoreSNErrors() || this.step.getMarkFailed()) {
                run.setResult(Result.FAILURE);
                throw new AbortException("snDevOpsConfigGetSnapshots  - No snapshot found for input parameters");
            }
            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots  - No snapshot found for input parameters");
            return this.mapper.writeValueAsString(result);
        }
        catch (IOException | IndexOutOfBoundsException | InterruptedException | ParserConfigurationException | TransformerException | JSONException e) {
            if (e instanceof AbortException && (!jobProperties.isIgnoreSNErrors() || this.step.getMarkFailed())) {
                run.setResult(Result.FAILURE);
                throw e;
            }
            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Exception in run method");
            return this.mapper.writeValueAsString((Object)"[]");
        }
    }

    public List<String> fetchDeployablesAssociatedWithApplication(String appId, TaskListener listener) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException, ParserConfigurationException, TransformerException {
        DevOpsModel model = new DevOpsModel();
        ArrayList<String> deployableNames = new ArrayList<String>();
        JSONObject response = model.fetchDeployables(appId);
        JSONArray result = response.getJSONArray("result");
        if (!result.isEmpty()) {
            for (int i = 0; i < result.size(); ++i) {
                deployableNames.add(result.getJSONObject(i).getString("node.name"));
            }
        }
        return deployableNames;
    }

    public List<CDMSnapshot> fetchLatestSnapshots(String appId, List<String> deployables, boolean isValidated) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException, ParserConfigurationException, TransformerException {
        DevOpsModel model = new DevOpsModel();
        ArrayList<CDMSnapshot> snapshotList = new ArrayList<CDMSnapshot>();
        this.getSnapShotListAfterQuery(appId, deployables, model, snapshotList, null, isValidated, true);
        return snapshotList;
    }

    public List<CDMSnapshot> addDeployableDetails(List<CDMSnapshot> snapshots) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException, ParserConfigurationException, TransformerException {
        DevOpsModel model = new DevOpsModel();
        for (CDMSnapshot snapshot : snapshots) {
            String sysId = snapshot.getSys_id();
            JSONObject response = model.getDeployableName(sysId);
            JSONArray result = response.getJSONArray("result");
            if (result.isEmpty()) {
                snapshot.setDeployableName("");
                snapshot.setEnvironmentType("");
                continue;
            }
            JSONObject responseBody = result.getJSONObject(0);
            snapshot.setDeployableName(responseBody.getString("deployable_id.name"));
            snapshot.setEnvironmentType(responseBody.getString("cdm_deployable_id.environment_type"));
        }
        return snapshots;
    }

    public List<CDMSnapshot> generateTestResults(List<CDMSnapshot> results, FilePath workspace, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException, ParserConfigurationException, TransformerException {
        DevOpsModel model = new DevOpsModel();
        int noOfSnapshots = results.size();
        List<Object> snapshotNames = new ArrayList();
        List<Object> validationStates = new ArrayList();
        List<Object> snapshotSysIds = new ArrayList();
        ArrayList<CDMSnapshot> updatedSnapshotObj = new ArrayList<CDMSnapshot>();
        for (int i = 0; i < noOfSnapshots; ++i) {
            snapshotNames = results.stream().map(s -> s.getName()).collect(Collectors.toList());
            validationStates = results.stream().map(s -> s.getValidation()).collect(Collectors.toList());
            snapshotSysIds = results.stream().map(s -> s.getSys_id()).collect(Collectors.toList());
        }
        JSONObject validationResults = null;
        ArrayList<JSONObject> processedResults = new ArrayList<JSONObject>();
        for (int j = 0; j < noOfSnapshots; ++j) {
            String snapshotName = (String)snapshotNames.get(j);
            String validationState = (String)validationStates.get(j);
            String snapshotSysId = (String)snapshotSysIds.get(j);
            if (validationState.equalsIgnoreCase("passed") || validationState.equalsIgnoreCase("failed") || validationState.equalsIgnoreCase("execution_error") || validationState.equalsIgnoreCase("not_validated") || validationState.equalsIgnoreCase("passed_with_exception")) {
                validationResults = model.getValidationResults(snapshotSysId, "", "");
                JSONArray result = validationResults.getJSONArray("result");
                if (result.isEmpty()) {
                    GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Failed to get the validation results or no results found for the snapshot : " + snapshotName);
                    this.processValidationResults(validationResults, snapshotName, snapshotSysId, validationState, workspace, listener, envVars);
                    processedResults.add(null);
                    continue;
                }
                GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Fetching validation results for the snapshot : " + snapshotName);
                this.processValidationResults(validationResults, snapshotName, snapshotSysId, validationState, workspace, listener, envVars);
                processedResults.add(validationResults);
                continue;
            }
            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Validation of snapshot " + snapshotName + " is not yet complete, skipping validation results");
            processedResults.add(null);
        }
        for (int k = 0; k < processedResults.size(); ++k) {
            JSONObject policyValidations = (JSONObject)processedResults.get(k);
            CDMSnapshot intialResult = results.get(k);
            intialResult.setValidationResults(policyValidations);
            updatedSnapshotObj.add(intialResult);
        }
        return updatedSnapshotObj;
    }

    public void processValidationResults(JSONObject validationResult, String snapshotName, String snapshotSysId, String validationState, FilePath workspace, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException, ParserConfigurationException, TransformerException {
        JSONArray results = validationResult.getJSONArray("result");
        String format = "";
        format = this.step.getOutputFormat() == null || !this.step.getOutputFormat().equalsIgnoreCase("json") ? "xml" : "json";
        ArrayList<JSONObject> processedResults = new ArrayList<JSONObject>();
        String appName = "";
        if (results.size() != 0) {
            int noOfPolicies = results.size();
            ArrayList<String> policyNames = new ArrayList<String>();
            ArrayList<String> impactedNodes = new ArrayList<String>();
            ArrayList<String> nodePaths = new ArrayList<String>();
            JSONObject getApp = results.getJSONObject(0);
            appName = getApp.getString("snapshot.application_id.name");
            JSONObject dummyJSON = new JSONObject();
            for (int i = 0; i < noOfPolicies; ++i) {
                String decision = "";
                String policyName = "";
                String impactedNode = "";
                String nodePath = "";
                JSONObject policyOutput = results.getJSONObject(i);
                String output = policyOutput.getString("policy_execution.output");
                if (output.isEmpty()) {
                    decision = "non-complaint";
                    policyName = policyOutput.getString("policy.name");
                    impactedNode = policyOutput.getString("impacted_node.name");
                    nodePath = policyOutput.getString("node_path");
                } else {
                    JSONObject outputJson = JSONObject.fromObject((Object)output);
                    decision = outputJson.getString("decision");
                    policyName = policyOutput.getString("policy.name");
                    if (decision.equals("passed_with_exception")) {
                        policyName = policyName + " (EXCEPTION)";
                    }
                    impactedNode = policyOutput.getString("impacted_node.name");
                    nodePath = policyOutput.getString("node_path");
                }
                if (policyNames.contains(policyName)) continue;
                policyNames.add(policyName);
                impactedNodes.add(impactedNode);
                nodePaths.add(nodePath);
                if (!output.isEmpty()) {
                    processedResults.add(JSONObject.fromObject((Object)output));
                    continue;
                }
                processedResults.add(dummyJSON);
            }
            this.generateTestResults(processedResults, policyNames, impactedNodes, nodePaths, snapshotName, appName, snapshotSysId, format, validationState, workspace, envVars, listener);
        } else {
            String path = workspace.getRemote();
            String pipeline = (String)envVars.get((Object)DevOpsConstants.PIPELINE_JOB_NAME.toString());
            if (pipeline.contains("/")) {
                pipeline = pipeline.replaceAll("/", "_");
            }
            String fName = snapshotName + "_" + pipeline + "_" + (String)envVars.get((Object)DevOpsConstants.PIPELINE_BUILD_NUMBER.toString());
            String fileName = "";
            StringBuilder filePath = new StringBuilder();
            if (format.equalsIgnoreCase("json")) {
                fileName = fName + ".json";
                filePath.append(path);
                filePath.append(File.separator);
                filePath.append(fileName);
                this.writeToFile(workspace, "", filePath.toString());
            } else {
                fileName = fName + ".xml";
                filePath.append(path);
                filePath.append(File.separator);
                filePath.append(fileName);
                DocumentBuilderFactory documentFactoryElement = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilderElement = documentFactoryElement.newDocumentBuilder();
                Document documentElement = documentBuilderElement.newDocument();
                Element testSuitesRootElement = documentElement.createElement("testsuites");
                documentElement.appendChild(testSuitesRootElement);
                String name = appName + "/" + snapshotName;
                Element testSuiteRootElement = documentElement.createElement("testsuite");
                testSuitesRootElement.appendChild(testSuiteRootElement);
                Attr nameElement = documentElement.createAttribute("name");
                nameElement.setValue(name);
                testSuiteRootElement.setAttributeNode(nameElement);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                DOMSource source = new DOMSource(documentElement);
                StringWriter stringWriter = new StringWriter();
                StreamResult result = new StreamResult(stringWriter);
                transformer.transform(source, result);
                this.writeToFile(workspace, stringWriter.toString(), filePath.toString());
            }
        }
    }

    public void generateTestResults(List<JSONObject> validationResults, List<String> pNames, List<String> impactedNodes, List<String> nodePaths, String snapshotName, String applicationName, String snapshotSysId, String format, String validationState, FilePath workspace, EnvVars envVars, TaskListener listener) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException, ParserConfigurationException, TransformerException {
        DevOpsModel model = new DevOpsModel();
        String path = workspace.getRemote();
        String pipeline = (String)envVars.get((Object)DevOpsConstants.PIPELINE_JOB_NAME.toString());
        if (pipeline.contains("/")) {
            pipeline = pipeline.replaceAll("/", "_");
        }
        String fName = snapshotName + "_" + pipeline + "_" + (String)envVars.get((Object)DevOpsConstants.PIPELINE_BUILD_NUMBER.toString());
        String fileName = "";
        if (!format.equalsIgnoreCase("json")) {
            int noOfPolicies = validationResults.size();
            int failureCount = 0;
            int nonComplaintDecisions = 0;
            for (int k = 0; k < validationResults.size(); ++k) {
                JSONObject processedResult = validationResults.get(k);
                if (processedResult.toString().equals("{}")) continue;
                String decision = processedResult.getString("decision");
                JSONArray failureArray = new JSONArray();
                failureArray = processedResult.getJSONArray("failures");
                failureCount += failureArray.size();
                if (!decision.equals("non_compliant")) continue;
                ++nonComplaintDecisions;
            }
            String test = "1";
            String noOfFailure = "1";
            for (int j = 0; j < noOfPolicies; ++j) {
                JSONObject policyResult = validationResults.get(j);
                String message = "";
                if (policyResult.toString().equals("{}") && (validationState.equalsIgnoreCase("execution_error") || validationState.equalsIgnoreCase("failed"))) {
                    DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    Element root = document.createElement("testsuites");
                    Attr tests = document.createAttribute("tests");
                    tests.setValue(test);
                    root.setAttributeNode(tests);
                    Attr failures = document.createAttribute("failures");
                    failures.setValue(noOfFailure);
                    root.setAttributeNode(failures);
                    document.appendChild(root);
                    Element testcase = document.createElement("testcase");
                    Attr decision = document.createAttribute("decision");
                    Attr policyName = document.createAttribute("name");
                    Element failure = document.createElement("failure");
                    decision.setValue("non_complaint");
                    policyName.setValue(pNames.get(j));
                    testcase.setAttributeNode(decision);
                    testcase.setAttributeNode(policyName);
                    testcase.appendChild(failure);
                    Element testsuite = document.createElement("testsuite");
                    root.appendChild(testsuite);
                    String name1 = applicationName + "/" + snapshotName;
                    Attr name = document.createAttribute("name");
                    name.setValue(name1);
                    testsuite.setAttributeNode(name);
                    testsuite.appendChild(testcase);
                    continue;
                }
                JSONObject r = model.getValidationResults(snapshotSysId, pNames.get(j), "xml");
                JSONArray info = r.getJSONArray("result");
                if (info.isEmpty()) continue;
                for (int b = 0; b < info.size(); ++b) {
                    Attr name;
                    String name1;
                    Element testsuite;
                    message = info.get(b).toString();
                    String validationDecision = policyResult.getString("decision");
                    DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    Element root = document.createElement("testsuites");
                    Attr tests = document.createAttribute("tests");
                    tests.setValue(test);
                    root.setAttributeNode(tests);
                    Attr failures = document.createAttribute("failures");
                    root.setAttributeNode(failures);
                    document.appendChild(root);
                    Element testcase = document.createElement("testcase");
                    Attr decision = document.createAttribute("decision");
                    Attr policyName = document.createAttribute("name");
                    Element failure = document.createElement("failure");
                    decision.setValue(validationDecision);
                    if (validationDecision.equalsIgnoreCase("compliant_with_exception")) {
                        policyName.setValue(pNames.get(j) + " (EXCEPTION)");
                    } else {
                        policyName.setValue(pNames.get(j));
                    }
                    testcase.setAttributeNode(decision);
                    testcase.setAttributeNode(policyName);
                    JSONArray failuresArray = policyResult.getJSONArray("failures");
                    if (failuresArray.size() == 0) {
                        testsuite = document.createElement("testsuite");
                        if (validationDecision.equalsIgnoreCase("non_complaint")) {
                            failures.setValue(noOfFailure);
                            testcase.appendChild(failure);
                            root.appendChild(testsuite);
                            name1 = applicationName + "/" + snapshotName;
                            name = document.createAttribute("name");
                            name.setValue(name1);
                            testsuite.setAttributeNode(name);
                            testsuite.appendChild(testcase);
                        } else {
                            failures.setValue("0");
                            root.appendChild(testsuite);
                            name1 = applicationName + "/" + snapshotName;
                            name = document.createAttribute("name");
                            name.setValue(name1);
                            testsuite.setAttributeNode(name);
                            testsuite.appendChild(testcase);
                        }
                    } else if (message.length() != 0) {
                        failures.setValue(noOfFailure);
                        failure.appendChild(document.createTextNode(message));
                        testcase.appendChild(failure);
                        testsuite = document.createElement("testsuite");
                        root.appendChild(testsuite);
                        name1 = applicationName + "/" + snapshotName;
                        name = document.createAttribute("name");
                        name.setValue(name1);
                        testsuite.setAttributeNode(name);
                        testsuite.appendChild(testcase);
                    } else {
                        failures.setValue("0");
                        testsuite = document.createElement("testsuite");
                        root.appendChild(testsuite);
                        name1 = applicationName + "/" + snapshotName;
                        name = document.createAttribute("name");
                        name.setValue(name1);
                        testsuite.setAttributeNode(name);
                        testsuite.appendChild(testcase);
                    }
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                    DOMSource source = new DOMSource(document);
                    StringWriter stringWriter = new StringWriter();
                    StreamResult result = new StreamResult(stringWriter);
                    transformer.transform(source, result);
                    String outputData = stringWriter.toString();
                    fileName = fName + "_" + pNames.get(j) + "_" + String.valueOf(b) + ".xml";
                    StringBuilder filePath = new StringBuilder();
                    filePath.append(path);
                    filePath.append(File.separator);
                    filePath.append(fileName);
                    this.writeToFile(workspace, outputData, filePath.toString());
                }
            }
        } else {
            fileName = fName + ".json";
            StringBuilder filePath = new StringBuilder();
            filePath.append(path);
            filePath.append(File.separator);
            filePath.append(fileName);
            ArrayList<JSONObject> modifiedList = new ArrayList<JSONObject>();
            for (int p = 0; p < validationResults.size(); ++p) {
                JSONObject newObj = new JSONObject();
                ArrayList<JSONObject> results = new ArrayList<JSONObject>();
                ArrayList<JSONObject> failures = new ArrayList<JSONObject>();
                ArrayList<JSONObject> warnings = new ArrayList<JSONObject>();
                int nonComplaintCount = 0;
                newObj.put("PolicyName", (Object)pNames.get(p));
                JSONObject o = model.getValidationResults(snapshotSysId, pNames.get(p), "json");
                JSONArray info = o.getJSONArray("result");
                if (!info.isEmpty()) {
                    for (int i = 0; i < info.size(); ++i) {
                        JSONObject f = info.getJSONObject(i);
                        String type = f.getString("type");
                        if (f.getString("policy_execution.decision").equalsIgnoreCase("non_compliant")) {
                            ++nonComplaintCount;
                        }
                        if (type.equalsIgnoreCase("Information")) {
                            results.add(f);
                            continue;
                        }
                        if (type.equalsIgnoreCase("Warning")) {
                            warnings.add(f);
                            continue;
                        }
                        failures.add(f);
                    }
                }
                if (nonComplaintCount == 0) {
                    newObj.put("Decision", (Object)"compliant");
                } else {
                    newObj.put("Decision", (Object)"non_compliant");
                }
                newObj.put("Results", results);
                newObj.put("Warnings", warnings);
                newObj.put("Failures", failures);
                modifiedList.add(newObj);
            }
            JSONObject jsonResult = new JSONObject();
            jsonResult.put("Application", (Object)applicationName);
            jsonResult.put("Snapshot", (Object)snapshotName);
            jsonResult.put("ValidationResults", modifiedList);
            this.writeToFile(workspace, jsonResult.toString(), filePath.toString());
        }
    }

    private void writeToFile(FilePath workspace, String fileContent, String filePath) throws IOException, InterruptedException {
        VirtualChannel channel = workspace.getChannel();
        FilePath outputFilePath = null;
        outputFilePath = workspace.isRemote() ? new FilePath(channel, filePath) : new FilePath(new File(filePath));
        outputFilePath.write(fileContent, null);
    }

    public List<CDMSnapshot> processSnapshotsByPollingCreationAndValidationStatus(String appSysId, List<String> deployableNames, String changesetNumber) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException {
        DevOpsModel model = new DevOpsModel();
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Polling for creation");
        this.pollForSnapshotCreation(appSysId, deployableNames, changesetNumber, model);
        JSONObject snapShotStatus = model.snapShotExists(appSysId, deployableNames, changesetNumber);
        this.checkErrorInResponse(snapShotStatus, "snDevOpsConfigGetSnapshots - Exception occurred while polling for snapshot creation");
        JSONArray result = snapShotStatus.getJSONArray(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
        List<CDMSnapshot> snapshotListAfterpoll = this.getSnapshotList(result);
        if (snapshotListAfterpoll.size() == 0 || snapshotListAfterpoll.size() < deployableNames.size()) {
            snapshotListAfterpoll.clear();
            return snapshotListAfterpoll;
        }
        GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Polling for validation : " + snapshotListAfterpoll.size());
        this.pollForSnapshotValidation(appSysId, deployableNames, snapshotListAfterpoll, model);
        ArrayList<CDMSnapshot> snapshotList = new ArrayList<CDMSnapshot>();
        this.getSnapShotListAfterQuery(appSysId, deployableNames, model, snapshotList, changesetNumber, false, false);
        return snapshotList;
    }

    private List<CDMSnapshot> processSnapshotsByPollingValidationStatus(String appSysId, List<String> deployableNames, TaskListener listener) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException {
        DevOpsModel devOpsModel = new DevOpsModel();
        ArrayList<CDMSnapshot> snapshotList = new ArrayList<CDMSnapshot>();
        boolean isValidated = this.step.getIsValidated();
        this.getSnapShotListAfterQuery(appSysId, deployableNames, devOpsModel, snapshotList, null, isValidated, false);
        if (snapshotList.size() == 0) {
            return snapshotList;
        }
        if (isValidated) {
            CDMSnapshot vSnapshot = null;
            if (((CDMSnapshot)snapshotList.get(0)).getValidation().equals("passed") || ((CDMSnapshot)snapshotList.get(0)).getValidation().equals("passed_with_exception")) {
                vSnapshot = (CDMSnapshot)snapshotList.get(0);
                snapshotList = new ArrayList();
                snapshotList.add(vSnapshot);
                return snapshotList;
            }
            List<CDMSnapshot> latestPassed = this.getLatestPassedSnapshot(snapshotList, isValidated, appSysId, deployableNames, devOpsModel, listener);
            return latestPassed;
        }
        Stream<String> validationStates = Stream.of("in_progress", "requested");
        List<CDMSnapshot> filteredSnapshots = snapshotList.stream().filter(snapshot -> validationStates.anyMatch(s -> s.contains(snapshot.getValidation()))).collect(Collectors.toList());
        if (filteredSnapshots.size() == 0) {
            return snapshotList;
        }
        this.pollForSnapshotValidation(appSysId, deployableNames, filteredSnapshots, devOpsModel);
        snapshotList = new ArrayList();
        this.getSnapShotListAfterQuery(appSysId, deployableNames, devOpsModel, snapshotList, null, isValidated, false);
        return snapshotList;
    }

    private List<CDMSnapshot> getLatestPassedSnapshot(List<CDMSnapshot> snapshotList, boolean isValidated, String appSysId, List<String> deployableNames, DevOpsModel model, TaskListener listener) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException {
        if (snapshotList.size() < 2) {
            return snapshotList;
        }
        GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Fetching the latest validated snapshot");
        CDMSnapshot vSnapshot = snapshotList.get(0);
        snapshotList.remove(1);
        this.pollForSnapshotValidation(appSysId, deployableNames, snapshotList, model);
        snapshotList = new ArrayList<CDMSnapshot>();
        this.getSnapShotListAfterQuery(appSysId, deployableNames, model, snapshotList, null, isValidated, false);
        if (snapshotList.get(0).getValidation().equals("passed") || snapshotList.get(0).getValidation().equals("passed_with_exception")) {
            if (snapshotList.size() == 2) {
                snapshotList.remove(1);
            }
            return snapshotList;
        }
        if (snapshotList.get(0).getValidation().equals("in_progress") || snapshotList.get(0).getValidation().equals("requested")) {
            if (snapshotList.get(0).getSys_id().equals(vSnapshot.getSys_id())) {
                snapshotList = new ArrayList<CDMSnapshot>();
                return snapshotList;
            }
            return this.getLatestPassedSnapshot(snapshotList, isValidated, appSysId, deployableNames, model, listener);
        }
        return snapshotList;
    }

    private void getSnapShotListAfterQuery(String appSysId, List<String> deployableNames, DevOpsModel devOpsModel, List<CDMSnapshot> snapshotList, String changesetNumber, boolean isValidated, boolean noImapactedDeployable) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        String snapshotType = "";
        String appName = this.step.getApplicationName();
        String depName = this.step.getDeployableName();
        String changNumber = this.step.getChangesetNumber();
        snapshotType = appName != null && !appName.isEmpty() && depName != null && !depName.isEmpty() && changNumber != null && !changNumber.isEmpty() ? "specific_snapshot" : (appName != null && !appName.isEmpty() && depName != null && !depName.isEmpty() ? "latest_snapshot" : "all_snapshots");
        String transactionSource = "system_information=jenkins,interface_type=" + this.step.getIsValidated() + ",interface_version=" + snapshotType + ",interface=" + changNumber;
        deployableNames.forEach(deployableName -> {
            JSONObject snapshots = devOpsModel.getSnapshotsByDeployables(appSysId, (String)deployableName, changesetNumber, isValidated, transactionSource, noImapactedDeployable);
            try {
                this.checkErrorInResponse(snapshots, "Unable to fetch snapshots for " + this.step.getApplicationName() + ":" + this.step.getDeployableName());
            }
            catch (IOException | InterruptedException e) {
                GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Exception in getSnapShotListAfterQuery" + e);
            }
            JSONArray result = snapshots.getJSONArray(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
            try {
                snapshotList.addAll(this.getSnapshotList(result));
            }
            catch (IOException e) {
                GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Exception in getSnapShotListAfterQuery" + e);
            }
        });
    }

    public void pollForSnapshotCreation(String appSysId, List<String> deployableNames, String changesetNumber, DevOpsModel model) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        ArrayList snapshotListAfterpoll = new ArrayList();
        Callable<String> callable = () -> {
            String retryStatus = "success";
            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Checking for snapshot");
            JSONObject snapShotStatus = model.snapShotExists(appSysId, deployableNames, changesetNumber);
            this.checkErrorInResponse(snapShotStatus, "Exception occurred while polling for snapshot creation");
            JSONArray result = null;
            result = snapShotStatus.getJSONArray(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
            if (result == null || result.size() < 1) {
                retryStatus = RETRY;
                return retryStatus;
            }
            snapshotListAfterpoll.add(this.getSnapshotList(result).get(0));
            if (snapshotListAfterpoll.size() < deployableNames.size()) {
                retryStatus = RETRY;
                GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Snapshots found : " + snapshotListAfterpoll.size());
            }
            return retryStatus;
        };
        this.pollWithCallable(listener, callable, model);
    }

    private void pollForSnapshotValidation(String appSysId, List<String> deployableNames, List<CDMSnapshot> filteredSnapshots, DevOpsModel model) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        Callable<String> callable = () -> {
            String retryStatus = "success";
            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Waiting for validation to complete");
            JSONObject snapShotStatus = model.querySnapShotStatus(appSysId, deployableNames, filteredSnapshots.stream().map(s -> s.getName()).collect(Collectors.toList()), this.notValidatedRetryCount--, this.checkForNotValidated);
            this.checkErrorInResponse(snapShotStatus, "Exception occurred while polling snapshot for validation");
            JSONArray result = snapShotStatus.getJSONArray(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
            List<CDMSnapshot> snapshotListAfterpoll = this.getSnapshotList(result);
            int notValidatedSnapshotCount = 0;
            for (CDMSnapshot cdmSnapshot : snapshotListAfterpoll) {
                if (!cdmSnapshot.getValidation().equals("not_validated")) continue;
                ++notValidatedSnapshotCount;
            }
            if (notValidatedSnapshotCount == 0) {
                this.checkForNotValidated = false;
            }
            if (snapshotListAfterpoll.size() > 0) {
                retryStatus = RETRY;
            }
            return retryStatus;
        };
        this.pollWithCallable(listener, callable, model);
    }

    private void pollWithCallable(TaskListener listener, Callable<String> callable, DevOpsModel model) throws AbortException {
        RetryPolicy retryPolicy = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handle(ConnectException.class)).handleResultIf(result -> result == RETRY)).withBackoff(114L, 466944L, ChronoUnit.MILLIS).withMaxAttempts(14).build();
        Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(ctx -> {
            String result = (String)callable.call();
            if (ctx.getAttemptCount() == 13 && result == RETRY) {
                try {
                    String retryExhaustedMessage = "snDevOpsConfigGetSnapshots - Failed after 14 tries!";
                    GenericUtils.printConsoleLog(listener, retryExhaustedMessage);
                    Run run = (Run)this.getContext().get(Run.class);
                    DevOpsJobProperty jobProperties = model.getJobProperty(run.getParent());
                    if (!jobProperties.isIgnoreSNErrors() || this.step.getMarkFailed()) {
                        throw new AbortException(retryExhaustedMessage);
                    }
                    GenericUtils.printConsoleLog(listener, "Job Ignore Error && Not Mark Failed");
                }
                catch (IOException | InterruptedException io) {
                    GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Exception in pollWithCallable");
                }
            }
            return result;
        });
    }

    public List<CDMSnapshot> getSnapshotList(JSONArray result) throws IOException {
        Iterator iterator = result.iterator();
        ArrayList<CDMSnapshot> snapshotList = new ArrayList<CDMSnapshot>();
        while (iterator.hasNext()) {
            Map snapShotObjectMap = (Map)iterator.next();
            CDMSnapshot snapshotObject = (CDMSnapshot)this.mapper.convertValue((Object)snapShotObjectMap, CDMSnapshot.class);
            snapshotList.add(snapshotObject);
        }
        return snapshotList;
    }

    public List<String> getDeployableNames(DevOpsModel model, String changesetId, TaskListener listener) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException {
        ArrayList deployableNames = Lists.newArrayList();
        if (!StringUtils.isEmpty((CharSequence)changesetId)) {
            JSONObject impactedDeployables = model.getImpactedDeployables(changesetId);
            if (this.step.getShowResults()) {
                GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Response from impacted deployables api : " + impactedDeployables);
            }
            this.checkErrorInResponse(impactedDeployables, "Unable to fetch deployable names for App" + this.step.getApplicationName());
            JSONArray result = impactedDeployables.getJSONArray(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
            for (int i = 0; i < result.size(); ++i) {
                JSONObject deployable = result.getJSONObject(i);
                String deployableName = deployable.getString("name");
                deployableNames.add(deployableName.toLowerCase());
            }
            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Deployables which got impacted are : " + deployableNames);
        } else {
            deployableNames.add(this.step.getDeployableName().toLowerCase());
        }
        return deployableNames;
    }

    private void checkErrorInResponse(JSONObject snapshotStatus, String errorMessage) throws IOException, InterruptedException, JSONException, IndexOutOfBoundsException {
        Run run = null;
        TaskListener listener = null;
        run = (Run)this.getContext().get(Run.class);
        listener = (TaskListener)this.getContext().get(TaskListener.class);
        if (snapshotStatus.containsKey((Object)DevOpsConstants.COMMON_RESULT_ERROR.toString())) {
            JSONObject error = snapshotStatus.getJSONObject(DevOpsConstants.COMMON_RESULT_ERROR.toString());
            String errorFromAPI = error.getString(DevOpsConstants.COMMON_RESPONSE_MESSAGE.toString());
            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - " + errorMessage + ": " + errorFromAPI);
            run.setResult(Result.FAILURE);
            throw new AbortException(errorMessage);
        }
    }

    private Boolean validateStepInputs() throws Exception {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        if (StringUtils.isEmpty((CharSequence)this.step.getApplicationName())) {
            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Application name is missing");
            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Application name is mandatory parameter");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.step.getDeployableName()) && StringUtils.isEmpty((CharSequence)this.step.getChangesetNumber())) {
            GenericUtils.printConsoleLog(listener, "snDevOpsConfigGetSnapshots - Deployable name or Changeset number  is mandatory");
            return false;
        }
        return true;
    }
}

