/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.pipeline.steps.DevOpsStep;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsPipelineChangeStepExecution;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.Serializable;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DevOpsPipelineChangeStep
extends Step
implements Serializable,
DevOpsStep {
    private static final long serialVersionUID = 1L;
    private String configurationName = null;
    private boolean enabled = true;
    private boolean ignoreErrors = false;
    private String changeRequestDetails = null;
    private String applicationName;
    private String snapshotName;
    private int pollingInterval;
    private int changeCreationTimeOut;
    private boolean abortOnChangeCreationFailure = true;
    private int changeStepTimeOut;
    private boolean abortOnChangeStepTimeOut = true;

    @DataBoundConstructor
    public DevOpsPipelineChangeStep() {
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    @DataBoundSetter
    public void setPollingInterval(Object pollingInterval) {
        if (pollingInterval != null) {
            this.pollingInterval = pollingInterval.toString().matches("\\d+(\\.\\d+)?") ? (int)Float.parseFloat(pollingInterval.toString()) : 0;
        }
    }

    public int getChangeCreationTimeOut() {
        return this.changeCreationTimeOut;
    }

    @DataBoundSetter
    public void setChangeCreationTimeOut(Object changeCreationTimeOut) {
        if (changeCreationTimeOut != null) {
            this.changeCreationTimeOut = changeCreationTimeOut.toString().matches("\\d+(\\.\\d+)?") ? (int)Float.parseFloat(changeCreationTimeOut.toString()) : 0;
        }
    }

    public boolean isAbortOnChangeCreationFailure() {
        return this.abortOnChangeCreationFailure;
    }

    @DataBoundSetter
    public void setAbortOnChangeCreationFailure(boolean abortOnChangeCreationFailure) {
        this.abortOnChangeCreationFailure = abortOnChangeCreationFailure;
    }

    public int getChangeStepTimeOut() {
        return this.changeStepTimeOut;
    }

    @DataBoundSetter
    public void setChangeStepTimeOut(Object changeStepTimeOut) {
        if (changeStepTimeOut != null) {
            this.changeStepTimeOut = changeStepTimeOut.toString().matches("\\d+(\\.\\d+)?") ? (int)Float.parseFloat(changeStepTimeOut.toString()) : 0;
        }
    }

    public boolean isAbortOnChangeStepTimeOut() {
        return this.abortOnChangeStepTimeOut;
    }

    @DataBoundSetter
    public void setAbortOnChangeStepTimeOut(boolean abortOnChangeStepTimeOut) {
        this.abortOnChangeStepTimeOut = abortOnChangeStepTimeOut;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @DataBoundSetter
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    @DataBoundSetter
    public void setIgnoreErrors(boolean ignore) {
        this.ignoreErrors = ignore;
    }

    public String getChangeRequestDetails() {
        return this.changeRequestDetails;
    }

    @DataBoundSetter
    public void setChangeRequestDetails(String changeRequestDetails) {
        if (!GenericUtils.isEmpty(changeRequestDetails)) {
            this.changeRequestDetails = changeRequestDetails;
        }
    }

    @Override
    public String getConfigurationName() {
        return this.configurationName;
    }

    @DataBoundSetter
    public void setConfigurationName(String configurationName) {
        if (!GenericUtils.isEmpty(configurationName)) {
            this.configurationName = configurationName;
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @DataBoundSetter
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName == null || applicationName.isEmpty() ? null : applicationName;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    @DataBoundSetter
    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName == null || snapshotName.isEmpty() ? null : snapshotName;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new DevOpsPipelineChangeStepExecution(context, this);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return DevOpsConstants.CHANGE_FUNCTION_NAME.toString();
        }

        public String getDisplayName() {
            return DevOpsConstants.CHANGE_DISPLAY_NAME.toString();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, EnvVars.class);
        }
    }
}

