/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.model;

import io.jenkins.plugins.model.DevOpsRunStatusTestModel;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.IOException;
import java.util.logging.Level;
import org.jenkinsci.plugins.workflow.actions.WorkspaceAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class DevOpsPipelineNode {
    private boolean active = true;
    private String id;
    private String name;
    private String shortName;
    private String parentId;
    private String parentName;
    private String parentExecutionUrl;
    private boolean stepAssociated;
    private String executionUrl;
    private String pipelineExecutionUrl;
    private String upstreamTaskExecutionURL;
    private String upstreamStageName;
    private FlowNode flowNode;
    private DevOpsRunStatusTestModel testModel;
    private boolean changeCtrlInProgress;
    private String stageExecutionStatus;
    private long startTime;
    private long duration;
    private long changeStartTime;
    private WorkspaceAction wsAction;
    private String stageStatusFromTag;

    public long getChangeStartTime() {
        return this.changeStartTime;
    }

    public void setChangeStartTime(long changeStartTime) {
        this.changeStartTime = changeStartTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public WorkspaceAction getWsAction() {
        return this.wsAction;
    }

    public void setWsAction(WorkspaceAction wsAction) {
        this.wsAction = wsAction;
    }

    public DevOpsPipelineNode(String parentId, String shortName, String name, FlowNode flowNode, String pipelineExecutionUrl, String stageExecutionStatus) {
        this.name = name;
        this.shortName = shortName;
        this.id = flowNode.getId();
        this.parentId = parentId;
        this.flowNode = flowNode;
        this.pipelineExecutionUrl = pipelineExecutionUrl;
        this.setExecutionUrl();
        this.stageExecutionStatus = stageExecutionStatus;
    }

    public String getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public boolean isStepAssociated() {
        return this.stepAssociated;
    }

    public void setStepAssociated(boolean stepAssociated) {
        this.stepAssociated = stepAssociated;
    }

    public String getExecutionUrl() {
        return this.executionUrl;
    }

    private void setExecutionUrl() {
        if (null != this.getFlowNode()) {
            try {
                this.executionUrl = this.getFlowNode().getUrl();
            }
            catch (IOException e) {
                GenericUtils.printDebug(DevOpsPipelineNode.class.getName(), "setExecutionURL", new String[]{"message"}, new String[]{"Skipping declarative stage"}, Level.FINE);
            }
        }
    }

    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public void setFlowNode(FlowNode flowNode) {
        this.flowNode = flowNode;
    }

    public void setTestModel(DevOpsRunStatusTestModel testModel) {
        this.testModel = testModel;
    }

    public DevOpsRunStatusTestModel getTestModel() {
        return this.testModel;
    }

    public String getUpstreamTaskExecURL() {
        return this.upstreamTaskExecutionURL;
    }

    public void setUpstreamTaskExecURL(String upstreamTaskExecURL) {
        this.upstreamTaskExecutionURL = upstreamTaskExecURL;
    }

    public String getUpstreamStageName() {
        return this.upstreamStageName;
    }

    public void setUpstreamStageName(String upstreamStageName) {
        this.upstreamStageName = upstreamStageName;
    }

    public boolean isChangeCtrlInProgress() {
        return this.changeCtrlInProgress;
    }

    public void setChangeCtrlInProgress(boolean isChangeStepInProgress) {
        this.changeCtrlInProgress = isChangeStepInProgress;
    }

    public void setStageExecStatus(String status) {
        this.stageExecutionStatus = status;
    }

    public String getStageStatusFromTag() {
        return this.stageStatusFromTag;
    }

    public void setStageStatusFromTag(String stageStatusFromTag) {
        this.stageStatusFromTag = stageStatusFromTag;
    }

    public String getPipelineExecutionUrl() {
        return this.pipelineExecutionUrl;
    }

    public void setPipelineExecutionUrl(String pipelineExecutionUrl) {
        this.pipelineExecutionUrl = pipelineExecutionUrl;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentExecutionUrl() {
        return this.parentExecutionUrl;
    }

    public void setParentExecutionUrl(String parentExecutionUrl) {
        this.parentExecutionUrl = parentExecutionUrl;
    }
}

