/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.config;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.utils.CommUtils;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class DevOpsConfigurationEntry
extends AbstractDescribableImpl<DevOpsConfigurationEntry> {
    private String instanceUrl;
    private String apiVersion;
    private String toolId;
    private String snArtifactToolId;
    private boolean defaultConnection;
    private boolean active;
    private String name;
    private String credentialsId;
    private boolean trackCheck;
    private boolean trackPullRequestPipelinesCheck;
    private String secretCredentialId;

    @DataBoundConstructor
    public DevOpsConfigurationEntry(String name, boolean active, boolean defaultConnection, String instanceUrl, String toolId, String snArtifactToolId, String apiVersion, String credentialsId, boolean trackCheck, boolean trackPullRequestPipelinesCheck, String secretCredentialId) {
        this.name = name;
        this.active = active;
        this.defaultConnection = defaultConnection;
        this.instanceUrl = GenericUtils.removeTrailingSlashes(instanceUrl);
        this.toolId = toolId;
        this.snArtifactToolId = snArtifactToolId;
        this.apiVersion = apiVersion;
        this.credentialsId = credentialsId;
        this.trackCheck = trackCheck;
        this.trackPullRequestPipelinesCheck = trackPullRequestPipelinesCheck;
        this.secretCredentialId = secretCredentialId;
    }

    public boolean getActive() {
        return this.active;
    }

    @DataBoundSetter
    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean getDefaultConnection() {
        return this.defaultConnection;
    }

    @DataBoundSetter
    public void setDefaultConnection(boolean defaultConnection) {
        this.defaultConnection = defaultConnection;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public boolean getSnDevopsEnabled() {
        return this.active;
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    @DataBoundSetter
    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = GenericUtils.removeTrailingSlashes(instanceUrl);
    }

    public String getApiVersion() {
        if (!GenericUtils.isEmptyOrDefault(this.getSecretCredentialId())) {
            return DevOpsConstants.VERSION_V2.toString();
        }
        if (!GenericUtils.isEmptyOrDefault(this.getCredentialsId())) {
            return DevOpsConstants.VERSION_V1.toString();
        }
        return this.apiVersion;
    }

    @DataBoundSetter
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public boolean getTrackCheck() {
        return this.trackCheck;
    }

    @DataBoundSetter
    public void setTrackCheck(boolean trackCheck) {
        this.trackCheck = trackCheck;
    }

    public boolean getTrackPullRequestPipelinesCheck() {
        return this.trackPullRequestPipelinesCheck;
    }

    @DataBoundSetter
    public void setTrackPullRequestPipelinesCheck(boolean trackPullRequestPipelinesCheck) {
        this.trackPullRequestPipelinesCheck = trackPullRequestPipelinesCheck;
    }

    public String getToolId() {
        return this.toolId;
    }

    @DataBoundSetter
    public void setToolId(String toolId) {
        this.toolId = toolId;
    }

    public String getSnArtifactToolId() {
        return this.snArtifactToolId;
    }

    @DataBoundSetter
    public void setSnArtifactToolId(String snArtifactToolId) {
        this.snArtifactToolId = snArtifactToolId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getSecretCredentialId() {
        return this.secretCredentialId;
    }

    @DataBoundSetter
    public void setSecretCredentialId(String secretCredentialId) {
        this.secretCredentialId = secretCredentialId;
    }

    public static String getUser(String credentialsId) {
        if (GenericUtils.isEmpty(credentialsId)) {
            return null;
        }
        StandardUsernamePasswordCredentials sc = DevOpsConfigurationEntry.getCredentials(credentialsId);
        if (sc != null) {
            return sc.getUsername();
        }
        return null;
    }

    public static String getPwd(String credentialsId) {
        if (GenericUtils.isEmpty(credentialsId)) {
            return null;
        }
        StandardUsernamePasswordCredentials sc = DevOpsConfigurationEntry.getCredentials(credentialsId);
        if (sc != null && sc.getPassword() != null) {
            return sc.getPassword().getPlainText();
        }
        return null;
    }

    public static StandardUsernamePasswordCredentials getCredentials(String credentialsId) {
        Object dr = null;
        ItemGroup itemGroup = null;
        Authentication authentication = null;
        List lc = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, itemGroup, authentication, (DomainRequirement[])new DomainRequirement[]{dr});
        for (int i = 0; i < lc.size(); ++i) {
            StandardUsernamePasswordCredentials sc = (StandardUsernamePasswordCredentials)lc.get(i);
            if (!sc.getId().equals(credentialsId)) continue;
            return sc;
        }
        return null;
    }

    public static String getTokenText(String credentialsId) {
        Object dr = null;
        ItemGroup itemGroup = null;
        Authentication authentication = null;
        List lc = CredentialsProvider.lookupCredentials(StringCredentials.class, itemGroup, authentication, (DomainRequirement[])new DomainRequirement[]{dr});
        for (int i = 0; i < lc.size(); ++i) {
            StringCredentials sc = (StringCredentials)lc.get(i);
            if (!sc.getId().equals(credentialsId)) continue;
            return sc.getSecret().getPlainText();
        }
        return null;
    }

    public static boolean callConnectionApi(String apiVersion, JSONObject params, String userId, String password, Map<String, String> tokenDetails, String instanceUrl) {
        String changeControlUrl = DevOpsConfigurationEntry.getChangeControlUrl(instanceUrl, apiVersion);
        String result = GenericUtils.parseResponseResult(CommUtils.callV2Support("GET", changeControlUrl, params, null, userId, password, null, null, tokenDetails), DevOpsConstants.TEST_CONNECTION_RESPONSE_ATTR.toString());
        return result != null && result.equalsIgnoreCase("OK");
    }

    public static String getTrimmedUrl(String url) {
        return GenericUtils.isNotEmpty(url) ? (url.endsWith("/") ? url.substring(0, url.length() - 1) : url) : null;
    }

    public static String getChangeControlUrl(String instanceUrl, String apiVersion) {
        return GenericUtils.isNotEmpty(instanceUrl) ? String.format("%s/api/sn_devops/%s/devops/orchestration/changeControl", DevOpsConfigurationEntry.getTrimmedUrl(instanceUrl), apiVersion) : null;
    }

    public static String getChangeInfoUrl(String instanceUrl, String apiVersion) {
        return GenericUtils.isNotEmpty(instanceUrl) ? String.format("%s/api/sn_devops/%s/devops/orchestration/changeInfo", DevOpsConfigurationEntry.getTrimmedUrl(instanceUrl), apiVersion) : null;
    }

    public static String getTrackingUrl(String instanceUrl, String apiVersion) {
        return GenericUtils.isNotEmpty(instanceUrl) ? String.format("%s/api/sn_devops/%s/devops/orchestration/pipelineInfo", DevOpsConfigurationEntry.getTrimmedUrl(instanceUrl), apiVersion) : null;
    }

    public String getTrackingUrl() {
        return DevOpsConfigurationEntry.getTrackingUrl(this.getInstanceUrl(), this.getApiVersion());
    }

    public String getChangeControlUrl() {
        return DevOpsConfigurationEntry.getChangeControlUrl(this.getInstanceUrl(), this.getApiVersion());
    }

    public String getChangeInfoUrl() {
        return DevOpsConfigurationEntry.getChangeInfoUrl(this.getInstanceUrl(), this.getApiVersion());
    }

    public String getCallbackUrl() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_devops/%s/devops/orchestration/callback", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl()), this.getApiVersion()) : null;
    }

    public String getMappingUrl() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_devops/%s/devops/orchestration/stepMapping", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl()), this.getApiVersion()) : null;
    }

    public String getNotificationUrl() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_devops/%s/devops/tool/orchestration", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl()), this.getApiVersion()) : null;
    }

    public String getTestUrl() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_devops/%s/devops/tool/test", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl()), this.getApiVersion()) : null;
    }

    public String getArtifactRegistrationUrl() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_devops/%s/devops/artifact/registration", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl()), this.getApiVersion()) : null;
    }

    public String getArtifactCreatePackageUrl() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_devops/%s/devops/package/registration", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl()), this.getApiVersion()) : null;
    }

    public String getCDMChangeSetCreationURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_cdm/changesets/create", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    public String getCDMUploadToComponentURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_cdm/applications/uploads/components", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    public String getCDMUploadToDeployableURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_cdm/applications/uploads/deployables", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    public String getCDMUploadToCollectionURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_cdm/applications/uploads/collections", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    public String getUploadStatusURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_cdm/applications/upload-status/", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    public String getSnapshotStatusURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/now/table/sn_cdm_snapshot", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    public String getPublishSnapshotURL(String snapshotId) {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_cdm/snapshots/%s/publish", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl()), snapshotId) : null;
    }

    public String getExportRequestURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_cdm/applications/deployables/exports", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    public String getExportConfigStatusURL(String exportId) {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_cdm/applications/deployables/exports/" + exportId + "/status", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    public String getExportConfigDataURL(String exportId) {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_cdm/applications/deployables/exports/" + exportId + "/content", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    public String getImpactedDeployableURL(String changesetId) {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_cdm/changesets/%s/impacted-deployables", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl()), changesetId) : null;
    }

    public String getPipelineRegisterURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_devops/%s/devops/config/updatePipeline", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl()), DevOpsConstants.VERSION_V1.toString()) : null;
    }

    public String getValidateSnapshotURL(String snapshotId) {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_cdm/snapshots/%s/validate", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl()), snapshotId) : null;
    }

    public String getChangesetURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/now/table/sn_cdm_changeset", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    public String getValidAppURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/now/table/sn_cdm_application", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    public String getPolicyValidationURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/now/table/sn_cdm_policy_validation_result", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    public String getSecurityResultRegistrationURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/sn_devops/%s/devops/tool/security", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl()), this.getApiVersion()) : null;
    }

    public String getDeployablesURL() {
        return GenericUtils.isNotEmpty(this.getInstanceUrl()) ? String.format("%s/api/now/table/sn_cdm_deployable", DevOpsConfigurationEntry.getTrimmedUrl(this.getInstanceUrl())) : null;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DevOpsConfigurationEntry> {
        public String getDisplayName() {
            return "DevOpsConfigurationEntryDescriptor";
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String credentialsId) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            AbstractIdCredentialsListBoxModel options = new StandardListBoxModel().includeAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardUsernamePasswordCredentials.class).includeCurrentValue(credentialsId);
            ListBoxModel.Option defOption = new ListBoxModel.Option(DevOpsConstants.SN_DEFAULT_KEY.toString(), DevOpsConstants.SN_DEFUALT.toString());
            options.add(0, (Object)defOption);
            if (DevOpsConstants.SN_DEFUALT.toString().equals(credentialsId)) {
                ((ListBoxModel.Option)options.get((int)0)).selected = true;
            } else {
                for (ListBoxModel.Option option : options) {
                    if (!option.value.equals(credentialsId)) continue;
                    option.selected = true;
                }
            }
            return options;
        }

        public ListBoxModel doFillSecretCredentialIdItems(@QueryParameter String secretCredentialId) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel().includeCurrentValue(secretCredentialId);
            }
            Object dr = null;
            Object itemGroup = null;
            Object authentication = null;
            AbstractIdCredentialsListBoxModel options = new StandardListBoxModel().includeAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StringCredentials.class).includeCurrentValue(secretCredentialId);
            ListBoxModel.Option defOption = new ListBoxModel.Option(DevOpsConstants.SN_DEFAULT_KEY.toString(), DevOpsConstants.SN_DEFUALT.toString());
            options.add(0, (Object)defOption);
            if (DevOpsConstants.SN_DEFUALT.toString().equals(secretCredentialId)) {
                ((ListBoxModel.Option)options.get((int)0)).selected = true;
            } else {
                for (ListBoxModel.Option option : options) {
                    if (!option.value.equals(secretCredentialId)) continue;
                    option.selected = true;
                }
            }
            return options;
        }

        @POST
        public FormValidation doCheckName(@QueryParameter(value="name") String name) throws IOException, ServletException {
            if (GenericUtils.isEmpty(name)) {
                return FormValidation.error((String)"Please provide a unique name for this connection");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckInstanceUrl(@QueryParameter(value="instanceUrl") String snInstanceUrl) throws IOException, ServletException {
            if (GenericUtils.isEmpty(snInstanceUrl)) {
                return FormValidation.error((String)"Please provide a valid instance URL");
            }
            if (snInstanceUrl.length() > 0 && !snInstanceUrl.startsWith("http")) {
                return FormValidation.error((String)"URL must start with http/https");
            }
            if (snInstanceUrl.length() > 9 && !GenericUtils.checkUrlValid(snInstanceUrl)) {
                if (snInstanceUrl.substring(0, 5).equalsIgnoreCase("http:")) {
                    return FormValidation.error((String)"HTTP URLs are not allowed");
                }
                return FormValidation.error((String)"Invalid URL");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAuthType(@QueryParameter(value="authType") String authType) throws IOException, ServletException {
            if (GenericUtils.isEmpty(authType)) {
                return FormValidation.error((String)"Please provide an auth Type");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCredentialsId(@QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="secretCredentialId") String secretCredentialId) throws IOException, ServletException {
            List drl = null;
            ItemGroup itemGroup = null;
            Authentication authentication = null;
            if (GenericUtils.isEmptyOrDefault(credentialsId) && GenericUtils.isEmptyOrDefault(secretCredentialId)) {
                return FormValidation.error((String)"Please choose a credential!");
            }
            if (!GenericUtils.isEmptyOrDefault(credentialsId) && CredentialsProvider.listCredentials(StandardUsernamePasswordCredentials.class, itemGroup, authentication, drl, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId)).isEmpty()) {
                return FormValidation.error((String)"Cannot find currently selected credentials");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSecretCredentialId(@QueryParameter(value="secretCredentialId") String secretCredentialId, @QueryParameter(value="credentialsId") String credentialsId) throws IOException, ServletException {
            List drl = null;
            ItemGroup itemGroup = null;
            Authentication authentication = null;
            if (GenericUtils.isEmptyOrDefault(secretCredentialId) && GenericUtils.isEmptyOrDefault(credentialsId)) {
                return FormValidation.error((String)"Please choose a secret credential!");
            }
            if (!GenericUtils.isEmptyOrDefault(secretCredentialId) && CredentialsProvider.listCredentials(StringCredentials.class, itemGroup, authentication, drl, (CredentialsMatcher)CredentialsMatchers.withId((String)secretCredentialId)).isEmpty()) {
                return FormValidation.error((String)"Cannot find currently selected credentials");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckToolId(@QueryParameter(value="toolId") String snToolId) throws IOException, ServletException {
            if (GenericUtils.isEmpty(snToolId)) {
                return FormValidation.error((String)"Please provide a valid tool ID");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="instanceUrl") String instanceUrl, @QueryParameter(value="toolId") String toolId, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="secretCredentialId") String secretCredentialId, @QueryParameter(value="active") boolean active) throws IOException, ServletException {
            List drl = null;
            ItemGroup itemGroup = null;
            Authentication authentication = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (!active) {
                return FormValidation.error((String)"Connection must be active!");
            }
            if (GenericUtils.isEmpty(instanceUrl)) {
                return FormValidation.error((String)"Please provide the url!");
            }
            if (GenericUtils.isEmpty(toolId)) {
                return FormValidation.error((String)"Invalid tool id!");
            }
            if (GenericUtils.isEmptyOrDefault(secretCredentialId) && GenericUtils.isEmptyOrDefault(credentialsId)) {
                return FormValidation.error((String)"Invalid Credential id!");
            }
            if (GenericUtils.isEmpty(instanceUrl) || !GenericUtils.checkUrlValid(instanceUrl)) {
                return FormValidation.error((String)"Invalid URL");
            }
            JSONObject params = new JSONObject();
            String user = null;
            String pwd = null;
            String tokenValue = null;
            boolean basicTest = false;
            boolean tokenTest = false;
            params.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)toolId);
            params.put(DevOpsConstants.TEST_CONNECTION_ATTR.toString(), (Object)"true");
            params.put(DevOpsConstants.TOOL_TYPE_ATTR.toString(), (Object)DevOpsConstants.TOOL_TYPE.toString());
            HashMap<String, String> tokenDetails = new HashMap<String, String>();
            if (!GenericUtils.isEmptyOrDefault(credentialsId)) {
                if (CredentialsProvider.listCredentials(StandardUsernamePasswordCredentials.class, itemGroup, authentication, drl, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId)).isEmpty()) {
                    return FormValidation.error((String)"Cannot find currently selected credentials");
                }
                StandardUsernamePasswordCredentials credentials = DevOpsConfigurationEntry.getCredentials(credentialsId);
                if (credentials != null) {
                    user = credentials.getUsername();
                    if (credentials.getPassword() != null) {
                        pwd = credentials.getPassword().getPlainText();
                    }
                }
                try {
                    basicTest = DevOpsConfigurationEntry.callConnectionApi(DevOpsConstants.VERSION_V1.toString(), params, user, pwd, null, instanceUrl);
                }
                catch (Exception e) {
                    return FormValidation.error((String)("Client error : " + e.getMessage()));
                }
            }
            if (!GenericUtils.isEmptyOrDefault(secretCredentialId)) {
                if (CredentialsProvider.listCredentials(StringCredentials.class, itemGroup, authentication, drl, (CredentialsMatcher)CredentialsMatchers.withId((String)secretCredentialId)).isEmpty()) {
                    return FormValidation.error((String)"Cannot find currently selected credentials");
                }
                tokenValue = DevOpsConfigurationEntry.getTokenText(secretCredentialId);
                tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), tokenValue);
                try {
                    tokenTest = DevOpsConfigurationEntry.callConnectionApi(DevOpsConstants.VERSION_V2.toString(), params, user, pwd, tokenDetails, instanceUrl);
                }
                catch (Exception e) {
                    return FormValidation.error((String)("Client error : " + e.getMessage()));
                }
            }
            if (!GenericUtils.isEmptyOrDefault(secretCredentialId) && !GenericUtils.isEmptyOrDefault(credentialsId)) {
                if (basicTest && tokenTest) {
                    return FormValidation.ok((String)(DevOpsConstants.BASIC_AUTHENCIATION_SUCCUSS.toString() + "\n" + DevOpsConstants.TOKEN_AUTHENTICATION_SUCCUSS.toString()));
                }
                if (basicTest) {
                    return FormValidation.error((String)(DevOpsConstants.BASIC_AUTHENCIATION_SUCCUSS.toString() + "\n" + DevOpsConstants.TOKEN_AUTHENTICATION_FAILURE.toString()));
                }
                if (tokenTest) {
                    return FormValidation.error((String)(DevOpsConstants.BASIC_AUTHENCIATION_FAILURE.toString() + "\n" + DevOpsConstants.TOKEN_AUTHENTICATION_SUCCUSS.toString()));
                }
                return FormValidation.error((String)(DevOpsConstants.BASIC_AUTHENCIATION_FAILURE.toString() + "\n" + DevOpsConstants.TOKEN_AUTHENTICATION_FAILURE.toString()));
            }
            if (!GenericUtils.isEmptyOrDefault(secretCredentialId)) {
                if (tokenTest) {
                    return FormValidation.ok((String)DevOpsConstants.TOKEN_AUTHENTICATION_SUCCUSS.toString());
                }
                return FormValidation.error((String)DevOpsConstants.TOKEN_AUTHENTICATION_FAILURE.toString());
            }
            if (basicTest) {
                return FormValidation.ok((String)DevOpsConstants.BASIC_AUTHENCIATION_SUCCUSS.toString());
            }
            return FormValidation.error((String)DevOpsConstants.BASIC_AUTHENCIATION_FAILURE.toString());
        }
    }
}

