/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import com.google.common.util.concurrent.ListenableFuture;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Environment;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import io.jenkins.plugins.DevOpsRunStatusAction;
import io.jenkins.plugins.config.DevOpsConfigurationEntry;
import io.jenkins.plugins.config.DevOpsJobProperty;
import io.jenkins.plugins.model.DevOpsModel;
import io.jenkins.plugins.model.DevOpsNotificationModel;
import io.jenkins.plugins.model.DevOpsPipelineGraph;
import io.jenkins.plugins.model.DevOpsPipelineNode;
import io.jenkins.plugins.model.DevOpsRunStatusModel;
import io.jenkins.plugins.model.DevOpsRunStatusStageModel;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.StageAction;
import org.jenkinsci.plugins.workflow.actions.TagsAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.cps.CpsStepContext;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepContext;

@Extension
public class DevOpsRunListener
extends RunListener<Run<?, ?>> {
    private DevOpsNotificationModel notificationModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleted(Run<?, ?> run, TaskListener listener) {
        super.onCompleted(run, listener);
        DevOpsModel model = new DevOpsModel();
        this.printDebug("onCompleted", null, null, Level.FINE);
        try {
            EnvVars vars = GenericUtils.getEnvVars(run, listener);
            DevOpsModel.DevOpsPipelineInfo pipelineInfo = model.checkIsTracking(run.getParent(), run.getId(), (String)vars.get((Object)"BRANCH_NAME"));
            if (pipelineInfo != null) {
                String pronoun = run.getParent().getPronoun();
                this.printDebug("onCompleted", new String[]{"pronoun"}, new String[]{pronoun}, Level.FINE);
                if (this.notificationModel == null) {
                    this.notificationModel = new DevOpsNotificationModel();
                }
                if (pronoun.equalsIgnoreCase(DevOpsConstants.PULL_REQUEST_PRONOUN.toString()) && pipelineInfo.hasTrackedPullRequestConfig() || pronoun.equalsIgnoreCase(DevOpsConstants.PIPELINE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.BITBUCKET_MULTI_BRANCH_PIPELINE_PRONOUN.toString())) {
                    this.handleRunCompleted(run, vars, pipelineInfo);
                } else if (pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString())) {
                    this.handleRunCompleted(run, vars, pipelineInfo);
                }
            }
        }
        finally {
            model.removeFromTrackingCache(run.getParent().getFullName(), run.getId());
            model.removeFromPipelineInfoCache(run.getParent().getFullName(), run.getId());
        }
    }

    public Environment setUpEnvironment(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        DevOpsModel model = new DevOpsModel();
        this.printDebug("setUpEnvironment", null, null, Level.FINE);
        if (build != null && (build.getParent().getPronoun().equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || build.getParent().getPronoun().equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString())) && model.checkIsTrackingCache(build.getParent(), build.getId())) {
            String jobId = model.getJobId((Run<?, ?>)build, (Job<?, ?>)build.getParent());
            String token = model.removeCallbackToken(jobId);
            String jobUrl = build.getParent().getAbsoluteUrl();
            String jobName = build.getParent().getName();
            String jenkinsUrl = model.getJenkinsUrl();
            String buildUrl = jenkinsUrl + build.getUrl();
            if (jobId != null && jobUrl != null && jobName != null && jenkinsUrl != null && buildUrl != null) {
                this.displayChangeRequestInfo((Run<?, ?>)build, listener, (Job<?, ?>)build.getParent(), model);
                String configurationName = model.getJobProperty(build.getParent()).getConfigurationName();
                DevOpsConfigurationEntry devOpsConfig = GenericUtils.getDevOpsConfigurationEntryOrDefault(configurationName);
                if (token != null) {
                    if (this.shouldStop((Run<?, ?>)build, listener, (Job<?, ?>)build.getParent(), model)) {
                        model.sendBuildAndToken(token, jenkinsUrl, buildUrl, jobUrl, jobName, null, null, false, null, false, devOpsConfig);
                        build.setResult(Result.FAILURE);
                        throw new Run.RunnerAbortedException();
                    }
                    model.sendBuildAndToken(token, jenkinsUrl, buildUrl, jobUrl, jobName, null, null, false, null, false, devOpsConfig);
                } else if (this.shouldStopDueToLocalError((Run<?, ?>)build, listener, (Job<?, ?>)build.getParent(), model)) {
                    build.setResult(Result.FAILURE);
                    throw new Run.RunnerAbortedException();
                }
            }
        }
        return super.setUpEnvironment(build, launcher, listener);
    }

    private boolean shouldStopDueToLocalError(Run<?, ?> run, BuildListener listener, Job<?, ?> job, DevOpsModel model) {
        this.printDebug("shouldStopDueToLocalError", null, null, Level.FINE);
        boolean result = false;
        if (run != null && job != null && listener != null && (job.getPronoun().equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || job.getPronoun().equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString()))) {
            String jobId = model.getJobId(run, job);
            String _result = model.removeCallbackResult(jobId);
            if (jobId != null && _result != null && _result.contains(DevOpsConstants.COMMON_RESULT_FAILURE.toString())) {
                DevOpsJobProperty jobProperties = model.getJobProperty(run.getParent());
                if (jobProperties.isIgnoreSNErrors()) {
                    GenericUtils.printConsoleLog((TaskListener)listener, "IGNORED: Change creation error ignored as the Ignore ServiceNow DevOps errors option is enabled.");
                } else {
                    result = true;
                    String msg = "There was error in sending callback request";
                    if (_result.contains(DevOpsConstants.COMMON_RESULT_FAILURE.toString())) {
                        msg = _result;
                    }
                    this.printDebug("shouldStop", new String[]{"message"}, new String[]{msg}, Level.FINE);
                    listener.getLogger().println("[ServiceNow DevOps]" + msg);
                }
            }
        }
        return result;
    }

    private boolean shouldStop(Run<?, ?> run, BuildListener listener, Job<?, ?> job, DevOpsModel model) {
        this.printDebug("shouldStop", null, null, Level.FINE);
        boolean result = false;
        if (run != null && job != null && listener != null && (job.getPronoun().equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || job.getPronoun().equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString()))) {
            String jobId = model.getJobId(run, job);
            String _result = model.removeCallbackResult(jobId);
            if (jobId != null && _result != null) {
                if (!model.isApproved(_result)) {
                    result = true;
                    if (model.isCanceled(_result)) {
                        listener.getLogger().println("[ServiceNow DevOps] Job was canceled");
                        this.printDebug("shouldStop", new String[]{"message"}, new String[]{"Job was canceled"}, Level.INFO);
                        String changeComments = model.getChangeComments(_result);
                        if (!GenericUtils.isEmpty(changeComments)) {
                            listener.getLogger().println("[ServiceNow DevOps] \nCancel comments:\n" + changeComments);
                        }
                    } else {
                        String msg = "Job was not approved for execution";
                        if (_result.contains(DevOpsConstants.COMMON_RESULT_FAILURE.toString())) {
                            msg = _result;
                        }
                        this.printDebug("shouldStop", new String[]{"message"}, new String[]{msg}, Level.FINE);
                        listener.getLogger().println("[ServiceNow DevOps]" + msg);
                        String changeComments = model.getChangeComments(_result);
                        if (!GenericUtils.isEmpty(changeComments)) {
                            listener.getLogger().println("[ServiceNow DevOps] \nRejection comments:\n" + changeComments);
                        }
                    }
                } else {
                    this.printDebug("shouldStop", new String[]{"message"}, new String[]{"Job has been approved for execution"}, Level.INFO);
                    listener.getLogger().println("[ServiceNow DevOps] Job has been approved for execution");
                    String changeComments = model.getChangeComments(_result);
                    if (!GenericUtils.isEmpty(changeComments)) {
                        listener.getLogger().println("[ServiceNow DevOps] \nApproval comments:\n" + changeComments);
                    }
                }
            }
        }
        return result;
    }

    private void displayChangeRequestInfo(Run<?, ?> run, BuildListener listener, Job<?, ?> job, DevOpsModel model) {
        this.printDebug("displayChangeRequestInfo", null, null, Level.FINE);
        if (run != null && job != null && listener != null && (job.getPronoun().equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || job.getPronoun().equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString()))) {
            String jobId = model.getJobId(run, job);
            String _result = model.removeChangeRequestContent(jobId);
            if (jobId != null && _result != null) {
                String changeComments;
                String changeRequestId = model.getChangeRequestInfo(_result);
                if (!GenericUtils.isEmpty(changeRequestId)) {
                    listener.getLogger().println("[ServiceNow DevOps] Change Request Id : " + changeRequestId);
                }
                if (!GenericUtils.isEmpty(changeComments = model.getChangeComments(_result))) {
                    listener.getLogger().println("[ServiceNow DevOps] Change details:\n" + changeComments);
                }
            }
        }
    }

    public void onStarted(Run<?, ?> run, TaskListener listener) {
        DevOpsModel.DevOpsPipelineInfo pipelineInfo;
        super.onStarted(run, listener);
        DevOpsModel model = new DevOpsModel();
        this.printDebug("onStarted", null, null, Level.FINE);
        EnvVars vars = GenericUtils.getEnvVars(run, listener);
        if (vars != null && (pipelineInfo = model.checkIsTracking(run.getParent(), run.getId(), (String)vars.get((Object)"BRANCH_NAME"))) != null) {
            this.printDebug("onStarted", new String[]{"pipelineInfo"}, new String[]{pipelineInfo.toString()}, Level.FINE);
            model.addToPipelineInfoCache(run.getParent().getFullName(), run.getId(), pipelineInfo);
            if (pipelineInfo.hasTrackedConfig()) {
                model.addToTrackingCache(run.getParent().getFullName(), run.getId());
                this.notificationModel = new DevOpsNotificationModel();
                String pronoun = run.getParent().getPronoun();
                if (pronoun.equalsIgnoreCase(DevOpsConstants.PULL_REQUEST_PRONOUN.toString()) && pipelineInfo.hasTrackedPullRequestConfig() || pronoun.equalsIgnoreCase(DevOpsConstants.PIPELINE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.BITBUCKET_MULTI_BRANCH_PIPELINE_PRONOUN.toString())) {
                    this.handleRunStarted(run, vars, pipelineInfo);
                    this.handlePipeline(run, vars, pipelineInfo);
                } else if (pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString())) {
                    this.handleRunStarted(run, vars, pipelineInfo);
                }
            }
        }
    }

    private void handlePipeline(final Run<?, ?> run, final EnvVars vars, final DevOpsModel.DevOpsPipelineInfo pipelineInfo) {
        this.printDebug("handlePipeline", null, null, Level.FINE);
        if (run instanceof WorkflowRun) {
            ListenableFuture promise = ((WorkflowRun)run).getExecutionPromise();
            promise.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        FlowExecution ex = (FlowExecution)((WorkflowRun)run).getExecutionPromise().get();
                        ex.addListener((GraphListener)new DevOpsStageListener(run, vars, DevOpsRunListener.this.notificationModel, pipelineInfo));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            }, (Executor)Executors.newSingleThreadExecutor());
        }
    }

    private void handleRunStarted(Run<?, ?> run, EnvVars vars, DevOpsModel.DevOpsPipelineInfo pipelineInfo) {
        this.printDebug("handleRunStarted", null, null, Level.FINE);
        if (run != null) {
            DevOpsRunStatusAction action = new DevOpsRunStatusAction();
            DevOpsRunStatusModel model = action.createRunStatus(null, run, vars, DevOpsConstants.NOTIFICATION_STARTED.toString(), null, false, null);
            action.setModel(model);
            run.addAction((Action)action);
            if (this.notificationModel != null) {
                this.notificationModel.sendNotificationToConfigurations(action, pipelineInfo, false, run, vars);
            }
        }
    }

    private void handleRunCompleted(Run<?, ?> run, EnvVars vars, DevOpsModel.DevOpsPipelineInfo pipelineInfo) {
        DevOpsRunStatusAction action;
        this.printDebug("handleRunCompleted", null, null, Level.FINE);
        if (run != null && (action = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class)) != null) {
            DevOpsRunStatusModel model = action.createRunStatus(null, run, vars, DevOpsConstants.NOTIFICATION_COMPLETED.toString(), null, false, null);
            action.setModel(model);
            if (this.notificationModel != null) {
                this.notificationModel.sendNotificationToConfigurations(action, pipelineInfo, false, run, vars);
            }
        }
    }

    private void printDebug(String methodName, String[] variables, String[] values, Level logLevel) {
        GenericUtils.printDebug(DevOpsRunListener.class.getName(), methodName, variables, values, logLevel);
    }

    public static class DevOpsStageListener
    implements GraphListener {
        private final Run<?, ?> run;
        private final EnvVars vars;
        private final DevOpsNotificationModel notificationModel;
        private DevOpsModel.DevOpsPipelineInfo pipelineInfo;

        public DevOpsStageListener(Run<?, ?> run, EnvVars vars, DevOpsNotificationModel notificationModel, DevOpsModel.DevOpsPipelineInfo pipelineInfo) {
            this.run = run;
            this.vars = vars;
            this.notificationModel = notificationModel;
            this.pipelineInfo = pipelineInfo;
        }

        public void onNewHead(FlowNode flowNode) {
            DevOpsStageListener._printDebug("onNewHead", null, null, Level.FINE);
            DevOpsRunStatusAction action = (DevOpsRunStatusAction)this.run.getAction(DevOpsRunStatusAction.class);
            DevOpsPipelineGraph pipelineGraph = action.getPipelineGraph();
            if (!pipelineGraph.isAlreadyProcessed(flowNode.getId())) {
                if (DevOpsStageListener.isStageStart(flowNode)) {
                    DevOpsStageListener._printDebug("onNewHead", new String[]{"message"}, new String[]{"stageStart FlowNode-Id: " + flowNode.getId()}, Level.FINE);
                    if (!this.isDeclarativeStage(flowNode, true)) {
                        FlowNode parentFlowNode = DevOpsStageListener.getParentStageFlowNode(flowNode);
                        String stageId = flowNode.getId();
                        String parentId = parentFlowNode == null ? "" : parentFlowNode.getId();
                        String pipelineExecutionUrl = null;
                        Jenkins jenkins = Jenkins.getInstanceOrNull();
                        if (jenkins != null) {
                            pipelineExecutionUrl = jenkins.getRootUrl() + this.run.getUrl();
                        }
                        String stageShortName = DevOpsStageListener.getStageShortName(flowNode);
                        DevOpsPipelineNode devOpsPipelineNode = pipelineGraph.addNode(parentId, stageShortName, flowNode, pipelineExecutionUrl, DevOpsConstants.NOTIFICATION_STARTED.toString());
                        DevOpsModel devopsModel = new DevOpsModel();
                        devopsModel.associateStepToNode(this.run, stageId);
                        DevOpsRunStatusModel model = action.createRunStatus(flowNode, this.run, this.vars, null, DevOpsConstants.NOTIFICATION_STARTED.toString(), true, devOpsPipelineNode);
                        action.setModel(model);
                        if (this.notificationModel != null) {
                            this.notificationModel.sendNotificationToConfigurations(action, this.pipelineInfo, true, this.run, this.vars);
                        }
                    } else {
                        DevOpsStageListener._printDebug("onNewHead", new String[]{"message"}, new String[]{"Skipping declarative stage Flow-Id:" + flowNode.getId()}, Level.FINE);
                    }
                } else if (this.isStageEnd(flowNode)) {
                    DevOpsStageListener._printDebug("onNewHead", new String[]{"message"}, new String[]{"stageEnd FlowNode-Id: " + flowNode.getId()}, Level.FINE);
                    if (!this.isDeclarativeStage(flowNode, false)) {
                        StepStartNode startNode = (StepStartNode)((StepEndNode)flowNode).getStartNode();
                        String stageStatusFromTag = this.getStageStatusFromTag((FlowNode)startNode);
                        DevOpsPipelineNode devOpsPipelineNode = pipelineGraph.getNodeById(startNode.getId());
                        DevOpsRunStatusModel model = action.createRunStatus(flowNode, this.run, this.vars, null, DevOpsConstants.NOTIFICATION_COMPLETED.toString(), false, devOpsPipelineNode);
                        if (GenericUtils.isNotEmpty(stageStatusFromTag)) {
                            DevOpsRunStatusStageModel stageModel = model.getStageModel();
                            stageModel.setStageStatusFromTag(stageStatusFromTag);
                            devOpsPipelineNode.setStageStatusFromTag(stageStatusFromTag);
                        }
                        action.setModel(model);
                        if (this.notificationModel != null) {
                            this.notificationModel.sendNotificationToConfigurations(action, this.pipelineInfo, false, this.run, this.vars);
                        }
                    } else {
                        DevOpsStageListener._printDebug("onNewHead", new String[]{"message"}, new String[]{"Skipping declarative stage Flow-Id:" + flowNode.getId()}, Level.FINE);
                    }
                }
                pipelineGraph.addToProcessedList(flowNode.getId());
            } else {
                DevOpsStageListener._printDebug("onNewHead", new String[]{"message"}, new String[]{"FlowNode with ID:", flowNode.getId(), " is already processed"}, Level.FINE);
            }
        }

        private String getStageStatusFromTag(FlowNode fn) {
            String tagValue = null;
            try {
                DevOpsStageListener._printDebug("getStageStatusFromTag", null, null, Level.FINE);
                TagsAction tagsAction = (TagsAction)fn.getPersistentAction(TagsAction.class);
                if (tagsAction != null && (tagValue = tagsAction.getTagValue("STAGE_STATUS")) != null && DevOpsStageListener.skippedStages().contains(tagValue)) {
                    return tagValue;
                }
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
            return tagValue;
        }

        public static List<String> skippedStages() {
            return Arrays.asList("SKIPPED_FOR_FAILURE", "SKIPPED_FOR_UNSTABLE", "SKIPPED_FOR_CONDITIONAL", "SKIPPED_FOR_RESTART");
        }

        private boolean isDeclarativeStage(FlowNode fn, boolean stageStart) {
            boolean result = false;
            if (fn != null) {
                String nodeName = "";
                if (stageStart) {
                    nodeName = DevOpsStageListener.getStageShortName((FlowNode)((StepStartNode)fn));
                } else {
                    StepStartNode startNode = (StepStartNode)((StepEndNode)fn).getStartNode();
                    if (startNode != null) {
                        nodeName = DevOpsStageListener.getStageShortName((FlowNode)startNode);
                    }
                }
                result = nodeName.startsWith(DevOpsConstants.DECLARATIVE_STAGE.toString());
            }
            return result;
        }

        public static String getStageShortName(FlowNode startNode) {
            String nodeName = "";
            if (startNode != null) {
                LabelAction label = (LabelAction)startNode.getAction(LabelAction.class);
                nodeName = label != null ? label.getDisplayName() : startNode.getDisplayName();
            }
            return nodeName;
        }

        private static FlowNode getCurrentStageFlowNode(StepContext stepContext, DevOpsPipelineGraph graph) {
            if (stepContext != null && stepContext instanceof CpsStepContext) {
                FlowNode flowNode = null;
                try {
                    flowNode = (FlowNode)((CpsStepContext)stepContext).get(FlowNode.class);
                    if (flowNode != null) {
                        for (FlowNode fn : flowNode.getEnclosingBlocks()) {
                            if (!DevOpsStageListener.isStageStart(fn)) continue;
                            return fn;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public static String getCurrentStageId(StepContext stepContext, DevOpsPipelineGraph graph) {
            FlowNode fn = DevOpsStageListener.getCurrentStageFlowNode(stepContext, graph);
            return fn == null ? "" : fn.getId();
        }

        public static String getCurrentStageName(StepContext stepContext, DevOpsPipelineGraph graph) {
            FlowNode fn = DevOpsStageListener.getCurrentStageFlowNode(stepContext, graph);
            return fn == null ? "" : graph.getNodeById(fn.getId()).getName();
        }

        public static FlowNode getParentStageFlowNode(FlowNode flowNode) {
            if (flowNode != null && DevOpsStageListener.isStageStart(flowNode)) {
                StepStartNode node = (StepStartNode)flowNode;
                for (FlowNode fn : node.getEnclosingBlocks()) {
                    if (!DevOpsStageListener.isStageStart(fn)) continue;
                    return fn;
                }
            }
            return null;
        }

        public static boolean isStageStart(FlowNode fn) {
            DevOpsStageListener._printDebug("isStageStart", null, null, Level.FINE);
            return fn != null && (fn.getAction(StageAction.class) != null || fn.getAction(LabelAction.class) != null && fn.getAction(ThreadNameAction.class) == null && DevOpsStageListener.isStageStartStep(fn));
        }

        private boolean isStageEnd(FlowNode fn) {
            DevOpsRunStatusAction action;
            DevOpsStageListener._printDebug("isStageEnd", null, null, Level.FINE);
            if (fn != null && this.isStageEndStep(fn) && (action = (DevOpsRunStatusAction)this.run.getAction(DevOpsRunStatusAction.class)) != null) {
                StepStartNode startNode = (StepStartNode)((StepEndNode)fn).getStartNode();
                DevOpsPipelineGraph graph = action.getPipelineGraph();
                if (DevOpsStageListener.isStageStart((FlowNode)startNode) && graph.isAlreadyProcessed(startNode.getId())) {
                    return true;
                }
            }
            return false;
        }

        public static boolean isParallelBranch(FlowNode flowNode) {
            DevOpsStageListener._printDebug("isParallelBranch", null, null, Level.FINE);
            return flowNode != null && flowNode instanceof StepStartNode && flowNode.getActions(LabelAction.class) != null && flowNode.getAction(ThreadNameAction.class) != null;
        }

        public static boolean isEnclosedInParallel(FlowNode flowNode) {
            DevOpsStageListener._printDebug("isParallelStage", null, null, Level.FINE);
            for (FlowNode fn : flowNode.getEnclosingBlocks()) {
                if (DevOpsStageListener.isParallelBranch(fn)) {
                    return true;
                }
                if (!DevOpsStageListener.isStageStart(fn)) continue;
                return false;
            }
            return false;
        }

        private static boolean isStageStartStep(FlowNode fn) {
            DevOpsStageListener._printDebug("isStageStartStep", null, null, Level.FINE);
            if (fn instanceof StepStartNode) {
                return ((StepStartNode)fn).getStepName().equalsIgnoreCase("stage");
            }
            return false;
        }

        private boolean isStageEndStep(FlowNode fn) {
            StepStartNode ssn;
            DevOpsStageListener._printDebug("isStageEndStep", null, null, Level.FINE);
            if (fn instanceof StepEndNode && (ssn = (StepStartNode)((StepEndNode)fn).getStartNode()) != null) {
                return ssn.getStepName().equalsIgnoreCase("stage");
            }
            return false;
        }

        private static void _printDebug(String methodName, String[] variables, String[] values, Level logLevel) {
            GenericUtils.printDebug(DevOpsStageListener.class.getName(), methodName, variables, values, logLevel);
        }
    }
}

