/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.RootAction;
import hudson.security.csrf.CrumbExclusion;
import io.jenkins.plugins.config.DevOpsConfigurationEntry;
import io.jenkins.plugins.model.DevOpsModel;
import io.jenkins.plugins.model.DevOpsRunStatusJobModel;
import io.jenkins.plugins.model.DevOpsRunStatusModel;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsPipelineChangeStepExecution;
import io.jenkins.plugins.utils.CommUtils;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class DevOpsRootAction
extends CrumbExclusion
implements RootAction {
    private static final HashMap<String, String> webhooks = new HashMap();
    private static final HashMap<String, String> jobs = new HashMap();
    private static final HashMap<String, String> callbackContent = new HashMap();
    private static final HashMap<String, String> callbackToken = new HashMap();
    private static final HashMap<String, DevOpsPipelineChangeStepExecution> pipelineWebhooks = new HashMap();
    private static final HashMap<String, String> changeRequestContent = new HashMap();
    private static final HashMap<String, Boolean> trackedJobs = new HashMap();
    private static final HashMap<String, DevOpsModel.DevOpsPipelineInfo> snPipelineInfo = new HashMap();

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return DevOpsConstants.CALLBACK_URL_IDENTIFIER.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _handleFreestyleCallback(String token, StringBuffer content) {
        String originalToken;
        String jobId;
        HashMap<String, String> hashMap = webhooks;
        synchronized (hashMap) {
            jobId = webhooks.remove(token);
        }
        HashMap<String, String> hashMap2 = jobs;
        synchronized (hashMap2) {
            originalToken = jobs.remove(jobId);
        }
        if (jobId != null && originalToken.equals(token)) {
            hashMap2 = callbackContent;
            synchronized (hashMap2) {
                callbackContent.put(jobId, content.toString().trim());
            }
            hashMap2 = callbackToken;
            synchronized (hashMap2) {
                callbackToken.put(jobId, token);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _handlePipelineCallback(String token, StringBuffer content) {
        DevOpsPipelineChangeStepExecution exec;
        HashMap<String, DevOpsPipelineChangeStepExecution> hashMap = pipelineWebhooks;
        synchronized (hashMap) {
            exec = pipelineWebhooks.remove(token);
        }
        if (exec != null) {
            exec.onTriggered(token, content.toString().trim());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _displayFreestyleChangeRequestInfo(String token, StringBuffer content) {
        String originalToken;
        String jobId;
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "_displayFreestyleChangeRequestInfo", new String[]{"token"}, new String[]{token}, Level.INFO);
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "_displayFreestyleChangeRequestInfo", new String[]{"content"}, new String[]{content.toString()}, Level.INFO);
        HashMap<String, String> hashMap = webhooks;
        synchronized (hashMap) {
            jobId = webhooks.get(token);
        }
        HashMap<String, String> hashMap2 = jobs;
        synchronized (hashMap2) {
            originalToken = jobs.get(jobId);
        }
        if (jobId != null && originalToken.equals(token)) {
            hashMap2 = changeRequestContent;
            synchronized (hashMap2) {
                changeRequestContent.put(jobId, content.toString().trim());
            }
            return true;
        }
        return false;
    }

    private JSONObject _sendDummyNotification(String reqestedToolId, DevOpsConfigurationEntry devopsConfig) {
        try {
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "_sendDummyNotification", new String[]{"reqestedToolId"}, new String[]{reqestedToolId}, Level.FINE);
            JSONObject params = new JSONObject();
            params.put(DevOpsConstants.TOOL_TYPE_ATTR.toString(), (Object)DevOpsConstants.TOOL_TYPE.toString());
            String toolId = devopsConfig.getToolId();
            params.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)toolId);
            String user = DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId());
            String pwd = DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId());
            DevOpsRunStatusModel model = new DevOpsRunStatusModel();
            DevOpsRunStatusJobModel jobModel = new DevOpsRunStatusJobModel();
            UUID uuid = UUID.randomUUID();
            jobModel.setName(uuid.toString() + "_dummyWebhookPipeline");
            model.setJobModel(jobModel);
            model.setNumber(0);
            model.setUrl(uuid.toString());
            model.setPronoun(DevOpsConstants.JENKINS_DUMMY_EVENT_PRONOUN.toString());
            Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).setPrettyPrinting().create();
            String data = gson.toJson((Object)model);
            JSONObject jsonResult = null;
            if (!GenericUtils.isEmptyOrDefault(devopsConfig.getSecretCredentialId())) {
                HashMap<String, String> tokenDetails = new HashMap<String, String>();
                tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), DevOpsConfigurationEntry.getTokenText(devopsConfig.getSecretCredentialId()));
                jsonResult = CommUtils.callV2Support("POST", devopsConfig.getNotificationUrl(), params, data, user, pwd, null, null, tokenDetails);
            } else {
                jsonResult = CommUtils.call("POST", devopsConfig.getNotificationUrl(), params, data, user, pwd, null, null);
            }
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "_sendDummyNotification", new String[]{"reqestedToolId", "jsonResult"}, new String[]{reqestedToolId, jsonResult.toString()}, Level.FINE);
            return jsonResult;
        }
        catch (Exception e) {
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "_sendDummyNotification", "Sending dummy notification failed for toolId: " + reqestedToolId + " Exception:" + e.getMessage(), Level.SEVERE);
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _displayPipelineChangeRequestInfo(String token, StringBuffer content) {
        DevOpsPipelineChangeStepExecution exec;
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "_displayPipelineChangeRequestInfo", new String[]{"token"}, new String[]{token}, Level.INFO);
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "_displayPipelineChangeRequestInfo", new String[]{"content"}, new String[]{content.toString()}, Level.INFO);
        HashMap<String, DevOpsPipelineChangeStepExecution> hashMap = pipelineWebhooks;
        synchronized (hashMap) {
            exec = pipelineWebhooks.get(token);
        }
        if (exec != null) {
            exec.displayPipelineChangeRequestInfo(token, content.toString().trim());
            return true;
        }
        return false;
    }

    public static String getRootDirFilePath(String jobName) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "getRootDirFilePath", new String[]{"jobName"}, new String[]{jobName}, Level.FINE);
        DevOpsModel devopsModel = new DevOpsModel();
        String jenkinsDirFilePath = devopsModel.getJenkinsRootDirPath();
        if (jobName.contains(DevOpsConstants.PATH_SEPARATOR.toString())) {
            jobName = jobName.replace(DevOpsConstants.PATH_SEPARATOR.toString(), DevOpsConstants.JOBS_PATH.toString());
        }
        String finalPath = jenkinsDirFilePath + DevOpsConstants.JOBS_PATH.toString() + jobName + DevOpsConstants.PATH_SEPARATOR.toString() + DevOpsConstants.SERVICENOW_PIPELINE_INFO_FILE_NAME.toString();
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "getRootDirFilePath", new String[]{"jobName", "finalPath"}, new String[]{jobName, finalPath}, Level.INFO);
        return finalPath;
    }

    private boolean _updatePipelineInfoFile(String token, StringBuffer content) {
        JSONObject apiResponse;
        if (content != null && (apiResponse = JSONObject.fromObject((Object)content.toString())) != null) {
            String jobName = apiResponse.get(DevOpsConstants.JOBNAME_ATTR.toString()).toString();
            Object instanceUrlObj = apiResponse.get(DevOpsConstants.INSTANCE_URL_ATTR.toString());
            Object toolIdObj = apiResponse.get(DevOpsConstants.TOOL_ID_ATTR.toString());
            if (toolIdObj == null || instanceUrlObj == null || jobName == null) {
                return false;
            }
            String instanceUrl = instanceUrlObj.toString();
            String toolId = toolIdObj.toString();
            String rootDirFilePath = DevOpsRootAction.getRootDirFilePath(jobName);
            if (this.updateResponseInFile(jobName, apiResponse, rootDirFilePath, toolId, instanceUrl)) {
                return true;
            }
        }
        return false;
    }

    public boolean updateResponseInFile(String jobName, JSONObject apiResponse, String rootDirFilePath, String toolId, String instanceUrl) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "updateResponseInFile", new String[]{"jobName"}, new String[]{jobName}, Level.FINE);
        try {
            String configKey;
            JSONObject trackObj;
            String fileContents;
            JSONObject pipelineInfo;
            FilePath pipelineInfoFile = new FilePath(new File(rootDirFilePath));
            if (pipelineInfoFile.exists() && (pipelineInfo = JSONObject.fromObject((Object)(fileContents = pipelineInfoFile.readToString()))) != null && (trackObj = GenericUtils.getTrackInfoForConfigKey(pipelineInfo, configKey = GenericUtils.getConfigEntryTrackKey(instanceUrl, toolId))) != null) {
                JSONObject updatedTrackObj = this.getUpdatedResponse(apiResponse, trackObj);
                pipelineInfo.put(configKey, (Object)updatedTrackObj);
                pipelineInfoFile.write(pipelineInfo.toString(), "UTF-8");
                String logMessage = "jobName : " + jobName + " pipelineInfoFile: " + rootDirFilePath + " is updated with content: " + pipelineInfo.toString();
                GenericUtils.printDebug(DevOpsRootAction.class.getName(), "updateResponseInFile", logMessage, Level.FINE);
                return true;
            }
            String logMessage = "jobName : " + jobName + " pipelineInfoFile: " + rootDirFilePath + " is missing";
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "updateResponseInFile", logMessage, Level.WARNING);
            return false;
        }
        catch (Exception e) {
            String logMessage = "Failed to Update PipelineInfoFile for jobName : " + jobName + " pipelineInfoFile: " + rootDirFilePath + " Exception: " + e.getMessage();
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "updateResponseInFile", logMessage, Level.SEVERE);
            e.printStackTrace();
            return false;
        }
    }

    public JSONObject getUpdatedResponse(JSONObject apiResponse, JSONObject fileData) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "getUpdatedResponse", new String[]{"apiResponse", "fileData"}, new String[]{apiResponse.toString(), fileData.toString()}, Level.FINE);
        JSONObject pipelineInfo = fileData.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
        if (pipelineInfo != null) {
            if (apiResponse.containsKey((Object)DevOpsConstants.TRACKING_RESPONSE_ATTR.toString())) {
                pipelineInfo.put(DevOpsConstants.TRACKING_RESPONSE_ATTR.toString(), apiResponse.get(DevOpsConstants.TRACKING_RESPONSE_ATTR.toString()));
            }
            if (apiResponse.containsKey((Object)DevOpsConstants.TEST_INFO_RESPONSE.toString())) {
                pipelineInfo.put(DevOpsConstants.TEST_INFO_RESPONSE.toString(), apiResponse.get(DevOpsConstants.TEST_INFO_RESPONSE.toString()));
            }
        }
        fileData.put(DevOpsConstants.COMMON_RESPONSE_RESULT.toString(), (Object)pipelineInfo);
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "getUpdatedResponse", new String[]{"apiResponse", "fileData"}, new String[]{apiResponse.toString(), fileData.toString()}, Level.FINE);
        return fileData;
    }

    /*
     * Exception decompiling
     */
    public void doDynamic(StaplerRequest request, StaplerResponse response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static JSONObject getTrackInfoForConfigKey(String jobName, String path, String key) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "getTrackInfoForConfigKey", new String[]{"jobName", "path"}, new String[]{jobName, path}, Level.INFO);
        try {
            FilePath pipelineInfoFile = new FilePath(new File(path));
            if (!pipelineInfoFile.exists()) {
                return null;
            }
            String fileContents = pipelineInfoFile.readToString();
            JSONObject pipelineInfo = JSONObject.fromObject((Object)fileContents);
            if (pipelineInfo != null) {
                return GenericUtils.getTrackInfoForConfigKey(pipelineInfo, key);
            }
            return null;
        }
        catch (Exception e) {
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "getTrackInfoForConfigKey", "reading pipelineInfoFile file: " + path + " failed\n Exception: " + GenericUtils.getStackTraceAsString(e), Level.SEVERE);
            return null;
        }
    }

    public static JSONObject getTrackingObjectFromFile(String path) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "getTrackingObjectFromFile", new String[]{"path"}, new String[]{path}, Level.INFO);
        try {
            FilePath pipelineInfoFile = new FilePath(new File(path));
            if (!pipelineInfoFile.exists()) {
                return null;
            }
            String fileContents = pipelineInfoFile.readToString();
            JSONObject pipelineInfo = JSONObject.fromObject((Object)fileContents);
            return pipelineInfo;
        }
        catch (Exception e) {
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "getTrackingObjectFromFile", "reading pipelineInfoFile file: " + path + " failed\n Exception: " + GenericUtils.getStackTraceAsString(e), Level.SEVERE);
            return null;
        }
    }

    public static Boolean updateInfoInFile(String jobName, JSONObject configsTrackInfo, String path) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "updateInfoInFile", new String[]{"jobName", "path"}, new String[]{jobName, path}, Level.INFO);
        try {
            FilePath pipelineInfoFile = new FilePath(new File(path));
            pipelineInfoFile.write(configsTrackInfo.toString(), "UTF-8");
            return true;
        }
        catch (Exception e) {
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "updateInfoInFile", "update pipelineInfoFile file: " + path + " failed\n Exception: " + GenericUtils.getStackTraceAsString(e), Level.SEVERE);
            return false;
        }
    }

    public static Boolean _deleteConfigEntryInInfoFiles(StringBuffer content) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "_deleteConfigEntryInInfoFiles", new String[0], new String[0], Level.INFO);
        try {
            JSONObject apiResponse;
            if (content != null && (apiResponse = JSONObject.fromObject((Object)content.toString())) != null) {
                Object instanceUrlObj = apiResponse.get(DevOpsConstants.INSTANCE_URL_ATTR.toString());
                Object toolIdObj = apiResponse.get(DevOpsConstants.TOOL_ID_ATTR.toString());
                if (toolIdObj == null || instanceUrlObj == null) {
                    return false;
                }
                String instanceUrl = instanceUrlObj.toString();
                String toolId = toolIdObj.toString();
                DevOpsModel devopsModel = new DevOpsModel();
                String jenkinsDirFilePath = devopsModel.getJenkinsRootDirPath() + DevOpsConstants.JOBS_PATH.toString();
                GenericUtils.printDebug(DevOpsRootAction.class.getName(), "_deleteConfigEntryInInfoFiles", new String[]{"jenkinsDirFilePath"}, new String[]{jenkinsDirFilePath}, Level.INFO);
                FilePath jenkinsRootDir = new FilePath(new File(jenkinsDirFilePath));
                if (jenkinsRootDir.exists() && !GenericUtils.isEmpty(instanceUrl) && !GenericUtils.isEmpty(toolId)) {
                    DevOpsRootAction._checkAndDeleteConfigEntryInInfoFiles(jenkinsRootDir, instanceUrl, toolId);
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "_deleteConfigEntryInInfoFiles", "_deleteConfigEntryInInfoFiles failed\n Exception: " + GenericUtils.getStackTraceAsString(e), Level.SEVERE);
            return false;
        }
    }

    public static void _checkAndDeleteConfigEntryInInfoFiles(FilePath jenkinsRootDir, String instanceUrl, String toolId) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "_checkAndDeleteConfigEntryInInfoFiles", new String[]{"instanceUrl", "toolId"}, new String[]{instanceUrl, toolId}, Level.INFO);
        try {
            String pipelineInfoFile = null;
            String folderPipelineInfoFile = null;
            ArrayList contents = new ArrayList(jenkinsRootDir.list());
            for (FilePath jobPath : contents) {
                pipelineInfoFile = jobPath + DevOpsConstants.PATH_SEPARATOR.toString() + DevOpsConstants.SERVICENOW_PIPELINE_INFO_FILE_NAME.toString();
                FilePath pipelineInfoPath = new FilePath(new File(pipelineInfoFile));
                if (pipelineInfoPath.exists()) {
                    String configKey;
                    String fileContents = pipelineInfoPath.readToString();
                    JSONObject pipelineInfo = JSONObject.fromObject((Object)fileContents);
                    if (pipelineInfo == null || !pipelineInfo.containsKey((Object)(configKey = GenericUtils.getConfigEntryTrackKey(instanceUrl, toolId)))) continue;
                    pipelineInfoPath.write(pipelineInfo.discard(configKey).toString(), "UTF-8");
                    continue;
                }
                folderPipelineInfoFile = jobPath + DevOpsConstants.JOBS_PATH.toString();
                FilePath folderPipelineDir = new FilePath(new File(folderPipelineInfoFile));
                if (!folderPipelineDir.exists()) continue;
                DevOpsRootAction._checkAndDeleteConfigEntryInInfoFiles(folderPipelineDir, instanceUrl, toolId);
            }
            return;
        }
        catch (Exception e) {
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "_checkAndDeleteConfigEntryInInfoFiles", "_checkAndDeleteConfigEntryInInfoFiles failed\n Exception: " + GenericUtils.getStackTraceAsString(e), Level.SEVERE);
            return;
        }
    }

    public static Boolean deletePipelineInfoFiles() {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "deletePipelineInfoFiles", new String[0], new String[0], Level.INFO);
        try {
            DevOpsModel devopsModel = new DevOpsModel();
            String jenkinsDirFilePath = devopsModel.getJenkinsRootDirPath() + DevOpsConstants.JOBS_PATH.toString();
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "deletePipelineInfoFiles", new String[]{"jenkinsDirFilePath"}, new String[]{jenkinsDirFilePath}, Level.INFO);
            FilePath jenkinsRootDir = new FilePath(new File(jenkinsDirFilePath));
            if (jenkinsRootDir.exists()) {
                DevOpsRootAction.checkAndDeletePipelineInfoFiles(jenkinsRootDir);
            }
            return true;
        }
        catch (Exception e) {
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "deletePipelineInfoFiles", "delete pipelineInfoFiles failed\n Exception: " + GenericUtils.getStackTraceAsString(e), Level.SEVERE);
            return false;
        }
    }

    public static void checkAndDeletePipelineInfoFiles(FilePath jenkinsRootDir) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "checkAndDeletePipelineInfoFiles", new String[0], new String[0], Level.INFO);
        try {
            String pipelineInfoFile = null;
            String folderPipelineInfoFile = null;
            ArrayList contents = new ArrayList(jenkinsRootDir.list());
            for (FilePath jobPath : contents) {
                pipelineInfoFile = null;
                pipelineInfoFile = jobPath + DevOpsConstants.PATH_SEPARATOR.toString() + DevOpsConstants.SERVICENOW_PIPELINE_INFO_FILE_NAME.toString();
                FilePath pipelineInfoPath = new FilePath(new File(pipelineInfoFile));
                if (pipelineInfoPath.exists()) {
                    pipelineInfoPath.delete();
                    continue;
                }
                folderPipelineInfoFile = null;
                folderPipelineInfoFile = jobPath + DevOpsConstants.JOBS_PATH.toString();
                FilePath folderPipelineDir = new FilePath(new File(folderPipelineInfoFile));
                if (!folderPipelineDir.exists()) continue;
                DevOpsRootAction.checkAndDeletePipelineInfoFiles(folderPipelineDir);
            }
            return;
        }
        catch (Exception e) {
            GenericUtils.printDebug(DevOpsRootAction.class.getName(), "checkAndDeletePipelineInfoFiles", "checkAndDeletePipelineInfoFiles  failed\n Exception: " + GenericUtils.getStackTraceAsString(e), Level.SEVERE);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean getTrackedJob(String key) {
        Boolean tracking;
        HashMap<String, Boolean> hashMap = trackedJobs;
        synchronized (hashMap) {
            tracking = trackedJobs.get(key);
        }
        return tracking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTrackedJob(String key) {
        Boolean tracking = true;
        HashMap<String, Boolean> hashMap = trackedJobs;
        synchronized (hashMap) {
            trackedJobs.put(key, tracking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean removeTrackedJob(String key) {
        Boolean tracking = false;
        HashMap<String, Boolean> hashMap = trackedJobs;
        synchronized (hashMap) {
            if (trackedJobs.containsKey(key)) {
                tracking = trackedJobs.remove(key);
            }
        }
        return tracking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSnPipelineInfo(String key, DevOpsModel.DevOpsPipelineInfo pipelineInfo) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "setSnPipelineInfo", new String[]{"key"}, new String[]{key}, Level.FINE);
        HashMap<String, DevOpsModel.DevOpsPipelineInfo> hashMap = snPipelineInfo;
        synchronized (hashMap) {
            snPipelineInfo.put(key, pipelineInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DevOpsModel.DevOpsPipelineInfo getSnPipelineInfo(String key) {
        DevOpsModel.DevOpsPipelineInfo pipelineInfo;
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "getSnPipelineInfo", new String[]{"key"}, new String[]{key}, Level.FINE);
        HashMap<String, DevOpsModel.DevOpsPipelineInfo> hashMap = snPipelineInfo;
        synchronized (hashMap) {
            pipelineInfo = snPipelineInfo.get(key);
        }
        return pipelineInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSnPipelineInfo(String key) {
        HashMap<String, DevOpsModel.DevOpsPipelineInfo> hashMap = snPipelineInfo;
        synchronized (hashMap) {
            if (snPipelineInfo.containsKey(key)) {
                snPipelineInfo.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getChangeRequestContent(String jobId) {
        String content;
        HashMap<String, String> hashMap = changeRequestContent;
        synchronized (hashMap) {
            content = changeRequestContent.get(jobId);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeChangeRequestContent(String jobId) {
        String content;
        HashMap<String, String> hashMap = changeRequestContent;
        synchronized (hashMap) {
            content = changeRequestContent.remove(jobId);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCallbackContent(String jobId) {
        String content;
        HashMap<String, String> hashMap = callbackContent;
        synchronized (hashMap) {
            content = callbackContent.get(jobId);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeCallbackContent(String jobId) {
        String content;
        HashMap<String, String> hashMap = callbackContent;
        synchronized (hashMap) {
            content = callbackContent.remove(jobId);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCallbackContent(String jobId, String content) {
        if (jobId != null && content != null) {
            HashMap<String, String> hashMap = callbackContent;
            synchronized (hashMap) {
                callbackContent.put(jobId, content.trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeCallbackToken(String jobId) {
        String token;
        HashMap<String, String> hashMap = callbackToken;
        synchronized (hashMap) {
            token = callbackToken.remove(jobId);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getToken(String jobId) {
        String token;
        HashMap<String, String> hashMap = jobs;
        synchronized (hashMap) {
            token = jobs.get(jobId);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJobId(String token) {
        String jobId;
        HashMap<String, String> hashMap = webhooks;
        synchronized (hashMap) {
            jobId = webhooks.get(token);
        }
        return jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerWebhook(String token, String jobId) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "registerWebhook", new String[]{"message"}, new String[]{"Registering freestyle webhook with token: " + token}, Level.INFO);
        HashMap<String, String> hashMap = webhooks;
        synchronized (hashMap) {
            webhooks.put(token, jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerJob(String jobId, String token) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "registerJob", new String[]{"message"}, new String[]{"Registering freestyle job with id: " + jobId}, Level.INFO);
        HashMap<String, String> hashMap = jobs;
        synchronized (hashMap) {
            jobs.put(jobId, token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterWebhook(String token) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "deregisterWebhook", new String[]{"message"}, new String[]{"Deregistering freestyle webhook with token: " + token}, Level.INFO);
        HashMap<String, String> hashMap = webhooks;
        synchronized (hashMap) {
            webhooks.remove(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterJob(String jobId) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "deregisterJob", new String[]{"message"}, new String[]{"Deregistering freestyle job with id: " + jobId}, Level.INFO);
        HashMap<String, String> hashMap = jobs;
        synchronized (hashMap) {
            jobs.remove(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPipelineWebhook(DevOpsPipelineChangeStepExecution exec) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "registerPipelineWebhook", new String[]{"message"}, new String[]{"Registering pipeline webhook with token: " + exec.getToken()}, Level.INFO);
        HashMap<String, DevOpsPipelineChangeStepExecution> hashMap = pipelineWebhooks;
        synchronized (hashMap) {
            pipelineWebhooks.put(exec.getToken(), exec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterPipelineWebhook(DevOpsPipelineChangeStepExecution exec) {
        GenericUtils.printDebug(DevOpsRootAction.class.getName(), "deregisterPipelineWebhook", new String[]{"message"}, new String[]{"Deregistering pipeline webhook with token: " + exec.getToken()}, Level.INFO);
        HashMap<String, DevOpsPipelineChangeStepExecution> hashMap = pipelineWebhooks;
        synchronized (hashMap) {
            pipelineWebhooks.remove(exec.getToken());
        }
    }

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/" + DevOpsConstants.CALLBACK_URL_IDENTIFIER.toString() + "/")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }
}

