/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps.executions;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.DevOpsRunListener;
import io.jenkins.plugins.DevOpsRunStatusAction;
import io.jenkins.plugins.actions.RegisterSecurityAction;
import io.jenkins.plugins.config.DevOpsConfigurationEntry;
import io.jenkins.plugins.config.DevOpsJobProperty;
import io.jenkins.plugins.model.DevOpsModel;
import io.jenkins.plugins.model.DevOpsPipelineInfoConfig;
import io.jenkins.plugins.pipeline.steps.DevOpsPipelineRegisterSecurityStep;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;

public class DevOpsPipelineRegisterSecurityStepExecution
extends SynchronousStepExecution<String> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(DevOpsPipelineRegisterSecurityStepExecution.class.getName());
    private DevOpsPipelineRegisterSecurityStep step;

    protected DevOpsPipelineRegisterSecurityStepExecution(@NonNull StepContext context) {
        super(context);
    }

    public DevOpsPipelineRegisterSecurityStepExecution(@Nonnull StepContext context, DevOpsPipelineRegisterSecurityStep step) {
        super(context);
        this.step = step;
    }

    public DevOpsPipelineRegisterSecurityStep getStep() {
        return this.step;
    }

    public void setStep(DevOpsPipelineRegisterSecurityStep step) {
        this.step = step;
    }

    protected String run() throws Exception {
        try {
            JSONObject registerResponse;
            EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
            Run run = (Run)this.getContext().get(Run.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            String attributes = this.step.getSecurityResultAttributes();
            try {
                DevOpsModel model = new DevOpsModel();
                boolean pipelineTrack = model.checkIsTrackingCache(run.getParent(), run.getId());
                DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntryOrDefault(this.step.getConfigurationName());
                if (devopsConfig == null) {
                    return String.valueOf(GenericUtils.handleConfigurationNotFound(this.step, null, listener, this.getContext(), false, false));
                }
                String devopsConfigMessage = String.format("[ServiceNow DevOps] Using DevOps configuration %s", devopsConfig.getName());
                listener.getLogger().println(devopsConfigMessage);
                GenericUtils.printDebug(DevOpsPipelineRegisterSecurityStepExecution.class.getName(), "run", new String[]{"configurationName"}, new String[]{devopsConfig.getName()}, Level.FINE);
                DevOpsModel.DevOpsPipelineInfo _pipelineInfo = model.checkIsTracking(run.getParent(), run.getId(), (String)envVars.get((Object)"BRANCH_NAME"));
                DevOpsPipelineInfoConfig pipelineInfoConfig = GenericUtils.getPipelineInfoConfigFromConfigEntry(_pipelineInfo, devopsConfig);
                if (!pipelineTrack || pipelineInfoConfig != null && !pipelineInfoConfig.isTrack()) {
                    listener.getLogger().println("[ServiceNow DevOps] Pipeline is not tracked");
                    LOGGER.log(Level.INFO, "Pipeline not tracked");
                    return null;
                }
                JSONObject pipelineInfo = new JSONObject();
                String stageName = (String)envVars.get((Object)"STAGE_NAME");
                DevOpsRunStatusAction action = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class);
                if (action != null) {
                    stageName = DevOpsRunListener.DevOpsStageListener.getCurrentStageName(this.getContext(), action.getPipelineGraph());
                }
                pipelineInfo.put(DevOpsConstants.SEC_TOOL_BUILD_NUMBER.toString(), envVars.get((Object)"BUILD_NUMBER"));
                pipelineInfo.put(DevOpsConstants.SEC_TOOL_STAGE_NAME.toString(), (Object)stageName);
                String jobName = (String)envVars.get((Object)"JOB_BASE_NAME");
                String jobFullName = (String)envVars.get((Object)"JOB_NAME");
                if (jobFullName == null || jobFullName.equals("")) {
                    jobFullName = jobName;
                }
                pipelineInfo.put(DevOpsConstants.SEC_TOOL_JOB_FULL_NAME.toString(), (Object)jobFullName);
                pipelineInfo.put(DevOpsConstants.SEC_TOOL_JOB_NAME.toString(), (Object)jobName);
                if (null != envVars.get((Object)"BRANCH_NAME")) {
                    pipelineInfo.put(DevOpsConstants.SEC_TOOL_BRANCH_NAME.toString(), envVars.get((Object)"BRANCH_NAME"));
                }
                JSONObject securityParams = null;
                securityParams = JSONObject.fromObject((Object)attributes);
                JSONObject payload = new JSONObject();
                payload.put(DevOpsConstants.SEC_TOOL_JSON_ATTR_RESULT_META_DATA.toString(), (Object)securityParams);
                payload.put(DevOpsConstants.SEC_TOOL_JSON_ATTR_TASK_INFO.toString(), (Object)pipelineInfo);
                RegisterSecurityAction rs = new RegisterSecurityAction(securityParams.toString());
                run.addAction((Action)rs);
                registerResponse = model.registerSecurityResult(payload, this.step.getConfigurationName());
            }
            catch (JSONException jsonException) {
                return this.handleException("securityResultAttributes should be in stringified JSON format : " + jsonException.getMessage());
            }
            catch (Exception exception) {
                return this.handleException("Error while registering security result to ServiceNow DevOps : " + exception.getMessage());
            }
            JSONObject resultStatus = registerResponse.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
            String status = "";
            try {
                status = resultStatus.getString(DevOpsConstants.COMMON_RESPONSE_STATUS.toString());
            }
            catch (JSONException j) {
                return this.handleException("Register step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
            }
            String errorMessage = "";
            if (status.equalsIgnoreCase("Failure")) {
                try {
                    errorMessage = resultStatus.getString(DevOpsConstants.COMMON_RESPONSE_MESSAGE.toString());
                }
                catch (JSONException j) {
                    return this.handleException("Register step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
                }
                return this.handleException(errorMessage);
            }
            GenericUtils.printConsoleLog(listener, DevOpsConstants.SECURITY_RESULT_STEP_DISPLAY_NAME.toString() + " - Security step information is successfully sent to ServiceNow");
            return DevOpsConstants.COMMON_RESPONSE_SUCCESS.toString();
        }
        catch (Exception e) {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            listener.getLogger().println("[ServiceNow DevOps] Error occurred while registering the Security scan results,Exception: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    private String handleException(String exceptionMessage) throws Exception {
        Run run = (Run)this.getContext().get(Run.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        DevOpsModel model = new DevOpsModel();
        DevOpsJobProperty jobProperties = model.getJobProperty(run.getParent());
        if (!jobProperties.isIgnoreSNErrors()) {
            run.setResult(Result.FAILURE);
            throw new AbortException(DevOpsConstants.SECURITY_RESULT_STEP_FUNCTION_NAME.toString() + " - " + exceptionMessage);
        }
        GenericUtils.printConsoleLog(listener, DevOpsConstants.SECURITY_RESULT_STEP_FUNCTION_NAME.toString() + " - " + exceptionMessage + " - Ignoring SN Errors");
        return DevOpsConstants.COMMON_RESULT_ERROR.name();
    }
}

