/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps.executions;

import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.DevOpsRunListener;
import io.jenkins.plugins.DevOpsRunStatusAction;
import io.jenkins.plugins.config.DevOpsConfigurationEntry;
import io.jenkins.plugins.config.DevOpsJobProperty;
import io.jenkins.plugins.model.DevOpsModel;
import io.jenkins.plugins.model.DevOpsPipelineGraph;
import io.jenkins.plugins.model.DevOpsPipelineInfoConfig;
import io.jenkins.plugins.pipeline.steps.DevOpsPipelineChangeInfoStep;
import io.jenkins.plugins.utils.CommUtils;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.util.HashMap;
import java.util.logging.Level;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;

public class DevOpsPipelineChageInfoStepExecution
extends SynchronousStepExecution<String> {
    private static final long serialVersionUID = 1L;
    private String currentJenkinsStepName = "[ServiceNow DevOps] snDevOpsGetChangeNumber, ";
    private DevOpsPipelineChangeInfoStep step;

    public DevOpsPipelineChageInfoStepExecution(StepContext context, DevOpsPipelineChangeInfoStep step) {
        super(context);
        this.step = step;
    }

    public DevOpsPipelineChangeInfoStep getStep() {
        return this.step;
    }

    protected String run() throws Exception {
        try {
            Run run = (Run)this.getContext().get(Run.class);
            String pronoun = run.getParent().getPronoun();
            boolean isPullRequestPipeline = pronoun.equalsIgnoreCase(DevOpsConstants.PULL_REQUEST_PRONOUN.toString());
            DevOpsModel model = new DevOpsModel();
            DevOpsJobProperty jobProperties = model.getJobProperty(run.getParent());
            boolean pipelineTrack = model.checkIsTrackingCache(run.getParent(), run.getId());
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
            DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntryOrDefault(this.step.getConfigurationName());
            if (devopsConfig == null) {
                return String.valueOf(GenericUtils.handleConfigurationNotFound(this.step, jobProperties, listener, this.getContext(), false, true));
            }
            String devopsConfigMessage = String.format("[ServiceNow DevOps] Using DevOps configuration %s", devopsConfig.getName());
            listener.getLogger().println(devopsConfigMessage);
            GenericUtils.printDebug(DevOpsPipelineChageInfoStepExecution.class.getName(), "run", new String[]{"configurationName"}, new String[]{devopsConfig.getName()}, Level.FINE);
            DevOpsModel.DevOpsPipelineInfo _pipelineInfo = model.checkIsTracking(run.getParent(), run.getId(), (String)envVars.get((Object)"BRANCH_NAME"));
            DevOpsPipelineInfoConfig pipelineInfoConfig = GenericUtils.getPipelineInfoConfigFromConfigEntry(_pipelineInfo, devopsConfig);
            if (!pipelineTrack || pipelineInfoConfig != null && !pipelineInfoConfig.isTrack()) {
                listener.getLogger().println("[ServiceNow DevOps] Pipeline is not tracked");
                return null;
            }
            return this.getChangeRequestNumber(run, isPullRequestPipeline, pipelineTrack, listener, devopsConfig, this.getStep().getChangeDetails());
        }
        catch (Exception e) {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            listener.getLogger().println("[ServiceNow DevOps] Error occurred while running snDevOpsGetChangeNumber, Exception: " + e.getMessage());
            throw e;
        }
    }

    private String getChangeRequestNumber(Run<?, ?> run, boolean isPullRequestPipeline, boolean pipelineTrack, TaskListener listener, DevOpsConfigurationEntry devopsConfig, String changeDetails) {
        String changeRequestNumber;
        listener.getLogger().println(this.currentJenkinsStepName + " ChangeDetails => " + changeDetails);
        if (GenericUtils.isNotEmpty(changeDetails)) {
            changeRequestNumber = this.getChangeRequestNumberFromChangeDetails(run, isPullRequestPipeline, pipelineTrack, listener, devopsConfig, changeDetails);
        } else {
            listener.getLogger().println(this.currentJenkinsStepName + " No changeDetails provided, checking for change in current stage");
            changeRequestNumber = this.getChangeRequestNumberFromStageName(run, isPullRequestPipeline, pipelineTrack, listener, devopsConfig, "");
        }
        if (GenericUtils.isNotEmpty(changeRequestNumber)) {
            listener.getLogger().println(this.currentJenkinsStepName + " 'Change Request Number' => " + changeRequestNumber);
        }
        return changeRequestNumber;
    }

    private String getChangeRequestNumberFromChangeDetails(Run<?, ?> run, boolean isPullRequestPipeline, boolean pipelineTrack, TaskListener listener, DevOpsConfigurationEntry devopsConfig, String changeDetails) {
        JSONObject changeDetailsJSON = JSONObject.fromObject((Object)changeDetails);
        JSONObject params = new JSONObject();
        String buildNumber = (String)changeDetailsJSON.get("build_number");
        String stageName = (String)changeDetailsJSON.get("stage_name");
        String pipelineName = (String)changeDetailsJSON.get("pipeline_name");
        if (GenericUtils.isEmpty(buildNumber) || GenericUtils.isEmpty(pipelineName) || GenericUtils.isEmpty(stageName)) {
            if (GenericUtils.isEmpty(buildNumber) && GenericUtils.isNotEmpty(stageName)) {
                return this.getChangeRequestNumberFromStageName(run, isPullRequestPipeline, pipelineTrack, listener, devopsConfig, stageName);
            }
            listener.getLogger().print(this.currentJenkinsStepName + " Couldn't get 'Change Request Number'. Please provide");
            if (GenericUtils.isEmpty(pipelineName)) {
                listener.getLogger().print(" Pipeline Name,");
            }
            if (GenericUtils.isEmpty(buildNumber)) {
                listener.getLogger().print(" Build Number,");
            }
            if (GenericUtils.isEmpty(stageName)) {
                listener.getLogger().print(" Stage Name");
            }
            listener.getLogger().println(".");
            return null;
        }
        String branchName = (String)changeDetailsJSON.get("branch_name");
        params.put(DevOpsConstants.CONFIG_BUILD_NUMBER.toString(), (Object)buildNumber);
        params.put(DevOpsConstants.ARTIFACT_STAGE_NAME.toString(), (Object)stageName);
        params.put(DevOpsConstants.ARTIFACT_PIPELINE_NAME.toString(), (Object)pipelineName);
        params.put(DevOpsConstants.SCM_BRANCH_NAME.toString(), (Object)branchName);
        params.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)devopsConfig.getToolId());
        JSONObject responseJSON = null;
        if (!GenericUtils.isEmptyOrDefault(devopsConfig.getSecretCredentialId())) {
            HashMap<String, String> tokenDetails = new HashMap<String, String>();
            tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), DevOpsConfigurationEntry.getTokenText(devopsConfig.getSecretCredentialId()));
            responseJSON = CommUtils.callV2Support(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getChangeInfoUrl(), params, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null, tokenDetails);
        } else {
            responseJSON = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getChangeInfoUrl(), params, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        }
        return this.parseResponseResult(listener, responseJSON);
    }

    private String parseResponseResult(TaskListener listener, JSONObject responseJSON) {
        if (null != responseJSON) {
            if (responseJSON.containsKey((Object)DevOpsConstants.COMMON_RESPONSE_RESULT.toString())) {
                JSONObject resultJSON = responseJSON.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
                if (resultJSON.containsKey((Object)DevOpsConstants.COMMON_RESPONSE_NUMBER.toString())) {
                    return resultJSON.getString(DevOpsConstants.COMMON_RESPONSE_NUMBER.toString());
                }
                if (resultJSON.containsKey((Object)DevOpsConstants.COMMON_RESPONSE_ERROR_MESSAGE.toString())) {
                    listener.getLogger().println(this.currentJenkinsStepName + " Couldn't get 'Change Request Number', " + resultJSON.getString(DevOpsConstants.COMMON_RESPONSE_ERROR_MESSAGE.toString()));
                }
            } else if (responseJSON.containsKey((Object)DevOpsConstants.COMMON_RESULT_ERROR.toString())) {
                listener.getLogger().println(this.currentJenkinsStepName + " Couldn't get 'Change Request Number', " + responseJSON.getJSONObject(DevOpsConstants.COMMON_RESULT_ERROR.toString()).getString(DevOpsConstants.COMMON_RESPONSE_MESSAGE.toString()));
            }
        }
        return null;
    }

    private String getChangeRequestNumberFromStageName(Run<?, ?> run, boolean isPullRequestPipeline, boolean pipelineTrack, TaskListener listener, DevOpsConfigurationEntry devopsConfig, String stageName) {
        if (pipelineTrack && (isPullRequestPipeline && devopsConfig.getTrackPullRequestPipelinesCheck() || !isPullRequestPipeline)) {
            String currentStageName;
            DevOpsPipelineGraph pipelineGraph;
            DevOpsRunStatusAction runStatusAction = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class);
            if (!stageName.isEmpty()) {
                return runStatusAction.changeRequestInfo.get(stageName);
            }
            if (runStatusAction != null && (pipelineGraph = runStatusAction.getPipelineGraph()) != null && (currentStageName = DevOpsRunListener.DevOpsStageListener.getCurrentStageName(this.getContext(), pipelineGraph)) != null) {
                return runStatusAction.changeRequestInfo.get(currentStageName);
            }
        } else {
            listener.getLogger().println(this.currentJenkinsStepName + " Please enable 'Pipeline Track' to fetch 'Change Request Number' using 'Stage Name'.");
        }
        return null;
    }
}

