/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps.executions;

import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.config.DevOpsJobProperty;
import io.jenkins.plugins.model.DevOpsModel;
import io.jenkins.plugins.pipeline.steps.DevOpsConfigUploadStep;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class DevOpsConfigUploadStepExecution
extends SynchronousNonBlockingStepExecution<String> {
    private static final long serialVersionUID = 1L;
    private static final int MAX_DEPTH_COUNT = 10;
    private DevOpsConfigUploadStep step;
    private int retryFrequency = 220;
    private int maxRetryCount = 20;
    private String validFormatRegex = ".{json,xml,yml,ini,properties,yaml}";

    public DevOpsConfigUploadStepExecution(StepContext context, DevOpsConfigUploadStep step) {
        super(context);
        this.step = step;
    }

    protected String run() throws Exception {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        DevOpsModel model = new DevOpsModel();
        GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - Config upload step execution starts");
        if (this.step.getConfigFile() == null || this.step.getConfigFile().isEmpty()) {
            return this.handleException("File regex cannot be empty. Upload failed");
        }
        if (this.step.getTarget() == null || this.step.getTarget().isEmpty()) {
            return this.handleException("Target cannot be empty. Upload failed");
        }
        try {
            listener.getLogger().println("Looking for file : " + this.step.getConfigFile());
            List<FilePath> allFilesInWorkspace = null;
            try {
                allFilesInWorkspace = this.walkFilePaths(workspace, 10);
            }
            catch (IOException | InterruptedException e) {
                return this.handleException("Error occured while fetching the files");
            }
            if (allFilesInWorkspace.isEmpty()) {
                return this.handleException("No files found inside workspace");
            }
            String configFile = this.step.getConfigFile();
            boolean isFolder = false;
            if (configFile.indexOf(46) == -1) {
                isFolder = true;
            }
            StringBuilder updatedRegex = new StringBuilder(configFile);
            if (isFolder) {
                if (this.step.getDataFormat() == null) {
                    updatedRegex.append(this.validFormatRegex);
                } else {
                    updatedRegex.append("." + this.step.getDataFormat());
                }
            }
            PathMatcher maskMatcher = FileSystems.getDefault().getPathMatcher("glob:" + updatedRegex);
            List filteredList = allFilesInWorkspace.stream().filter(c -> {
                Path fileRelativePath = Paths.get(c.getRemote().replace(workspace.getRemote() + "/", ""), new String[0]);
                return maskMatcher.matches(fileRelativePath);
            }).collect(Collectors.toList());
            if (filteredList.size() < 1) {
                return this.handleException("No files found for given regex");
            }
            JSONObject changesetResponse = null;
            String changesetNumber = "";
            if (this.step.getChangesetNumber() == null) {
                block51: {
                    try {
                        changesetResponse = model.createChangeset(this.step.getApplicationName().trim(), listener);
                    }
                    catch (Exception e) {
                        return this.handleException("Creation of changeset failed due to : " + e.getMessage() + " - Upload failed");
                    }
                    if (changesetResponse == null) {
                        return this.handleException("Failed to create changeset. Upload failed");
                    }
                    if (this.step.getShowResults()) {
                        GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - Response from create changeset api : " + changesetResponse);
                    }
                    try {
                        if (changesetResponse.containsKey((Object)DevOpsConstants.COMMON_RESPONSE_RESULT.toString())) {
                            JSONObject result = changesetResponse.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
                            if (result.containsKey((Object)DevOpsConstants.COMMON_RESPONSE_NUMBER.toString())) {
                                changesetNumber = result.getString(DevOpsConstants.COMMON_RESPONSE_NUMBER.toString());
                            }
                            break block51;
                        }
                        JSONObject error = changesetResponse.getJSONObject(DevOpsConstants.COMMON_RESULT_ERROR.toString());
                        String errorMessage = error.getString(DevOpsConstants.COMMON_RESPONSE_MESSAGE.toString());
                        return this.handleException(errorMessage);
                    }
                    catch (JSONException j) {
                        return this.handleException("Upload step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
                    }
                }
                GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - New changeset created, Since it is not provided with inputs");
            } else {
                changesetNumber = this.step.getChangesetNumber();
            }
            GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - Initiating the upload");
            boolean commitFlag = false;
            boolean deleteFlag = false;
            String changesetId = "";
            JSONObject responseStatus = null;
            if (this.step.getAutoDelete() == null || this.step.getAutoDelete().booleanValue()) {
                deleteFlag = true;
            }
            for (FilePath fileToUpload : filteredList) {
                String fileContent = fileToUpload.readToString();
                String fileName = "";
                String format = "";
                String dataFormat = "";
                String transactionSource = "system_information=jenkins,interface_type=" + this.step.getTarget() + ",interface=" + this.step.getAutoValidate() + ",session_type=" + this.step.getAutoCommit() + ",interface_version=";
                dataFormat = this.step.getDataFormat() == null ? ((format = (fileName = fileToUpload.getName()).substring(fileName.lastIndexOf(46) + 1)).equals("yml") ? dataFormat + "yaml" : dataFormat + format) : dataFormat + this.step.getDataFormat().toLowerCase();
                transactionSource = transactionSource + dataFormat;
                Path relativePath = Paths.get(fileToUpload.getRemote().replace(workspace.getRemote() + "/", ""), new String[0]);
                String modifiedNamePath = "";
                if (this.step.getConvertPath()) {
                    modifiedNamePath = this.step.getNamePath() + File.separator + relativePath.toString();
                } else {
                    File f = new File(relativePath.toString());
                    String absoulteName = f.getName();
                    modifiedNamePath = this.step.getNamePath() + File.separator + absoulteName;
                }
                if (filteredList.indexOf(fileToUpload) == filteredList.size() - 1) {
                    commitFlag = this.step.getAutoCommit();
                }
                JSONObject uploadRequest = null;
                try {
                    uploadRequest = model.uploadData(this.step.getApplicationName().trim(), changesetNumber, dataFormat, modifiedNamePath, commitFlag, deleteFlag, this.step.getAutoValidate(), fileContent, this.step.getTarget(), this.step.getDeployableName(), this.step.getCollectionName(), this.step.getAutoPublish(), transactionSource);
                }
                catch (Exception e) {
                    return this.handleException("Failed to upload file due to : " + e.getMessage() + " - Upload failed");
                }
                if (uploadRequest == null) {
                    return this.handleException("Invalid target Type : Upload failed");
                }
                if (this.step.getShowResults()) {
                    GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - Response from upload request api for file " + relativePath + " : " + uploadRequest);
                }
                String errorMessage = "";
                if (uploadRequest.containsKey((Object)DevOpsConstants.COMMON_RESULT_ERROR.toString())) {
                    try {
                        JSONObject error = uploadRequest.getJSONObject(DevOpsConstants.COMMON_RESULT_ERROR.toString());
                        errorMessage = error.getString(DevOpsConstants.COMMON_RESPONSE_MESSAGE.toString());
                    }
                    catch (JSONException j) {
                        return this.handleException("Upload step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
                    }
                    return this.handleException("Upload failed : " + errorMessage);
                }
                String uploadId = "";
                try {
                    JSONObject result = uploadRequest.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
                    uploadId = result.getString(DevOpsConstants.CONFIG_UPLOAD_ID.toString());
                }
                catch (JSONException j) {
                    return this.handleException("Upload step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
                }
                GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - Polling for upload status of the file - " + relativePath);
                int retryCount = 0;
                String state = "";
                JSONObject response = null;
                while (retryCount <= this.maxRetryCount) {
                    ++retryCount;
                    try {
                        response = model.checkStatusForUpload(uploadId);
                    }
                    catch (Exception e) {
                        return this.handleException("Failed to fetch upload status due to : " + e.getMessage() + " - Upload failed");
                    }
                    try {
                        responseStatus = response.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
                        state = responseStatus.getString(DevOpsConstants.COMMON_RESPONSE_STATE.toString());
                    }
                    catch (JSONException j) {
                        return this.handleException("Upload step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
                    }
                    if (!state.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_NEW.toString()) && !state.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_IN_PROGRESS.toString()) && !state.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_READY.toString()) && !state.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_INITIALIZING.toString())) break;
                    if (retryCount % 2 == 0) {
                        GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - Waiting for response - Retried  " + retryCount + " times");
                        this.retryFrequency *= 2;
                    }
                    try {
                        Thread.sleep(this.retryFrequency);
                    }
                    catch (InterruptedException i) {
                        GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - Exception while fetching upload status");
                    }
                }
                if (this.step.getShowResults()) {
                    GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - Response from upload status api for file " + relativePath + " : " + response);
                }
                try {
                    String output = "";
                    if (responseStatus != null && !state.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_COMPLETED.toString())) {
                        output = responseStatus.getString(DevOpsConstants.COMMON_RESPONSE_OUTPUT.toString());
                        return this.handleException("Upload failed due to : " + output);
                    }
                }
                catch (JSONException j) {
                    return this.handleException("Upload step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
                }
                this.retryFrequency = 220;
            }
            try {
                if (responseStatus != null) {
                    changesetId = responseStatus.getJSONObject(DevOpsConstants.COMMON_RESPONSE_OUTPUT.toString()).getString(DevOpsConstants.COMMON_RESPONSE_NUMBER.toString());
                }
            }
            catch (JSONException j) {
                return this.handleException("Upload step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
            }
            GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - Upload completed successfully (" + filteredList.size() + " files uploaded to changeset: " + changesetId + ")");
            GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - Files got uploaded under the changeset : " + changesetId);
            return changesetId;
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            return this.handleException("Failed to read regex pattern - Upload failed");
        }
    }

    private List<FilePath> walkFilePaths(FilePath filePath, int nMaxDepth) throws IOException, InterruptedException {
        ArrayList<FilePath> fileList = new ArrayList<FilePath>();
        filePath.list().stream().forEach(c -> {
            try {
                if (c.isDirectory() && nMaxDepth > 0) {
                    List<FilePath> paths = this.walkFilePaths((FilePath)c, nMaxDepth - 1);
                    fileList.addAll(paths);
                } else {
                    fileList.add((FilePath)c);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        return fileList;
    }

    private String handleException(String exceptionMessage) throws Exception {
        Run run = (Run)this.getContext().get(Run.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        DevOpsModel model = new DevOpsModel();
        DevOpsJobProperty jobProperties = model.getJobProperty(run.getParent());
        if (!jobProperties.isIgnoreSNErrors() || this.step.getMarkFailed()) {
            run.setResult(Result.FAILURE);
            throw new AbortException(DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - " + exceptionMessage);
        }
        GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - " + exceptionMessage + " - Ignoring SN Errors");
        return null;
    }
}

