/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps.executions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.AbortException;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.config.DevOpsJobProperty;
import io.jenkins.plugins.model.CDMSnapshot;
import io.jenkins.plugins.model.DevOpsModel;
import io.jenkins.plugins.pipeline.steps.DevOpsConfigGetSnapshotsStep;
import io.jenkins.plugins.pipeline.steps.DevOpsConfigRegisterPipelineStep;
import io.jenkins.plugins.pipeline.steps.DevOpsConfigStep;
import io.jenkins.plugins.pipeline.steps.DevOpsConfigUploadStep;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsConfigGetSnapshotsStepExecution;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsConfigRegisterPipelineStepExecution;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsConfigUploadStepExecution;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class DevOpsConfigStepExecution
extends SynchronousNonBlockingStepExecution<String> {
    private static final long serialVersionUID = 1L;
    private DevOpsConfigStep step;
    StepContext uploadContext = null;
    StepContext getSnapshotContext = null;
    StepContext registerContext = null;
    String changesetId;
    String snapshotObj;
    private ObjectMapper mapper = new ObjectMapper();

    public DevOpsConfigStepExecution(StepContext context, DevOpsConfigStep step) {
        super(context);
        this.step = step;
        this.uploadContext = context;
        this.getSnapshotContext = context;
        this.registerContext = context;
    }

    protected String run() throws Exception {
        Run run = (Run)this.getContext().get(Run.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        DevOpsModel model = new DevOpsModel();
        DevOpsJobProperty jobProperties = model.getJobProperty(run.getParent());
        GenericUtils.printConsoleLog(listener, "Config step execution starts");
        try {
            boolean publishFlag = false;
            boolean valiateFlag = false;
            boolean commitFlag = false;
            boolean deleteFlag = false;
            if (this.step.getAutoPublish() == null || this.step.getAutoPublish().equalsIgnoreCase("true")) {
                publishFlag = true;
            }
            if (this.step.getAutoValidate() == null || this.step.getAutoValidate().equalsIgnoreCase("true")) {
                valiateFlag = true;
            }
            if (this.step.getAutoCommit() == null || this.step.getAutoCommit().equalsIgnoreCase("true")) {
                commitFlag = true;
            }
            if (this.step.getAutoDelete() == null || this.step.getAutoDelete().equalsIgnoreCase("true")) {
                deleteFlag = true;
            }
            DevOpsConfigUploadStep uploadStep = new DevOpsConfigUploadStep(this.step.getApplicationName(), this.step.getTarget(), this.step.getNamePath(), this.step.getConfigFile(), commitFlag, deleteFlag, valiateFlag, publishFlag);
            uploadStep.setChangesetNumber(this.step.getChangesetNumber());
            uploadStep.setDeployableName(this.step.getDeployableName());
            uploadStep.setCollectionName(this.step.getCollectionName());
            uploadStep.setConvertPath(this.step.getConvertPath());
            uploadStep.setMarkFailed(this.step.getMarkFailed());
            uploadStep.setShowResults(this.step.getShowResults());
            uploadStep.setDataFormat(this.step.getDataFormat());
            DevOpsConfigUploadStepExecution uploadExec = new DevOpsConfigUploadStepExecution(this.uploadContext, uploadStep);
            this.changesetId = uploadExec.run();
            if (!this.changesetId.isEmpty()) {
                if (!commitFlag) {
                    throw new AbortException("If you want to validate and publish your configuration data changes, please ensure autoCommit, autoValidate, and autoPublish flags are all set to 'true' before running your pipeline");
                }
                if (!valiateFlag) {
                    DevOpsConfigGetSnapshotsStep getStepForStatus = new DevOpsConfigGetSnapshotsStep(this.step.getApplicationName(), null, this.changesetId);
                    DevOpsConfigGetSnapshotsStepExecution getExecForStatus = new DevOpsConfigGetSnapshotsStepExecution(this.getSnapshotContext, getStepForStatus);
                    List<CDMSnapshot> snapshotStatusList = new ArrayList<CDMSnapshot>();
                    JSONObject changesetDetails = model.getChangesetId(this.changesetId);
                    JSONArray changesetResult = changesetDetails.getJSONArray("result");
                    JSONObject changesetObj = changesetResult.getJSONObject(0);
                    String changesetSysId = changesetObj.getString("sys_id");
                    List<String> deployNames = getExecForStatus.getDeployableNames(model, changesetSysId, listener);
                    if (deployNames.size() == 0) {
                        throw new AbortException("No deployables got impacted");
                    }
                    JSONObject appDetails = model.checkForValidApp(this.step.getApplicationName());
                    JSONArray appResult = appDetails.getJSONArray("result");
                    String appId = appResult.getJSONObject(0).getString("sys_id");
                    JSONObject updatedSnapshotObj = model.snapShotExists(appId, deployNames, this.changesetId);
                    if (updatedSnapshotObj != null) {
                        JSONArray snapshotArray = updatedSnapshotObj.getJSONArray("result");
                        snapshotStatusList = getExecForStatus.getSnapshotList(snapshotArray);
                    }
                    getExecForStatus.addDeployableDetails(snapshotStatusList);
                    return this.mapper.writeValueAsString(snapshotStatusList);
                }
                GenericUtils.printConsoleLog(listener, "--------------------------------------");
                DevOpsConfigGetSnapshotsStep getStep = new DevOpsConfigGetSnapshotsStep(this.step.getApplicationName(), null, this.changesetId);
                getStep.setMarkFailed(this.step.getMarkFailed());
                getStep.setShowResults(this.step.getShowResults());
                getStep.setOutputFormat(this.step.getTestResultFormat());
                getStep.setIsValidated(this.step.getIsValidated());
                getStep.setContinueWithLatest(this.step.getContinueWithLatest());
                DevOpsConfigGetSnapshotsStepExecution getExec = new DevOpsConfigGetSnapshotsStepExecution(this.getSnapshotContext, getStep);
                this.snapshotObj = getExec.run();
                GenericUtils.printConsoleLog(listener, "--------------------------------------");
                List snapshotList = (List)this.mapper.readValue(this.snapshotObj, (TypeReference)new TypeReference<List<CDMSnapshot>>(){});
                ArrayList<String> deploybaleNames = new ArrayList<String>();
                for (CDMSnapshot cdmSnapshot : snapshotList) {
                    deploybaleNames.add(cdmSnapshot.getDeployableName());
                }
                GenericUtils.printConsoleLog(listener, "--------------------------------------");
                DevOpsConfigRegisterPipelineStep registerStep = new DevOpsConfigRegisterPipelineStep();
                registerStep.setApplicationName(this.step.getApplicationName());
                registerStep.setChangesetNumber(this.changesetId);
                DevOpsConfigRegisterPipelineStepExecution registerExec = new DevOpsConfigRegisterPipelineStepExecution(this.registerContext, registerStep);
                registerExec.run();
                Thread.sleep(3000L);
                List<CDMSnapshot> updatedSnapshotList = new ArrayList<CDMSnapshot>();
                JSONObject updatedSnapshotObj = model.snapShotExists(getExec.appSysId, deploybaleNames, this.changesetId);
                if (updatedSnapshotObj != null) {
                    JSONArray snapshotArray = updatedSnapshotObj.getJSONArray("result");
                    updatedSnapshotList = getExec.getSnapshotList(snapshotArray);
                }
                getExec.addDeployableDetails(updatedSnapshotList);
                for (CDMSnapshot cdmSnapshot : updatedSnapshotList) {
                    JSONArray validationArray;
                    JSONObject validationResults = model.getValidationResults(cdmSnapshot.getSys_id(), "", "");
                    if (validationResults == null || (validationArray = validationResults.getJSONArray("result")).isEmpty()) continue;
                    cdmSnapshot.setValidationResults(validationResults);
                }
                ArrayList<String> snapshotsFailed = new ArrayList<String>();
                ArrayList<String> snapshotExecError = new ArrayList<String>();
                for (CDMSnapshot cdmSnapshot : updatedSnapshotList) {
                    if (cdmSnapshot.getValidation().equals("failed")) {
                        snapshotsFailed.add(cdmSnapshot.getName());
                        continue;
                    }
                    if (!cdmSnapshot.getValidation().equals("execution_error")) continue;
                    snapshotExecError.add(cdmSnapshot.getName());
                }
                if (snapshotsFailed.size() != 0 || snapshotExecError.size() != 0) {
                    if (!this.step.getMarkFailed() && snapshotExecError.size() != 0) {
                        GenericUtils.printConsoleLog(listener, "Upload succeeded, but validation failed to execute on one or more snapshots. Snapshots where validation executed successfully and have passed have been published.Please check errors section for more details.");
                    } else {
                        GenericUtils.printConsoleLog(listener, "Not all snapshots passed validation. If this was not expected, make sure to review validation results before proceeding.Alternatively, you could use the 'markFailed' argument next time to fail the action in the event a snapshot fails validation.");
                    }
                    for (String snapshotName : snapshotsFailed) {
                        GenericUtils.printConsoleLog(listener, snapshotName + " failed validation. Please review validation results file for more information.");
                    }
                    for (String snapshotName : snapshotExecError) {
                        GenericUtils.printConsoleLog(listener, snapshotName + " failed to execute validation. Please retry validation before proceeding.");
                    }
                    if (this.step.getMarkFailed()) {
                        throw new AbortException("Stopping pipeline execution since one or more snapshots failed in validation");
                    }
                }
                return this.mapper.writeValueAsString(updatedSnapshotList);
            }
            throw new AbortException("Changeset not found, stopping pipeline execution");
        }
        catch (IOException | IndexOutOfBoundsException | InterruptedException | NullPointerException | ParserConfigurationException | TransformerException | JSONException e) {
            if (!jobProperties.isIgnoreSNErrors() || this.step.getMarkFailed()) {
                run.setResult(Result.FAILURE);
                throw e;
            }
            GenericUtils.printConsoleLog(listener, e.getMessage());
            GenericUtils.printConsoleLog(listener, "Step execution failed, continuing the pipeline");
            return "[]";
        }
    }
}

