/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps.executions;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.config.DevOpsJobProperty;
import io.jenkins.plugins.model.DevOpsModel;
import io.jenkins.plugins.pipeline.steps.DevOpsConfigExportStep;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class DevOpsConfigExportStepExecution
extends SynchronousNonBlockingStepExecution<Boolean> {
    private static final long serialVersionUID = 1L;
    private DevOpsConfigExportStep step;
    private int retryFrequency = 220;
    private int maxRetryCount = 20;

    public DevOpsConfigExportStepExecution(StepContext context, DevOpsConfigExportStep step) {
        super(context);
        this.step = step;
    }

    protected Boolean run() throws Exception {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
        DevOpsModel model = new DevOpsModel();
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString() + " - Config export step execution starts");
        GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString() + " - Sending export request");
        String snapshot = "";
        if (GenericUtils.isNotEmpty(this.step.getSnapshotName())) {
            snapshot = this.step.getSnapshotName().trim();
        }
        JSONObject responseEnvType = null;
        try {
            responseEnvType = model.fetchSnapshotRecord(this.step.getApplicationName().trim(), this.step.getDeployableName().trim(), snapshot);
        }
        catch (Exception e) {
            return this.handleException("Exception occurred while export - " + e.getMessage() + " : Export step failed");
        }
        if (responseEnvType == null) {
            return this.handleException("Unable to find snapshot with given inputs : Export step failed");
        }
        JSONArray resultEnvType = null;
        try {
            resultEnvType = responseEnvType.getJSONArray(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
        }
        catch (JSONException j) {
            return this.handleException("Export step failed :" + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
        }
        if (resultEnvType.isEmpty()) {
            return this.handleException("Unable to find snapshot with given inputs : Export step failed");
        }
        String environmentType = "";
        try {
            JSONObject responseBody = resultEnvType.getJSONObject(0);
            environmentType = responseBody.getString(DevOpsConstants.CONFIG_ENVIRONMENT_TYPE.toString());
        }
        catch (JSONException j) {
            return this.handleException("Export step failed :" + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
        }
        String transactionSource = "system_information=jenkins,interface_type=" + this.step.getExporterName() + ",interface=" + this.step.getExporterFormat() + ",interface_version=" + environmentType;
        JSONObject request = null;
        try {
            request = model.insertExportRequest(this.step.getApplicationName(), this.step.getDeployableName(), this.step.getExporterName(), this.step.getExporterFormat(), this.step.getExporterArgs(), this.step.getSnapshotName(), transactionSource);
        }
        catch (Exception e) {
            return this.handleException(e.getMessage());
        }
        String exportId = "";
        if (null == request) {
            return this.handleException("Failed to create export request");
        }
        if (this.step.getShowResults()) {
            GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString() + " - Response from export request api : " + request);
        }
        String errorMessage = "";
        if (request.containsKey((Object)DevOpsConstants.COMMON_RESULT_ERROR.toString())) {
            try {
                JSONObject error = request.getJSONObject(DevOpsConstants.COMMON_RESULT_ERROR.toString());
                errorMessage = error.getString(DevOpsConstants.COMMON_RESPONSE_MESSAGE.toString());
            }
            catch (JSONException j) {
                return this.handleException("Export step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
            }
            return this.handleException(errorMessage);
        }
        try {
            JSONObject result = request.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
            exportId = result.getString(DevOpsConstants.COMMON_RESPONSE_EXPORT_ID.toString());
        }
        catch (JSONException j) {
            return this.handleException("Export step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
        }
        GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString() + " - Polling for export status");
        JSONObject response = null;
        JSONObject exportStatus = null;
        String state = "";
        int retryCount = 0;
        while (retryCount <= this.maxRetryCount) {
            ++retryCount;
            try {
                exportStatus = model.fetchExportStatus(exportId);
            }
            catch (Exception e) {
                return this.handleException(e.getMessage());
            }
            try {
                response = exportStatus.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
                state = response.getString(DevOpsConstants.COMMON_RESPONSE_STATE.toString());
            }
            catch (JSONException j) {
                return this.handleException("Export step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
            }
            if (!state.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_NEW.toString()) && !state.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_IN_PROGRESS.toString()) && !state.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_READY.toString()) && !state.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_INITIALIZING.toString())) break;
            if (retryCount % 2 == 0) {
                GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString() + " - Waiting for response - Retried  " + retryCount + " times");
                this.retryFrequency *= 2;
            }
            try {
                Thread.sleep(this.retryFrequency);
            }
            catch (InterruptedException i) {
                GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString() + " - Exception while fetching export status");
            }
        }
        if (this.step.getShowResults()) {
            GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString() + " - Response from export status api : " + exportStatus);
        }
        String message = "";
        try {
            if (response != null && !state.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_COMPLETED.toString())) {
                message = response.getString(DevOpsConstants.COMMON_RESPONSE_OUTPUT.toString());
                return this.handleException(message);
            }
        }
        catch (JSONException j) {
            return this.handleException("Export step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
        }
        JSONObject output = null;
        String outputState = "";
        try {
            if (response != null) {
                output = response.getJSONObject(DevOpsConstants.COMMON_RESPONSE_EXPORTER_RESULT.toString());
                outputState = output.getString(DevOpsConstants.COMMON_RESPONSE_STATE.toString());
            }
        }
        catch (JSONException j) {
            return this.handleException("Export step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
        }
        if (output != null && outputState.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_FAILURE.toString())) {
            JSONArray errors = null;
            try {
                errors = output.getJSONArray(DevOpsConstants.COMMON_RESPONSE_ERRORS.toString());
            }
            catch (JSONException j) {
                return this.handleException("Export step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
            }
            return this.handleException("Export failed due to : " + errors);
        }
        GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString() + " - Fetching exported data");
        JSONObject exportResponse = null;
        String exportData = "";
        try {
            exportResponse = model.fetchExportData(exportId);
        }
        catch (Exception e) {
            return this.handleException(e.getMessage());
        }
        if (this.step.getShowResults()) {
            GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString() + " - Response from export data api : " + exportResponse);
        }
        try {
            JSONObject body = exportResponse.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
            if (body.get(DevOpsConstants.COMMON_RESPONSE_EXPORTER_RESULT.toString()) instanceof JSONObject) {
                exportData = body.getJSONObject(DevOpsConstants.COMMON_RESPONSE_EXPORTER_RESULT.toString()).toString();
            } else {
                exportData = body.getString(DevOpsConstants.COMMON_RESPONSE_EXPORTER_RESULT.toString());
                if (this.step.getExporterFormat().equalsIgnoreCase(DevOpsConstants.CONFIG_RAW_FORMAT.toString())) {
                    exportData = exportData.replace("\"", "\\\"");
                }
            }
        }
        catch (JSONException j) {
            return this.handleException("Export step failed : " + DevOpsConstants.FAILURE_REASON_CONN_ISSUE.toString());
        }
        GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString() + " - Writing exported data to file");
        String exportDataFileName = "";
        exportDataFileName = GenericUtils.isEmpty(this.step.getFileName()) ? (this.step.getExporterFormat().equalsIgnoreCase(DevOpsConstants.CONFIG_JSON_FORMAT.toString()) || this.step.getExporterFormat().equalsIgnoreCase("") ? "EXPORT_DATA_" + (String)envVars.get((Object)DevOpsConstants.PIPELINE_JOB_NAME.toString()) + "_" + (String)envVars.get((Object)DevOpsConstants.PIPELINE_BUILD_NUMBER.toString()) + "." + DevOpsConstants.CONFIG_JSON_FORMAT.toString() : (this.step.getExporterFormat().equalsIgnoreCase(DevOpsConstants.CONFIG_RAW_FORMAT.toString()) ? "EXPORT_DATA_" + (String)envVars.get((Object)DevOpsConstants.PIPELINE_JOB_NAME.toString()) + "_" + (String)envVars.get((Object)DevOpsConstants.PIPELINE_BUILD_NUMBER.toString()) + "." + DevOpsConstants.CONFIG_TEXT_FORMAT.toString() : "EXPORT_DATA_" + (String)envVars.get((Object)DevOpsConstants.PIPELINE_JOB_NAME.toString()) + "_" + (String)envVars.get((Object)DevOpsConstants.PIPELINE_BUILD_NUMBER.toString()) + "." + this.step.getExporterFormat())) : this.step.getFileName();
        FilePath filePath = new FilePath(workspace, exportDataFileName);
        try {
            filePath.write(exportData, "utf-8");
        }
        catch (Exception e) {
            return this.handleException(" Exception while writing file : " + e.getMessage());
        }
        return true;
    }

    private Boolean handleException(String exceptionMessage) throws Exception {
        Run run = (Run)this.getContext().get(Run.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        DevOpsModel model = new DevOpsModel();
        DevOpsJobProperty jobProperties = model.getJobProperty(run.getParent());
        if (!jobProperties.isIgnoreSNErrors() || this.step.getMarkFailed()) {
            run.setResult(Result.FAILURE);
            throw new AbortException(DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString() + " - " + exceptionMessage);
        }
        GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString() + " - " + exceptionMessage + " - Ignoring SN Errors");
        return false;
    }
}

