/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.pipeline.steps.DevOpsStep;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsPipelineUpdateChangeInfoStepExecution;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.Serializable;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DevOpsPipelineUpdateChangeInfoStep
extends Step
implements Serializable,
DevOpsStep {
    private String changeRequestNumber;
    private String changeRequestDetails;
    private String configurationName;

    public String getChangeRequestDetails() {
        return this.changeRequestDetails;
    }

    @Override
    public String getConfigurationName() {
        return this.configurationName;
    }

    @DataBoundSetter
    public void setConfigurationName(String configurationName) {
        if (!GenericUtils.isEmpty(configurationName)) {
            this.configurationName = configurationName;
        }
    }

    @DataBoundSetter
    public void setChangeRequestDetails(String changeRequestDetails) {
        this.changeRequestDetails = changeRequestDetails;
    }

    public String getChangeRequestNumber() {
        return this.changeRequestNumber;
    }

    @DataBoundSetter
    public void setChangeRequestNumber(String changeRequestNumber) {
        this.changeRequestNumber = changeRequestNumber;
    }

    @DataBoundConstructor
    public DevOpsPipelineUpdateChangeInfoStep() {
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new DevOpsPipelineUpdateChangeInfoStepExecution(stepContext, this);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return DevOpsConstants.CHANGE_REQUEST_UPDATE_INFO_FUNCTION_NAME.toString();
        }

        public String getDisplayName() {
            return DevOpsConstants.CHANGE_REQUEST_UPDATE_INFO_DISPLAY_NAME.toString();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, EnvVars.class);
        }
    }
}

