/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.pipeline.steps.DevOpsStep;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsPipelineRegisterArtifactStepExecution;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.Serializable;
import java.util.Set;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DevOpsPipelineRegisterArtifactStep
extends Step
implements Serializable,
DevOpsStep {
    private static final long serialVersionUID = 1L;
    private boolean m_enabled = true;
    private boolean ignoreErrors = false;
    private String artifactsPayload;
    private String configurationName;

    @DataBoundConstructor
    public DevOpsPipelineRegisterArtifactStep(String artifactsPayload) {
        this.artifactsPayload = artifactsPayload;
        this.configurationName = null;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new DevOpsPipelineRegisterArtifactStepExecution(context, this);
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    @DataBoundSetter
    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    @Override
    public String getConfigurationName() {
        return this.configurationName;
    }

    @DataBoundSetter
    public void setConfigurationName(String configurationName) {
        if (!GenericUtils.isEmpty(configurationName)) {
            this.configurationName = configurationName;
        }
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    @DataBoundSetter
    public void setIgnoreErrors(boolean ignore) {
        this.ignoreErrors = ignore;
    }

    @DataBoundSetter
    public void setArtifactsPayload(String artifactsPayload) {
        this.artifactsPayload = artifactsPayload;
    }

    public String getArtifactsPayload() {
        return this.artifactsPayload;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"snDevOpsArtifact"})
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return DevOpsConstants.ARTIFACT_REGISTER_STEP_FUNCTION_NAME.toString();
        }

        public String getDisplayName() {
            return DevOpsConstants.ARTIFACT_REGISTER_STEP_DISPLAY_NAME.toString();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, EnvVars.class);
        }
    }
}

