/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.pipeline.steps.DevOpsStep;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsPipelineCreateArtifactPackageStepExecution;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.Serializable;
import java.util.Set;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DevOpsPipelineCreateArtifactPackageStep
extends Step
implements Serializable,
DevOpsStep {
    private static final long serialVersionUID = 1L;
    private String artifactsPayload;
    private String name;
    private String configurationName;

    @DataBoundConstructor
    public DevOpsPipelineCreateArtifactPackageStep(String name, String artifactsPayload) {
        this.name = name;
        this.artifactsPayload = artifactsPayload;
        this.configurationName = null;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new DevOpsPipelineCreateArtifactPackageStepExecution(context, this);
    }

    @Override
    public String getConfigurationName() {
        return this.configurationName;
    }

    @DataBoundSetter
    public void setConfigurationName(String configurationName) {
        if (!GenericUtils.isEmpty(configurationName)) {
            this.configurationName = configurationName;
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getArtifactsPayload() {
        return this.artifactsPayload;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setArtifactsPayload(String artifactsPayload) {
        this.artifactsPayload = artifactsPayload;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    @Extension
    @Symbol(value={"snDevOpsPackage"})
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return DevOpsConstants.ARTIFACT_PACKAGE_STEP_FUNCTION_NAME.toString();
        }

        public String getDisplayName() {
            return DevOpsConstants.ARTIFACT_PACKAGE_STEP_DISPLAY_NAME.toString();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, EnvVars.class);
        }
    }
}

