/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsConfigStepExecution;
import io.jenkins.plugins.utils.DevOpsConstants;
import java.io.Serializable;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DevOpsConfigStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean m_enabled = true;
    private boolean m_ignoreErrors = false;
    private String applicationName;
    private String changesetNumber;
    private String target;
    private String configFile;
    private String namePath;
    private String deployableName;
    private String collectionName;
    private String dataFormat;
    private boolean convertPath;
    private boolean markFailed;
    private boolean showResults;
    private String testResultFormat;
    private boolean isValidated;
    private String autoPublish;
    private String autoValidate;
    private String autoCommit;
    private boolean continueWithLatest;
    private String autoDelete;

    @DataBoundConstructor
    public DevOpsConfigStep(String applicationName, String target, String namePath, String configFile) {
        this.applicationName = applicationName;
        this.target = target;
        this.namePath = namePath;
        this.configFile = configFile;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new DevOpsConfigStepExecution(context, this);
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    @DataBoundSetter
    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public boolean isIgnoreErrors() {
        return this.m_ignoreErrors;
    }

    @DataBoundSetter
    public void setIgnoreErrors(boolean ignore) {
        this.m_ignoreErrors = ignore;
    }

    @DataBoundSetter
    public void setChangesetNumber(String changesetNumber) {
        this.changesetNumber = changesetNumber == null || changesetNumber.isEmpty() ? null : changesetNumber;
    }

    public String getChangesetNumber() {
        return this.changesetNumber;
    }

    @DataBoundSetter
    public void setDeployableName(String deployableName) {
        this.deployableName = deployableName == null || deployableName.isEmpty() ? null : deployableName;
    }

    public String getDeployableName() {
        return this.deployableName;
    }

    @DataBoundSetter
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName == null || collectionName.isEmpty() ? null : collectionName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    @DataBoundSetter
    public void setConvertPath(boolean convertPath) {
        this.convertPath = !convertPath ? false : convertPath;
    }

    public boolean getConvertPath() {
        return this.convertPath;
    }

    @DataBoundSetter
    public void setMarkFailed(boolean markFailed) {
        this.markFailed = markFailed;
    }

    public boolean getMarkFailed() {
        return this.markFailed;
    }

    @DataBoundSetter
    public void setShowResults(boolean showResults) {
        this.showResults = showResults;
    }

    public boolean getShowResults() {
        return this.showResults;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setNamePath(String namePath) {
        this.namePath = namePath;
    }

    public String getNamePath() {
        return this.namePath;
    }

    @DataBoundSetter
    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat == null || dataFormat.isEmpty() ? null : dataFormat;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    @DataBoundSetter
    public void setTestResultFormat(String testResultFormat) {
        this.testResultFormat = testResultFormat == null || testResultFormat.isEmpty() ? null : testResultFormat;
    }

    public String getTestResultFormat() {
        return this.testResultFormat;
    }

    @DataBoundSetter
    public void setIsValidated(boolean isValidated) {
        this.isValidated = isValidated;
    }

    public boolean getIsValidated() {
        return this.isValidated;
    }

    public String getAutoPublish() {
        return this.autoPublish;
    }

    @DataBoundSetter
    public void setAutoPublish(String autoPublish) {
        this.autoPublish = autoPublish == null || autoPublish.isEmpty() ? "true" : autoPublish;
    }

    public String getAutoValidate() {
        return this.autoValidate;
    }

    @DataBoundSetter
    public void setAutoValidate(String autoValidate) {
        this.autoValidate = autoValidate == null || autoValidate.isEmpty() ? "true" : autoValidate;
    }

    public String getAutoCommit() {
        return this.autoCommit;
    }

    @DataBoundSetter
    public void setAutoCommit(String autoCommit) {
        this.autoCommit = autoCommit == null || autoCommit.isEmpty() ? "true" : autoCommit;
    }

    @DataBoundSetter
    public void setContinueWithLatest(boolean continueWithLatest) {
        this.continueWithLatest = continueWithLatest;
    }

    public boolean getContinueWithLatest() {
        return this.continueWithLatest;
    }

    public String getAutoDelete() {
        return this.autoDelete;
    }

    @DataBoundSetter
    public void setAutoDelete(String autoDelete) {
        this.autoDelete = autoDelete == null || autoDelete.isEmpty() ? "true" : autoDelete;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return DevOpsConstants.CONFIG_PIPELINE_STEP_FUNCTION_NAME.toString();
        }

        public String getDisplayName() {
            return DevOpsConstants.CONFIG_PIPELINE_STEP_DISPLAY_NAME.toString();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, EnvVars.class);
        }
    }
}

