/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsConfigRegisterPipelineStepExecution;
import io.jenkins.plugins.utils.DevOpsConstants;
import java.io.Serializable;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DevOpsConfigRegisterPipelineStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean m_enabled = true;
    private boolean m_ignoreErrors = false;
    private String changesetNumber;
    private String snapshotName;
    private String applicationName;
    private boolean markFailed;
    private boolean showResults;

    @DataBoundConstructor
    public DevOpsConfigRegisterPipelineStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new DevOpsConfigRegisterPipelineStepExecution(context, this);
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    @DataBoundSetter
    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public boolean isIgnoreErrors() {
        return this.m_ignoreErrors;
    }

    @DataBoundSetter
    public void setIgnoreErrors(boolean ignore) {
        this.m_ignoreErrors = ignore;
    }

    @DataBoundSetter
    public void setChangesetNumber(String changesetNumber) {
        this.changesetNumber = changesetNumber == null || changesetNumber.isEmpty() ? null : changesetNumber;
    }

    public String getChangesetNumber() {
        return this.changesetNumber;
    }

    @DataBoundSetter
    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName == null || snapshotName.isEmpty() ? null : snapshotName;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    @DataBoundSetter
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @DataBoundSetter
    public void setMarkFailed(boolean markFailed) {
        this.markFailed = markFailed;
    }

    public boolean getMarkFailed() {
        return this.markFailed;
    }

    @DataBoundSetter
    public void setShowResults(boolean showResults) {
        this.showResults = showResults;
    }

    public boolean getShowResults() {
        return this.showResults;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return DevOpsConstants.CONFIG_REGISTER_PIPELINE_STEP_FUNCTION_NAME.toString();
        }

        public String getDisplayName() {
            return DevOpsConstants.CONFIG_REGISTER_PIPELINE_STEP_DISPLAY_NAME.toString();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, EnvVars.class);
        }
    }
}

