/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.steps;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsConfigExportStepExecution;
import io.jenkins.plugins.utils.DevOpsConstants;
import java.io.Serializable;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DevOpsConfigExportStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean m_enabled = true;
    private boolean m_ignoreErrors = false;
    private String applicationName;
    private String deployableName;
    private String exporterName;
    private String exporterFormat;
    private JSONObject exporterArgs;
    private String fileName;
    private String snapshotName;
    private boolean markFailed;
    private boolean showResults;

    @DataBoundConstructor
    public DevOpsConfigExportStep(String applicationName, String deployableName, String exporterName, String exporterFormat, String fileName) {
        this.applicationName = applicationName;
        this.deployableName = deployableName;
        this.exporterName = exporterName;
        this.exporterFormat = exporterFormat;
        this.fileName = fileName;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new DevOpsConfigExportStepExecution(context, this);
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    @DataBoundSetter
    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public boolean isIgnoreErrors() {
        return this.m_ignoreErrors;
    }

    @DataBoundSetter
    public void setIgnoreErrors(boolean ignore) {
        this.m_ignoreErrors = ignore;
    }

    @DataBoundSetter
    public void setExporterArgs(String exporterArgs) {
        if (exporterArgs == null || exporterArgs.isEmpty()) {
            this.exporterArgs = null;
        } else {
            try {
                JSONObject arguments = null;
                this.exporterArgs = arguments = JSONObject.fromObject((Object)exporterArgs);
            }
            catch (Exception e) {
                Logger.getLogger(e.getMessage());
            }
        }
    }

    public JSONObject getExporterArgs() {
        return this.exporterArgs;
    }

    @DataBoundSetter
    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName == null || snapshotName.isEmpty() ? null : snapshotName;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    @DataBoundSetter
    public void setMarkFailed(boolean markFailed) {
        this.markFailed = markFailed;
    }

    public boolean getMarkFailed() {
        return this.markFailed;
    }

    @DataBoundSetter
    public void setShowResults(boolean showResults) {
        this.showResults = showResults;
    }

    public boolean getShowResults() {
        return this.showResults;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setDeployableName(String deployableName) {
        this.deployableName = deployableName;
    }

    public String getDeployableName() {
        return this.deployableName;
    }

    public void setExporterName(String exporterName) {
        this.exporterName = exporterName;
    }

    public String getExporterName() {
        return this.exporterName;
    }

    public void setExporterFormat(String exporterFormat) {
        this.exporterFormat = exporterFormat;
    }

    public String getExporterFormat() {
        return this.exporterFormat;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return DevOpsConstants.CONFIG_EXPORT_STEP_FUNCTION_NAME.toString();
        }

        public String getDisplayName() {
            return DevOpsConstants.CONFIG_EXPORT_STEP_DISPLAY_NAME.toString();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, EnvVars.class);
        }
    }
}

