/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.model;

import hudson.FilePath;
import io.jenkins.plugins.DevOpsRunListener;
import io.jenkins.plugins.model.DevOpsJFrogModel;
import io.jenkins.plugins.model.DevOpsPipelineNode;
import io.jenkins.plugins.model.DevOpsSecurityResultModel;
import io.jenkins.plugins.model.DevOpsSonarQubeModel;
import io.jenkins.plugins.model.DevOpsTestSummary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class DevOpsPipelineGraph {
    private String jobExecutionUrl;
    private FilePath workspacePath;
    private final Set<String> processedIdList = new HashSet<String>();
    private final Map<String, DevOpsPipelineNode> map = new HashMap<String, DevOpsPipelineNode>();
    private final Map<String, LinkedList<DevOpsPipelineNode>> graph = new HashMap<String, LinkedList<DevOpsPipelineNode>>();
    private final Set<DevOpsTestSummary> jobTestResults = new HashSet<DevOpsTestSummary>();
    private final Set<DevOpsSonarQubeModel> jobSonarQubeModelResults = new HashSet<DevOpsSonarQubeModel>();
    private final Set<DevOpsJFrogModel> jobJFrogModelResults = new HashSet<DevOpsJFrogModel>();
    private final Set<DevOpsSecurityResultModel> jobSecurityResults = new HashSet<DevOpsSecurityResultModel>();

    public FilePath getWorkspacePath() {
        return this.workspacePath;
    }

    public void setWorkspacePath(FilePath workspacePath) {
        this.workspacePath = workspacePath;
    }

    public DevOpsPipelineNode getNodeById(String id) {
        return this.map.get(id);
    }

    public DevOpsPipelineNode getNodeByName(String nodeName) {
        Optional<DevOpsPipelineNode> node = this.map.values().stream().filter(entry -> entry.getName().equals(nodeName)).findFirst();
        return node.orElse(null);
    }

    public String getJobExecutionUrl() {
        return this.jobExecutionUrl;
    }

    public void setJobExecutionUrl(String jobExecutionUrl) {
        if (null == this.jobExecutionUrl) {
            this.jobExecutionUrl = jobExecutionUrl;
        }
    }

    public void addToProcessedList(String stageId) {
        this.processedIdList.add(stageId);
    }

    public boolean isAlreadyProcessed(String stageId) {
        return this.processedIdList.contains(stageId);
    }

    public void addStepToNode(String stageId) {
        DevOpsPipelineNode nodeById;
        if (null != stageId && null != (nodeById = this.getNodeById(stageId))) {
            nodeById.setStepAssociated(true);
        }
    }

    public boolean isStepAssociated(String stageId) {
        DevOpsPipelineNode nodeById = this.getNodeById(stageId);
        if (null != nodeById) {
            return nodeById.isStepAssociated();
        }
        return false;
    }

    public boolean isTestResultPublished(DevOpsTestSummary testSummary) {
        return this.jobTestResults.contains(testSummary);
    }

    public void addToJobTestResults(DevOpsTestSummary testSummary) {
        this.jobTestResults.add(testSummary);
    }

    public boolean isSonarQubeModelResultPublished(DevOpsSonarQubeModel sonarQubeModel) {
        return this.jobSonarQubeModelResults.contains(sonarQubeModel);
    }

    public void addToJobSonarQubeModelResults(DevOpsSonarQubeModel sonarQubeModel) {
        this.jobSonarQubeModelResults.add(sonarQubeModel);
    }

    public boolean isJFrogModelResultPublished(DevOpsJFrogModel jFrogModel) {
        return this.jobJFrogModelResults.contains(jFrogModel);
    }

    public void addToJobJFrogModelResults(DevOpsJFrogModel jFrogModel) {
        this.jobJFrogModelResults.add(jFrogModel);
    }

    private String getGraphHashKey(String nodeId) {
        return "Prefix_" + nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DevOpsPipelineNode addNode(String parentId, String shortName, FlowNode flowNode, String pipelineExecutionUrl, String status) {
        DevOpsPipelineNode parentNode;
        String name = shortName;
        if (!StringUtils.isEmpty((String)parentId) && (parentNode = this.map.get(parentId)) != null) {
            name = parentNode.getName() + "/" + shortName;
        }
        DevOpsPipelineNode node = new DevOpsPipelineNode(parentId, shortName, name, flowNode, pipelineExecutionUrl, status);
        String key = this.getGraphHashKey(parentId);
        Map<String, LinkedList<DevOpsPipelineNode>> map = this.graph;
        synchronized (map) {
            LinkedList<Object> linkedList;
            if (!this.graph.containsKey(key)) {
                linkedList = new LinkedList();
                this.graph.put(key, linkedList);
            } else {
                linkedList = this.graph.get(key);
            }
            if (linkedList.isEmpty() || !linkedList.isEmpty() && !Objects.equals(((DevOpsPipelineNode)linkedList.getFirst()).getId(), flowNode.getId())) {
                linkedList.addFirst(node);
            }
        }
        this.map.put(flowNode.getId(), node);
        this.populateUpstreamDetails(parentId, flowNode.getId());
        this.populateParentDetails(parentId, flowNode.getId());
        return node;
    }

    public static String getStageExecutionUrl(String pipelineUrl, String stageId) {
        return pipelineUrl + "execution/node/" + stageId + "/wfapi/describe";
    }

    private void populateParentDetails(String parentStageId, String stageId) {
        if (!StringUtils.isEmpty((String)parentStageId)) {
            DevOpsPipelineNode parentNode = this.getNodeById(parentStageId);
            DevOpsPipelineNode node = this.getNodeById(stageId);
            if (parentNode != null) {
                node.setParentName(parentNode.getName());
                String parentExecutionUrl = DevOpsPipelineGraph.getStageExecutionUrl(parentNode.getPipelineExecutionUrl(), parentStageId);
                node.setParentExecutionUrl(parentExecutionUrl);
            }
        }
    }

    private void populateUpstreamDetails(String parentStageId, String stageId) {
        DevOpsPipelineNode upStreamPipelineNode;
        DevOpsPipelineNode node;
        FlowNode flowNode;
        Boolean isParallelStage;
        if (this.map.containsKey(stageId) && !(isParallelStage = Boolean.valueOf(DevOpsRunListener.DevOpsStageListener.isEnclosedInParallel(flowNode = (node = this.getNodeById(stageId)).getFlowNode()))).booleanValue() && (upStreamPipelineNode = this.getUpStreamNode(parentStageId, stageId)) != null) {
            node.setUpstreamStageName(upStreamPipelineNode.getName());
            String upstreamTaskExecURL = DevOpsPipelineGraph.getStageExecutionUrl(upStreamPipelineNode.getPipelineExecutionUrl(), upStreamPipelineNode.getId());
            node.setUpstreamTaskExecURL(upstreamTaskExecURL);
        }
    }

    private DevOpsPipelineNode getUpStreamNode(String parentId, String id) {
        DevOpsPipelineNode upStreamStage = null;
        String key = this.getGraphHashKey(parentId);
        if (this.graph.containsKey(key)) {
            LinkedList<DevOpsPipelineNode> linkedList = this.graph.get(key);
            for (int i = 0; i < linkedList.size() - 1; ++i) {
                if (!linkedList.get(i).getId().equals(id)) continue;
                upStreamStage = linkedList.get(i + 1);
                break;
            }
        }
        return upStreamStage;
    }

    public List<String> getWaitForChildExecutions(String stageId) {
        ArrayList<String> childs = new ArrayList<String>();
        String key = this.getGraphHashKey(stageId);
        if (this.graph.containsKey(key)) {
            LinkedList<DevOpsPipelineNode> list = this.graph.get(key);
            for (DevOpsPipelineNode node : list) {
                childs.add(DevOpsPipelineGraph.getStageExecutionUrl(node.getPipelineExecutionUrl(), node.getId()));
            }
        }
        return childs;
    }

    public void addToJobSecurityResults(DevOpsSecurityResultModel model) {
        this.jobSecurityResults.add(model);
    }

    public boolean isJobSecurityResultsPublished(DevOpsSecurityResultModel securityResultModel) {
        return this.jobSecurityResults.contains(securityResultModel);
    }
}

