/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.model;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.ScheduleResult;
import hudson.scm.SCM;
import hudson.triggers.SCMTrigger;
import io.jenkins.plugins.DevOpsRootAction;
import io.jenkins.plugins.DevOpsRunListener;
import io.jenkins.plugins.DevOpsRunStatusAction;
import io.jenkins.plugins.config.DevOpsConfigurationEntry;
import io.jenkins.plugins.config.DevOpsJobProperty;
import io.jenkins.plugins.model.DevOpsPipelineGraph;
import io.jenkins.plugins.model.DevOpsPipelineInfoConfig;
import io.jenkins.plugins.model.DevOpsPipelineNode;
import io.jenkins.plugins.pipeline.steps.DevOpsPipelineMapStep;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsPipelineChangeStepExecution;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsPipelineMapStepExecution;
import io.jenkins.plugins.utils.CommUtils;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.triggers.SCMTriggerItem;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class DevOpsModel {
    public final Pattern urlPatt = Pattern.compile("^(https?):\\/\\/[-a-zA-Z0-9+&@#\\/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#\\/%=~_|]");
    private boolean queueJobs;

    private void printDebug(String methodName, String[] variables, String[] values, Level logLevel) {
        GenericUtils.printDebug(DevOpsModel.class.getName(), methodName, variables, values, logLevel);
    }

    public boolean isQueueJobs() {
        return this.queueJobs;
    }

    public void setQueueJobs(boolean queue) {
        this.queueJobs = queue;
    }

    public boolean isApproved(String result) {
        boolean b = false;
        this.printDebug("isApproved", new String[]{"result"}, new String[]{result}, Level.INFO);
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)result);
            if (jsonObject.containsKey((Object)DevOpsConstants.CALLBACK_RESULT_ATTR.toString())) {
                result = jsonObject.getString(DevOpsConstants.CALLBACK_RESULT_ATTR.toString());
                b = result.equals(DevOpsConstants.CALLBACK_RESULT_SUCCESS.toString());
            }
        }
        catch (Exception e) {
            this.printDebug("isApproved", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
        }
        return b;
    }

    public boolean isCanceled(String result) {
        boolean b = false;
        this.printDebug("isCanceled", new String[]{"result"}, new String[]{result}, Level.INFO);
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)result);
            if (jsonObject.containsKey((Object)DevOpsConstants.CALLBACK_RESULT_ATTR.toString())) {
                result = jsonObject.getString(DevOpsConstants.CALLBACK_RESULT_ATTR.toString());
                b = result.equals(DevOpsConstants.CALLBACK_RESULT_CANCELED.toString());
            }
        }
        catch (Exception e) {
            this.printDebug("isCanceled", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
        }
        return b;
    }

    public String getChangeComments(String result) {
        String changeComments = "";
        this.printDebug("getChangeComments", new String[]{"result"}, new String[]{result}, Level.INFO);
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)result);
            if (jsonObject.containsKey((Object)DevOpsConstants.CALLBACK_RESULT_COMMENTS.toString())) {
                return jsonObject.getString(DevOpsConstants.CALLBACK_RESULT_COMMENTS.toString());
            }
        }
        catch (Exception e) {
            this.printDebug("getChangeComments", new String[]{"exception"}, new String[]{e.getMessage()}, Level.INFO);
        }
        return changeComments;
    }

    public String getChangeRequestInfo(String result) {
        String changeRequestId = "";
        this.printDebug("getChangeRequestInfo", null, null, Level.INFO);
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)result);
            if (jsonObject.containsKey((Object)DevOpsConstants.CHANGE_REQUEST_ID.toString())) {
                return jsonObject.getString(DevOpsConstants.CHANGE_REQUEST_ID.toString());
            }
        }
        catch (Exception e) {
            this.printDebug("getChangeRequestInfo", new String[]{"exception"}, new String[]{e.getMessage()}, Level.INFO);
        }
        return changeRequestId;
    }

    public boolean isCommFailure(String result) {
        boolean b = false;
        this.printDebug("isCommFailure", new String[]{"result"}, new String[]{result}, Level.INFO);
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)result);
            if (jsonObject.containsKey((Object)DevOpsConstants.CALLBACK_RESULT_ATTR.toString())) {
                result = jsonObject.getString(DevOpsConstants.CALLBACK_RESULT_ATTR.toString());
                b = result.equals(DevOpsConstants.CALLBACK_RESULT_COMM_FAILURE.toString());
            }
        }
        catch (Exception e) {
            this.printDebug("isCommFailure", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
        }
        return b;
    }

    public DevOpsPipelineInfo checkIsTracking(Queue.Item item) {
        this.printDebug("checkIsTracking(item)", null, null, Level.FINE);
        if (item == null) {
            return null;
        }
        if (!(item.task instanceof Job)) {
            return null;
        }
        Job job = (Job)item.task;
        if (!this.checkIsValid(job)) {
            return null;
        }
        String jobUrl = job.getAbsoluteUrl();
        String jobName = job.getFullName();
        this.printDebug("checkIsTracking(item)", new String[]{"tracking"}, new String[]{"true"}, Level.FINE);
        return this.isTrackingEndpoint(job, jobUrl, jobName, job.getPronoun(), null, false);
    }

    public DevOpsPipelineInfo checkIsTracking(Job<?, ?> job, String runId, String branchName) {
        DevOpsPipelineInfo pipelineInfo;
        this.printDebug("checkIsTracking(run)", new String[]{"runId", "branchName"}, new String[]{runId, branchName}, Level.FINE);
        if (job == null) {
            return null;
        }
        if (!this.checkIsValid(job)) {
            return null;
        }
        String jobUrl = job.getAbsoluteUrl();
        String jobName = job.getFullName();
        if (this.isTrackingCache(jobName, runId) && (pipelineInfo = this.getPipelineInfo(job, runId)) != null) {
            return pipelineInfo;
        }
        return this.isTrackingEndpoint(job, jobUrl, jobName, job.getPronoun(), branchName, GenericUtils.isMultiBranch(job));
    }

    public DevOpsPipelineInfo getPipelineInfo(Job<?, ?> job, String runId) {
        if (job == null) {
            return null;
        }
        if (!this.checkIsValid(job)) {
            return null;
        }
        String jobName = job.getFullName();
        String key = this.getTrackingKey(jobName, runId);
        this.printDebug("getPipelineInfo", new String[]{"jobName", "key"}, new String[]{jobName, key}, Level.FINE);
        return DevOpsRootAction.getSnPipelineInfo(key);
    }

    public boolean checkIsTrackingCache(Job<?, ?> job, String runId) {
        this.printDebug("checkIsTrackingCache", new String[]{"runId"}, new String[]{runId}, Level.FINE);
        if (job == null) {
            return false;
        }
        if (!this.checkIsValid(job)) {
            return false;
        }
        String jobName = job.getFullName();
        return this.isTrackingCache(jobName, runId);
    }

    public boolean checkIsValid(Job<?, ?> job) {
        this.printDebug("checkIsValid", null, null, Level.FINE);
        if (job == null || job.getPronoun() == null) {
            return false;
        }
        String pronoun = job.getPronoun();
        if (!(pronoun.equalsIgnoreCase(DevOpsConstants.PIPELINE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.BITBUCKET_MULTI_BRANCH_PIPELINE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.PULL_REQUEST_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString()))) {
            return false;
        }
        if (!GenericUtils.isDevOpsConfigurationEnabled()) {
            return false;
        }
        this.printDebug("checkIsValid", new String[]{"valid"}, new String[]{"true"}, Level.FINE);
        return true;
    }

    public String getTrackingKey(String jobName, String runId) {
        this.printDebug("getTrackingKey", new String[]{"runId", "jobName"}, new String[]{runId, jobName}, Level.FINE);
        if (jobName == null) {
            return null;
        }
        return jobName + DevOpsConstants.TRACKING_KEY_SEPARATOR.toString() + runId;
    }

    public void addToPipelineInfoCache(String jobName, String runId, DevOpsPipelineInfo pipelineInfo) {
        this.printDebug("addToPipelineInfoCache", new String[]{"runId", "jobName"}, new String[]{runId, jobName}, Level.FINE);
        String key = this.getTrackingKey(jobName, runId);
        if (key == null) {
            return;
        }
        if (pipelineInfo == null) {
            return;
        }
        DevOpsRootAction.setSnPipelineInfo(key, pipelineInfo);
    }

    public void removeFromPipelineInfoCache(String jobName, String runId) {
        this.printDebug("removeFromPipelineInfoCache", new String[]{"runId", "jobName"}, new String[]{runId, jobName}, Level.FINE);
        String key = this.getTrackingKey(jobName, runId);
        if (key == null) {
            return;
        }
        DevOpsRootAction.removeSnPipelineInfo(key);
    }

    public void addToTrackingCache(String jobName, String runId) {
        this.printDebug("addToTrackingCache", new String[]{"runId", "jobName"}, new String[]{runId, jobName}, Level.FINE);
        String key = this.getTrackingKey(jobName, runId);
        this.printDebug("addToTrackingCache", new String[]{"key"}, new String[]{key}, Level.FINE);
        if (key == null) {
            return;
        }
        DevOpsRootAction.setTrackedJob(key);
    }

    public void removeFromTrackingCache(String jobName, String runId) {
        this.printDebug("removeFromTrackingCache", new String[]{"runId", "jobName"}, new String[]{runId, jobName}, Level.FINE);
        String key = this.getTrackingKey(jobName, runId);
        if (key == null) {
            return;
        }
        DevOpsRootAction.removeTrackedJob(key);
    }

    public boolean isTrackingCache(String jobName, String runId) {
        this.printDebug("isTrackingCache", new String[]{"runId", "jobName"}, new String[]{runId, jobName}, Level.FINE);
        String key = this.getTrackingKey(jobName, runId);
        if (key == null) {
            return false;
        }
        Boolean tracking = DevOpsRootAction.getTrackedJob(key);
        if (tracking == null) {
            return false;
        }
        this.printDebug("isTrackingCache", new String[]{"tracking"}, new String[]{String.valueOf(tracking)}, Level.FINE);
        return tracking;
    }

    public JSONObject getTrackInfoForConfigKey(String jobName, String path, String key) {
        this.printDebug("getTrackInfoForConfigKey", new String[]{"jobName"}, new String[]{jobName}, Level.FINE);
        if (jobName == null || path == null || key == null) {
            return null;
        }
        this.printDebug("getTrackInfoForConfigKey", new String[]{"path"}, new String[]{path}, Level.FINE);
        return DevOpsRootAction.getTrackInfoForConfigKey(jobName, path, key);
    }

    public JSONObject getTrackingObjectFromFile(String path) {
        this.printDebug("getTrackingObjectFromFile", new String[]{"path"}, new String[]{path}, Level.FINE);
        if (path == null) {
            return null;
        }
        this.printDebug("getTrackingObjectFromFile", new String[]{"path"}, new String[]{path}, Level.FINE);
        return DevOpsRootAction.getTrackingObjectFromFile(path);
    }

    public Boolean updatePipelineInfoInFile(String jobName, JSONObject configsTrackInfo, String path) {
        this.printDebug("updatePipelineInfoInFile", new String[]{"jobName"}, new String[]{jobName}, Level.FINE);
        if (jobName == null || path == null || configsTrackInfo == null) {
            return false;
        }
        this.printDebug("updatePipelineInfoInFile", new String[]{"path"}, new String[]{path}, Level.FINE);
        return DevOpsRootAction.updateInfoInFile(jobName, configsTrackInfo, path);
    }

    public List<DevOpsConfigurationEntry> getDevOpsConfigEntriesFromTrackingObject(JSONObject trackingObject) {
        if (trackingObject == null) {
            return null;
        }
        ArrayList<DevOpsConfigurationEntry> devopsConfigs = new ArrayList<DevOpsConfigurationEntry>();
        Iterator keys = trackingObject.keys();
        while (keys.hasNext()) {
            String toolId;
            String instanceUrl;
            DevOpsConfigurationEntry entry;
            String[] _key;
            boolean resultValue;
            JSONObject result;
            JSONObject configResult;
            String key = (String)keys.next();
            if (!(trackingObject.get(key) instanceof JSONObject) || !(configResult = trackingObject.getJSONObject(key)).containsKey((Object)DevOpsConstants.COMMON_RESPONSE_RESULT.toString()) || !(result = configResult.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString())).containsKey((Object)"track") || !(resultValue = result.getBoolean("track")) || (_key = key.split("_")).length != 2 || (entry = GenericUtils.getDevOpsConfigurationEntryByInstanceUrlAndToolId(instanceUrl = _key[1], toolId = _key[0])) == null) continue;
            devopsConfigs.add(entry);
        }
        if (devopsConfigs.size() > 0) {
            return devopsConfigs;
        }
        return null;
    }

    public String getInfoFilePath(Job<?, ?> job) {
        if (job == null) {
            return null;
        }
        String jobDir = job.getRootDir().getAbsolutePath();
        if (GenericUtils.isMultiBranch(job).booleanValue()) {
            jobDir = jobDir.split(DevOpsConstants.MULTIBRANCH_PATH_SEPARATOR.toString())[0];
        }
        return jobDir + DevOpsConstants.PATH_SEPARATOR.toString() + DevOpsConstants.SERVICENOW_PIPELINE_INFO_FILE_NAME.toString();
    }

    public DevOpsPipelineInfoConfig getPipelineInfoConfig(String key, JSONObject configTrackInfo, String pronoun, DevOpsConfigurationEntry entry) {
        if (key == null || configTrackInfo == null || entry == null) {
            return null;
        }
        String result = GenericUtils.parseResponseResult(configTrackInfo, DevOpsConstants.TRACKING_RESPONSE_ATTR.toString());
        if (result != null) {
            if (result.equalsIgnoreCase("true")) {
                JSONObject resultObj = configTrackInfo.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
                if (resultObj.containsKey((Object)DevOpsConstants.TEST_INFO_RESPONSE.toString())) {
                    JSONObject testInfo = resultObj.getJSONObject(DevOpsConstants.TEST_INFO_RESPONSE.toString());
                    return new DevOpsPipelineInfoConfig(true, entry, key, testInfo);
                }
                return new DevOpsPipelineInfoConfig(true, entry, key);
            }
            if (result.equalsIgnoreCase("false")) {
                return new DevOpsPipelineInfoConfig(false, entry, key);
            }
            if (result.contains(DevOpsConstants.COMMON_RESULT_FAILURE.toString())) {
                if (result.contains(DevOpsConstants.FAILURE_REASON_CONN_REFUSED.toString())) {
                    return new DevOpsPipelineInfoConfig(false, entry, key, true, DevOpsConstants.FAILURE_REASON_CONN_REFUSED_UI.toString());
                }
                if (result.contains(DevOpsConstants.FAILURE_REASON_USER_NOAUTH.toString())) {
                    return new DevOpsPipelineInfoConfig(false, entry, key, true, DevOpsConstants.FAILURE_REASON_USER_NOAUTH_UI.toString());
                }
                if (pronoun != null && result.contains(DevOpsConstants.FAILURE_REASON_PIPELINE_DETAILS_NOT_FOUND.toString()) && (pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString()))) {
                    return new DevOpsPipelineInfoConfig(false, entry, key);
                }
            }
        }
        return new DevOpsPipelineInfoConfig(false, entry, key, true, DevOpsConstants.FAILURE_REASON_GENERIC_UI.toString());
    }

    public DevOpsPipelineInfo isTrackingEndpoint(Job<?, ?> job, String jobUrl, String jobName, String pronoun, String branchName, boolean isMultiBranch) {
        this.printDebug("isTrackingEndpoint", new String[]{"jobUrl", "jobName", "pronoun", "branchName", "isMultiBranch"}, new String[]{jobUrl, jobName, pronoun, branchName, String.valueOf(isMultiBranch)}, Level.FINE);
        List<DevOpsConfigurationEntry> activeDevopsConfigEntries = GenericUtils.getActiveDevOpsConfigurationEntry();
        String infoFilePath = this.getInfoFilePath(job);
        JSONObject configsTrackInfo = new JSONObject();
        ArrayList<DevOpsPipelineInfoConfig> pipelineInfoConfigs = new ArrayList<DevOpsPipelineInfoConfig>();
        for (DevOpsConfigurationEntry entry : activeDevopsConfigEntries) {
            JSONObject configTrackInfo = this.getTrackInfoForConfigKey(jobName, infoFilePath, GenericUtils.getConfigEntryTrackKey(entry.getInstanceUrl(), entry.getToolId()));
            if (configTrackInfo == null || entry.getTrackCheck()) {
                JSONObject params = new JSONObject();
                params.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)entry.getToolId());
                params.put("url", (Object)jobUrl);
                params.put("name", (Object)jobName);
                params.put("pronoun", (Object)pronoun);
                if (branchName != null) {
                    params.put("branchName", (Object)branchName);
                }
                params.put("isMultiBranch", (Object)isMultiBranch);
                this.printDebug("isTrackingEndpoint", new String[]{"configurationName"}, new String[]{entry.getName()}, Level.FINE);
                if (!GenericUtils.isEmptyOrDefault(entry.getSecretCredentialId())) {
                    HashMap<String, String> tokenDetails = new HashMap<String, String>();
                    tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), DevOpsConfigurationEntry.getTokenText(entry.getSecretCredentialId()));
                    configTrackInfo = CommUtils.callV2Support(DevOpsConstants.REST_GET_METHOD.toString(), entry.getTrackingUrl(), params, null, DevOpsConfigurationEntry.getUser(entry.getSecretCredentialId()), DevOpsConfigurationEntry.getPwd(entry.getSecretCredentialId()), null, null, tokenDetails);
                } else {
                    configTrackInfo = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), entry.getTrackingUrl(), params, null, DevOpsConfigurationEntry.getUser(entry.getCredentialsId()), DevOpsConfigurationEntry.getPwd(entry.getCredentialsId()), null, null);
                }
            }
            if (!GenericUtils.checkIfAttributeExist(configTrackInfo, DevOpsConstants.TRACKING_RESPONSE_ATTR.toString()).booleanValue()) continue;
            String configKey = GenericUtils.getConfigEntryTrackKey(entry.getInstanceUrl(), entry.getToolId());
            configsTrackInfo.put(configKey, (Object)configTrackInfo);
            DevOpsPipelineInfoConfig pipelineInfoConfig = this.getPipelineInfoConfig(configKey, configTrackInfo, pronoun, entry);
            if (pipelineInfoConfig == null) continue;
            pipelineInfoConfigs.add(pipelineInfoConfig);
        }
        if (!configsTrackInfo.isEmpty()) {
            this.updatePipelineInfoInFile(jobName, configsTrackInfo, infoFilePath);
        }
        return new DevOpsPipelineInfo(pipelineInfoConfigs);
    }

    public boolean scheduleNextJob(Run<?, ?> run, Job<?, ?> job, int quietPeriod) {
        this.printDebug("scheduleNextJob", null, null, Level.FINE);
        List causes = run.getCauses();
        if (causes.size() > 1) {
            ArrayList<Cause> _causes = new ArrayList<Cause>();
            for (int i = 1; i < causes.size(); ++i) {
                Cause c = (Cause)causes.get(i);
                if (!(c instanceof Cause.UpstreamCause)) continue;
                _causes.add(c);
            }
            CauseAction cAction = new CauseAction(_causes);
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins != null) {
                Queue queue = jenkins.getQueue();
                Queue.Task project = (Queue.Task)jenkins.getItemByFullName(job.getFullName(), AbstractProject.class);
                if (queue != null && project != null && cAction != null) {
                    ScheduleResult sResult = queue.schedule2(project, quietPeriod, new Action[]{cAction});
                    return sResult.isCreated();
                }
            }
        }
        return false;
    }

    public String getJobId(Queue.Item item, Job<?, ?> job) {
        this.printDebug("getJobId", null, null, Level.FINE);
        String queueId = String.valueOf(item.getId());
        String jobName = job.getUrl();
        return queueId + "/" + jobName;
    }

    public String getJobId(Run<?, ?> run, Job<?, ?> job) {
        this.printDebug("getJobId", null, null, Level.FINE);
        String queueId = String.valueOf(run.getQueueId());
        String jobName = job.getUrl();
        return queueId + "/" + jobName;
    }

    public String getChangeRequestContent(String jobId) {
        this.printDebug("getChangeRequestContent", new String[]{"jobId"}, new String[]{jobId}, Level.FINE);
        return DevOpsRootAction.getChangeRequestContent(jobId);
    }

    public String removeChangeRequestContent(String jobId) {
        this.printDebug("removeChangeRequestContent", new String[]{"jobId"}, new String[]{jobId}, Level.FINE);
        return DevOpsRootAction.removeChangeRequestContent(jobId);
    }

    public String getCallbackResult(String jobId) {
        this.printDebug("getCallbackResult", new String[]{"jobId"}, new String[]{jobId}, Level.FINE);
        return DevOpsRootAction.getCallbackContent(jobId);
    }

    public String removeCallbackResult(String jobId) {
        this.printDebug("removeCallbackResult", new String[]{"jobId"}, new String[]{jobId}, Level.FINE);
        return DevOpsRootAction.removeCallbackContent(jobId);
    }

    public String removeCallbackToken(String jobId) {
        this.printDebug("removeCallbackToken", new String[]{"jobId"}, new String[]{jobId}, Level.FINE);
        return DevOpsRootAction.removeCallbackToken(jobId);
    }

    public String getToken(String jobId) {
        this.printDebug("getToken", new String[]{"jobId"}, new String[]{jobId}, Level.FINE);
        return DevOpsRootAction.getToken(jobId);
    }

    public String getNewToken(String pronoun) {
        this.printDebug("getNewToken", new String[]{"pronoun"}, new String[]{pronoun}, Level.FINE);
        String token = null;
        if (pronoun != null) {
            if (pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString())) {
                token = DevOpsConstants.FREESTYLE_CALLBACK_URL_IDENTIFIER.toString() + DevOpsConstants.CALLBACK_TOKEN_SEPARATOR.toString() + UUID.randomUUID().toString();
            } else if (pronoun.equalsIgnoreCase(DevOpsConstants.PIPELINE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.PULL_REQUEST_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.BITBUCKET_MULTI_BRANCH_PIPELINE_PRONOUN.toString())) {
                token = DevOpsConstants.PIPELINE_CALLBACK_URL_IDENTIFIER.toString() + DevOpsConstants.CALLBACK_TOKEN_SEPARATOR.toString() + UUID.randomUUID().toString();
            }
        }
        return token;
    }

    public String getJenkinsUrl() {
        this.printDebug("getJenkinsUrl", null, null, Level.FINE);
        String url = null;
        try {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins != null) {
                url = jenkins.getRootUrl();
            }
        }
        catch (IllegalStateException e) {
            this.printDebug("getJenkinsUrl", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
        }
        return url;
    }

    public String getJenkinsRootDirPath() {
        this.printDebug("getJenkinsRootDirPath", null, null, Level.FINE);
        String path = null;
        try {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins != null) {
                path = jenkins.getRootDir().getAbsolutePath();
            }
        }
        catch (IllegalStateException e) {
            this.printDebug("getJenkinsRootDirPath", new String[]{"exception"}, new String[]{e.getMessage()}, Level.FINE);
        }
        return path;
    }

    public boolean isWaiting(String token) {
        this.printDebug("isWaiting", null, null, Level.FINE);
        String _jobId = DevOpsRootAction.getJobId(token);
        return _jobId != null;
    }

    public boolean checkUrlValid(String url) {
        this.printDebug("checkUrlValid", new String[]{"url"}, new String[]{url}, Level.FINE);
        Matcher m = this.urlPatt.matcher(url);
        return m.matches();
    }

    private String getCallbackUrl(String token, String jenkinsUrl) throws URISyntaxException {
        this.printDebug("getCallbackUrl", new String[]{"token", "jenkinsUrl"}, new String[]{token, jenkinsUrl}, Level.FINE);
        URI baseUri = new URI(jenkinsUrl);
        URI relative = new URI(DevOpsConstants.CALLBACK_URL_IDENTIFIER.toString() + "/" + token);
        URI path = baseUri.resolve(relative);
        return path.toString();
    }

    public String replaceLast(String string, String substring, String replacement) {
        int index = string.lastIndexOf(substring);
        if (index == -1) {
            return string;
        }
        return string.substring(0, index) + replacement + string.substring(index + substring.length());
    }

    public String sendBuildAndToken(String token, String jenkinsUrl, String buildUrl, String jobUrl, String jobName, String stageName, DevOpsPipelineNode stageNode, Boolean isMultiBranch, String branchName, Boolean isChangeClose, DevOpsConfigurationEntry devopsConfig) {
        this.printDebug("sendBuildAndToken", null, null, Level.FINE);
        JSONObject params = new JSONObject();
        JSONObject data = new JSONObject();
        String result = null;
        if (devopsConfig == null) {
            return null;
        }
        params.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)devopsConfig.getToolId());
        params.put(DevOpsConstants.TOOL_TYPE_ATTR.toString(), (Object)DevOpsConstants.TOOL_TYPE.toString());
        try {
            String callbackUrl = this.getCallbackUrl(token, jenkinsUrl);
            data.put(DevOpsConstants.CALLBACK_URL_ATTR.toString(), (Object)callbackUrl);
            data.put(DevOpsConstants.JOB_URL_ATTR.toString(), (Object)jobUrl);
            data.put(DevOpsConstants.BUILD_URL_ATTR.toString(), (Object)buildUrl);
            data.put(DevOpsConstants.IS_MULTI_BRANCH_ATTR.toString(), (Object)Boolean.toString(isMultiBranch));
            data.put(DevOpsConstants.SCM_BRANCH_NAME.toString(), (Object)branchName);
            if (stageNode != null) {
                data.put(DevOpsConstants.JOB_NAME_ATTR.toString(), (Object)(jobName + DevOpsConstants.JOB_STAGE_SEPARATOR.toString() + stageName));
                data.put(DevOpsConstants.JOB_URL_ATTR.toString(), (Object)this.replaceLast(jobUrl, "/", DevOpsConstants.JOB_STAGE_SEPARATOR.toString() + stageNode.getName() + "/"));
            } else {
                data.put(DevOpsConstants.JOB_NAME_ATTR.toString(), (Object)jobName);
            }
            if (isChangeClose.booleanValue() && null != stageNode) {
                data.put(DevOpsConstants.PARENT_BUILD_URL_ATTR.toString(), (Object)(jenkinsUrl + stageNode.getExecutionUrl() + "wfapi/describe"));
            }
            this.addStageNodeParams(stageNode, data, jobName, jobUrl, DevOpsConstants.REST_PUT_METHOD);
            if (!GenericUtils.isEmptyOrDefault(devopsConfig.getSecretCredentialId())) {
                HashMap<String, String> tokenDetails = new HashMap<String, String>();
                tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), DevOpsConfigurationEntry.getTokenText(devopsConfig.getSecretCredentialId()));
                result = GenericUtils.parseResponseResult(CommUtils.callV2Support(DevOpsConstants.REST_PUT_METHOD.toString(), devopsConfig.getChangeControlUrl() + "/" + token, params, data.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null, tokenDetails), DevOpsConstants.COMMON_RESPONSE_CHANGE_CTRL.toString());
            } else {
                result = GenericUtils.parseResponseResult(CommUtils.call(DevOpsConstants.REST_PUT_METHOD.toString(), devopsConfig.getChangeControlUrl() + "/" + token, params, data.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null), DevOpsConstants.COMMON_RESPONSE_CHANGE_CTRL.toString());
            }
        }
        catch (Exception e) {
            this.printDebug("sendBuildAndToken", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
        }
        return result;
    }

    public String sendIsUnderChgControl(String jobUrl, String jobName, String stageName, DevOpsPipelineNode stageNode, Boolean isMultiBranch, String branchName, String configurationName) {
        this.printDebug("sendIsUnderChgControl", null, null, Level.FINE);
        JSONObject params = new JSONObject();
        String result = null;
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntryOrDefault(configurationName);
        if (devopsConfig == null) {
            return null;
        }
        params.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)devopsConfig.getToolId());
        params.put(DevOpsConstants.TOOL_TYPE_ATTR.toString(), (Object)DevOpsConstants.TOOL_TYPE.toString());
        params.put(DevOpsConstants.JOB_URL_ATTR.toString(), (Object)jobUrl);
        params.put(DevOpsConstants.IS_MULTI_BRANCH_ATTR.toString(), (Object)Boolean.toString(isMultiBranch));
        params.put(DevOpsConstants.SCM_BRANCH_NAME.toString(), (Object)branchName);
        if (stageNode != null) {
            params.put(DevOpsConstants.JOB_NAME_ATTR.toString(), (Object)(jobName + DevOpsConstants.JOB_STAGE_SEPARATOR.toString() + stageNode.getName()));
            params.put(DevOpsConstants.JOB_URL_ATTR.toString(), (Object)this.replaceLast(jobUrl, "/", DevOpsConstants.JOB_STAGE_SEPARATOR.toString() + stageNode.getName() + "/"));
        } else {
            params.put(DevOpsConstants.JOB_NAME_ATTR.toString(), (Object)jobName);
        }
        this.addStageNodeParams(stageNode, params, jobName, jobUrl, DevOpsConstants.REST_GET_METHOD);
        try {
            if (!GenericUtils.isEmptyOrDefault(devopsConfig.getSecretCredentialId())) {
                HashMap<String, String> tokenDetails = new HashMap<String, String>();
                tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), DevOpsConfigurationEntry.getTokenText(devopsConfig.getSecretCredentialId()));
                result = GenericUtils.parseResponseResult(CommUtils.callV2Support(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getChangeControlUrl(), params, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null, tokenDetails), DevOpsConstants.COMMON_RESPONSE_CHANGE_CTRL.toString());
            } else {
                result = GenericUtils.parseResponseResult(CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getChangeControlUrl(), params, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null), DevOpsConstants.COMMON_RESPONSE_CHANGE_CTRL.toString());
            }
        }
        catch (Exception e) {
            this.printDebug("sendIsUnderChgControl", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
        }
        return result;
    }

    public String sendJobAndCallbackUrl(String token, String jobUrl, String jobName, String stageName, DevOpsPipelineNode stageNode, String jenkinsUrl, String endpointUrl, String user, String pwd, String tool, JSONObject jobDetails, Boolean isMultiBranch, String branchName, String changeRequestDetails, PipelineChangeResponse changeResponse, String applicationName, String snapshotName, Boolean isFreestyle) {
        this.printDebug("sendJobAndCallbackUrl", null, null, Level.FINE);
        JSONObject params = new JSONObject();
        JSONObject data = new JSONObject();
        String result = null;
        params.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)tool);
        params.put(DevOpsConstants.TOOL_TYPE_ATTR.toString(), (Object)DevOpsConstants.TOOL_TYPE.toString());
        try {
            String message;
            String parentStageExecutionURL;
            String callbackUrl = this.getCallbackUrl(token, jenkinsUrl);
            data.put(DevOpsConstants.CALLBACK_URL_ATTR.toString(), (Object)callbackUrl);
            data.put(DevOpsConstants.JOB_URL_ATTR.toString(), (Object)jobUrl);
            data.put(DevOpsConstants.IS_MULTI_BRANCH_ATTR.toString(), (Object)Boolean.toString(isMultiBranch));
            data.put(DevOpsConstants.SCM_BRANCH_NAME.toString(), (Object)branchName);
            if (isFreestyle != null) {
                data.put(DevOpsConstants.IS_FREESTYLE_ATTR.toString(), (Object)Boolean.toString(isFreestyle));
            }
            if (stageNode != null && null != stageNode.getPipelineExecutionUrl()) {
                data.put(DevOpsConstants.PIPLINE_EXECUTION_URL.toString(), (Object)stageNode.getPipelineExecutionUrl());
            }
            if (stageName != null && !stageName.isEmpty()) {
                data.put(DevOpsConstants.JOB_NAME_ATTR.toString(), (Object)(jobName + DevOpsConstants.JOB_STAGE_SEPARATOR.toString() + stageName));
                data.put(DevOpsConstants.JOB_NAME_ATTR.toString(), (Object)jobName);
                data.put(DevOpsConstants.STAGENAME_ATTR.toString(), (Object)stageName);
                data.put(DevOpsConstants.JOB_URL_ATTR.toString(), (Object)this.replaceLast(jobUrl, "/", DevOpsConstants.JOB_STAGE_SEPARATOR.toString() + stageName + "/"));
            } else {
                data.put(DevOpsConstants.JOB_NAME_ATTR.toString(), (Object)jobName);
            }
            this.addStageNodeParams(stageNode, data, jobName, jobUrl, DevOpsConstants.REST_POST_METHOD);
            if (data.get(DevOpsConstants.JOB_PARENT_STAGE_EXECUTION_URL.toString()) != null && (parentStageExecutionURL = data.get(DevOpsConstants.JOB_PARENT_STAGE_EXECUTION_URL.toString()).toString()) != null) {
                jobDetails.put(DevOpsConstants.BUILD_URL_ATTR.toString(), data.get(DevOpsConstants.JOB_PARENT_STAGE_EXECUTION_URL.toString()));
            }
            data.put(DevOpsConstants.JOB_DETAILS_ATTR.toString(), (Object)jobDetails);
            if (GenericUtils.isNotEmpty(changeRequestDetails)) {
                JSONObject crAttrJSON = JSONObject.fromObject((Object)changeRequestDetails);
                data.put(DevOpsConstants.CR_ATTRS.toString(), (Object)crAttrJSON);
            }
            if (GenericUtils.isNotEmpty(applicationName) && GenericUtils.isNotEmpty(snapshotName)) {
                data.put(DevOpsConstants.CONFIG_APP_NAME.toString(), (Object)applicationName);
                data.put(DevOpsConstants.CONFIG_SNAPSHOT_NAME.toString(), (Object)snapshotName);
            }
            JSONObject response = CommUtils.call(DevOpsConstants.REST_POST_METHOD.toString(), endpointUrl, params, data.toString(), user, pwd, null, null);
            result = GenericUtils.parseResponseResult(response, DevOpsConstants.COMMON_RESPONSE_CHANGE_CTRL.toString());
            if (changeResponse != null && !GenericUtils.isEmpty(message = GenericUtils.parseResponseResult(response, DevOpsConstants.COMMON_RESPONSE_MESSAGE.toString()))) {
                changeResponse.setMessage(message);
            }
        }
        catch (JSONException e) {
            this.printDebug("sendJobAndCallbackUrl", new String[]{"JSONException"}, new String[]{e.getMessage()}, Level.SEVERE);
            JSONObject errorObj = new JSONObject();
            String errorMessage = "Failed to parse changeRequestDetails json." + e.getMessage();
            errorObj.put(DevOpsConstants.COMMON_RESULT_FAILURE.toString(), (Object)errorMessage);
            result = errorObj.toString();
        }
        catch (Exception e) {
            this.printDebug("sendJobAndCallbackUrl", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
        }
        return result;
    }

    public String sendJobAndCallbackUrlV2(String token, String jobUrl, String jobName, String stageName, DevOpsPipelineNode stageNode, String jenkinsUrl, String endpointUrl, String user, String pwd, String tool, JSONObject jobDetails, Boolean isMultiBranch, String branchName, String changeRequestDetails, PipelineChangeResponse changeResponse, String applicationName, String snapshotName, Map<String, String> tokenDetails, Boolean isFreestyle) {
        this.printDebug("sendJobAndCallbackUrl", null, null, Level.FINE);
        JSONObject params = new JSONObject();
        JSONObject data = new JSONObject();
        String result = null;
        params.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)tool);
        params.put(DevOpsConstants.TOOL_TYPE_ATTR.toString(), (Object)DevOpsConstants.TOOL_TYPE.toString());
        try {
            String message;
            String parentStageExecutionURL;
            String callbackUrl = this.getCallbackUrl(token, jenkinsUrl);
            data.put(DevOpsConstants.CALLBACK_URL_ATTR.toString(), (Object)callbackUrl);
            data.put(DevOpsConstants.JOB_URL_ATTR.toString(), (Object)jobUrl);
            data.put(DevOpsConstants.IS_MULTI_BRANCH_ATTR.toString(), (Object)Boolean.toString(isMultiBranch));
            data.put(DevOpsConstants.SCM_BRANCH_NAME.toString(), (Object)branchName);
            if (isFreestyle != null) {
                data.put(DevOpsConstants.IS_FREESTYLE_ATTR.toString(), (Object)Boolean.toString(isFreestyle));
            }
            if (stageNode != null && null != stageNode.getPipelineExecutionUrl()) {
                data.put(DevOpsConstants.PIPLINE_EXECUTION_URL.toString(), (Object)stageNode.getPipelineExecutionUrl());
            }
            if (stageName != null && !stageName.isEmpty()) {
                data.put(DevOpsConstants.JOB_NAME_ATTR.toString(), (Object)(jobName + DevOpsConstants.JOB_STAGE_SEPARATOR.toString() + stageName));
                data.put(DevOpsConstants.JOB_NAME_ATTR.toString(), (Object)jobName);
                data.put(DevOpsConstants.STAGENAME_ATTR.toString(), (Object)stageName);
                data.put(DevOpsConstants.JOB_URL_ATTR.toString(), (Object)this.replaceLast(jobUrl, "/", DevOpsConstants.JOB_STAGE_SEPARATOR.toString() + stageName + "/"));
            } else {
                data.put(DevOpsConstants.JOB_NAME_ATTR.toString(), (Object)jobName);
            }
            this.addStageNodeParams(stageNode, data, jobName, jobUrl, DevOpsConstants.REST_POST_METHOD);
            if (data.get(DevOpsConstants.JOB_PARENT_STAGE_EXECUTION_URL.toString()) != null && (parentStageExecutionURL = data.get(DevOpsConstants.JOB_PARENT_STAGE_EXECUTION_URL.toString()).toString()) != null) {
                jobDetails.put(DevOpsConstants.BUILD_URL_ATTR.toString(), data.get(DevOpsConstants.JOB_PARENT_STAGE_EXECUTION_URL.toString()));
            }
            data.put(DevOpsConstants.JOB_DETAILS_ATTR.toString(), (Object)jobDetails);
            if (GenericUtils.isNotEmpty(changeRequestDetails)) {
                JSONObject crAttrJSON = JSONObject.fromObject((Object)changeRequestDetails);
                data.put(DevOpsConstants.CR_ATTRS.toString(), (Object)crAttrJSON);
            }
            if (GenericUtils.isNotEmpty(applicationName) && GenericUtils.isNotEmpty(snapshotName)) {
                data.put(DevOpsConstants.CONFIG_APP_NAME.toString(), (Object)applicationName);
                data.put(DevOpsConstants.CONFIG_SNAPSHOT_NAME.toString(), (Object)snapshotName);
            }
            JSONObject response = CommUtils.callV2Support(DevOpsConstants.REST_POST_METHOD.toString(), endpointUrl, params, data.toString(), user, pwd, null, null, tokenDetails);
            result = GenericUtils.parseResponseResult(response, DevOpsConstants.COMMON_RESPONSE_CHANGE_CTRL.toString());
            if (changeResponse != null && !GenericUtils.isEmpty(message = GenericUtils.parseResponseResult(response, DevOpsConstants.COMMON_RESPONSE_MESSAGE.toString()))) {
                changeResponse.setMessage(message);
            }
        }
        catch (JSONException e) {
            this.printDebug("sendJobAndCallbackUrl", new String[]{"JSONException"}, new String[]{e.getMessage()}, Level.SEVERE);
            JSONObject errorObj = new JSONObject();
            String errorMessage = "Failed to parse changeRequestDetails json." + e.getMessage();
            errorObj.put(DevOpsConstants.COMMON_RESULT_FAILURE.toString(), (Object)errorMessage);
            result = errorObj.toString();
        }
        catch (Exception e) {
            this.printDebug("sendJobAndCallbackUrl", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
        }
        return result;
    }

    public DevOpsJobProperty getJobProperty(Job<?, ?> job) {
        this.printDebug("getJobProperty", null, null, Level.FINE);
        DevOpsJobProperty jobProperty = (DevOpsJobProperty)job.getProperty(DevOpsJobProperty.class);
        if (jobProperty == null) {
            jobProperty = new DevOpsJobProperty();
        }
        return jobProperty;
    }

    public String sendUpdateMapping(String jobUrl, String jobName, String stageName, DevOpsPipelineNode stageNode, String stepSysId, Boolean isMultiBranch, String branchName, String configurationName) {
        this.printDebug("sendUpdateMapping", null, null, Level.FINE);
        JSONObject params = new JSONObject();
        JSONObject data = new JSONObject();
        String result = null;
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntryOrDefault(configurationName);
        params.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)devopsConfig.getToolId());
        params.put(DevOpsConstants.TOOL_TYPE_ATTR.toString(), (Object)DevOpsConstants.TOOL_TYPE.toString());
        data.put(DevOpsConstants.JOB_URL_ATTR.toString(), (Object)jobUrl);
        data.put(DevOpsConstants.IS_MULTI_BRANCH_ATTR.toString(), (Object)Boolean.toString(isMultiBranch));
        data.put(DevOpsConstants.SCM_BRANCH_NAME.toString(), (Object)branchName);
        if (stageName != null && !stageName.isEmpty()) {
            data.put(DevOpsConstants.JOB_NAME_ATTR.toString(), (Object)(jobName + DevOpsConstants.JOB_STAGE_SEPARATOR.toString() + stageName));
            data.put(DevOpsConstants.JOB_URL_ATTR.toString(), (Object)this.replaceLast(jobUrl, "/", DevOpsConstants.JOB_STAGE_SEPARATOR.toString() + stageName + "/"));
        } else {
            data.put(DevOpsConstants.JOB_NAME_ATTR.toString(), (Object)jobName);
        }
        if (!GenericUtils.isEmpty(stepSysId)) {
            data.put(DevOpsConstants.STEP_SYSID_ATTR.toString(), (Object)stepSysId);
        }
        this.addStageNodeParams(stageNode, data, jobName, jobUrl, DevOpsConstants.REST_POST_METHOD);
        try {
            if (!GenericUtils.isEmptyOrDefault(devopsConfig.getSecretCredentialId())) {
                HashMap<String, String> tokenDetails = new HashMap<String, String>();
                tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), DevOpsConfigurationEntry.getTokenText(devopsConfig.getSecretCredentialId()));
                result = GenericUtils.parseResponseResult(CommUtils.callV2Support(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getMappingUrl(), params, data.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null, tokenDetails), DevOpsConstants.STEP_MAPPING_RESPONSE_ATTR.toString());
            } else {
                result = GenericUtils.parseResponseResult(CommUtils.call(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getMappingUrl(), params, data.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null), DevOpsConstants.STEP_MAPPING_RESPONSE_ATTR.toString());
            }
        }
        catch (Exception e) {
            this.printDebug("sendIsMappingValid", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
        }
        return result;
    }

    private void addStageNodeParams(DevOpsPipelineNode stageNode, JSONObject params, String jobName, String jobUrl, DevOpsConstants callMethod) {
        String stageName;
        if (stageNode != null && (stageName = stageNode.getName()) != null && !stageName.isEmpty()) {
            params.put(DevOpsConstants.JOB_PARENT_STAGE_NAME.toString(), (Object)(jobName + DevOpsConstants.JOB_STAGE_SEPARATOR.toString() + stageName));
            params.put(DevOpsConstants.JOB_PARENT_STAGE_URL.toString(), (Object)this.replaceLast(jobUrl, "/", DevOpsConstants.JOB_STAGE_SEPARATOR.toString() + stageName + "/"));
            if (callMethod.equals((Object)DevOpsConstants.REST_POST_METHOD) || callMethod.equals((Object)DevOpsConstants.REST_PUT_METHOD)) {
                params.put(DevOpsConstants.JOB_PARENT_STAGE_DATA.toString(), (Object)this.getStageNodeJSONObject(stageNode));
                String parentStageExecutionURL = stageNode.getExecutionUrl();
                if (parentStageExecutionURL != null) {
                    params.put(DevOpsConstants.JOB_PARENT_STAGE_EXECUTION_URL.toString(), (Object)(this.getJenkinsUrl() + parentStageExecutionURL + "wfapi/describe"));
                }
            }
        }
    }

    private JSONObject getStageNodeJSONObject(DevOpsPipelineNode stageNode) {
        JSONObject stageNodeJSONObj = new JSONObject();
        stageNodeJSONObj.put("id", (Object)stageNode.getId());
        stageNodeJSONObj.put("name", (Object)stageNode.getName());
        stageNodeJSONObj.put("parentId", (Object)stageNode.getParentId());
        stageNodeJSONObj.put("upstreamStageName", (Object)stageNode.getUpstreamStageName());
        stageNodeJSONObj.put("upstreamTaskExecutionURL", (Object)stageNode.getUpstreamTaskExecURL());
        return stageNodeJSONObj;
    }

    public CauseOfBlockage getWaitingBlockage(String message) {
        final String _message = message;
        return new CauseOfBlockage(){

            public String getShortDescription() {
                return _message;
            }
        };
    }

    public String registerFreestyleAndNotify(Queue.Item item, Job<?, ?> job, String token, String jobId, String jobUrl, String jobName, String jenkinsUrl, String configurationName) {
        this.printDebug("registerFreestyleAndNotify", null, null, Level.FINE);
        String result = null;
        try {
            JSONObject jobDetails = this.getJobDetailsForFreestyle(item, job, jenkinsUrl);
            int buildNumber = job.getNextBuildNumber();
            String fullName = job.getFullName();
            jobDetails.put("buildNumber", (Object)Integer.toString(buildNumber));
            jobDetails.put("fullName", (Object)fullName);
            DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntryOrDefault(configurationName);
            if (devopsConfig == null) {
                return null;
            }
            if (!GenericUtils.isEmptyOrDefault(devopsConfig.getSecretCredentialId())) {
                HashMap<String, String> tokenDetails = new HashMap<String, String>();
                tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), DevOpsConfigurationEntry.getTokenText(devopsConfig.getSecretCredentialId()));
                result = this.sendJobAndCallbackUrlV2(token, jobUrl, jobName, null, null, jenkinsUrl, devopsConfig.getChangeControlUrl(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), devopsConfig.getToolId(), jobDetails, GenericUtils.isMultiBranch(job), null, this.getJobProperty(job).getChangeRequestDetails(), null, null, null, tokenDetails, true);
            } else {
                result = this.sendJobAndCallbackUrl(token, jobUrl, jobName, null, null, jenkinsUrl, devopsConfig.getChangeControlUrl(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), devopsConfig.getToolId(), jobDetails, GenericUtils.isMultiBranch(job), null, this.getJobProperty(job).getChangeRequestDetails(), null, null, null, true);
            }
            if (result != null && result.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_VALUE_TRUE.toString())) {
                DevOpsRootAction.registerWebhook(token, jobId);
                DevOpsRootAction.registerJob(jobId, token);
            }
        }
        catch (Exception e) {
            this.printDebug("registerAndFreestyleNotify", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
        }
        return result;
    }

    public JSONObject getJobDetailsForFreestyle(Queue.Item item, Job<?, ?> controlledJob, String jenkinsUrl) throws InterruptedException {
        this.printDebug("getJobDetailsForFreestyle", null, null, Level.FINE);
        List causes = item.getCauses();
        return this._getJobDetails(causes, controlledJob, jenkinsUrl);
    }

    public JSONObject getJobDetailsForPipeline(Run<?, ?> run, Job<?, ?> controlledJob, String jenkinsUrl, DevOpsPipelineNode devOpsPipelineNode) throws InterruptedException {
        this.printDebug("getJobDetailsForPipeline", null, null, Level.FINE);
        JSONObject json = new JSONObject();
        if (run != null) {
            if (devOpsPipelineNode != null) {
                String upstreamTaskExecutionURL = devOpsPipelineNode.getUpstreamTaskExecURL();
                if (StringUtils.isEmpty((CharSequence)upstreamTaskExecutionURL)) {
                    json.put(DevOpsConstants.MESSAGE_ATTR.toString(), (Object)("Started by " + upstreamTaskExecutionURL));
                    json.put(DevOpsConstants.TRIGGER_TYPE_ATTR.toString(), (Object)"upstream");
                    json.put(DevOpsConstants.UPSTREAM_BUILD_URL_ATTR.toString(), (Object)upstreamTaskExecutionURL);
                } else {
                    List causes = run.getCauses();
                    json = this._getJobDetails(causes, controlledJob, jenkinsUrl);
                }
            } else {
                List causes = run.getCauses();
                json = this._getJobDetails(causes, controlledJob, jenkinsUrl);
            }
        }
        return json;
    }

    private JSONObject _getJobDetails(List<Cause> causes, Job<?, ?> job, String jenkinsUrl) {
        this.printDebug("_getJobDetails", null, null, Level.FINE);
        JSONObject json = new JSONObject();
        block2: for (Cause cause : causes) {
            json.put(DevOpsConstants.MESSAGE_ATTR.toString(), (Object)cause.getShortDescription());
            if (cause instanceof Cause.UserIdCause) {
                String lastBuildUrl;
                Matcher m;
                Cause.UserIdCause userCause = (Cause.UserIdCause)cause;
                json.put(DevOpsConstants.TRIGGER_TYPE_ATTR.toString(), (Object)"user");
                json.put(DevOpsConstants.USERNAME_ATTR.toString(), (Object)userCause.getUserName());
                json.put(DevOpsConstants.LAST_BUILD_URL_ATTR.toString(), (Object)"");
                Run lastRun = job.getLastBuild();
                if (lastRun != null && (m = this.urlPatt.matcher(lastBuildUrl = jenkinsUrl + lastRun.getUrl())).matches()) {
                    json.put(DevOpsConstants.LAST_BUILD_URL_ATTR.toString(), (Object)lastBuildUrl);
                }
                this.printDebug("_getJobDetails", new String[]{"cause is UserIdCause"}, new String[]{userCause.getShortDescription()}, Level.FINE);
                break;
            }
            if (cause instanceof Cause.UpstreamCause) {
                Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)cause;
                json.put(DevOpsConstants.TRIGGER_TYPE_ATTR.toString(), (Object)"upstream");
                String upstreamBuildUrl = jenkinsUrl + upstreamCause.getUpstreamUrl() + upstreamCause.getUpstreamBuild() + "/";
                Matcher m = this.urlPatt.matcher(upstreamBuildUrl);
                if (m.matches()) {
                    json.put(DevOpsConstants.UPSTREAM_BUILD_URL_ATTR.toString(), (Object)upstreamBuildUrl);
                }
                this.printDebug("_getJobDetails", new String[]{"cause is UpstreamCause"}, new String[]{upstreamCause.getShortDescription()}, Level.FINE);
                break;
            }
            if (cause instanceof SCMTrigger.SCMTriggerCause) {
                File log;
                SCMTrigger.SCMTriggerCause scmCause = (SCMTrigger.SCMTriggerCause)cause;
                this.printDebug("_getJobDetails", new String[]{"cause is SCMTriggerCause"}, new String[]{scmCause.getShortDescription()}, Level.FINE);
                json.put(DevOpsConstants.TRIGGER_TYPE_ATTR.toString(), (Object)"scm");
                SCMTriggerItem tItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(job);
                if (tItem == null) break;
                SCMTrigger trigger = tItem.getSCMTrigger();
                if (trigger != null && (log = trigger.getLogFile()) != null && log.canRead()) {
                    try {
                        String fContent = Util.loadFile((File)log);
                        json.put(DevOpsConstants.SCM_LOG_ATTR.toString(), (Object)fContent);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                Collection scms = tItem.getSCMs();
                for (SCM scm : scms) {
                    if (!scm.getClass().getName().equals(DevOpsConstants.GIT_PLUGIN_SCM_CLASS.toString())) continue;
                    json.put(DevOpsConstants.SCM_TYPE_ATTR.toString(), (Object)"git");
                    JSONObject scmChanges = new JSONObject();
                    json.put(DevOpsConstants.SCM_CHANGES_ATTR.toString(), (Object)scmChanges);
                    break block2;
                }
                break;
            }
            this.printDebug("_getJobDetails", new String[]{"cause is " + cause.getClass().getSimpleName()}, new String[]{cause.getShortDescription()}, Level.FINE);
            json.put(DevOpsConstants.TRIGGER_TYPE_ATTR.toString(), (Object)"default");
        }
        return json;
    }

    public String registerPipelineAndNotify(Run<?, ?> run, Job<?, ?> controlledJob, String token, String jobUrl, String jobName, String stageId, String jenkinsUrl, DevOpsPipelineChangeStepExecution stepExecution, PipelineChangeResponse changeResponse, DevOpsConfigurationEntry devopsConfig) {
        String result = null;
        try {
            this.printDebug("registerPipelineAndNotify", new String[]{"configurationName"}, new String[]{devopsConfig.getName()}, Level.FINE);
            DevOpsPipelineNode stageNode = this.getStageNodeById(run, stageId);
            JSONObject jobDetails = this.getJobDetailsForPipeline(run, controlledJob, jenkinsUrl, stageNode);
            int buildNumber = run.getNumber();
            String fullName = controlledJob.getFullName();
            jobDetails.put("buildNumber", (Object)Integer.toString(buildNumber));
            jobDetails.put("fullName", (Object)fullName);
            StepContext ctx = stepExecution.getContext();
            EnvVars vars = null;
            try {
                vars = (EnvVars)ctx.get(EnvVars.class);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            String changeRequestDetails = stepExecution.getStep().getChangeRequestDetails();
            if (GenericUtils.isNotEmpty(changeRequestDetails) && vars != null) {
                changeRequestDetails = vars.expand(changeRequestDetails);
            }
            String applicationName = stepExecution.getStep().getApplicationName();
            String snapshotName = stepExecution.getStep().getSnapshotName();
            String buildUrl = DevOpsPipelineGraph.getStageExecutionUrl(stageNode.getPipelineExecutionUrl(), stageNode.getId());
            jobDetails.put(DevOpsConstants.BUILD_URL_ATTR.toString(), (Object)buildUrl);
            try {
                DevOpsRunStatusAction runStatusAction = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class);
                if (runStatusAction != null && runStatusAction.getModel() != null && runStatusAction.getModel().getSCMModel() != null && GenericUtils.isNotEmpty(runStatusAction.getModel().getSCMModel().getUrl())) {
                    jobDetails.put(DevOpsConstants.REPOSITORY_URL_ATTR.toString(), (Object)runStatusAction.getModel().getSCMModel().getUrl());
                }
            }
            catch (Exception e) {
                this.printDebug("registerPipelineAndNotify", new String[]{"Error getting repository URL"}, new String[]{e.getMessage()}, Level.FINE);
            }
            if (!GenericUtils.isEmptyOrDefault(devopsConfig.getSecretCredentialId())) {
                HashMap<String, String> tokenDetails = new HashMap<String, String>();
                tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), DevOpsConfigurationEntry.getTokenText(devopsConfig.getSecretCredentialId()));
                result = this.sendJobAndCallbackUrlV2(token, jobUrl, jobName, stageNode.getName(), stageNode, jenkinsUrl, devopsConfig.getChangeControlUrl(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), devopsConfig.getToolId(), jobDetails, GenericUtils.isMultiBranch(controlledJob), vars != null ? (String)vars.get((Object)"BRANCH_NAME") : null, changeRequestDetails, changeResponse, applicationName, snapshotName, tokenDetails, false);
            } else {
                result = this.sendJobAndCallbackUrl(token, jobUrl, jobName, stageNode.getName(), stageNode, jenkinsUrl, devopsConfig.getChangeControlUrl(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), devopsConfig.getToolId(), jobDetails, GenericUtils.isMultiBranch(controlledJob), vars != null ? (String)vars.get((Object)"BRANCH_NAME") : null, changeRequestDetails, changeResponse, applicationName, snapshotName, false);
            }
            if (null != result && !result.contains(DevOpsConstants.COMMON_RESULT_FAILURE.toString())) {
                if (result.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_VALUE_TRUE.toString())) {
                    stepExecution.setToken(token);
                    DevOpsRootAction.registerPipelineWebhook(stepExecution);
                }
            } else {
                String cause = "";
                if (null != result) {
                    cause = "Cause: " + result;
                }
                this.printDebug("registerPipelineAndNotify", new String[]{"message"}, new String[]{"Register change control failed. Response from sendJobAndCallbackUrl(): " + cause}, Level.FINE);
            }
        }
        catch (InterruptedException e) {
            this.printDebug("registerPipelineAndNotify", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
        }
        return result;
    }

    public PipelineChangeResponse handlePipeline(Run<?, ?> run, Job<?, ?> controlledJob, DevOpsPipelineChangeStepExecution stepExecution, TaskListener listener, DevOpsPipelineInfoConfig pipelineInfoConfig) {
        this.printDebug("handlePipeline", null, null, Level.FINE);
        PipelineChangeResponse changeResponse = new PipelineChangeResponse();
        if (run != null && controlledJob != null) {
            String jobUrl = controlledJob.getAbsoluteUrl();
            String jobName = controlledJob.getName();
            String jenkinsUrl = this.getJenkinsUrl();
            DevOpsPipelineGraph graph = ((DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class)).getPipelineGraph();
            if (jobUrl != null && jenkinsUrl != null && jobName != null && pipelineInfoConfig != null) {
                String _result;
                String stageId = DevOpsRunListener.DevOpsStageListener.getCurrentStageId(stepExecution.getContext(), graph);
                DevOpsPipelineNode stageNode = this.getStageNodeById(run, stageId);
                this.printDebug("handlePipeline", new String[]{"message", "jobUrl", "jobName"}, new String[]{"Job is under change control", jobUrl, jobName}, Level.FINE);
                String token = this.getNewToken(controlledJob.getPronoun());
                this.printDebug("handlePipeline", new String[]{"token"}, new String[]{token}, Level.FINE);
                listener.getLogger().println("[ServiceNow DevOps] Going to register callback hook with token: " + token);
                DevOpsRunStatusAction runStatusAction = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class);
                if (runStatusAction != null && runStatusAction.getModel() != null && runStatusAction.getModel().getSCMModel() != null && GenericUtils.isNotEmpty(runStatusAction.getModel().getSCMModel().getUrl())) {
                    listener.getLogger().println("[ServiceNow DevOps] Found repository URL: " + runStatusAction.getModel().getSCMModel().getUrl());
                }
                if ((_result = this.registerPipelineAndNotify(run, controlledJob, token, jobUrl, jobName, stageNode.getId(), jenkinsUrl, stepExecution, changeResponse, pipelineInfoConfig.getDevopsConfig())) != null) {
                    if (_result.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_VALUE_TRUE.toString())) {
                        this.printDebug("handlePipeline", new String[]{"message", "token"}, new String[]{"Job registered", token}, Level.FINE);
                        changeResponse.setAction(PipelineChangeAction.WAIT);
                        listener.getLogger().println("[ServiceNow DevOps] register callback hook successful with token: " + token);
                    } else {
                        this.printDebug("handlePipeline", new String[]{"message"}, new String[]{"Something went wrong when registering the job"}, Level.WARNING);
                        changeResponse.setAction(PipelineChangeAction.ABORT);
                        changeResponse.setErrorMessage(_result);
                    }
                } else {
                    this.printDebug("handlePipeline", new String[]{"message"}, new String[]{"Something went wrong when calling SN to register the job"}, Level.WARNING);
                    changeResponse.setAction(PipelineChangeAction.ABORT);
                }
            }
        }
        return changeResponse;
    }

    public String getCommFailureResult() {
        this.printDebug("getCommFailureResult", null, null, Level.FINE);
        JSONObject result = new JSONObject();
        result.put(DevOpsConstants.CALLBACK_RESULT_ATTR.toString(), (Object)DevOpsConstants.CALLBACK_RESULT_COMM_FAILURE.toString());
        return result.toString();
    }

    public String getAbortResult() {
        this.printDebug("getAbortResult", null, null, Level.FINE);
        JSONObject result = new JSONObject();
        result.put(DevOpsConstants.CALLBACK_CANCELED_ATTR.toString(), (Object)"true");
        return result.toString();
    }

    public void setAbortResultForFreestyle(String jobId, String _result) {
        String result;
        this.printDebug("setAbortResultForFreestyle", new String[]{"jobId"}, new String[]{jobId}, Level.FINE);
        String string = result = GenericUtils.isEmpty(_result) ? this.getAbortResult() : _result;
        if (jobId != null) {
            DevOpsRootAction.setCallbackContent(jobId, result);
        }
    }

    public void setAbortResultForFreestyle(String jobId) {
        this.printDebug("setAbortResultForFreestyle", new String[]{"jobId"}, new String[]{jobId}, Level.FINE);
        if (jobId != null) {
            DevOpsRootAction.setCallbackContent(jobId, this.getAbortResult());
        }
    }

    private void cancelItem(Queue.Item item) {
        this.printDebug("cancelItem", null, null, Level.FINE);
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            jenkins.getQueue().cancel(item);
        }
    }

    public CauseOfBlockage handleFreestyle(Queue.Item item, Job<?, ?> job) {
        this.printDebug("handleFreestyle", null, null, Level.FINE);
        if (item != null && job != null) {
            String jobId = this.getJobId(item, job);
            this.printDebug("handleFreestyle", new String[]{"callback result -> jobId "}, new String[]{jobId}, Level.INFO);
            String result = this.getCallbackResult(jobId);
            if (result != null) {
                this.printDebug("handleFreestyle", new String[]{"callback result"}, new String[]{result}, Level.INFO);
                return null;
            }
            this.printDebug("handleFreestyle", new String[]{"callback result in else case"}, new String[]{"null"}, Level.INFO);
            String changeRequestContent = this.getChangeRequestContent(jobId);
            this.printDebug("handleFreestyle", new String[]{"changeRequestContent"}, new String[]{changeRequestContent}, Level.INFO);
            if (changeRequestContent != null) {
                String changeRequestId = this.getChangeRequestInfo(changeRequestContent);
                this.printDebug("handleFreestyle", new String[]{"changeRequestId"}, new String[]{changeRequestId}, Level.INFO);
                if (!GenericUtils.isEmpty(changeRequestId)) {
                    String changeComments = this.getChangeComments(changeRequestContent);
                    if (!GenericUtils.isEmpty(changeComments)) {
                        return this.getWaitingBlockage("Job is waiting for approval on change request: " + changeRequestId + " Change details: " + changeComments);
                    }
                    return this.getWaitingBlockage("Job is waiting for approval on change request: " + changeRequestId);
                }
            }
            String jobUrl = job.getAbsoluteUrl();
            String jobName = job.getName();
            String jenkinsUrl = this.getJenkinsUrl();
            if (jobUrl != null && jenkinsUrl != null && jobName != null && jobId != null) {
                String token = this.getToken(jobId);
                if (token != null) {
                    this.printDebug("handleFreestyle", new String[]{"message", "token"}, new String[]{"Job already registered, waiting for callback", token}, Level.FINE);
                    if (this.isWaiting(token)) {
                        return this.getWaitingBlockage("Job is waiting for approval");
                    }
                } else {
                    this.printDebug("handleFreestyle", new String[]{"message", "token"}, new String[]{"Job not registered", "null"}, Level.FINE);
                    DevOpsPipelineInfo pipelineInfo = this.checkIsTracking(item);
                    if (pipelineInfo != null) {
                        String configurationName = this.getJobProperty(job).getConfigurationName();
                        String _result = this.sendIsUnderChgControl(jobUrl, jobName, null, null, GenericUtils.isMultiBranch(job), null, configurationName);
                        if (_result != null) {
                            if (_result.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_VALUE_TRUE.toString())) {
                                this.printDebug("handleFreestyle", new String[]{"message", "jobUrl", "jobName"}, new String[]{"Job is under change control", jobUrl, jobName}, Level.FINE);
                                token = this.getNewToken(job.getPronoun());
                                this.printDebug("handleFreestyle", new String[]{"token"}, new String[]{token}, Level.FINE);
                                _result = this.registerFreestyleAndNotify(item, job, token, jobId, jobUrl, jobName, jenkinsUrl, configurationName);
                                if (_result != null) {
                                    if (_result.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_VALUE_TRUE.toString())) {
                                        this.printDebug("handleFreestyle", new String[]{"message", "token"}, new String[]{"Job registered", token}, Level.FINE);
                                        return this.getWaitingBlockage("Job is waiting for approval");
                                    }
                                    this.printDebug("handleFreestyle", new String[]{"message", "_result"}, new String[]{"Something went wrong when registering the job", _result}, Level.WARNING);
                                    if (GenericUtils.isNotEmpty(_result) && _result.contains(DevOpsConstants.COMMON_RESULT_FAILURE.toString())) {
                                        this.setAbortResultForFreestyle(jobId, _result);
                                    } else {
                                        this.setAbortResultForFreestyle(jobId);
                                    }
                                } else {
                                    this.printDebug("handleFreestyle", new String[]{"message"}, new String[]{"Something went wrong when calling SN to register the job"}, Level.WARNING);
                                    this.setAbortResultForFreestyle(jobId);
                                }
                            } else if (_result.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_VALUE_FALSE.toString())) {
                                this.printDebug("handleFreestyle", new String[]{"message", "jobUrl"}, new String[]{"Job is not under change control", jobUrl}, Level.FINE);
                            } else if (_result.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_VALUE_UNKNOWN.toString())) {
                                this.printDebug("handleFreestyle", new String[]{"message"}, new String[]{"Job is not associated with any step"}, Level.FINE);
                                this.setAbortResultForFreestyle(jobId);
                            }
                        } else {
                            this.printDebug("handleFreestyle", new String[]{"message"}, new String[]{"Something went wrong when checking if job is under change control"}, Level.WARNING);
                            this.setAbortResultForFreestyle(jobId);
                        }
                    }
                }
            }
        }
        return null;
    }

    public boolean handleStepMapping(Run<?, ?> run, Job<?, ?> controlledJob, DevOpsPipelineMapStepExecution devOpsPipelineMapStepExecution, EnvVars vars) {
        boolean result = false;
        if (devOpsPipelineMapStepExecution == null) {
            return result;
        }
        DevOpsPipelineMapStep devOpsPipelineMapStep = devOpsPipelineMapStepExecution.getStep();
        if (devOpsPipelineMapStep == null) {
            return result;
        }
        String stepSysId = devOpsPipelineMapStep.getStepSysId();
        this.printDebug("handleStepMapping", new String[]{"stepSysId --"}, new String[]{stepSysId}, Level.FINE);
        if (run != null && controlledJob != null) {
            String jobUrl = controlledJob.getAbsoluteUrl();
            String jobName = controlledJob.getName();
            String jenkinsUrl = this.getJenkinsUrl();
            DevOpsPipelineGraph graph = ((DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class)).getPipelineGraph();
            if (jobUrl != null && jenkinsUrl != null && jobName != null) {
                String stageId = DevOpsRunListener.DevOpsStageListener.getCurrentStageId(devOpsPipelineMapStepExecution.getContext(), graph);
                DevOpsPipelineNode stageNode = this.getStageNodeById(run, stageId);
                if (this.isStepAssociated(run, stageNode.getId())) {
                    this.associateStepToNode(run, stageNode.getId());
                    this.printDebug("handleStepMapping", new String[]{"message"}, new String[]{"Step has been associated already"}, Level.FINE);
                    return true;
                }
                String _result = this.sendUpdateMapping(jobUrl, jobName, stageNode.getName(), stageNode, stepSysId, GenericUtils.isMultiBranch(controlledJob), vars != null ? (String)vars.get((Object)"BRANCH_NAME") : null, devOpsPipelineMapStepExecution.getStep().getConfigurationName());
                if (null != _result && !_result.contains(DevOpsConstants.COMMON_RESULT_FAILURE.toString())) {
                    if (_result.equalsIgnoreCase(DevOpsConstants.COMMON_RESPONSE_VALUE_TRUE.toString())) {
                        result = true;
                        this.associateStepToNode(run, stageNode.getName());
                        this.printDebug("handleStepMapping", new String[]{"message"}, new String[]{"Step associated successfully"}, Level.FINE);
                    } else {
                        this.printDebug("handleStepMapping", new String[]{"message"}, new String[]{"Step could not be associated - invalid"}, Level.WARNING);
                    }
                } else {
                    String cause = "";
                    if (null != _result) {
                        cause = "Cause: " + _result;
                    }
                    this.printDebug("handleStepMapping", new String[]{"message"}, new String[]{"Something when wrong when calling SN to associate the step. Reason: " + cause}, Level.WARNING);
                }
            }
        }
        return result;
    }

    public DevOpsPipelineNode getStageNodeByName(Run<?, ?> run, String stageName) {
        DevOpsRunStatusAction action;
        this.printDebug("getStageNodeByName", null, null, Level.FINE);
        if (run != null && (action = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class)) != null) {
            return action.getPipelineGraph().getNodeByName(stageName);
        }
        return null;
    }

    public DevOpsPipelineNode getStageNodeById(Run<?, ?> run, String stageId) {
        DevOpsRunStatusAction action;
        this.printDebug("getStageNodeByName", null, null, Level.FINE);
        if (run != null && (action = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class)) != null) {
            return action.getPipelineGraph().getNodeById(stageId);
        }
        return null;
    }

    private boolean isStepAssociated(Run<?, ?> run, String stageId) {
        DevOpsRunStatusAction action = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class);
        if (action != null) {
            return action.getPipelineGraph().isStepAssociated(stageId);
        }
        return false;
    }

    public void associateStepToNode(Run<?, ?> run, String stageName) {
        DevOpsRunStatusAction action;
        if (null != run && null != stageName && (action = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class)) != null) {
            action.getPipelineGraph().addStepToNode(stageName);
        }
    }

    public boolean isChangeStepInProgress(Run<?, ?> run, String stageId) {
        DevOpsPipelineNode currentNode = this.getStageNodeById(run, stageId);
        if (null != currentNode) {
            return currentNode.isChangeCtrlInProgress();
        }
        return false;
    }

    public void markChangeStepToProgress(Run<?, ?> run, String stageId) {
        DevOpsPipelineNode currentNode = this.getStageNodeById(run, stageId);
        if (null != currentNode) {
            currentNode.setChangeCtrlInProgress(true);
        }
    }

    public String handleArtifactRegistration(StepContext stepContext, Run<?, ?> run, TaskListener listener, String artifactPayload, EnvVars vars, String configurationName) {
        DevOpsRunStatusAction action;
        String result = null;
        this.printDebug("handleArtifactRegistration", new String[]{"artifactPayload --"}, new String[]{artifactPayload}, Level.FINE);
        String buildNumber = null;
        String stageName = null;
        String branchName = null;
        String jobUrl = null;
        String jobName = null;
        if (run != null && (action = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class)) != null) {
            stageName = DevOpsRunListener.DevOpsStageListener.getCurrentStageName(stepContext, action.getPipelineGraph());
        }
        if (vars != null) {
            jobName = (String)vars.get((Object)"JOB_NAME");
            buildNumber = (String)vars.get((Object)"BUILD_NUMBER");
            if (GenericUtils.isNotEmpty((CharSequence)vars.get((Object)"GIT_BRANCH"))) {
                branchName = (String)vars.get((Object)"GIT_BRANCH");
            } else if (GenericUtils.isNotEmpty((CharSequence)vars.get((Object)"BRANCH_NAME"))) {
                branchName = (String)vars.get((Object)"BRANCH_NAME");
            }
        } else {
            return result;
        }
        jobUrl = (String)vars.get((Object)"JOB_URL");
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntryOrDefault(configurationName);
        result = this.registerArtifact(listener, artifactPayload, jobName, jobUrl, buildNumber, stageName, branchName, GenericUtils.isFreeStyleProject(run), devopsConfig);
        return result;
    }

    public String registerArtifact(TaskListener listener, String artifactsPayload, String jobName, String jobUrl, String buildNumber, String stageName, String branchName, boolean isFreeStyle, DevOpsConfigurationEntry devopsConfig) {
        this.printDebug("registerArtifact", null, null, Level.FINE);
        JSONObject queryParams = new JSONObject();
        JSONObject payload = new JSONObject();
        String result = null;
        try {
            if (devopsConfig.getSnArtifactToolId() != null && devopsConfig.getSnArtifactToolId().length() > 0) {
                queryParams.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)devopsConfig.getSnArtifactToolId());
            }
            queryParams.put(DevOpsConstants.ORCHESTRATION_TOOL_ID_ATTR.toString(), (Object)devopsConfig.getToolId());
            JSONObject artifactsPayloadJSON = JSONObject.fromObject((Object)artifactsPayload);
            if (artifactsPayloadJSON.containsKey((Object)DevOpsConstants.ARTIFACT_ARTIFACTS_ATTR.toString())) {
                JSONArray artifactsJSONArray = artifactsPayloadJSON.getJSONArray(DevOpsConstants.ARTIFACT_ARTIFACTS_ATTR.toString());
                payload.put(DevOpsConstants.ARTIFACT_ARTIFACTS_ATTR.toString(), (Object)artifactsJSONArray);
            }
            if (artifactsPayloadJSON.containsKey((Object)DevOpsConstants.ARTIFACT_STAGE_NAME.toString())) {
                stageName = artifactsPayloadJSON.getString(DevOpsConstants.ARTIFACT_STAGE_NAME.toString());
            }
            if (artifactsPayloadJSON.containsKey((Object)DevOpsConstants.ARTIFACT_BRANCH_NAME.toString())) {
                branchName = artifactsPayloadJSON.getString(DevOpsConstants.ARTIFACT_BRANCH_NAME.toString());
            }
            if (artifactsPayloadJSON.containsKey((Object)DevOpsConstants.ARTIFACT_TASK_EXEC_NUM.toString())) {
                buildNumber = artifactsPayloadJSON.getString(DevOpsConstants.ARTIFACT_TASK_EXEC_NUM.toString());
            }
            if (isFreeStyle) {
                payload.put(DevOpsConstants.ARTIFACT_PROJECT_NAME.toString(), (Object)jobName);
            } else {
                payload.put(DevOpsConstants.ARTIFACT_PIPELINE_NAME.toString(), (Object)jobName);
            }
            if (null != buildNumber) {
                payload.put(DevOpsConstants.ARTIFACT_TASK_EXEC_NUM.toString(), (Object)buildNumber);
            }
            if (null != stageName) {
                payload.put(DevOpsConstants.ARTIFACT_STAGE_NAME.toString(), (Object)stageName);
            }
            if (null != branchName) {
                payload.put(DevOpsConstants.ARTIFACT_BRANCH_NAME.toString(), (Object)branchName);
            }
            this.printDebug("registerArtifact", new String[]{"message"}, new String[]{"Payload: " + payload.toString()}, Level.FINE);
            GenericUtils.printConsoleLog(listener, "Register artifact payload: " + payload.toString());
            JSONObject response = null;
            if (!GenericUtils.isEmptyOrDefault(devopsConfig.getSecretCredentialId())) {
                HashMap<String, String> tokenDetails = new HashMap<String, String>();
                tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), DevOpsConfigurationEntry.getTokenText(devopsConfig.getSecretCredentialId()));
                response = CommUtils.callV2Support(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getArtifactRegistrationUrl(), queryParams, payload.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null, tokenDetails);
            } else {
                response = CommUtils.call(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getArtifactRegistrationUrl(), queryParams, payload.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
            }
            if (null != response) {
                GenericUtils.printConsoleLog(listener, "Register artifact on URL " + devopsConfig.getArtifactRegistrationUrl() + " responded with : " + response.toString());
                result = GenericUtils.parseResponseResult(response, DevOpsConstants.ARTIFACT_REGISTER_STATUS_ATTR.toString());
                this.logResponseStatus(listener, response);
                this.logLinkAndDescription(listener, result);
            }
        }
        catch (Exception e) {
            this.printDebug("registerArtifact", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
            GenericUtils.printConsoleLog(listener, "Register artifact request could not be sent due to the exception: " + e.getMessage());
        }
        return result;
    }

    public String handleArtifactCreatePackage(StepContext stepContext, Run<?, ?> run, TaskListener listener, String packageName, String payload, EnvVars vars, String configurationName) {
        String result = null;
        this.printDebug("handleArtifactCreatePackage", new String[]{"packageName --"}, new String[]{packageName}, Level.FINE);
        if (run != null) {
            String buildNumber = null;
            String stageName = null;
            String branchName = null;
            String jobUrl = null;
            String jobName = null;
            DevOpsRunStatusAction action = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class);
            if (action != null) {
                stageName = DevOpsRunListener.DevOpsStageListener.getCurrentStageName(stepContext, action.getPipelineGraph());
            }
            if (vars != null) {
                jobName = (String)vars.get((Object)"JOB_NAME");
                buildNumber = (String)vars.get((Object)"BUILD_NUMBER");
                if (GenericUtils.isNotEmpty((CharSequence)vars.get((Object)"GIT_BRANCH"))) {
                    branchName = (String)vars.get((Object)"GIT_BRANCH");
                } else if (GenericUtils.isNotEmpty((CharSequence)vars.get((Object)"BRANCH_NAME"))) {
                    branchName = (String)vars.get((Object)"BRANCH_NAME");
                }
            } else {
                return result;
            }
            jobUrl = (String)vars.get((Object)"JOB_URL");
            DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntryOrDefault(configurationName);
            result = this.createArtifactPackage(listener, packageName, payload, jobName, jobUrl, buildNumber, stageName, branchName, GenericUtils.isFreeStyleProject(run), devopsConfig);
        }
        return result;
    }

    public String createArtifactPackage(TaskListener listener, String artifactName, String artifactsPayload, String jobName, String jobUrl, String buildNumber, String stageName, String branchName, boolean isFreeStyle, DevOpsConfigurationEntry devopsConfig) {
        this.printDebug("createArtifactPackage", null, null, Level.FINE);
        JSONObject queryParams = new JSONObject();
        JSONObject payload = new JSONObject();
        ArrayList<JSONObject> artifactsList = new ArrayList<JSONObject>();
        String result = null;
        try {
            if (devopsConfig.getSnArtifactToolId() != null && devopsConfig.getSnArtifactToolId().length() > 0) {
                queryParams.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)devopsConfig.getSnArtifactToolId());
            }
            queryParams.put(DevOpsConstants.ORCHESTRATION_TOOL_ID_ATTR.toString(), (Object)devopsConfig.getToolId());
            payload.put(DevOpsConstants.ARTIFACT_NAME_ATTR.toString(), (Object)artifactName);
            JSONObject artifactsPayloadJSON = JSONObject.fromObject((Object)artifactsPayload);
            if (artifactsPayloadJSON.containsKey((Object)DevOpsConstants.ARTIFACT_ARTIFACTS_ATTR.toString())) {
                JSONArray artifactsJSONArray = artifactsPayloadJSON.getJSONArray(DevOpsConstants.ARTIFACT_ARTIFACTS_ATTR.toString());
                for (Object artifactObj : artifactsJSONArray) {
                    JSONObject artifactJSON = (JSONObject)artifactObj;
                    if (artifactJSON.containsKey((Object)DevOpsConstants.ARTIFACT_CURRENT_BUILD_INFO.toString()) && artifactJSON.getString(DevOpsConstants.ARTIFACT_CURRENT_BUILD_INFO.toString()).equals(DevOpsConstants.COMMON_RESPONSE_VALUE_TRUE.toString())) {
                        artifactJSON.remove(DevOpsConstants.ARTIFACT_CURRENT_BUILD_INFO.toString());
                        artifactJSON = this.addBuildDetails(artifactJSON, jobName, buildNumber, stageName, branchName);
                    }
                    artifactsList.add(artifactJSON);
                }
                payload.put(DevOpsConstants.ARTIFACT_ARTIFACTS_ATTR.toString(), artifactsList);
            }
            if (artifactsPayloadJSON.containsKey((Object)DevOpsConstants.ARTIFACT_STAGE_NAME.toString())) {
                stageName = artifactsPayloadJSON.getString(DevOpsConstants.ARTIFACT_STAGE_NAME.toString());
            }
            if (artifactsPayloadJSON.containsKey((Object)DevOpsConstants.ARTIFACT_BRANCH_NAME.toString())) {
                branchName = artifactsPayloadJSON.getString(DevOpsConstants.ARTIFACT_BRANCH_NAME.toString());
            }
            if (artifactsPayloadJSON.containsKey((Object)DevOpsConstants.ARTIFACT_TASK_EXEC_NUM.toString())) {
                buildNumber = artifactsPayloadJSON.getString(DevOpsConstants.ARTIFACT_TASK_EXEC_NUM.toString());
            }
            if (isFreeStyle) {
                payload.put(DevOpsConstants.ARTIFACT_PROJECT_NAME.toString(), (Object)jobName);
            } else {
                payload.put(DevOpsConstants.ARTIFACT_PIPELINE_NAME.toString(), (Object)jobName);
            }
            if (null != buildNumber) {
                payload.put(DevOpsConstants.ARTIFACT_TASK_EXEC_NUM.toString(), (Object)buildNumber);
            }
            if (null != stageName) {
                payload.put(DevOpsConstants.ARTIFACT_STAGE_NAME.toString(), (Object)stageName);
            }
            if (null != branchName) {
                payload.put(DevOpsConstants.ARTIFACT_BRANCH_NAME.toString(), (Object)branchName);
            }
            this.printDebug("createArtifactPackage", new String[]{"message"}, new String[]{"Payload: " + payload.toString()}, Level.FINE);
            GenericUtils.printConsoleLog(listener, "Create Artifact package payload: " + payload.toString());
            JSONObject response = null;
            if (!GenericUtils.isEmptyOrDefault(devopsConfig.getSecretCredentialId())) {
                HashMap<String, String> tokenDetails = new HashMap<String, String>();
                tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), DevOpsConfigurationEntry.getTokenText(devopsConfig.getSecretCredentialId()));
                response = CommUtils.callV2Support(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getArtifactCreatePackageUrl(), queryParams, payload.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null, tokenDetails);
            } else {
                response = CommUtils.call(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getArtifactCreatePackageUrl(), queryParams, payload.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
            }
            if (response != null) {
                GenericUtils.printConsoleLog(listener, "Create artifact package on URL " + devopsConfig.getArtifactCreatePackageUrl() + " responded with : " + response.toString());
                result = GenericUtils.parseResponseResult(response, DevOpsConstants.ARTIFACT_REGISTER_STATUS_ATTR.toString());
                this.logResponseStatus(listener, response);
                this.logLinkAndDescription(listener, result);
            }
        }
        catch (Exception e) {
            this.printDebug("createArtifactPackage", new String[]{"exception"}, new String[]{e.getMessage()}, Level.SEVERE);
            GenericUtils.printConsoleLog(listener, "Create Artifact package request could not be sent due to the exception: " + e.getMessage());
        }
        return result;
    }

    public JSONObject addBuildDetails(JSONObject artifactJSON, String jobName, String buildNumber, String stageName, String branchName) {
        if (null == artifactJSON.get(DevOpsConstants.ARTIFACT_PIPELINE_NAME.toString())) {
            artifactJSON.put(DevOpsConstants.ARTIFACT_PIPELINE_NAME.toString(), (Object)jobName);
        }
        if (null == artifactJSON.get(DevOpsConstants.ARTIFACT_TASK_EXEC_NUM.toString())) {
            artifactJSON.put(DevOpsConstants.ARTIFACT_TASK_EXEC_NUM.toString(), (Object)buildNumber);
        }
        if (null == artifactJSON.get(DevOpsConstants.ARTIFACT_STAGE_NAME.toString()) && null != stageName) {
            artifactJSON.put(DevOpsConstants.ARTIFACT_STAGE_NAME.toString(), (Object)stageName);
        }
        if (null == artifactJSON.get(DevOpsConstants.ARTIFACT_BRANCH_NAME.toString())) {
            artifactJSON.put(DevOpsConstants.ARTIFACT_BRANCH_NAME.toString(), (Object)branchName);
        }
        return artifactJSON;
    }

    public JSONObject createChangeset(String applicationName, TaskListener listener) {
        JSONObject queryParams = new JSONObject();
        JSONObject filePayloadJSON = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        queryParams.put(DevOpsConstants.CONFIG_APPLICATION_NAME.toString(), (Object)applicationName);
        JSONObject response = CommUtils.call(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getCDMChangeSetCreationURL(), queryParams, filePayloadJSON.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    public JSONObject uploadData(String applicationName, String changesetNumber, String dataFormat, String path, boolean autoCommit, boolean autoDelete, boolean autoValidate, String fileContent, String target, String deployableName, String collectionName, boolean autoPublish, String transactionSource) {
        JSONObject queryParams = new JSONObject();
        queryParams.put(DevOpsConstants.CONFIG_APPLICATION_NAME.toString(), (Object)applicationName);
        queryParams.put(DevOpsConstants.CONFIG_CHANGESET_NUMBER.toString(), (Object)changesetNumber);
        queryParams.put(DevOpsConstants.CONFIG_NAME_PATH.toString(), (Object)path);
        queryParams.put(DevOpsConstants.CONFIG_DATA_FORMAT.toString(), (Object)dataFormat);
        queryParams.put(DevOpsConstants.CONFIG_AUTO_COMMIT.toString(), (Object)autoCommit);
        queryParams.put(DevOpsConstants.CONFIG_AUTO_DELETE.toString(), (Object)autoDelete);
        queryParams.put(DevOpsConstants.CONFIG_AUTO_VALIDATE.toString(), (Object)autoValidate);
        queryParams.put(DevOpsConstants.CONFIG_DEPLOYABLE_NAME.toString(), (Object)deployableName);
        queryParams.put(DevOpsConstants.CONFIG_COLLECTION_NAME.toString(), (Object)collectionName);
        if (autoPublish) {
            queryParams.put("publishOption", (Object)"publish_valid");
        } else {
            queryParams.put("publishOption", (Object)"publish_none");
        }
        JSONObject filePayloadJSON = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        filePayloadJSON.put(DevOpsConstants.CONFIG_FILE_CONTENT.toString(), (Object)fileContent);
        JSONObject response = null;
        if (target.equalsIgnoreCase(DevOpsConstants.CONFIG_COMPONENT_TYPE.toString())) {
            response = CommUtils.call(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getCDMUploadToComponentURL(), queryParams, fileContent, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), "text/plain", transactionSource);
        } else if (target.equalsIgnoreCase(DevOpsConstants.CONFIG_DEPLOYABLE_TYPE.toString())) {
            response = CommUtils.call(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getCDMUploadToDeployableURL(), queryParams, fileContent, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), "text/plain", transactionSource);
        } else if (target.equalsIgnoreCase(DevOpsConstants.CONFIG_COLLECTION_TYPE.toString())) {
            response = CommUtils.call(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getCDMUploadToCollectionURL(), queryParams, fileContent, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), "text/plain", transactionSource);
        } else {
            return null;
        }
        return response;
    }

    public JSONObject checkStatusForUpload(String uploadId) {
        JSONObject queryParams = new JSONObject();
        JSONObject filePayloadJSON = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        String deleteURL = devopsConfig.getUploadStatusURL() + uploadId;
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), deleteURL, queryParams, filePayloadJSON.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    public JSONObject insertExportRequest(String applicationName, String deployableName, String exporterName, String exporterFormat, JSONObject exporterArgs, String snapshotName, String transactionSource) {
        JSONObject queryParams = new JSONObject();
        JSONObject filePayloadJSON = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        queryParams.put(DevOpsConstants.CONFIG_DEPLOYABLE_NAME.toString(), (Object)deployableName);
        queryParams.put(DevOpsConstants.CONFIG_EXPORTER_NAME.toString(), (Object)exporterName);
        queryParams.put(DevOpsConstants.CONFIG_APPLICATION_NAME.toString(), (Object)applicationName);
        queryParams.put(DevOpsConstants.CONFIG_EXPORTER_FORMAT.toString(), (Object)exporterFormat);
        queryParams.put(DevOpsConstants.CONFIG_EXPORTER_ARGUMENTS.toString(), (Object)exporterArgs);
        queryParams.put(DevOpsConstants.CONFIG_SNAPSHOT_NAME.toString(), (Object)snapshotName);
        JSONObject response = CommUtils.call(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getExportRequestURL(), queryParams, filePayloadJSON.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, transactionSource);
        return response;
    }

    public JSONObject getImpactedDeployables(String changesetId) {
        JSONObject queryParams = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        JSONObject filePayloadJSON = new JSONObject();
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getImpactedDeployableURL(changesetId), queryParams, filePayloadJSON.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    public JSONObject fetchExportStatus(String exportId) {
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        String exportStatusURL = devopsConfig.getExportConfigStatusURL(exportId);
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), exportStatusURL, null, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    public JSONObject fetchExportData(String exportId) {
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        String exportDataURL = devopsConfig.getExportConfigDataURL(exportId);
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), exportDataURL, null, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    public JSONObject getSnapshotsByDeployables(String applicationName, String deployableName, String changesetNumber, boolean isValidated, String transactionSource, boolean noImapactedDeployable) {
        JSONObject queryParams = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        String query = "deployable_id.name=" + deployableName + "^cdm_application_id.sys_id=" + applicationName;
        String queryLimit = "";
        if (StringUtils.isEmpty((CharSequence)changesetNumber)) {
            if (!isValidated) {
                query = query + "^ORDERBYDESCsys_created_on";
                queryLimit = "1";
            } else if (!noImapactedDeployable) {
                query = query + "^validationINpassed,in_progress,passed_with_exception,requested^ORDERBYDESCsys_created_on";
                queryLimit = "2";
            } else {
                query = query + "^validationINpassed,passed_with_exception^ORDERBYDESCsys_created_on";
                queryLimit = "1";
            }
        } else {
            query = query + "^changeset_id.number=" + changesetNumber;
            queryLimit = "1";
        }
        queryParams.put(DevOpsConstants.TABLE_API_QUERY.toString(), (Object)query);
        queryParams.put(DevOpsConstants.TABLE_API_FIELDS.toString(), (Object)"sys_id,name,description,validation,published,sys_created_on");
        queryParams.put(DevOpsConstants.TABLE_API_LIMIT.toString(), (Object)queryLimit);
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getSnapshotStatusURL(), queryParams, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, transactionSource);
        return response;
    }

    public JSONObject snapShotExists(String applicationName, List<String> deployableNames, String changesetNumber) {
        JSONObject queryParams = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        String deployableNamesCommaSeparated = String.join((CharSequence)",", deployableNames);
        String query = "deployable_id.nameIN" + deployableNamesCommaSeparated + "^cdm_application_id.sys_id=" + applicationName + "^changeset_id.number=" + changesetNumber;
        queryParams.put(DevOpsConstants.TABLE_API_QUERY.toString(), (Object)query);
        queryParams.put(DevOpsConstants.TABLE_API_FIELDS.toString(), (Object)"sys_id,name,description,validation,last_validated,published,last_published,sys_created_on");
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getSnapshotStatusURL(), queryParams, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    public JSONObject getDeployableName(String sysId) {
        JSONObject queryParams = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        queryParams.put(DevOpsConstants.TABLE_API_QUERY.toString(), (Object)("sys_id=" + sysId));
        queryParams.put(DevOpsConstants.TABLE_API_FIELDS.toString(), (Object)"deployable_id.name,cdm_deployable_id.environment_type");
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getSnapshotStatusURL(), queryParams, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    public JSONObject querySnapShotStatus(String appSysId, List<String> deployableNames, List<String> snapshotNames, int retryCount, boolean checkForNotValidated) throws InterruptedException {
        JSONObject queryParams = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        String validationStates = "in_progress,requested";
        String snapShotNamesCommaSeparated = String.join((CharSequence)",", snapshotNames);
        String deployableNamesCommaSeparated = String.join((CharSequence)",", deployableNames);
        String query = "cdm_application_id.sys_id=" + appSysId + "^cdm_deployable_id.nameIN" + deployableNamesCommaSeparated + "^nameIN" + snapShotNamesCommaSeparated + "^validationIN" + validationStates;
        if (retryCount > 1 && checkForNotValidated) {
            queryParams.put(DevOpsConstants.TABLE_API_QUERY.toString(), (Object)(query + ",not_validated"));
            Thread.sleep(500L);
        } else {
            queryParams.put(DevOpsConstants.TABLE_API_QUERY.toString(), (Object)query);
        }
        queryParams.put(DevOpsConstants.TABLE_API_FIELDS.toString(), (Object)"name,validation");
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getSnapshotStatusURL(), queryParams, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    public JSONObject fetchSnapshotRecord(String applicationName, String deployableName, String snapshotName) {
        JSONObject queryParams = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        String query = "deployable_id.name=" + deployableName + "^application_id.name=" + applicationName;
        query = GenericUtils.isEmpty(snapshotName) ? query + "^ORDERBYDESCsys_created_on" : query + "^name=" + snapshotName;
        String fields = DevOpsConstants.CONFIG_SNAPSHOT_SYS_ID.toString() + "," + DevOpsConstants.CONFIG_ENVIRONMENT_TYPE.toString();
        queryParams.put(DevOpsConstants.TABLE_API_QUERY.toString(), (Object)query);
        queryParams.put(DevOpsConstants.TABLE_API_FIELDS.toString(), (Object)fields);
        queryParams.put(DevOpsConstants.TABLE_API_LIMIT.toString(), (Object)"1");
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getSnapshotStatusURL(), queryParams, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    public JSONObject publishSnapshot(String snapshotId, TaskListener listener, String transactionSource) {
        JSONObject queryParams = new JSONObject();
        JSONObject filePayloadJSON = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        JSONObject response = new JSONObject();
        try {
            response = CommUtils.callSafe(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getPublishSnapshotURL(snapshotId), queryParams, filePayloadJSON.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, transactionSource);
        }
        catch (Exception e) {
            GenericUtils.printConsoleLog(listener, (Object)((Object)DevOpsConstants.CONFIG_PUBLISH_STEP_FUNCTION_NAME) + " - Publish Failed due to Connection Issue");
            response.put("failureCause", (Object)"Failed due to Exception");
            return response;
        }
        return response;
    }

    public JSONObject registerChangeset(String pipelineName, String branchName, String toolId, String buildNumber, String type, boolean isMultiBranch, String changesetNumber, String snapshotName, String applicationName, TaskListener listener) {
        JSONObject queryParams = new JSONObject();
        JSONObject filePayloadJSON = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        queryParams.put(DevOpsConstants.ARTIFACT_PIPELINE_NAME.toString(), (Object)pipelineName);
        queryParams.put(DevOpsConstants.SCM_BRANCH_NAME.toString(), (Object)branchName);
        queryParams.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)toolId);
        queryParams.put(DevOpsConstants.CONFIG_BUILD_NUMBER.toString(), (Object)buildNumber);
        queryParams.put("type", (Object)type);
        queryParams.put(DevOpsConstants.IS_MULTI_BRANCH_ATTR.toString(), (Object)isMultiBranch);
        filePayloadJSON.put("changeSetId", (Object)changesetNumber);
        filePayloadJSON.put(DevOpsConstants.CONFIG_SNAPSHOT_NAME.toString(), (Object)snapshotName);
        filePayloadJSON.put(DevOpsConstants.CONFIG_APPLICATION_NAME.toString(), (Object)applicationName);
        int retryCount = 0;
        int retryFrequency = 220;
        JSONObject response = null;
        JSONObject responseBody = new JSONObject();
        String statusMessage = "";
        while (retryCount <= 20) {
            if (++retryCount % 2 == 0) {
                retryFrequency *= 2;
            }
            if ((response = CommUtils.call(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getPipelineRegisterURL(), queryParams, filePayloadJSON.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null)) == null) {
                try {
                    Thread.sleep(retryFrequency);
                }
                catch (InterruptedException e) {
                    GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - " + e.getMessage());
                }
                continue;
            }
            JSONObject status = response.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString());
            statusMessage = status.getString(DevOpsConstants.COMMON_RESPONSE_STATUS.toString());
            if (!statusMessage.equalsIgnoreCase("Could not find matching task execution for given pipeline name and build number")) {
                if (statusMessage.equalsIgnoreCase("Success")) {
                    responseBody.put(DevOpsConstants.COMMON_RESPONSE_STATUS.toString(), (Object)"Success");
                    responseBody.put(DevOpsConstants.COMMON_RESPONSE_MESSAGE.toString(), (Object)"Successfully Registered");
                    return responseBody;
                }
                responseBody.put(DevOpsConstants.COMMON_RESPONSE_STATUS.toString(), (Object)"Failure");
                responseBody.put(DevOpsConstants.COMMON_RESPONSE_MESSAGE.toString(), (Object)statusMessage);
                return responseBody;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                GenericUtils.printConsoleLog(listener, DevOpsConstants.CONFIG_UPLOAD_STEP_FUNCTION_NAME.toString() + " - " + e.getMessage());
            }
        }
        if (response != null) {
            responseBody.put(DevOpsConstants.COMMON_RESPONSE_STATUS.toString(), (Object)"Failure");
            responseBody.put(DevOpsConstants.COMMON_RESPONSE_MESSAGE.toString(), (Object)statusMessage);
            return responseBody;
        }
        responseBody.put(DevOpsConstants.COMMON_RESPONSE_STATUS.toString(), (Object)"Failure");
        responseBody.put(DevOpsConstants.COMMON_RESPONSE_MESSAGE.toString(), (Object)"Failed to Register Changeset");
        return responseBody;
    }

    public JSONObject validateSnapshot(String snapshotId, TaskListener listener, String transactionSource) {
        JSONObject queryParams = new JSONObject();
        JSONObject filePayloadJSON = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        JSONObject response = new JSONObject();
        try {
            response = CommUtils.callSafe(DevOpsConstants.REST_POST_METHOD.toString(), devopsConfig.getValidateSnapshotURL(snapshotId), queryParams, filePayloadJSON.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, transactionSource);
        }
        catch (Exception e) {
            GenericUtils.printConsoleLog(listener, (Object)((Object)DevOpsConstants.CONFIG_VALIDATE_STEP_FUNCTION_NAME) + " - Validation of snapshot failed " + e.getMessage());
            response.put(DevOpsConstants.COMMON_RESULT_FAILURE.toString(), (Object)("Validate failed due to exception " + e.getMessage()));
            return response;
        }
        return response;
    }

    public JSONObject getChangesetId(String changesetId) {
        JSONObject queryParams = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        String query = "number=" + changesetId;
        queryParams.put(DevOpsConstants.TABLE_API_QUERY.toString(), (Object)query);
        queryParams.put(DevOpsConstants.TABLE_API_FIELDS.toString(), (Object)"sys_id,state,cdm_application.node.name");
        queryParams.put(DevOpsConstants.TABLE_API_LIMIT.toString(), (Object)"1");
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getChangesetURL(), queryParams, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    public JSONObject checkForValidApp(String applicationName) {
        JSONObject queryParams = new JSONObject();
        JSONObject filePayloadJSON = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        String query = "node.name=" + applicationName;
        queryParams.put(DevOpsConstants.TABLE_API_QUERY.toString(), (Object)query);
        queryParams.put(DevOpsConstants.TABLE_API_FIELDS.toString(), (Object)"sys_id,node.name");
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getValidAppURL(), queryParams, filePayloadJSON.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    public JSONObject getValidationResults(String snapshotSysId, String policy, String format) {
        JSONObject queryParams = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        String baseQuery = "snapshot.sys_id=" + snapshotSysId + "^is_latest=true";
        String query = "";
        if (policy.isEmpty()) {
            queryParams.put(DevOpsConstants.TABLE_API_QUERY.toString(), (Object)baseQuery);
            queryParams.put(DevOpsConstants.TABLE_API_FIELDS.toString(), (Object)"snapshot.application_id.name,policy.name,snapshot.name,impacted_node.name,node_path,policy_execution.output");
        } else if (format.equalsIgnoreCase("xml")) {
            query = baseQuery + "^policy.name=" + policy;
            queryParams.put(DevOpsConstants.TABLE_API_QUERY.toString(), (Object)query);
            queryParams.put(DevOpsConstants.TABLE_API_FIELDS.toString(), (Object)"description,impacted_node.name,node_path");
        } else {
            query = baseQuery + "^policy.name=" + policy;
            queryParams.put(DevOpsConstants.TABLE_API_QUERY.toString(), (Object)query);
            queryParams.put(DevOpsConstants.TABLE_API_FIELDS.toString(), (Object)"description,impacted_node.name,node_path,type,policy_execution.decision");
        }
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getPolicyValidationURL(), queryParams, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    public JSONObject getConfigInfo(String info) {
        JSONObject configStatus = null;
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)info);
            if (jsonObject.containsKey((Object)"configResult")) {
                return jsonObject.getJSONObject("configResult");
            }
        }
        catch (Exception e) {
            this.printDebug("getConfigInfo", new String[]{"exception"}, new String[]{e.getMessage()}, Level.INFO);
        }
        return configStatus;
    }

    public JSONObject registerSecurityResult(JSONObject payload, String configurationName) {
        JSONObject queryParams = new JSONObject();
        JSONObject response = null;
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntryOrDefault(configurationName);
        if (devopsConfig == null) {
            throw new IllegalStateException("DevopsConfiguration is not available");
        }
        String securityRegisterURL = devopsConfig.getSecurityResultRegistrationURL();
        queryParams.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)devopsConfig.getToolId());
        if (!GenericUtils.isEmptyOrDefault(devopsConfig.getSecretCredentialId())) {
            HashMap<String, String> tokenDetails = new HashMap<String, String>();
            tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), DevOpsConfigurationEntry.getTokenText(devopsConfig.getSecretCredentialId()));
            response = CommUtils.callV2Support(DevOpsConstants.REST_POST_METHOD.toString(), securityRegisterURL, queryParams, payload.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null, tokenDetails);
        } else {
            response = CommUtils.call(DevOpsConstants.REST_POST_METHOD.toString(), securityRegisterURL, queryParams, payload.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        }
        return response;
    }

    public JSONObject fetchDeployables(String appSysId) {
        JSONObject queryParams = new JSONObject();
        JSONObject filePayloadJSON = new JSONObject();
        DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntry();
        String query = "cdm_app=" + appSysId;
        queryParams.put(DevOpsConstants.TABLE_API_QUERY.toString(), (Object)query);
        queryParams.put(DevOpsConstants.TABLE_API_FIELDS.toString(), (Object)"node.name");
        JSONObject response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getDeployablesURL(), queryParams, filePayloadJSON.toString(), DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
        return response;
    }

    private void logLinkAndDescription(TaskListener listener, String result) {
        try {
            JSONObject artifactRegisterRequestObj;
            JSONObject parsedResultJSONObject = JSONObject.fromObject((Object)result);
            ArrayList<String> logMessages = new ArrayList<String>();
            if (parsedResultJSONObject.containsKey((Object)DevOpsConstants.ARTIFACT_REGISTER_REQUESTS.toString()) && (artifactRegisterRequestObj = parsedResultJSONObject.getJSONObject(DevOpsConstants.ARTIFACT_REGISTER_REQUESTS.toString())) != null) {
                JSONArray createResult = artifactRegisterRequestObj.getJSONArray(DevOpsConstants.CREATE.toString());
                JSONArray updateResult = artifactRegisterRequestObj.getJSONArray(DevOpsConstants.UPDATE.toString());
                JSONArray foundResult = artifactRegisterRequestObj.getJSONArray(DevOpsConstants.FOUND.toString());
                if (createResult != null && !createResult.isEmpty()) {
                    this.logResponseDetails(logMessages, createResult);
                }
                if (updateResult != null && !updateResult.isEmpty()) {
                    this.logResponseDetails(logMessages, updateResult);
                }
                if (foundResult != null && !foundResult.isEmpty()) {
                    this.logResponseDetails(logMessages, foundResult);
                }
                if (!logMessages.isEmpty()) {
                    listener.getLogger().println("Response details:");
                    logMessages.forEach(msg -> listener.getLogger().println((String)msg));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void logResponseDetails(List<String> logMessages, JSONArray artifactRegisterRequestsArray) {
        int i;
        int counter = 1;
        for (i = 0; i < artifactRegisterRequestsArray.toArray().length; ++i) {
            JSONObject obj = artifactRegisterRequestsArray.getJSONObject(i);
            if (!obj.containsKey((Object)DevOpsConstants.STAGING_TYPE.toString()) || !DevOpsConstants.CREATE_PACKAGE_ASSOCIATION.toString().equalsIgnoreCase(obj.getString(DevOpsConstants.STAGING_TYPE.toString()))) continue;
            this.buildLogMessage(logMessages, artifactRegisterRequestsArray.getJSONObject(i), 1);
            artifactRegisterRequestsArray.remove(i);
            ++counter;
            break;
        }
        for (i = 0; i < artifactRegisterRequestsArray.toArray().length; ++i) {
            this.buildLogMessage(logMessages, artifactRegisterRequestsArray.getJSONObject(i), counter);
            ++counter;
        }
    }

    private void buildLogMessage(List<String> logMessages, JSONObject obj, int counter) {
        if (obj.containsKey((Object)DevOpsConstants.DESCRIPTION.toString()) && obj.containsKey((Object)DevOpsConstants.LINK.toString())) {
            String description = obj.getString(DevOpsConstants.DESCRIPTION.toString());
            logMessages.add(String.format("%s.%s Link: %s", counter, description, obj.getString(DevOpsConstants.LINK.toString())));
        }
    }

    private void logResponseStatus(TaskListener listener, JSONObject jsonObject) {
        JSONObject result;
        String status = "error";
        if (jsonObject.containsKey((Object)DevOpsConstants.COMMON_RESPONSE_RESULT.toString()) && (result = jsonObject.getJSONObject(DevOpsConstants.COMMON_RESPONSE_RESULT.toString())).containsKey((Object)DevOpsConstants.COMMON_RESPONSE_STATUS.toString())) {
            status = result.getString(DevOpsConstants.COMMON_RESPONSE_STATUS.toString());
        }
        listener.getLogger().println(String.format("Response status: %s", status));
    }

    public static class PipelineChangeResponse {
        PipelineChangeAction action;
        String errorMessage;
        String message;

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public PipelineChangeAction getAction() {
            return this.action;
        }

        public void setAction(PipelineChangeAction action) {
            this.action = action;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    public static enum PipelineChangeAction {
        ABORT,
        WAIT;

    }

    public static class DevOpsPipelineInfo {
        private List<DevOpsPipelineInfoConfig> devopsPipelineConfigs;

        public DevOpsPipelineInfo(List<DevOpsPipelineInfoConfig> devopsPipelineConfigs) {
            this.devopsPipelineConfigs = devopsPipelineConfigs;
        }

        public List<DevOpsPipelineInfoConfig> getDevopsPipelineConfigs() {
            return this.devopsPipelineConfigs;
        }

        public void setDevopsPipelineConfigs(List<DevOpsPipelineInfoConfig> devopsPipelineConfigs) {
            this.devopsPipelineConfigs = devopsPipelineConfigs;
        }

        public boolean hasTrackedConfig() {
            if (this.devopsPipelineConfigs == null) {
                return false;
            }
            for (DevOpsPipelineInfoConfig config : this.devopsPipelineConfigs) {
                if (!config.isTrack()) continue;
                return true;
            }
            return false;
        }

        public boolean hasTrackedPullRequestConfig() {
            if (this.devopsPipelineConfigs == null) {
                return false;
            }
            for (DevOpsPipelineInfoConfig config : this.devopsPipelineConfigs) {
                DevOpsConfigurationEntry entry = config.getDevopsConfig();
                if (entry == null || !entry.getTrackPullRequestPipelinesCheck()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "devopsPipelineConfigs: " + this.devopsPipelineConfigs.toString();
        }
    }
}

