/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.model;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.DevOpsRootAction;
import io.jenkins.plugins.DevOpsRunListener;
import io.jenkins.plugins.DevOpsRunStatusAction;
import io.jenkins.plugins.config.DevOpsConfigurationEntry;
import io.jenkins.plugins.model.DevOpsChangeRequestDetails;
import io.jenkins.plugins.model.DevOpsModel;
import io.jenkins.plugins.model.DevOpsPipelineGraph;
import io.jenkins.plugins.model.DevOpsPipelineNode;
import io.jenkins.plugins.pipeline.steps.executions.DevOpsPipelineChangeStepExecution;
import io.jenkins.plugins.utils.CommUtils;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.logging.Level;
import net.sf.json.JSONObject;

public class DevOpsChangePollingModel {
    public DevOpsPipelineNode getStageNodeById(Run<?, ?> run, String stageId) {
        DevOpsModel model = new DevOpsModel();
        return model.getStageNodeById(run, stageId);
    }

    public long getChangeStartTime(Run<?, ?> run, String stageId) {
        DevOpsPipelineNode currentNode = this.getStageNodeById(run, stageId);
        if (null != currentNode) {
            return currentNode.getChangeStartTime();
        }
        return 0L;
    }

    public void setChangeStartTime(Run<?, ?> run, String stageId, long startTime) {
        DevOpsPipelineNode currentNode = this.getStageNodeById(run, stageId);
        if (null != currentNode) {
            currentNode.setChangeStartTime(startTime);
        }
    }

    public void launchChangePollingThread(TaskListener listener, Run<?, ?> run, Job<?, ?> controlledJob, DevOpsPipelineChangeStepExecution stepExecution) {
        DevOpsPipelineGraph graph = ((DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class)).getPipelineGraph();
        String stageId = DevOpsRunListener.DevOpsStageListener.getCurrentStageId(stepExecution.getContext(), graph);
        long startTime = System.currentTimeMillis();
        if (this.getChangeStartTime(run, stageId) > 0L) {
            startTime = this.getChangeStartTime(run, stageId);
        } else {
            this.setChangeStartTime(run, stageId, startTime);
        }
        long pollingIntervalFinal = stepExecution.getStep().getPollingInterval() > 0 ? (long)stepExecution.getStep().getPollingInterval() * 1000L : -1L;
        long changeFailureTimeoutFinal = (long)stepExecution.getStep().getChangeCreationTimeOut() * 1000L;
        long changeStepTimeoutFinal = (long)stepExecution.getStep().getChangeStepTimeOut() * 1000L;
        if (pollingIntervalFinal <= 0L && changeFailureTimeoutFinal <= 0L && changeStepTimeoutFinal <= 0L) {
            return;
        }
        long stageStartTime = startTime;
        Runnable pollingThread = () -> {
            class Interval {
                long intervalTime;
                String type;
                int priority;

                public Interval(long intervalTime, int priority, String type) {
                    this.intervalTime = intervalTime;
                    this.type = type;
                    this.priority = priority;
                }
            }
            Thread.currentThread().setName("DevopsChangePollingThread");
            String CHG_STEP = "changeStep";
            String CHG_CREATION = "changeCreation";
            String POLLING = "polling";
            Comparator comparator = (interval1, interval2) -> {
                if (interval1.intervalTime > interval2.intervalTime) {
                    return 1;
                }
                if (interval1.intervalTime == interval2.intervalTime) {
                    if (interval1.priority > interval2.priority) {
                        return 1;
                    }
                    if (interval1.priority == interval2.priority) {
                        return 0;
                    }
                    return -1;
                }
                return -1;
            };
            try {
                long sleepTime = 0L;
                long nextPollingTime = pollingIntervalFinal;
                boolean isChangeCreationChecked = false;
                DevOpsChangeRequestDetails previousChangeDetails = new DevOpsChangeRequestDetails();
                PriorityQueue<Interval> sleepIntervals = new PriorityQueue<Interval>(3, comparator);
                while (!Thread.currentThread().isInterrupted()) {
                    long nextPollingTimeTemp = -1L;
                    if (pollingIntervalFinal >= 0L) {
                        sleepIntervals.add(new Interval(nextPollingTime, 3, "polling"));
                    }
                    long duration = System.currentTimeMillis() - stageStartTime;
                    if (!isChangeCreationChecked && changeFailureTimeoutFinal > 0L) {
                        if (changeFailureTimeoutFinal <= duration) {
                            sleepIntervals.add(new Interval(0L, 2, "changeCreation"));
                        } else if (changeFailureTimeoutFinal <= duration + nextPollingTime) {
                            sleepIntervals.add(new Interval(changeFailureTimeoutFinal - duration, 2, "changeCreation"));
                            nextPollingTimeTemp = nextPollingTime - (changeFailureTimeoutFinal - duration);
                        } else {
                            sleepIntervals.add(new Interval(changeFailureTimeoutFinal - duration, 2, "changeCreation"));
                        }
                    }
                    if (changeStepTimeoutFinal > 0L) {
                        if (changeStepTimeoutFinal <= duration) {
                            sleepIntervals.add(new Interval(0L, 1, "changeStep"));
                        } else if (changeStepTimeoutFinal <= duration + nextPollingTime) {
                            sleepIntervals.add(new Interval(changeStepTimeoutFinal - duration, 1, "changeStep"));
                            if (nextPollingTimeTemp == -1L || changeFailureTimeoutFinal > changeStepTimeoutFinal) {
                                nextPollingTimeTemp = nextPollingTime - (changeStepTimeoutFinal - duration);
                            }
                        } else {
                            sleepIntervals.add(new Interval(changeStepTimeoutFinal - duration, 1, "changeStep"));
                        }
                    }
                    if (nextPollingTimeTemp != -1L) {
                        nextPollingTime = nextPollingTimeTemp;
                    }
                    if (!sleepIntervals.isEmpty()) {
                        Interval nextInterval = (Interval)sleepIntervals.poll();
                        sleepTime = nextInterval.intervalTime;
                        if (sleepTime > 0L) {
                            Thread.sleep(sleepTime);
                        }
                        JSONObject response = this.getChangeStatusInfo(run, controlledJob, stepExecution);
                        boolean changeFound = Boolean.parseBoolean(GenericUtils.parseResponseResult(response, DevOpsConstants.CHANGE_FOUND.toString()));
                        switch (nextInterval.type) {
                            case "changeCreation": {
                                isChangeCreationChecked = true;
                                if (changeFound) break;
                                this.checkAndLogChangeCreationFailure(stepExecution, listener);
                                break;
                            }
                            case "changeStep": {
                                this.checkAndLogChangeStepTimeout(stepExecution, listener);
                                break;
                            }
                            default: {
                                previousChangeDetails = this.logPollingMessages(listener, response, previousChangeDetails);
                                nextPollingTime = pollingIntervalFinal;
                            }
                        }
                        sleepIntervals.clear();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                this.printDebug("launchChangePollingThread", new String[]{"message"}, new String[]{"[ServiceNow DevOps] Polling is stopped"}, Level.INFO);
            }
            catch (Exception e) {
                this.printDebug("launchChangePollingThread", new String[]{"exception"}, new String[]{e.getMessage()}, Level.WARNING);
            }
        };
        Thread pollingThreadImpl = new Thread(pollingThread);
        stepExecution.setPollingThread(pollingThreadImpl);
        pollingThreadImpl.start();
    }

    public void checkAndLogChangeStepTimeout(DevOpsPipelineChangeStepExecution stepExecution, TaskListener listener) throws IOException, InterruptedException {
        boolean abort = stepExecution.getStep().isAbortOnChangeStepTimeOut();
        listener.getLogger().println("[ServiceNow DevOps] Change Step timeout occurred.");
        this.resumeOrAbortThePipeline(stepExecution, listener, abort, "Pipeline aborted due to change step timeout");
    }

    public void checkAndLogChangeCreationFailure(DevOpsPipelineChangeStepExecution stepExecution, TaskListener listener) throws IOException, InterruptedException {
        boolean abort = stepExecution.getStep().isAbortOnChangeCreationFailure();
        listener.getLogger().println("[ServiceNow DevOps] Change Creation failure timeout occurred.");
        this.resumeOrAbortThePipeline(stepExecution, listener, abort, "Pipeline aborted due to change creation timeout");
    }

    public void resumeOrAbortThePipeline(DevOpsPipelineChangeStepExecution stepExecution, TaskListener listener, boolean abort, String failureMessage) throws IOException, InterruptedException {
        DevOpsRootAction.deregisterPipelineWebhook(stepExecution);
        if (abort) {
            ((Run)stepExecution.getContext().get(Run.class)).setResult(Result.FAILURE);
            stepExecution.getContext().onFailure((Throwable)new AbortException("[ServiceNow DevOps] " + failureMessage));
            listener.getLogger().println("[ServiceNow DevOps] Aborting the pipeline");
        } else {
            stepExecution.getContext().onSuccess((Object)"[ServiceNow DevOps] Resuming the pipeline");
            listener.getLogger().println("[ServiceNow DevOps] Resuming the pipeline");
        }
        stepExecution.stopPollingThread();
    }

    public DevOpsChangeRequestDetails logPollingMessages(TaskListener listener, JSONObject response, DevOpsChangeRequestDetails previousChangeDetails) {
        String changeDetails;
        String changeEndDate;
        String changeStartDate;
        String changeApprovers;
        String changeAssignmentGroup;
        String changeState;
        DevOpsChangeRequestDetails currentChangeDetails;
        boolean changeFound = Boolean.parseBoolean(GenericUtils.parseResponseResult(response, DevOpsConstants.CHANGE_FOUND.toString()));
        if (changeFound && !previousChangeDetails.equals(currentChangeDetails = new DevOpsChangeRequestDetails(changeState = GenericUtils.parseResponseResult(response, DevOpsConstants.CHANGE_STATE_DISPLAY_VALUE.toString()), changeAssignmentGroup = GenericUtils.parseResponseResult(response, DevOpsConstants.CHANGE_ASSIGNMENT_GROUP.toString()), changeApprovers = GenericUtils.parseResponseResult(response, DevOpsConstants.CHANGE_APPROVERS.toString()), changeStartDate = GenericUtils.parseResponseResult(response, DevOpsConstants.CHANGE_START_DATE.toString()), changeEndDate = GenericUtils.parseResponseResult(response, DevOpsConstants.CHANGE_END_DATE.toString()), changeDetails = GenericUtils.parseResponseResult(response, DevOpsConstants.CHANGE_DETAILS.toString())))) {
            listener.getLogger().println();
            listener.getLogger().println("[ServiceNow DevOps] Change State: " + changeState);
            if (changeApprovers != null) {
                listener.getLogger().println("[ServiceNow DevOps] Change AssignmentGroup: " + changeAssignmentGroup + ", Change Approvers: " + changeApprovers);
            }
            if (GenericUtils.isNotEmpty(changeStartDate) && GenericUtils.isNotEmpty(changeEndDate)) {
                listener.getLogger().println("[ServiceNow DevOps] Planned Start Date: " + changeStartDate + " UTC, Planned End Date: " + changeEndDate + " UTC");
            }
            if (changeDetails != null) {
                listener.getLogger().println("[ServiceNow DevOps] Change Details: " + changeDetails);
            }
            return currentChangeDetails;
        }
        return previousChangeDetails;
    }

    public JSONObject getChangeStatusInfo(Run<?, ?> run, Job<?, ?> controlledJob, DevOpsPipelineChangeStepExecution stepExecution) throws IOException, InterruptedException {
        JSONObject response = null;
        if (run != null && controlledJob != null && stepExecution != null) {
            JSONObject queryParams = new JSONObject();
            String jobName = controlledJob.getName();
            DevOpsPipelineGraph graph = ((DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class)).getPipelineGraph();
            DevOpsConfigurationEntry devopsConfig = GenericUtils.getDevOpsConfigurationEntryOrDefault(stepExecution.getStep().getConfigurationName());
            if (jobName != null && devopsConfig != null) {
                String stageId = DevOpsRunListener.DevOpsStageListener.getCurrentStageId(stepExecution.getContext(), graph);
                DevOpsPipelineNode stageNode = this.getStageNodeById(run, stageId);
                String stageName = stageNode.getName();
                String buildNumber = String.valueOf(run.getNumber());
                EnvVars vars = (EnvVars)stepExecution.getContext().get(EnvVars.class);
                String branchName = (String)vars.get((Object)DevOpsConstants.PIPELINE_BRANCH_NAME.toString());
                String pipelineName = (String)vars.get((Object)DevOpsConstants.PIPELINE_JOB_NAME.toString());
                queryParams.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)devopsConfig.getToolId());
                queryParams.put(DevOpsConstants.TOOL_TYPE_ATTR.toString(), (Object)DevOpsConstants.TOOL_TYPE.toString());
                queryParams.put(DevOpsConstants.ARTIFACT_PIPELINE_NAME.toString(), (Object)pipelineName);
                queryParams.put(DevOpsConstants.ARTIFACT_STAGE_NAME.toString(), (Object)stageName);
                queryParams.put(DevOpsConstants.CONFIG_BUILD_NUMBER.toString(), (Object)buildNumber);
                queryParams.put(DevOpsConstants.SCM_BRANCH_NAME.toString(), (Object)branchName);
                if (!GenericUtils.isEmptyOrDefault(devopsConfig.getSecretCredentialId())) {
                    HashMap<String, String> tokenDetails = new HashMap<String, String>();
                    tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), DevOpsConfigurationEntry.getTokenText(devopsConfig.getSecretCredentialId()));
                    response = CommUtils.callV2Support(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getChangeInfoUrl(), queryParams, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null, tokenDetails);
                } else {
                    response = CommUtils.call(DevOpsConstants.REST_GET_METHOD.toString(), devopsConfig.getChangeInfoUrl(), queryParams, null, DevOpsConfigurationEntry.getUser(devopsConfig.getCredentialsId()), DevOpsConfigurationEntry.getPwd(devopsConfig.getCredentialsId()), null, null);
                }
            }
        }
        return response;
    }

    private void printDebug(String methodName, String[] variables, String[] values, Level logLevel) {
        GenericUtils.printDebug(DevOpsModel.class.getName(), methodName, variables, values, logLevel);
    }
}

