/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.config;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.config.DevOpsConfiguration;
import io.jenkins.plugins.config.DevOpsConfigurationEntry;
import io.jenkins.plugins.utils.DevOpsConstants;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class DevOpsJobProperty
extends JobProperty<Job<?, ?>> {
    private boolean ignoreSNErrors = false;
    private String changeRequestDetails;
    private String configurationName;

    public boolean isIgnoreSNErrors() {
        return this.ignoreSNErrors;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    @DataBoundSetter
    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    @DataBoundSetter
    public void setIgnoreSNErrors(boolean ignoreSNErrors) {
        this.ignoreSNErrors = ignoreSNErrors;
    }

    public String getChangeRequestDetails() {
        return this.changeRequestDetails;
    }

    @DataBoundSetter
    public void setChangeRequestDetails(String changeRequestDetails) {
        this.changeRequestDetails = changeRequestDetails;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean isFreeStyle() {
        String pronoun;
        String string = pronoun = this.owner != null ? this.owner.getPronoun() : "";
        return pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString());
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public DevOpsJobProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            DevOpsJobProperty property = new DevOpsJobProperty();
            if (formData != null && !formData.isNullObject() && !formData.isEmpty()) {
                Object configurationName;
                property.setIgnoreSNErrors(formData.getBoolean("ignoreSNErrors"));
                Object changeRequestDetails = formData.get("changeRequestDetails");
                if (changeRequestDetails != null) {
                    property.setChangeRequestDetails(formData.getString("changeRequestDetails"));
                }
                if ((configurationName = formData.get("configurationName")) != null) {
                    property.setConfigurationName(formData.getString("configurationName"));
                }
            }
            return property;
        }

        public ListBoxModel doFillConfigurationNameItems() {
            DevOpsConfiguration configuration = DevOpsConfiguration.get();
            List<DevOpsConfigurationEntry> existingEntries = configuration.getEntries();
            ListBoxModel items = new ListBoxModel();
            items.add("", "");
            for (DevOpsConfigurationEntry entry : existingEntries) {
                if (!StringUtils.isNotBlank((CharSequence)entry.getName())) continue;
                items.add(entry.getName(), entry.getName());
            }
            return items;
        }

        public String getDisplayName() {
            return "ServiceNow DevOps Job Settings";
        }
    }
}

