/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.FreeStyleBuild;
import hudson.model.InvisibleAction;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import hudson.tasks.test.PipelineBlockWithTests;
import hudson.tasks.test.TabulatedResult;
import io.jenkins.plugins.actions.RegisterSecurityAction;
import io.jenkins.plugins.model.DevOpsJFrogModel;
import io.jenkins.plugins.model.DevOpsPipelineGraph;
import io.jenkins.plugins.model.DevOpsPipelineNode;
import io.jenkins.plugins.model.DevOpsPullRequestModel;
import io.jenkins.plugins.model.DevOpsRunStatusJobModel;
import io.jenkins.plugins.model.DevOpsRunStatusModel;
import io.jenkins.plugins.model.DevOpsRunStatusSCMModel;
import io.jenkins.plugins.model.DevOpsRunStatusStageModel;
import io.jenkins.plugins.model.DevOpsRunStatusTestCaseModel;
import io.jenkins.plugins.model.DevOpsRunStatusTestModel;
import io.jenkins.plugins.model.DevOpsRunStatusTestSuiteModel;
import io.jenkins.plugins.model.DevOpsSecurityResultModel;
import io.jenkins.plugins.model.DevOpsSonarQubeModel;
import io.jenkins.plugins.model.DevOpsTestSummary;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.actions.WorkspaceAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class DevOpsRunStatusAction
extends InvisibleAction {
    private static final Logger LOGGER = Logger.getLogger(DevOpsRunStatusAction.class.getName());
    private DevOpsRunStatusModel model;
    private Set<String> seenIds = new HashSet<String>();
    private DevOpsPipelineGraph pipelineGraph = new DevOpsPipelineGraph();
    private static final int LOG_SIZE_LIMIT = 512000;
    public Map<String, String> changeRequestInfo = new HashMap<String, String>();

    public void setModel(DevOpsRunStatusModel model) {
        this.model = model;
    }

    public DevOpsRunStatusModel getModel() {
        return this.model;
    }

    public Set<String> getSeenIds() {
        return this.seenIds;
    }

    public void setSeenId(String nodeId) {
        if (nodeId != null && !nodeId.isEmpty()) {
            this.seenIds.add(nodeId);
        }
    }

    public DevOpsRunStatusModel createRunStatus(FlowNode fn, Run<?, ?> run, EnvVars vars, String runPhase, String stagePhase, boolean isStageStart, DevOpsPipelineNode devOpsPipelineNode) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        DevOpsRunStatusModel status = new DevOpsRunStatusModel();
        if (run != null && jenkins != null) {
            Job job;
            String jenkinsUrl = jenkins.getRootUrl();
            status.setNumber(run.getNumber());
            status.setUrl(jenkinsUrl + run.getUrl());
            status.setTimestamp(run.getTimeInMillis() + run.getDuration());
            Result result = run.getResult();
            if (result != null) {
                status.setResult(result.toString());
            }
            if (runPhase != null) {
                status.setPhase(runPhase);
            }
            if ((job = run.getParent()) != null) {
                status.setPronoun(job.getPronoun());
                status.setMultiBranch(Boolean.toString(GenericUtils.isMultiBranch(job)));
            }
            DevOpsRunStatusJobModel jobModel = this.createRunStatusJob(run);
            status.setJobModel(jobModel);
            DevOpsRunStatusStageModel stageModel = this.createRunStatusStage(fn, run, stagePhase, isStageStart, devOpsPipelineNode);
            status.setStageModel(stageModel);
            DevOpsRunStatusSCMModel scmModel = this.createRunStatusSCM(run, vars);
            status.setSCMModel(scmModel);
            String stageModelName = stageModel.getName();
            DevOpsRunStatusTestModel testModel = this.createRunStatusTest(run, status.getPronoun(), stageModel.getId(), stageModelName);
            status.setTestModel(testModel);
            if (DevOpsConstants.PULL_REQUEST_PRONOUN.toString().equals(job.getPronoun())) {
                String jobName = job.getName();
                String pullRequestNumber = jobName.replaceAll("[^0-9]", "");
                try {
                    for (Action runAction : run.getAllActions()) {
                        Method m;
                        if (!runAction.getClass().getName().equalsIgnoreCase("hudson.plugins.git.util.BuildData")) continue;
                        Method[] methods = runAction.getClass().getMethods();
                        HashSet remoteUrls = null;
                        ArrayList<String> pullRequestRepoUrls = new ArrayList<String>();
                        HashMap<String, Method> methodMap = new HashMap<String, Method>();
                        for (Method m2 : methods) {
                            methodMap.put(m2.getName(), m2);
                        }
                        if (methodMap.containsKey("getRemoteUrls") && (remoteUrls = (HashSet)(m = (Method)methodMap.get("getRemoteUrls")).invoke((Object)runAction, new Object[0])).size() > 0) {
                            String repoUrl;
                            String url = (String)remoteUrls.toArray()[0];
                            String pullRequestRepoUrlFormat1 = repoUrl = url.replaceAll(".git$", "");
                            pullRequestRepoUrls.add(pullRequestRepoUrlFormat1);
                            String[] parts = repoUrl.split("/");
                            if (parts.length > 2) {
                                String projectName = parts[parts.length - 2];
                                String repoName = parts[parts.length - 1];
                                String pullRequestRepoUrlFormat2 = repoUrl.replaceAll("/scm/" + projectName + "/.*$", "/projects/" + projectName + "/repos/" + repoName);
                                if (!pullRequestRepoUrlFormat1.equalsIgnoreCase(pullRequestRepoUrlFormat2)) {
                                    pullRequestRepoUrls.add(pullRequestRepoUrlFormat2);
                                }
                            }
                        }
                        DevOpsPullRequestModel pullRequestModel = new DevOpsPullRequestModel(pullRequestRepoUrls, pullRequestNumber);
                        status.setPullRequestModel(pullRequestModel);
                    }
                }
                catch (RuntimeException ignore) {
                    LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.createRunStatus()- RunTime Exception :  " + ignore.getMessage());
                }
                catch (Exception ignore) {
                    LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.createRunStatus()- Exception occured :  " + ignore.getMessage());
                }
            }
            if (!isStageStart) {
                List<DevOpsTestSummary> testSummaryList;
                ArrayList<DevOpsSonarQubeModel> finalList;
                long stageEndtime = 0L;
                long stageStartime = 0L;
                if (fn != null && fn instanceof StepEndNode) {
                    TimingAction timingAction = (TimingAction)((StepEndNode)fn).getAction(TimingAction.class);
                    if (timingAction != null) {
                        stageEndtime = timingAction.getStartTime();
                    }
                } else {
                    stageEndtime = run.getTimestamp().getTimeInMillis() + run.getDuration();
                }
                if (fn != null && fn instanceof StepEndNode) {
                    StepStartNode stageStartNode = (StepStartNode)((StepEndNode)fn).getStartNode();
                    TimingAction timingAction = (TimingAction)stageStartNode.getAction(TimingAction.class);
                    if (timingAction != null) {
                        stageStartime = timingAction.getStartTime();
                    }
                } else {
                    stageStartime = run.getTimestamp().getTimeInMillis();
                }
                status.setStageCompleteTimeStamp(stageEndtime);
                status.setStageStartTimeStamp(stageStartime);
                String pipelineNameForPayload = jobModel.getName();
                if (GenericUtils.isMultiBranch(job).booleanValue()) {
                    pipelineNameForPayload = (String)vars.get((Object)"JOB_NAME");
                }
                String stageName = stageModel.getName();
                if ((DevOpsConstants.FREESTYLE_PRONOUN.toString().equals(job.getPronoun()) || DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString().equals(job.getPronoun())) && DevOpsConstants.NOTIFICATION_COMPLETED.toString().equals(runPhase) || stageModel != null && GenericUtils.isNotEmpty(stageModel.getId())) {
                    String currentStageNodeId = stageModel.getId();
                    List<DevOpsJFrogModel> jfrogModelsList = this.getJfrogBuildDetails(run, currentStageNodeId);
                    for (DevOpsJFrogModel jfrogModel : jfrogModelsList) {
                        if (this.pipelineGraph.isJFrogModelResultPublished(jfrogModel)) continue;
                        status.addToJfrogBuildModels(jfrogModel);
                        this.pipelineGraph.addToJobJFrogModelResults(jfrogModel);
                    }
                }
                if ((DevOpsConstants.FREESTYLE_PRONOUN.toString().equals(job.getPronoun()) || DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString().equals(job.getPronoun())) && DevOpsConstants.NOTIFICATION_COMPLETED.toString().equals(runPhase) || stageModel != null && GenericUtils.isNotEmpty(stageModel.getId())) {
                    List<DevOpsSonarQubeModel> sonarQubeModelList = this.getSonarQubeAnalysis(run, stageName, pipelineNameForPayload, status.getNumber(), stageEndtime, stageModel.getId(), status.getPronoun(), status.isMultiBranch(), scmModel.getBranch());
                    try {
                        if (sonarQubeModelList != null && sonarQubeModelList.size() > 0) {
                            finalList = new ArrayList<DevOpsSonarQubeModel>();
                            for (DevOpsSonarQubeModel sonarQubeModel : sonarQubeModelList) {
                                if (this.pipelineGraph.isSonarQubeModelResultPublished(sonarQubeModel)) continue;
                                finalList.add(sonarQubeModel);
                                this.pipelineGraph.addToJobSonarQubeModelResults(sonarQubeModel);
                            }
                            if (finalList.size() > 0) {
                                status.setSonarQubeAnalysisModels(finalList);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((DevOpsConstants.FREESTYLE_PRONOUN.toString().equals(job.getPronoun()) || DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString().equals(job.getPronoun())) && DevOpsConstants.NOTIFICATION_COMPLETED.toString().equals(runPhase) || stageModel != null && GenericUtils.isNotEmpty(stageModel.getId())) {
                    List<DevOpsSecurityResultModel> veracodeModels = this.getVeracodeModels(run, stageName, pipelineNameForPayload, status.getNumber(), stageEndtime, stageModel.getId(), status.getPronoun(), status.isMultiBranch(), scmModel.getBranch());
                    try {
                        if (veracodeModels != null && veracodeModels.size() > 0) {
                            finalList = new ArrayList();
                            for (DevOpsSecurityResultModel veracodeModel : veracodeModels) {
                                if (this.pipelineGraph.isJobSecurityResultsPublished(veracodeModel)) continue;
                                finalList.add((DevOpsSonarQubeModel)((Object)veracodeModel));
                                this.pipelineGraph.addToJobSecurityResults(veracodeModel);
                            }
                            if (finalList.size() > 0) {
                                status.addToSecurityResults(finalList);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((DevOpsConstants.FREESTYLE_PRONOUN.toString().equals(job.getPronoun()) || DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString().equals(job.getPronoun())) && DevOpsConstants.NOTIFICATION_COMPLETED.toString().equals(runPhase) || stageModel != null && GenericUtils.isNotEmpty(stageModel.getId())) {
                    List<DevOpsSecurityResultModel> checkmarxModels = this.getCheckmarxModels(run, stageName, pipelineNameForPayload, status.getNumber(), stageEndtime, stageModel.getId(), status.getPronoun(), status.isMultiBranch(), scmModel.getBranch());
                    try {
                        if (checkmarxModels != null && checkmarxModels.size() > 0) {
                            finalList = new ArrayList();
                            for (DevOpsSecurityResultModel checkmarxModel : checkmarxModels) {
                                if (this.pipelineGraph.isJobSecurityResultsPublished(checkmarxModel)) continue;
                                finalList.add((DevOpsSonarQubeModel)((Object)checkmarxModel));
                                this.pipelineGraph.addToJobSecurityResults(checkmarxModel);
                            }
                            if (finalList.size() > 0) {
                                status.addToSecurityResults(finalList);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((DevOpsConstants.FREESTYLE_PRONOUN.toString().equals(job.getPronoun()) || DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString().equals(job.getPronoun())) && DevOpsConstants.NOTIFICATION_COMPLETED.toString().equals(runPhase) || stageModel != null && GenericUtils.isNotEmpty(stageModel.getId())) {
                    List<DevOpsSecurityResultModel> securityResults = this.getSecurityResultSteps(run, stageName, pipelineNameForPayload, status.getNumber(), stageEndtime, stageModel.getId(), status.getPronoun(), status.isMultiBranch(), scmModel.getBranch());
                    try {
                        if (securityResults != null && securityResults.size() > 0) {
                            finalList = new ArrayList();
                            for (DevOpsSecurityResultModel model : securityResults) {
                                if (this.pipelineGraph.isJobSecurityResultsPublished(model)) continue;
                                finalList.add((DevOpsSonarQubeModel)((Object)model));
                                this.pipelineGraph.addToJobSecurityResults(model);
                            }
                            if (finalList.size() > 0) {
                                status.addToSecurityResults(finalList);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((testSummaryList = this.createTestSummary(run, stageName, pipelineNameForPayload, status.getNumber(), stageEndtime, stageModel.getId(), status.getPronoun(), status.isMultiBranch(), scmModel.getBranch())) != null && testSummaryList.size() > 0) {
                    finalList = new ArrayList();
                    for (DevOpsTestSummary testSummary : testSummaryList) {
                        if (this.pipelineGraph.isTestResultPublished(testSummary)) continue;
                        finalList.add((DevOpsSonarQubeModel)((Object)testSummary));
                        this.pipelineGraph.addToJobTestResults(testSummary);
                    }
                    if (finalList.size() > 0) {
                        status.setTestSummaries(finalList);
                    }
                }
            }
            if ((DevOpsConstants.FREESTYLE_PRONOUN.toString().equals(job.getPronoun()) || DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString().equals(job.getPronoun())) && DevOpsConstants.NOTIFICATION_COMPLETED.toString().equals(runPhase) || stageModel != null && GenericUtils.isNotEmpty(stageModel.getId()) && (stageModel.getLog() == null || stageModel.getLog().size() == 0) && !isStageStart && (!DevOpsConstants.FREESTYLE_PRONOUN.toString().equals(job.getPronoun()) || !DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString().equals(job.getPronoun()))) {
                try {
                    ArrayList<String> rlogList = new ArrayList<String>();
                    String logText = this.extractLog(run.getLogText());
                    rlogList.add(DevOpsRunStatusAction.getLastChunk(logText, 512000));
                    status.setLog(rlogList);
                }
                catch (UnsupportedEncodingException ignore) {
                    LOGGER.log(Level.WARNING, " Error when extracting log | " + ignore.getMessage());
                }
            }
        }
        return status;
    }

    public int addTestSummariesForTestTypeMappings(JSONObject testInfo, boolean isStageStart, Run<?, ?> run, EnvVars vars) {
        int testsAdded = 0;
        if (!isStageStart && testInfo != null && this.model != null && run != null) {
            Job job = run.getParent();
            DevOpsRunStatusJobModel jobModel = this.model.getJobModel();
            DevOpsRunStatusStageModel stageModel = this.model.getStageModel();
            DevOpsRunStatusSCMModel scmModel = this.model.getSCMModel();
            StringBuilder testResultFiles = new StringBuilder();
            if (jobModel != null && stageModel != null && scmModel != null) {
                if (testInfo.containsKey((Object)"tool")) {
                    testResultFiles.append(testInfo.getString("tool"));
                }
                if (testInfo.containsKey((Object)"pipeline")) {
                    testResultFiles.append(",");
                    testResultFiles.append(testInfo.getString("pipeline"));
                }
                if (testInfo.containsKey((Object)"stages")) {
                    JSONObject stageObj = testInfo.getJSONObject("stages");
                    String stagename = null;
                    stagename = this.model.getPronoun().equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || this.model.getPronoun().equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString()) ? jobModel.getName() : stageModel.getName();
                    if (stageObj.containsKey((Object)stagename)) {
                        testResultFiles.append(",");
                        testResultFiles.append(stageObj.getString(stagename));
                    }
                }
                LOGGER.log(Level.INFO, "DevOpsRunStatusAction.addTestSummariesForTestTypeMappings: test Result Files -" + testResultFiles.toString());
                String pipelineNameForPayload = jobModel.getName();
                if (GenericUtils.isMultiBranch(job).booleanValue()) {
                    pipelineNameForPayload = (String)vars.get((Object)"JOB_NAME");
                }
                DevOpsPipelineNode nodeById = this.pipelineGraph.getNodeById(stageModel.getId());
                FilePath workspace = null;
                WorkspaceAction action = null;
                if (nodeById != null) {
                    action = nodeById.getWsAction();
                }
                if (action != null) {
                    workspace = action.getWorkspace();
                } else if (run instanceof FreeStyleBuild) {
                    workspace = ((FreeStyleBuild)run).getWorkspace();
                }
                if (workspace != null && testResultFiles.toString().length() > 0) {
                    long startTime = 0L;
                    startTime = nodeById != null ? nodeById.getStartTime() : run.getTimestamp().getTimeInMillis();
                    ArrayList<FilePath> testFileList = new ArrayList<FilePath>();
                    this.getTestFiles(workspace, testResultFiles.toString(), testFileList, startTime);
                    for (FilePath testFile : testFileList) {
                        DevOpsTestSummary testSummary = this.createTestSummaryFromFile(testFile, stageModel.getName(), pipelineNameForPayload, this.model.getNumber(), startTime, this.model.getPronoun(), this.model.isMultiBranch(), scmModel.getBranch());
                        if (testSummary == null) continue;
                        this.model.addToTestSummaries(testSummary);
                        ++testsAdded;
                    }
                }
            }
        }
        return testsAdded;
    }

    public void removeTestSummariesForTestTypeMappings(int testsAdded) {
        this.model.removeFromTestSummaries(testsAdded);
    }

    private DevOpsTestSummary createTestSummaryFromFile(FilePath testFile, String stageName, String pipelineName, int buildNumber, long stageStarttime, String pronoun, String isMultiBranch, String branchName) {
        try {
            if (testFile == null) {
                return null;
            }
            LOGGER.log(Level.INFO, "DevOpsRunStatusAction.createTestSummaryFromFile(): Creating test summary from file -" + testFile.getName());
            String fileString = testFile.readToString();
            String projectName = null;
            if (pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString())) {
                projectName = pipelineName;
                pipelineName = null;
                stageName = projectName;
            }
            DevOpsTestSummary testSummary = new DevOpsTestSummary.Builder(testFile.getName()).inStage(stageName).inPipeline(pipelineName).inProject(projectName).buildNumber(buildNumber).start(stageStarttime).finish(testFile.lastModified()).branchName(branchName).multiBranch(isMultiBranch).fileContent(fileString).build();
            return testSummary;
        }
        catch (Exception ignore) {
            LOGGER.log(Level.WARNING, "DevOpsRunStatusAction.createTestSummaryFromFile()- Error getting test report content - " + ignore.getMessage());
            return null;
        }
    }

    private void getTestFiles(FilePath ws, String testResults, List<FilePath> fileList, long stageStartTime) {
        try {
            LOGGER.log(Level.INFO, "DevOpsRunStatusAction.getTestFiles: testResults-" + testResults);
            FileSet fs = Util.createFileSet((File)new File(ws.getRemote()), (String)testResults);
            DirectoryScanner ds = fs.getDirectoryScanner();
            String[] files = ds.getIncludedFiles();
            LOGGER.log(Level.INFO, "DevOpsRunStatusAction.getTestFiles: files-" + files.length);
            for (String relPath : files) {
                FilePath reportFile = new FilePath(ws, relPath);
                if (reportFile.lastModified() <= stageStartTime) continue;
                fileList.add(reportFile);
            }
            LOGGER.log(Level.INFO, "DevOpsRunStatusAction.getTestFiles: fileList-" + fileList.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean stringContainsItemFromList(String inputStr, String[] items) {
        return Arrays.stream(items).anyMatch(inputStr::contains);
    }

    private WorkspaceAction getWorkspaceAction(Run<?, ?> run) {
        FlowExecution exec;
        WorkspaceAction wsAction = null;
        if (run instanceof WorkflowRun && (exec = ((WorkflowRun)run).getExecution()) != null) {
            FlowGraphWalker w = new FlowGraphWalker(exec);
            for (FlowNode n : w) {
                if (!(n instanceof StepStartNode) || (wsAction = (WorkspaceAction)n.getAction(WorkspaceAction.class)) == null) continue;
                return wsAction;
            }
        }
        return wsAction;
    }

    public DevOpsRunStatusJobModel createRunStatusJob(Run<?, ?> run) {
        Job job;
        DevOpsRunStatusJobModel status = new DevOpsRunStatusJobModel();
        if (run != null && (job = run.getParent()) != null) {
            status.setName(job.getName());
            status.setUrl(job.getAbsoluteUrl());
            status.setFullName(job.getFullName());
        }
        return status;
    }

    public DevOpsRunStatusStageModel createRunStatusStage(FlowNode fn, Run<?, ?> run, String phase, boolean isStageStart, DevOpsPipelineNode devOpsPipelineNode) {
        DevOpsRunStatusStageModel stageModel = new DevOpsRunStatusStageModel();
        if (run != null && fn != null && phase != null && devOpsPipelineNode != null) {
            stageModel.setPhase(phase);
            if (isStageStart) {
                this.setSeenId(((StepStartNode)fn).getId());
                stageModel.setId(((StepStartNode)fn).getId());
                stageModel.setDuration(0L);
                stageModel.setTimestamp(System.currentTimeMillis());
                this.setStageModelDetailsFromPipelineNode(devOpsPipelineNode, stageModel);
                WorkspaceAction wsAction = this.getWorkspaceAction(run);
                devOpsPipelineNode.setWsAction(wsAction);
                devOpsPipelineNode.setStartTime(stageModel.getTimestamp());
            } else {
                StepStartNode startNode = (StepStartNode)((StepEndNode)fn).getStartNode();
                if (startNode != null) {
                    stageModel.setId(startNode.getId());
                    long duration = this.getTime((FlowNode)startNode, (FlowNode)((StepEndNode)fn));
                    stageModel.setDuration(duration);
                    devOpsPipelineNode.setDuration(duration);
                    LOGGER.log(Level.FINE, "Set duration " + duration + "ms on pipeline node " + devOpsPipelineNode.getId());
                    this.setStageModelDetailsFromPipelineNode(devOpsPipelineNode, stageModel);
                    stageModel.setWaitForChildExecutions(this.pipelineGraph.getWaitForChildExecutions(devOpsPipelineNode.getId()));
                }
                stageModel.setTimestamp(System.currentTimeMillis());
                List parents = fn.getParents();
                if (parents != null) {
                    try {
                        String logPreamble = "[Stage:" + stageModel.getName() + "] \n\n";
                        int logPreambleLen = logPreamble.getBytes(StandardCharsets.UTF_8).length;
                        LinkedList<FlowNode> nodeStack = new LinkedList<FlowNode>();
                        for (FlowNode fnode : parents) {
                            nodeStack.addFirst(fnode);
                        }
                        LinkedList<String> logStack = new LinkedList<String>();
                        this.getLogForStage(nodeStack, startNode, logStack, new int[]{0}, 512000 - logPreambleLen);
                        logStack.addFirst(logPreamble);
                        ArrayList<String> logList = new ArrayList<String>(logStack);
                        stageModel.setLog(logList);
                    }
                    catch (UnsupportedEncodingException ignore) {
                        LOGGER.log(Level.WARNING, " createRunStatusStage - Error when extracting log | " + ignore.getMessage());
                    }
                }
                ErrorAction error = fn.getError();
                DevOpsPipelineNode nodeById = this.pipelineGraph.getNodeById(stageModel.getId());
                if (error != null) {
                    stageModel.setResult(Result.FAILURE.toString());
                    if (null != nodeById) {
                        nodeById.setStageExecStatus(DevOpsConstants.STAGE_RUN_FAILURE.toString());
                    }
                } else {
                    stageModel.setResult(Result.SUCCESS.toString());
                    if (null != nodeById) {
                        nodeById.setStageExecStatus(DevOpsConstants.STAGE_RUN_COMPLETED.toString());
                    }
                }
            }
        }
        return stageModel;
    }

    private void setStageModelDetailsFromPipelineNode(DevOpsPipelineNode devOpsPipelineNode, DevOpsRunStatusStageModel stageModel) {
        if (devOpsPipelineNode != null && stageModel != null) {
            stageModel.setName(devOpsPipelineNode.getName());
            stageModel.setUrl(DevOpsPipelineGraph.getStageExecutionUrl(devOpsPipelineNode.getPipelineExecutionUrl(), devOpsPipelineNode.getId()));
            if (devOpsPipelineNode.getUpstreamTaskExecURL() != null) {
                stageModel.setUpstreamTaskExecutionURL(devOpsPipelineNode.getUpstreamTaskExecURL());
            }
            if (devOpsPipelineNode.getUpstreamStageName() != null) {
                stageModel.setUpstreamStageName(devOpsPipelineNode.getUpstreamStageName());
            }
            if (devOpsPipelineNode.getParentExecutionUrl() != null) {
                stageModel.setParentExecutionUrl(devOpsPipelineNode.getParentExecutionUrl());
            }
            if (devOpsPipelineNode.getPipelineExecutionUrl() != null) {
                stageModel.setPipelineExecutionUrl(devOpsPipelineNode.getPipelineExecutionUrl());
            }
            if (devOpsPipelineNode.getParentName() != null) {
                stageModel.setParentStageName(devOpsPipelineNode.getParentName());
            }
        }
    }

    private void getLogForStage(Deque<FlowNode> nodeStack, StepStartNode startNode, Deque<String> logQueue, int[] currSize, int sizeLimit) throws UnsupportedEncodingException {
        while (!nodeStack.isEmpty() && currSize[0] < sizeLimit) {
            FlowNode stageNode = nodeStack.removeFirst();
            this.extractAndAddLog(stageNode, logQueue, currSize, sizeLimit);
            ArrayList<FlowNode> stageNodeParents = stageNode.getParents();
            if (CollectionUtils.isEmpty((Collection)stageNodeParents)) continue;
            if (stageNodeParents.size() > 1) {
                class FlowNodeEnd {
                    Long endTime;
                    FlowNode fnode;

                    FlowNodeEnd(Long et, FlowNode fn) {
                        this.endTime = et;
                        this.fnode = fn;
                    }
                }
                Comparator endTimeComparator = (s1, s2) -> s2.endTime.compareTo(s1.endTime);
                PriorityQueue<FlowNodeEnd> fnPriorityQueue = new PriorityQueue<FlowNodeEnd>(endTimeComparator);
                for (FlowNode fnode : stageNodeParents) {
                    long endTime = 0L;
                    if (fnode instanceof StepEndNode) {
                        TimingAction timeAction = (TimingAction)fnode.getAction(TimingAction.class);
                        endTime = timeAction != null ? timeAction.getStartTime() : 0L;
                    }
                    fnPriorityQueue.add(new FlowNodeEnd(endTime, fnode));
                }
                ArrayList<FlowNode> orderedParents = new ArrayList<FlowNode>();
                while (!fnPriorityQueue.isEmpty()) {
                    orderedParents.add(((FlowNodeEnd)fnPriorityQueue.remove()).fnode);
                }
                stageNodeParents = orderedParents;
            }
            FlowNode parentNode = (FlowNode)stageNodeParents.get(0);
            while (parentNode != null && !parentNode.equals((Object)startNode) && !CollectionUtils.isEmpty((Collection)parentNode.getParents()) && currSize[0] < sizeLimit) {
                this.extractAndAddLog(parentNode, logQueue, currSize, sizeLimit);
                parentNode = (FlowNode)parentNode.getParents().get(0);
            }
            if (stageNodeParents.size() <= 1 || currSize[0] >= sizeLimit) continue;
            for (int i = 1; i < stageNodeParents.size(); ++i) {
                nodeStack.push((FlowNode)stageNodeParents.get(i));
            }
        }
    }

    private void extractAndAddLog(FlowNode fn, Deque<String> logQueue, int[] currSize, int sizeLimit) throws UnsupportedEncodingException {
        LogAction logAction;
        String stageName;
        if (fn == null || currSize[0] >= sizeLimit) {
            return;
        }
        if (fn instanceof StepStartNode && ((StepStartNode)fn).getStepName().equals("Stage") && !"Stage : Start".equals(stageName = this.getNodeName(fn))) {
            this.addLogEntry("\n[[" + this.getNodeName(fn) + "]]\n", logQueue, currSize, sizeLimit);
        }
        if ((logAction = (LogAction)fn.getAction(LogAction.class)) != null) {
            AnnotatedLargeText logText = logAction.getLogText();
            String logStr = this.extractLog(logText);
            this.addLogEntry(logStr, logQueue, currSize, sizeLimit);
        }
    }

    private void addLogEntry(String logStr, Deque<String> logQueue, int[] currSize, int sizeLimit) throws UnsupportedEncodingException {
        int logLineLen = logStr.getBytes(StandardCharsets.UTF_8).length;
        if (currSize[0] + logLineLen > sizeLimit) {
            logStr = DevOpsRunStatusAction.getLastChunk(logStr, sizeLimit - currSize[0]);
            logLineLen = logStr.getBytes(StandardCharsets.UTF_8).length;
        }
        if (logLineLen > 0) {
            logQueue.addFirst(logStr);
        }
        currSize[0] = currSize[0] + logLineLen;
    }

    private String extractLog(AnnotatedLargeText largeText) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            largeText.writeLogTo(0L, (OutputStream)baos);
        }
        catch (FileNotFoundException x) {
            LOGGER.log(Level.INFO, " log file not created yet");
            return "";
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, " error reading the log");
            return "";
        }
        String logEntry = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        LOGGER.log(Level.INFO, " logEntry :" + logEntry);
        return logEntry;
    }

    public static String getLastChunk(String original, int chunkSize) throws UnsupportedEncodingException {
        int end = original.length();
        int from = 0;
        int to = end;
        from = end - chunkSize < 0 ? 0 : end - chunkSize;
        String chunk = original.substring(from, to);
        while (chunk.getBytes(StandardCharsets.UTF_8).length > chunkSize) {
            chunk = original.substring(from++, to);
        }
        return chunk;
    }

    public DevOpsRunStatusSCMModel createRunStatusSCM(Run<?, ?> run, EnvVars vars) {
        DevOpsRunStatusSCMModel status = new DevOpsRunStatusSCMModel();
        if (run != null && vars != null) {
            if (vars.get((Object)"GIT_URL") != null) {
                status.setUrl((String)vars.get((Object)"GIT_URL"));
            }
            if (vars.get((Object)"BRANCH_NAME") != null) {
                status.setBranch((String)vars.get((Object)"BRANCH_NAME"));
            } else if (vars.get((Object)"GIT_BRANCH") != null) {
                status.setBranch((String)vars.get((Object)"GIT_BRANCH"));
            }
            if (vars.get((Object)"GIT_COMMIT") != null) {
                status.setCommit((String)vars.get((Object)"GIT_COMMIT"));
            }
            if (GenericUtils.isEmpty(status.getUrl()) && GenericUtils.isMultiBranch(run.getParent()).booleanValue()) {
                this.populateSCMInfoFromBuildData(run, status);
            }
            status.setChanges(this.getChangedFiles(run));
            status.setCulprits(this.getCulprits(run));
        }
        return status;
    }

    private void populateSCMInfoFromBuildData(Run<?, ?> run, DevOpsRunStatusSCMModel status) {
        try {
            for (Action runAction : run.getAllActions()) {
                if (!runAction.getClass().getName().equalsIgnoreCase("hudson.plugins.git.util.BuildData")) continue;
                if (!GenericUtils.isEmpty(status.getUrl())) break;
                try {
                    Method m;
                    Object remoteUrls;
                    Method[] methods = runAction.getClass().getMethods();
                    HashMap<String, Method> methodMap = new HashMap<String, Method>();
                    for (Method m2 : methods) {
                        methodMap.put(m2.getName(), m2);
                    }
                    if (methodMap.containsKey("getRemoteUrls") && (remoteUrls = (m = (Method)methodMap.get("getRemoteUrls")).invoke((Object)runAction, new Object[0])) instanceof Set && !((Set)remoteUrls).isEmpty()) {
                        String url = ((Set)remoteUrls).iterator().next().toString();
                        status.setUrl(url);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Failed to get remote URLs: " + e.getMessage());
                }
                break;
            }
        }
        catch (RuntimeException ignore) {
            LOGGER.log(Level.WARNING, "Error extracting SCM info from BuildData: " + ignore.getMessage());
        }
        catch (Exception ignore) {
            LOGGER.log(Level.WARNING, "Exception while extracting SCM info from BuildData: " + ignore.getMessage());
        }
    }

    public List<DevOpsJFrogModel> getJfrogBuildDetails(Run<?, ?> run, String stageNodeId) {
        ArrayList<DevOpsJFrogModel> finalJfrogModelList = new ArrayList<DevOpsJFrogModel>();
        try {
            for (Action runAction : run.getAllActions()) {
                if (!runAction.getClass().getName().equalsIgnoreCase("org.jfrog.hudson.BuildInfoResultAction")) continue;
                Method[] methods = runAction.getClass().getMethods();
                List publishedBuildDetailsList = null;
                HashMap<String, Method> methodMap = new HashMap<String, Method>();
                for (Method m : methods) {
                    methodMap.put(m.getName(), m);
                }
                if (methodMap.containsKey(DevOpsConstants.GET_PUBLISHED_BUILDS_DETAILS.toString())) {
                    Method m = (Method)methodMap.get(DevOpsConstants.GET_PUBLISHED_BUILDS_DETAILS.toString());
                    publishedBuildDetailsList = (List)m.invoke((Object)runAction, new Object[0]);
                }
                if (!CollectionUtils.isNotEmpty(publishedBuildDetailsList)) continue;
                for (Object publishedBuildDetails : publishedBuildDetailsList) {
                    Field artifactoryUrlPrivateField = publishedBuildDetails.getClass().getDeclaredField("artifactoryUrl");
                    artifactoryUrlPrivateField.setAccessible(true);
                    String artifactoryUrl = (String)artifactoryUrlPrivateField.get(publishedBuildDetails);
                    artifactoryUrl = artifactoryUrl.replaceAll("/artifactory$", "");
                    Field buildNamePrivateField = publishedBuildDetails.getClass().getDeclaredField("buildName");
                    buildNamePrivateField.setAccessible(true);
                    String buildName = (String)buildNamePrivateField.get(publishedBuildDetails);
                    Field buildNumberPrivateField = publishedBuildDetails.getClass().getDeclaredField("buildNumber");
                    buildNumberPrivateField.setAccessible(true);
                    String buildNumber = (String)buildNumberPrivateField.get(publishedBuildDetails);
                    String startedTimeStamp = "";
                    Field[] fields = publishedBuildDetails.getClass().getDeclaredFields();
                    if (Arrays.stream(fields).anyMatch(field -> field.getName().equals(DevOpsConstants.STARTED_TIMESTAMP.toString()))) {
                        Field startedTimeStampPrivateField = publishedBuildDetails.getClass().getDeclaredField(DevOpsConstants.STARTED_TIMESTAMP.toString());
                        startedTimeStampPrivateField.setAccessible(true);
                        startedTimeStamp = (String)startedTimeStampPrivateField.get(publishedBuildDetails);
                    }
                    DevOpsJFrogModel jFrogModel = new DevOpsJFrogModel(buildName, buildNumber, startedTimeStamp, artifactoryUrl, stageNodeId);
                    finalJfrogModelList.add(jFrogModel);
                }
            }
        }
        catch (RuntimeException ignore) {
            LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.getJfrogBuildDetails()- RunTime Exception :  " + ignore.getMessage());
        }
        catch (Exception ignore) {
            LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.getJfrogBuildDetails()- Exception occured :  " + ignore.getMessage());
        }
        return finalJfrogModelList;
    }

    public List<DevOpsSonarQubeModel> getSonarQubeAnalysis(Run<?, ?> run, String stageName, String pipelineName, int buildNumber, long stageEndTime, String blockId, String pronoun, String isMultiBranch, String branchName) {
        ArrayList<DevOpsSonarQubeModel> finalSonarQubeModelList = new ArrayList<DevOpsSonarQubeModel>();
        try {
            for (Action sonarAction : run.getAllActions()) {
                Method m;
                if (!sonarAction.getClass().getName().equalsIgnoreCase("hudson.plugins.sonar.action.SonarAnalysisAction")) continue;
                DevOpsSonarQubeModel sonarModel = new DevOpsSonarQubeModel();
                Method[] methods = sonarAction.getClass().getMethods();
                String ceTaskId = null;
                StringBuffer urlBuilder = new StringBuffer();
                HashMap<String, Method> methodMap = new HashMap<String, Method>();
                for (Method m2 : methods) {
                    methodMap.put(m2.getName(), m2);
                }
                if (methodMap.containsKey("getCeTaskId")) {
                    m = (Method)methodMap.get("getCeTaskId");
                    ceTaskId = m.invoke((Object)sonarAction, new Object[0]).toString();
                }
                if (methodMap.containsKey("getServerUrl")) {
                    m = (Method)methodMap.get("getServerUrl");
                    urlBuilder = urlBuilder.append(m.invoke((Object)sonarAction, new Object[0]).toString());
                } else if (methodMap.containsKey("getInstallationUrl")) {
                    m = (Method)methodMap.get("getInstallationUrl");
                    urlBuilder = urlBuilder.append(m.invoke((Object)sonarAction, new Object[0]).toString());
                } else if (methodMap.containsKey("getUrl")) {
                    m = (Method)methodMap.get("getUrl");
                    String tempUrl = m.invoke((Object)sonarAction, new Object[0]).toString();
                    String serverUrl = tempUrl.substring(0, tempUrl.indexOf("/dashboard"));
                    urlBuilder = urlBuilder.append(serverUrl);
                }
                sonarModel.setScanID(ceTaskId);
                sonarModel.setUrl(urlBuilder.toString());
                sonarModel.setStageNodeId(blockId);
                finalSonarQubeModelList.add(sonarModel);
            }
        }
        catch (RuntimeException ignore) {
            LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.getSonarQubeAnalysis()- RunTime Exception :  " + ignore.getMessage());
        }
        catch (Exception ignore) {
            LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.getSonarQubeAnalysis()- Exception occured : " + ignore.getMessage());
        }
        return finalSonarQubeModelList;
    }

    public List<DevOpsTestSummary> createTestSummary(Run<?, ?> run, String stageName, String pipelineName, int buildNumber, long stageEndTime, String blockId, String pronoun, String isMultiBranch, String branchName) {
        ArrayList<DevOpsTestSummary> finalTestSummaryList = new ArrayList<DevOpsTestSummary>();
        try {
            List testActions = run.getAllActions().stream().filter(act -> act instanceof AbstractTestResultAction).collect(Collectors.toList());
            for (Action action : testActions) {
                AbstractTestResultAction testAction = (AbstractTestResultAction)action;
                if (testAction == null) continue;
                if (AggregatedTestResultAction.class.isInstance(testAction)) {
                    AggregatedTestResultAction aggtestAction = (AggregatedTestResultAction)testAction;
                    List childReports = aggtestAction.getChildReports();
                    for (AggregatedTestResultAction.ChildReport childReport : childReports) {
                        List<DevOpsTestSummary> testSummaryList = this.processTestResult(childReport.run, testAction, childReport.result, stageName, pipelineName, buildNumber, stageEndTime, blockId, pronoun, isMultiBranch, branchName);
                        if (testSummaryList == null || testSummaryList.size() <= 0) continue;
                        finalTestSummaryList.addAll(testSummaryList);
                    }
                    continue;
                }
                List<DevOpsTestSummary> testSummaryList = this.processTestResult(run, testAction, testAction.getResult(), stageName, pipelineName, buildNumber, stageEndTime, blockId, pronoun, isMultiBranch, branchName);
                if (testSummaryList == null || testSummaryList.size() <= 0) continue;
                finalTestSummaryList.addAll(testSummaryList);
            }
        }
        catch (Exception ignore) {
            LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.createTestSummary()- Error when extracting testResults | " + ignore.getMessage());
        }
        return finalTestSummaryList;
    }

    private List<DevOpsTestSummary> processTestResult(Run run, AbstractTestResultAction testAction, Object result, String stageName, String pipelineName, int buildNumber, long stageEndTime, String blockId, String pronoun, String isMultiBranch, String branchName) {
        if (run == null || result == null) {
            return null;
        }
        ArrayList<DevOpsTestSummary> devOpsTestSummaryList = new ArrayList<DevOpsTestSummary>();
        try {
            PipelineBlockWithTests aBlock;
            TabulatedResult testResult = (TabulatedResult)result;
            if ((pronoun.equalsIgnoreCase(DevOpsConstants.PULL_REQUEST_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.PIPELINE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.BITBUCKET_MULTI_BRANCH_PIPELINE_PRONOUN.toString())) && testResult.hasMultipleBlocks() && (aBlock = testResult.getPipelineBlockWithTests(blockId)) == null) {
                return devOpsTestSummaryList;
            }
            String projectName = null;
            if (pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString())) {
                projectName = pipelineName;
                pipelineName = null;
                stageName = projectName;
            }
            Collection packageResults = testResult.getChildren();
            for (hudson.tasks.test.TestResult packageResult : packageResults) {
                TabulatedResult tabResult = (TabulatedResult)packageResult;
                String reptUrl = Jenkins.getInstance().getRootUrl() + run.getUrl() + this.getResultUrl(tabResult) + "/" + tabResult.getSafeName();
                long startTime = stageEndTime - (long)(tabResult.getDuration() * 1000.0f);
                DevOpsTestSummary testSummary = new DevOpsTestSummary.Builder(tabResult.getName()).total(tabResult.getTotalCount()).failed(tabResult.getFailCount()).passed(tabResult.getPassCount()).skipped(tabResult.getSkipCount()).duration(tabResult.getDuration()).inStage(stageName).inPipeline(pipelineName).inProject(projectName).buildNumber(buildNumber).start(startTime).finish(stageEndTime).reportUrl(reptUrl).branchName(branchName).multiBranch(isMultiBranch).stageNodeId(blockId).build();
                devOpsTestSummaryList.add(testSummary);
            }
        }
        catch (ClassCastException e) {
            LOGGER.log(Level.WARNING, "Got ClassCast exception while converting results to Tabulated Result from action: " + testAction.getClass().getName() + ". Ignoring as we only want test results for processing.");
        }
        catch (Exception ignore) {
            LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.processTestResult() - Error when extracting testResults | " + ignore.getMessage());
        }
        return devOpsTestSummaryList;
    }

    protected String getResultUrl(TabulatedResult result) {
        boolean isTestng = result.getClass().getName().startsWith("hudson.plugins.testng.results");
        if (isTestng) {
            return "testngreports";
        }
        return "testReport";
    }

    public DevOpsRunStatusTestModel createRunStatusTest(Run<?, ?> run, String pronoun, String stageId, String stageName) {
        TestResult testResult;
        TestResultAction testResultAction;
        DevOpsRunStatusTestModel status = new DevOpsRunStatusTestModel();
        if (run != null && (testResultAction = (TestResultAction)run.getAction(TestResultAction.class)) != null && (testResult = testResultAction.getResult()) != null) {
            status.setDuration(testResult.getDuration());
            status.setName(testResult.getDisplayName() + " - " + testResult.getName());
            if (pronoun.equalsIgnoreCase(DevOpsConstants.PULL_REQUEST_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.PIPELINE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.BITBUCKET_MULTI_BRANCH_PIPELINE_PRONOUN.toString())) {
                if (stageId != null && stageName != null && !stageId.isEmpty() && !stageName.isEmpty()) {
                    int passed = 0;
                    int skipped = 0;
                    int failed = 0;
                    int regression = 0;
                    int fixed = 0;
                    Collection suiteResults = testResult.getSuites();
                    for (SuiteResult suiteResult : suiteResults) {
                        if (suiteResult == null) continue;
                        List blockIds = suiteResult.getEnclosingBlocks();
                        List blockNames = suiteResult.getEnclosingBlockNames();
                        if (blockIds == null || blockNames == null) continue;
                        if (blockIds.size() >= 1 && blockNames.size() >= 1) {
                            if (!blockIds.contains(stageId.trim()) || !blockNames.contains(stageName.trim())) continue;
                            DevOpsRunStatusTestSuiteModel suite = new DevOpsRunStatusTestSuiteModel();
                            suite.setDuration(suiteResult.getDuration());
                            suite.setName(suiteResult.getName());
                            suite.setStdErr(suiteResult.getStderr());
                            suite.setStdOut(suiteResult.getStdout());
                            List caseResults = suiteResult.getCases();
                            for (CaseResult caseResult : caseResults) {
                                List<DevOpsRunStatusTestCaseModel> cases;
                                if (caseResult == null) continue;
                                DevOpsRunStatusTestCaseModel _case = new DevOpsRunStatusTestCaseModel();
                                _case.setClassName(caseResult.getClassName());
                                _case.setName(caseResult.getName());
                                _case.setDuration(caseResult.getDuration());
                                _case.setErrorDetails(caseResult.getErrorDetails());
                                _case.setErrorStackTrace(caseResult.getErrorStackTrace());
                                CaseResult.Status caseStatus = caseResult.getStatus();
                                if (caseStatus != null) {
                                    if (caseStatus.getMessage().equalsIgnoreCase(CaseResult.Status.FAILED.toString())) {
                                        ++failed;
                                    } else if (caseStatus.getMessage().equalsIgnoreCase(CaseResult.Status.PASSED.toString())) {
                                        ++passed;
                                    } else if (caseStatus.getMessage().equalsIgnoreCase(CaseResult.Status.SKIPPED.toString())) {
                                        ++skipped;
                                    } else if (caseStatus.getMessage().equalsIgnoreCase(CaseResult.Status.REGRESSION.toString())) {
                                        ++regression;
                                    } else if (caseStatus.getMessage().equalsIgnoreCase(CaseResult.Status.FIXED.toString())) {
                                        ++fixed;
                                    }
                                    _case.setStatus(caseStatus.getMessage());
                                }
                                if ((cases = suite.getCases()) == null) {
                                    cases = new ArrayList<DevOpsRunStatusTestCaseModel>();
                                }
                                cases.add(_case);
                                suite.setCases(cases);
                            }
                            List<DevOpsRunStatusTestSuiteModel> suites = status.getSuites();
                            if (suites == null) {
                                suites = new ArrayList<DevOpsRunStatusTestSuiteModel>();
                            }
                            suites.add(suite);
                            status.setSuites(suites);
                            continue;
                        }
                        this.printDebug("createRunStatusTest", new String[]{"blockIds"}, new String[]{blockIds.toString()}, Level.FINE);
                        this.printDebug("createRunStatusTest", new String[]{"blockNames"}, new String[]{blockNames.toString()}, Level.FINE);
                    }
                    status.setFailed(failed);
                    status.setPassed(passed);
                    status.setSkipped(skipped);
                    status.setFixed(fixed);
                    status.setRegression(regression);
                    status.setTotal(failed + passed + skipped + fixed + regression);
                }
            } else if (pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString())) {
                int passed = 0;
                int skipped = 0;
                int failed = 0;
                int regression = 0;
                int fixed = 0;
                Collection suiteResults = testResult.getSuites();
                for (SuiteResult suiteResult : suiteResults) {
                    if (suiteResult == null) continue;
                    DevOpsRunStatusTestSuiteModel suite = new DevOpsRunStatusTestSuiteModel();
                    suite.setDuration(suiteResult.getDuration());
                    suite.setName(suiteResult.getName());
                    suite.setStdErr(suiteResult.getStderr());
                    suite.setStdOut(suiteResult.getStdout());
                    List caseResults = suiteResult.getCases();
                    for (CaseResult caseResult : caseResults) {
                        List<DevOpsRunStatusTestCaseModel> cases;
                        if (caseResult == null) continue;
                        DevOpsRunStatusTestCaseModel _case = new DevOpsRunStatusTestCaseModel();
                        _case.setClassName(caseResult.getClassName());
                        _case.setName(caseResult.getName());
                        _case.setDuration(caseResult.getDuration());
                        _case.setErrorDetails(caseResult.getErrorDetails());
                        _case.setErrorStackTrace(caseResult.getErrorStackTrace());
                        CaseResult.Status caseStatus = caseResult.getStatus();
                        if (caseStatus != null) {
                            if (caseStatus.getMessage().equalsIgnoreCase(CaseResult.Status.FAILED.toString())) {
                                ++failed;
                            } else if (caseStatus.getMessage().equalsIgnoreCase(CaseResult.Status.PASSED.toString())) {
                                ++passed;
                            } else if (caseStatus.getMessage().equalsIgnoreCase(CaseResult.Status.SKIPPED.toString())) {
                                ++skipped;
                            } else if (caseStatus.getMessage().equalsIgnoreCase(CaseResult.Status.REGRESSION.toString())) {
                                ++regression;
                            } else if (caseStatus.getMessage().equalsIgnoreCase(CaseResult.Status.FIXED.toString())) {
                                ++fixed;
                            }
                            _case.setStatus(caseStatus.getMessage());
                        }
                        if ((cases = suite.getCases()) == null) {
                            cases = new ArrayList<DevOpsRunStatusTestCaseModel>();
                        }
                        cases.add(_case);
                        suite.setCases(cases);
                    }
                    List<DevOpsRunStatusTestSuiteModel> suites = status.getSuites();
                    if (suites == null) {
                        suites = new ArrayList<DevOpsRunStatusTestSuiteModel>();
                    }
                    suites.add(suite);
                    status.setSuites(suites);
                }
                status.setFailed(failed);
                status.setPassed(passed);
                status.setSkipped(skipped);
                status.setFixed(fixed);
                status.setRegression(regression);
                status.setTotal(failed + passed + skipped + fixed + regression);
            }
        }
        return status;
    }

    public long getTime(FlowNode startNode, FlowNode endNode) {
        TimingAction startTime = (TimingAction)startNode.getAction(TimingAction.class);
        TimingAction endTime = (TimingAction)endNode.getAction(TimingAction.class);
        if (startTime != null && endTime != null) {
            return endTime.getStartTime() - startTime.getStartTime();
        }
        return 0L;
    }

    public String getNodeName(FlowNode startNode) {
        String nodeName = "";
        if (startNode != null) {
            LabelAction label = (LabelAction)startNode.getAction(LabelAction.class);
            nodeName = label != null ? label.getDisplayName() : startNode.getDisplayName();
        }
        return nodeName;
    }

    public List<String> getChangedFiles(Run<?, ?> run) {
        AbstractBuild build;
        Object[] items;
        ArrayList<String> affectedPaths = new ArrayList<String>();
        if (run instanceof AbstractBuild && (items = (build = (AbstractBuild)run).getChangeSet().getItems()) != null && items.length > 0) {
            for (Object o : items) {
                if (!(o instanceof ChangeLogSet.Entry)) continue;
                affectedPaths.addAll(((ChangeLogSet.Entry)o).getAffectedPaths());
            }
        }
        return affectedPaths;
    }

    public List<String> getCulprits(Run<?, ?> run) {
        ArrayList<String> culprits = new ArrayList<String>();
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            Set buildCulprits = build.getCulprits();
            for (User user : buildCulprits) {
                culprits.add(user.getId());
            }
        }
        return culprits;
    }

    private void printDebug(String methodName, String[] variables, String[] values, Level logLevel) {
        GenericUtils.printDebug(DevOpsRunStatusAction.class.getName(), methodName, variables, values, logLevel);
    }

    public DevOpsPipelineGraph getPipelineGraph() {
        return this.pipelineGraph;
    }

    public void setPipelineGraph(DevOpsPipelineGraph pipelineGraph) {
        this.pipelineGraph = pipelineGraph;
    }

    public List<DevOpsSecurityResultModel> getVeracodeModels(Run<?, ?> run, String stageName, String pipelineName, int buildNumber, long stageEndTime, String blockId, String pronoun, String isMultiBranch, String branchName) {
        ArrayList<DevOpsSecurityResultModel> veracodeModels = new ArrayList<DevOpsSecurityResultModel>();
        try {
            for (Action runAction : run.getAllActions()) {
                Method m;
                String detailedURL;
                String[] urlParts;
                if (!runAction.getClass().getName().equalsIgnoreCase("com.veracode.jenkins.plugin.VeracodeAction")) continue;
                Method[] methods = runAction.getClass().getMethods();
                HashMap<String, Method> methodMap = new HashMap<String, Method>();
                for (Method m2 : methods) {
                    methodMap.put(m2.getName(), m2);
                }
                if (!methodMap.containsKey("getDetailedReportURLForHTMLAttr") || (urlParts = (detailedURL = (String)(m = (Method)methodMap.get("getDetailedReportURLForHTMLAttr")).invoke((Object)runAction, new Object[0])).split(":")).length <= 3) continue;
                String buildId = urlParts[urlParts.length - 1];
                String appId = urlParts[urlParts.length - 2];
                JSONObject attributes = new JSONObject();
                attributes.put(DevOpsConstants.SEC_TOOL_SCANNER.toString(), (Object)DevOpsConstants.VERACODE.toString());
                attributes.put(DevOpsConstants.VERACODE_APP_ID.toString(), (Object)appId);
                attributes.put(DevOpsConstants.VERACODE_BUILD_ID.toString(), (Object)buildId);
                attributes.put(DevOpsConstants.CREATE_IBE.toString(), (Object)true);
                DevOpsSecurityResultModel model = new DevOpsSecurityResultModel(attributes.toString());
                model.setStageNodeId(blockId);
                veracodeModels.add(model);
            }
        }
        catch (RuntimeException ignore) {
            LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.getVeracodeModels()- RunTime Exception :  " + ignore.getMessage());
        }
        catch (Exception ignore) {
            LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.getVeracodeModels()- Exception occured :  " + ignore.getMessage());
        }
        return veracodeModels;
    }

    public List<DevOpsSecurityResultModel> getCheckmarxModels(Run<?, ?> run, String stageName, String pipelineName, int buildNumber, long stageEndTime, String blockId, String pronoun, String isMultiBranch, String branchName) {
        ArrayList<DevOpsSecurityResultModel> checkmarxModels = new ArrayList<DevOpsSecurityResultModel>();
        String scanId = null;
        String projectId = null;
        try {
            for (Action runAction : run.getAllActions()) {
                Method resultMethod;
                Method m;
                LOGGER.log(Level.INFO, runAction.getClass().getName());
                if (!runAction.getClass().getName().equalsIgnoreCase("com.checkmarx.jenkins.CheckmarxScanResultsAction")) continue;
                Method[] methods = runAction.getClass().getMethods();
                HashMap<String, Method> methodMap = new HashMap<String, Method>();
                for (Method m2 : methods) {
                    methodMap.put(m2.getName(), m2);
                }
                if (!methodMap.containsKey("getResultsSummary") || (m = (Method)methodMap.get("getResultsSummary")).invoke((Object)runAction, new Object[0]) == null) continue;
                HashMap<String, Method> resultsMethodMap = new HashMap<String, Method>();
                for (Method method : methods = m.invoke((Object)runAction, new Object[0]).getClass().getMethods()) {
                    resultsMethodMap.put(method.getName(), method);
                }
                if (resultsMethodMap.containsKey("getScanId")) {
                    resultMethod = (Method)resultsMethodMap.get("getScanId");
                    scanId = (String)resultMethod.invoke(m.invoke((Object)runAction, new Object[0]), new Object[0]);
                }
                if (resultsMethodMap.containsKey("getProjectId")) {
                    resultMethod = (Method)resultsMethodMap.get("getProjectId");
                    projectId = (String)resultMethod.invoke(m.invoke((Object)runAction, new Object[0]), new Object[0]);
                }
                if (scanId == null || projectId == null) continue;
                JSONObject attributes = new JSONObject();
                attributes.put(DevOpsConstants.SEC_TOOL_SCANNER.toString(), (Object)DevOpsConstants.CHECKMARX_ONE.toString());
                attributes.put(DevOpsConstants.CHECKMARX_SCAN_ID.toString(), (Object)scanId);
                attributes.put(DevOpsConstants.CHECKMARX_PROJECT_ID.toString(), (Object)projectId);
                attributes.put(DevOpsConstants.CREATE_IBE.toString(), (Object)true);
                DevOpsSecurityResultModel model = new DevOpsSecurityResultModel(attributes.toString());
                model.setStageNodeId(blockId);
                checkmarxModels.add(model);
            }
        }
        catch (RuntimeException ignore) {
            LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.getCheckmarxModels()- RunTime Exception :  " + ignore.getMessage());
        }
        catch (Exception ignore) {
            LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.getCheckmarxModels()- Exception occurred :  " + ignore.getMessage());
        }
        return checkmarxModels;
    }

    public List<DevOpsSecurityResultModel> getSecurityResultSteps(Run<?, ?> run, String stageName, String pipelineName, int buildNumber, long stageEndTime, String blockId, String pronoun, String isMultiBranch, String branchName) {
        ArrayList<DevOpsSecurityResultModel> finalSecurityResultModel = new ArrayList<DevOpsSecurityResultModel>();
        try {
            for (Action action : run.getAllActions()) {
                if (!action.getClass().getName().equalsIgnoreCase(RegisterSecurityAction.class.getName())) continue;
                RegisterSecurityAction ra = (RegisterSecurityAction)action;
                DevOpsSecurityResultModel securityResultModel = new DevOpsSecurityResultModel(ra.getSecurityToolAttributes().toString());
                securityResultModel.setStageNodeId(blockId);
                finalSecurityResultModel.add(securityResultModel);
            }
        }
        catch (RuntimeException ignore) {
            LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.getSecurityResultModel()- RunTime Exception :  " + ignore.getMessage());
        }
        catch (Exception ignore) {
            LOGGER.log(Level.WARNING, " DevOpsRunStatusAction.getSecurityResultModel()- Exception occured : " + ignore.getMessage());
        }
        return finalSecurityResultModel;
    }
}

