/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import io.jenkins.plugins.model.DevOpsModel;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.util.logging.Level;

@Extension
public class DevOpsQueueTaskDispatcher<P, R>
extends QueueTaskDispatcher {
    DevOpsModel model;

    public CauseOfBlockage canRun(Queue.Item item) {
        this.model = new DevOpsModel();
        if (item.task instanceof Job) {
            Job job = (Job)item.task;
            String pronoun = job.getPronoun();
            if (pronoun == null) {
                return null;
            }
            GenericUtils.printDebug(DevOpsQueueTaskDispatcher.class.getName(), "canRun", new String[]{"pronoun"}, new String[]{pronoun}, Level.FINE);
            if (pronoun.equalsIgnoreCase(DevOpsConstants.PULL_REQUEST_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.PIPELINE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.BITBUCKET_MULTI_BRANCH_PIPELINE_PRONOUN.toString())) {
                return null;
            }
            if (pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_PRONOUN.toString()) || pronoun.equalsIgnoreCase(DevOpsConstants.FREESTYLE_MAVEN_PRONOUN.toString())) {
                return this.model.handleFreestyle(item, job);
            }
            return null;
        }
        return null;
    }
}

