/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.RootAction;
import io.jenkins.plugins.model.DevOpsJobModel;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.json.JsonHttpResponse;
import org.kohsuke.stapler.verb.GET;

@Extension
public class DevOpsJSONAPI
implements RootAction {
    private static final HashMap<String, List<DevOpsJobModel>> jobsPageCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addJobsToCache(String pageKey, List<DevOpsJobModel> jobs) {
        HashMap<String, List<DevOpsJobModel>> hashMap = jobsPageCache;
        synchronized (hashMap) {
            jobsPageCache.put(pageKey, jobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DevOpsJobModel> getJobsFromCache(String pageKey) {
        HashMap<String, List<DevOpsJobModel>> hashMap = jobsPageCache;
        synchronized (hashMap) {
            return jobsPageCache.getOrDefault(pageKey, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPageConfigExistsInCache(String pageKey) {
        HashMap<String, List<DevOpsJobModel>> hashMap = jobsPageCache;
        synchronized (hashMap) {
            return jobsPageCache.containsKey(pageKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeJobsFromCache(String pageKey) {
        HashMap<String, List<DevOpsJobModel>> hashMap = jobsPageCache;
        synchronized (hashMap) {
            if (jobsPageCache.containsKey(pageKey)) {
                jobsPageCache.remove(pageKey);
            }
        }
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return DevOpsConstants.SN_DEVOPS_DISCOVER_API_BASE_URL.toString();
    }

    private DevOpsJobModel createDevOpsJobFromItem(AbstractItem item) {
        DevOpsJobModel job = new DevOpsJobModel();
        job.set_class(item.getClass().getName());
        job.setDisplayName(item.getDisplayName());
        job.setName(item.getFullName());
        job.setFullName(item.getFullName());
        job.setUrl(item.getAbsoluteUrl());
        return job;
    }

    private List<DevOpsJobModel> getAllJobs(Integer depth) throws Exception {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance == null) {
            GenericUtils.printDebug(DevOpsJSONAPI.class.getName(), "getAllJobs", new String[]{"message"}, new String[]{"No Instance Found"}, Level.WARNING);
            throw new Exception("No Instance Found");
        }
        return instance.getAllItems(AbstractItem.class, abstractItem -> !(depth != null && abstractItem.getFullName().split("/").length > depth || !abstractItem.getParent().getClass().getName().endsWith("Folder") && !abstractItem.getParent().getClass().getName().endsWith("Hudson"))).stream().map(item -> this.createDevOpsJobFromItem((AbstractItem)item)).collect(Collectors.toList());
    }

    @GET
    @WebMethod(name={"is-devops-api-present"})
    public JsonHttpResponse isDevOpsAPIPresent() {
        return new JsonHttpResponse(JSONObject.fromObject((Object)true), 200);
    }

    @GET
    @WebMethod(name={"jobs"})
    public JsonHttpResponse getJobs(@QueryParameter(required=true) Integer pageNumber, @QueryParameter(required=true) Integer pageSize, @QueryParameter(required=true) Integer depth, @QueryParameter(required=true) String importRequest) throws Exception {
        int totalPage;
        JSONObject response = new JSONObject();
        List<DevOpsJobModel> jobs = DevOpsJSONAPI.getJobsFromCache(importRequest);
        if (jobs == null) {
            jobs = this.getAllJobs(depth);
            DevOpsJSONAPI.addJobsToCache(importRequest, jobs);
        }
        if ((totalPage = jobs.size() / pageSize) < pageNumber) {
            GenericUtils.printDebug(DevOpsJSONAPI.class.getName(), "getJobs", new String[]{"message"}, new String[]{"pageNumber is larger than total pages"}, Level.WARNING);
            throw new Exception("pageNumber is larger than total pages");
        }
        int firstIndex = pageNumber * pageSize;
        int lastIndex = pageNumber == totalPage ? jobs.size() : firstIndex + pageSize;
        boolean isLastPage = lastIndex == jobs.size();
        JSONArray jobList = JSONArray.fromObject(jobs.subList(firstIndex, lastIndex));
        response.put("jobs", (Object)jobList);
        response.put("hasNext", (Object)(!isLastPage ? 1 : 0));
        if (isLastPage) {
            DevOpsJSONAPI.removeJobsFromCache(importRequest);
        }
        return new JsonHttpResponse(response, 200);
    }
}

