/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.gson.Gson;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.RootAction;
import hudson.util.Secret;
import io.jenkins.plugins.DevOpsDataApiAction;
import io.jenkins.plugins.config.DevOpsConfiguration;
import io.jenkins.plugins.config.DevOpsConfigurationEntry;
import io.jenkins.plugins.model.DevOpsConfigurationEntity;
import io.jenkins.plugins.utils.DevOpsConstants;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.json.JsonBody;
import org.kohsuke.stapler.json.JsonHttpResponse;
import org.kohsuke.stapler.verb.DELETE;
import org.kohsuke.stapler.verb.GET;
import org.kohsuke.stapler.verb.PUT;

@Extension
public class DevOpsEndpointsAction
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(DevOpsEndpointsAction.class.getName());
    private Predicate<DevOpsConfigurationEntry> isValidConfiguration = entry -> StringUtils.isNotBlank((String)entry.getToolId()) && StringUtils.isNotBlank((String)entry.getInstanceUrl());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "DevOps API";
    }

    public String getUrlName() {
        return "sndevops-api";
    }

    @GET
    @WebMethod(name={"pipeline-details"})
    public void getPipelineDetails(StaplerRequest request, StaplerResponse response) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        DevOpsDataApiAction dataApiAction = new DevOpsDataApiAction();
        dataApiAction.handlePipelineDetailsRequest(request, response);
    }

    @PUT
    @WebMethod(name={"plugin-configuration"})
    public JsonHttpResponse configurePlugin(@JsonBody DevOpsConfigurationEntity request) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Integer allowedConfigurations = Integer.valueOf(DevOpsConstants.MAX_ALLOWED_DEVOPS_CONFIGURATIONS.toString());
        JSONObject response = new JSONObject();
        String resMessage = "";
        JSONObject params = new JSONObject();
        boolean tokenTest = false;
        request.setInstanceUrl(GenericUtils.removeTrailingSlashes(request.getInstanceUrl()));
        params.put(DevOpsConstants.TOOL_ID_ATTR.toString(), (Object)request.getToolId());
        params.put(DevOpsConstants.TEST_CONNECTION_ATTR.toString(), (Object)"true");
        params.put(DevOpsConstants.TOOL_TYPE_ATTR.toString(), (Object)DevOpsConstants.TOOL_TYPE.toString());
        boolean isActive = true;
        if (!request.isSkipValidation()) {
            if (!GenericUtils.isEmptyOrDefault(request.getToken())) {
                HashMap<String, String> tokenDetails = new HashMap<String, String>();
                tokenDetails.put(DevOpsConstants.TOKEN_VALUE.toString(), request.getToken());
                try {
                    tokenTest = DevOpsConfigurationEntry.callConnectionApi(DevOpsConstants.VERSION_V2.toString(), params, null, null, tokenDetails, request.getInstanceUrl());
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, "Test connection failed for toolID" + request.getToolId());
                }
            }
        } else {
            LOGGER.log(Level.INFO, "Skipping token and connection validation for toolid: " + request.getToolId());
            tokenTest = true;
            isActive = false;
        }
        DevOpsConfiguration configuration = DevOpsConfiguration.get();
        List<DevOpsConfigurationEntry> existingEntries = configuration.getEntries();
        int numEntries = existingEntries.size();
        DevOpsConfigurationEntry devOpsConfigurationEntry = this.findMatchingConfiguration(request, existingEntries);
        if (devOpsConfigurationEntry == null && numEntries >= allowedConfigurations) {
            response.put("message", (Object)String.format("Unable to configure as we reached the maximum allowed ServiceNow DevOps configurations", new Object[0]));
            return new JsonHttpResponse(response, 500);
        }
        try {
            if (tokenTest) {
                String credential = this.addSecretTextCredential(request.getToken(), request.getTokenId());
                if (credential != null) {
                    if (devOpsConfigurationEntry == null) {
                        DevOpsConfigurationEntry entry = new DevOpsConfigurationEntry(this.buildConfigurationName(request), isActive, request.isDefaultConnection(), request.getInstanceUrl(), request.getToolId(), "", DevOpsConstants.VERSION_V2.toString(), "", false, false, credential);
                        if (numEntries == 0) {
                            entry.setDefaultConnection(true);
                        }
                        existingEntries.add(entry);
                    } else {
                        devOpsConfigurationEntry.setInstanceUrl(request.getInstanceUrl());
                        devOpsConfigurationEntry.setToolId(request.getToolId());
                        devOpsConfigurationEntry.setSecretCredentialId(credential);
                        devOpsConfigurationEntry.setActive(isActive);
                        if (StringUtils.isNotBlank((String)request.getName())) {
                            devOpsConfigurationEntry.setName(request.getName());
                        }
                        if (!devOpsConfigurationEntry.getDefaultConnection()) {
                            devOpsConfigurationEntry.setDefaultConnection(request.isDefaultConnection());
                        }
                        if (StringUtils.isBlank((String)devOpsConfigurationEntry.getSnArtifactToolId())) {
                            devOpsConfigurationEntry.setSnArtifactToolId("");
                        }
                        if (numEntries == 1) {
                            devOpsConfigurationEntry.setDefaultConnection(true);
                        }
                    }
                    configuration.setEntries(existingEntries);
                    response.put("message", (Object)DevOpsConstants.JENKINS_CONFIGURATION_SUCCESS.toString());
                    response.put("totalConfigurationsCount", (Object)existingEntries.size());
                    response.put("jenkinsVersion", (Object)GenericUtils.getJenkinsVersion());
                    return new JsonHttpResponse(response, 200);
                }
                resMessage = DevOpsConstants.JENKINS_CONFIGURATION_CRED_CREATION_FAILURE.toString();
            } else {
                resMessage = DevOpsConstants.JENKINS_CONFIGURATION_TEST_CONNECTION_FAILURE.toString();
            }
        }
        catch (Exception e) {
            resMessage = DevOpsConstants.JENKINS_CONFIGURATION_SAVE_FAILURE.toString();
            LOGGER.log(Level.INFO, "Error while saving config details" + e.getMessage());
        }
        response.put("message", (Object)resMessage);
        return new JsonHttpResponse(response, 500);
    }

    @DELETE
    @WebMethod(name={"plugin-configuration"})
    public JsonHttpResponse deletePluginConfiguration(@QueryParameter(value="name") String name) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        LOGGER.log(Level.INFO, "Deleting configuration with name: " + name);
        boolean removed = false;
        DevOpsConfiguration configuration = DevOpsConfiguration.get();
        List<DevOpsConfigurationEntry> entries = configuration.getEntries();
        if (entries != null && (removed = entries.removeIf(entry -> entry.getName().equals(name)))) {
            configuration.setEntries(entries);
            configuration.save();
        }
        JSONObject response = new JSONObject();
        if (removed) {
            response.put("message", (Object)"Configuration deleted successfully");
            return new JsonHttpResponse(response, 200);
        }
        response.put("message", (Object)"Configuration not found");
        return new JsonHttpResponse(response, 404);
    }

    @GET
    @WebMethod(name={"plugin-configuration"})
    public JsonHttpResponse getPluginConfiguration() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        List<DevOpsConfigurationEntry> entries = DevOpsConfiguration.get().getEntries();
        String entriesToJson = new Gson().toJson(entries);
        JSONArray jsonEntities = JSONArray.fromObject((Object)entriesToJson);
        JSONObject response = new JSONObject();
        response.put("entries", (Object)jsonEntities);
        return new JsonHttpResponse(response, 200);
    }

    @GET
    @WebMethod(name={"permissions"})
    public JsonHttpResponse getUserPermissions() {
        Jenkins jenkins = Jenkins.get();
        HashMap<String, Boolean> userPermissions = new HashMap<String, Boolean>();
        userPermissions.put("hasAdminRole", jenkins.hasPermission(Jenkins.ADMINISTER));
        JSONObject response = new JSONObject();
        response.put("permissions", userPermissions);
        return new JsonHttpResponse(response, 200);
    }

    private DevOpsConfigurationEntry findMatchingConfiguration(DevOpsConfigurationEntity body, List<DevOpsConfigurationEntry> existingEntries) {
        if (existingEntries == null) {
            return null;
        }
        return existingEntries.stream().filter(this.isValidConfiguration).filter(entry -> entry.getToolId().equalsIgnoreCase(body.getToolId()) && entry.getInstanceUrl().equalsIgnoreCase(body.getInstanceUrl())).findFirst().orElse(null);
    }

    private String addSecretTextCredential(String secretToken, String tokenId) {
        String credId = null;
        try {
            CredentialsStore store = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance()).iterator().next();
            StringCredentials tokenExists = this.getStringCredentialForTokenIfExists(tokenId);
            StringCredentialsImpl credential = new StringCredentialsImpl(CredentialsScope.GLOBAL, tokenId, tokenId, Secret.fromString((String)secretToken));
            if (null != tokenExists) {
                store.removeCredentials(Domain.global(), (Credentials)tokenExists);
            }
            store.addCredentials(Domain.global(), (Credentials)credential);
            credId = credential.getId();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error while creating the secret credential");
        }
        return credId;
    }

    public StringCredentials getStringCredentialForTokenIfExists(String credentialsId) {
        Object dr = null;
        ItemGroup itemGroup = null;
        List lc = CredentialsProvider.lookupCredentials(StringCredentials.class, itemGroup, null, (DomainRequirement[])new DomainRequirement[]{dr});
        for (int i = 0; i < lc.size(); ++i) {
            StringCredentials sc = (StringCredentials)lc.get(i);
            if (!sc.getId().equals(credentialsId)) continue;
            return sc;
        }
        return null;
    }

    private String buildConfigurationName(DevOpsConfigurationEntity request) throws URISyntaxException {
        if (StringUtils.isBlank((String)request.getName())) {
            String domain = new URI(request.getInstanceUrl()).getHost();
            String instanceName = domain.startsWith("www.") ? domain.substring(4) : domain;
            return String.format("DevOps-%s-%s", instanceName, new Date().getTime());
        }
        return request.getName();
    }
}

