/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.DevOpsRunStatusAction;
import io.jenkins.plugins.model.DevOpsJFrogModel;
import io.jenkins.plugins.model.DevOpsPipelineGraph;
import io.jenkins.plugins.model.DevOpsPipelineNode;
import io.jenkins.plugins.model.DevOpsSecurityResultModel;
import io.jenkins.plugins.model.DevOpsSonarQubeModel;
import io.jenkins.plugins.model.DevOpsTestSummary;
import io.jenkins.plugins.utils.GenericUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class DevOpsDataApiAction {
    private static final Map<String, Field> reflectionFieldCache = new HashMap<String, Field>();

    public void handlePipelineDetailsRequest(StaplerRequest request, StaplerResponse response) throws IOException {
        String methodName = "handlePipelineDetailsRequest";
        String jobName = request.getParameter("job");
        String buildNumber = request.getParameter("build");
        String branch = request.getParameter("branch");
        GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, new String[]{"requestURL", "jobName", "branch", "buildNumber"}, new String[]{request.getRequestURI(), jobName, branch, buildNumber}, Level.INFO);
        if (GenericUtils.isEmpty(jobName) || GenericUtils.isEmpty(buildNumber)) {
            String errorMsg = "Missing required parameters: job and build";
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, errorMsg, Level.WARNING);
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode errorResult = mapper.createObjectNode();
            errorResult.put("status", "error");
            errorResult.put("code", 400);
            errorResult.put("message", errorMsg);
            response.setStatus(400);
            response.setContentType("application/json");
            response.getWriter().write(mapper.writeValueAsString((Object)errorResult));
            return;
        }
        try {
            Job job;
            if (!GenericUtils.isEmpty(branch)) {
                String fullJobPath = this.sanitizeJobPath(jobName + "/" + branch);
                GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Looking up job with fullJobPath: " + fullJobPath, Level.INFO);
                job = (Job)Jenkins.get().getItemByFullName(fullJobPath, Job.class);
                GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Accessing multibranch pipeline: " + fullJobPath, Level.INFO);
                if (job == null) {
                    String directJobPath = this.sanitizeJobPath(jobName);
                    GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Fallback lookup with direct jobPath: " + directJobPath, Level.INFO);
                    job = (Job)Jenkins.get().getItemByFullName(directJobPath, Job.class);
                }
            } else {
                String standardJobPath = this.sanitizeJobPath(jobName);
                GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Standard job lookup with path: " + standardJobPath, Level.INFO);
                job = (Job)Jenkins.get().getItemByFullName(standardJobPath, Job.class);
            }
            if (job == null) {
                String errorMsg = "Job not found: " + jobName;
                GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, errorMsg, Level.WARNING);
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode errorResult = mapper.createObjectNode();
                errorResult.put("status", "error");
                errorResult.put("code", 404);
                errorResult.put("message", errorMsg);
                response.setStatus(404);
                response.setContentType("application/json");
                response.getWriter().write(mapper.writeValueAsString((Object)errorResult));
                return;
            }
            Run run = job.getBuildByNumber(Integer.parseInt(buildNumber));
            if (run == null) {
                String errorMsg = "Build not found: " + buildNumber;
                GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, errorMsg, Level.WARNING);
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode errorResult = mapper.createObjectNode();
                errorResult.put("status", "error");
                errorResult.put("code", 404);
                errorResult.put("message", errorMsg);
                response.setStatus(404);
                response.setContentType("application/json");
                response.getWriter().write(mapper.writeValueAsString((Object)errorResult));
                return;
            }
            ObjectNode result = this.getPipelineDetailsWithTasks(run);
            result.put("status", "success");
            result.put("code", 200);
            response.setStatus(200);
            response.setContentType("application/json");
            response.getWriter().write(new ObjectMapper().writeValueAsString((Object)result));
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Successfully processed pipeline details request for job: " + jobName + ", build: " + buildNumber, Level.INFO);
        }
        catch (NumberFormatException e) {
            String errorMsg = "Invalid build number format: " + buildNumber;
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, errorMsg + ": " + e.getMessage(), Level.WARNING);
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode errorResult = mapper.createObjectNode();
            errorResult.put("status", "error");
            errorResult.put("code", 400);
            errorResult.put("message", errorMsg);
            response.setStatus(400);
            response.setContentType("application/json");
            response.getWriter().write(mapper.writeValueAsString((Object)errorResult));
        }
        catch (Exception e) {
            String errorMsg = "Error processing request: " + e.getMessage();
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, errorMsg, Level.SEVERE);
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, GenericUtils.getStackTraceAsString(e), Level.SEVERE);
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode errorResult = mapper.createObjectNode();
            errorResult.put("status", "error");
            errorResult.put("code", 500);
            errorResult.put("message", errorMsg);
            response.setStatus(500);
            response.setContentType("application/json");
            response.getWriter().write(mapper.writeValueAsString((Object)errorResult));
        }
    }

    public ObjectNode getPipelineDetailsWithTasks(Run<?, ?> run) {
        String methodName = "getPipelineDetailsWithTasks";
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode result = mapper.createObjectNode();
        try {
            DevOpsRunStatusAction action;
            String buildUrl;
            int buildNumber;
            String jobName;
            if (run == null) {
                GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Run is null", Level.WARNING);
                result.put("error", "Invalid input: run parameter is null");
                return result;
            }
            try {
                Job parent = run.getParent();
                if (parent == null) {
                    throw new NullPointerException("Run parent is null");
                }
                jobName = parent.getFullName();
                buildNumber = run.getNumber();
                buildUrl = run.getUrl();
            }
            catch (NullPointerException e) {
                GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Error getting run information: " + e.getMessage(), Level.WARNING);
                result.put("error", "Invalid job data: " + e.getMessage());
                return result;
            }
            String buildResult = "IN_PROGRESS";
            if (run.getResult() != null) {
                buildResult = run.getResult().toString();
            }
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, new String[]{"jobName", "buildNumber", "buildResult"}, new String[]{jobName, String.valueOf(buildNumber), buildResult}, Level.INFO);
            result.put("jobName", jobName);
            result.put("buildNumber", buildNumber);
            result.put("buildUrl", buildUrl);
            result.put("result", buildResult);
            result.put("url", buildUrl);
            result.put("phase", "COMPLETED");
            DevOpsRunStatusAction runStatusAction = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class);
            if (runStatusAction != null && runStatusAction.getModel() != null && runStatusAction.getModel().getPullRequestModel() != null) {
                ObjectMapper prMapper = new ObjectMapper();
                ObjectNode prNode = (ObjectNode)prMapper.valueToTree((Object)runStatusAction.getModel().getPullRequestModel());
                result.set("pullRequestModel", (JsonNode)prNode);
            }
            result.put("timestamp", String.valueOf(run.getStartTimeInMillis()));
            result.put("startDateTime", new Date(run.getStartTimeInMillis()).toString());
            if (run.getResult() != null) {
                long endTime = run.getStartTimeInMillis() + run.getDuration();
                result.put("endDateTime", new Date(endTime).toString());
            }
            String isMultiBranch = "false";
            String branchName = "";
            try {
                if (run.getParent().getParent() != null && run.getParent().getParent().getClass().getName().contains("MultiBranch")) {
                    isMultiBranch = "true";
                    branchName = run.getParent().getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            result.put("isMultiBranch", isMultiBranch);
            if (!branchName.isEmpty()) {
                result.put("branch", branchName);
            }
            ObjectNode jobModel = mapper.createObjectNode();
            jobModel.put("name", run.getParent().getName());
            jobModel.put("url", run.getParent().getAbsoluteUrl());
            result.set("jobModel", (JsonNode)jobModel);
            boolean isPipeline = run instanceof WorkflowRun;
            ObjectNode pipelineExecutionDetails = mapper.createObjectNode();
            pipelineExecutionDetails.put("url", buildUrl);
            pipelineExecutionDetails.put("number", buildNumber);
            pipelineExecutionDetails.put("phase", "COMPLETED");
            pipelineExecutionDetails.put("result", buildResult);
            pipelineExecutionDetails.set("startDateTime", result.get("startDateTime"));
            if (result.has("endDateTime")) {
                pipelineExecutionDetails.set("endDateTime", result.get("endDateTime"));
            }
            if ((action = (DevOpsRunStatusAction)run.getAction(DevOpsRunStatusAction.class)) != null) {
                GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Found DevOpsRunStatusAction for build", Level.INFO);
                DevOpsPipelineGraph pipelineGraph = action.getPipelineGraph();
                if (pipelineGraph != null) {
                    GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Processing pipeline graph nodes", Level.INFO);
                    ObjectNode pipelineGraphDetails = mapper.createObjectNode();
                    ArrayNode stagesArray = mapper.createArrayNode();
                    try {
                        Field mapField = DevOpsPipelineGraph.class.getDeclaredField("map");
                        mapField.setAccessible(true);
                        Map stageMap = (Map)mapField.get(pipelineGraph);
                        if (stageMap != null && !stageMap.isEmpty()) {
                            for (Map.Entry entry : stageMap.entrySet()) {
                                try {
                                    DevOpsPipelineNode stageNode = (DevOpsPipelineNode)entry.getValue();
                                    if (stageNode == null) continue;
                                    ObjectNode stageObject = mapper.createObjectNode();
                                    stageObject.put("id", stageNode.getId());
                                    stageObject.put("name", stageNode.getName());
                                    stageObject.put("shortName", stageNode.getShortName());
                                    stageObject.put("active", stageNode.isActive());
                                    stageObject.put("stageName", stageNode.getName());
                                    stageObject.put("pipelineName", jobName);
                                    stageObject.put("stepAssociated", stageNode.isStepAssociated());
                                    String parentId = stageNode.getParentId();
                                    if (parentId != null && !parentId.isEmpty()) {
                                        stageObject.put("parentId", parentId);
                                        stageObject.put("parentName", stageNode.getParentName());
                                        stageObject.put("parentExecutionUrl", stageNode.getParentExecutionUrl());
                                    }
                                    stageObject.put("executionUrl", stageNode.getExecutionUrl());
                                    stageObject.put("pipelineExecutionUrl", stageNode.getPipelineExecutionUrl());
                                    stageObject.put("startTime", stageNode.getStartTime());
                                    stageObject.put("duration", stageNode.getDuration());
                                    stageObject.put("changeStartTime", stageNode.getChangeStartTime());
                                    stageObject.put("changeCtrlInProgress", stageNode.isChangeCtrlInProgress());
                                    String upstreamTaskExecURL = stageNode.getUpstreamTaskExecURL();
                                    if (upstreamTaskExecURL != null && !upstreamTaskExecURL.isEmpty()) {
                                        stageObject.put("upstreamTaskExecutionURL", upstreamTaskExecURL);
                                        stageObject.put("upstreamStageName", stageNode.getUpstreamStageName());
                                    }
                                    try {
                                        Field statusField = DevOpsPipelineNode.class.getDeclaredField("stageExecutionStatus");
                                        statusField.setAccessible(true);
                                        String status = (String)statusField.get(stageNode);
                                        if (status != null && !status.isEmpty()) {
                                            stageObject.put("status", status);
                                            stageObject.put("stageExecutionStatus", status);
                                        } else {
                                            stageObject.put("status", stageNode.isStepAssociated() ? "COMPLETED" : "STARTED");
                                        }
                                    }
                                    catch (IllegalAccessException | NoSuchFieldException ex) {
                                        stageObject.put("status", stageNode.isStepAssociated() ? "COMPLETED" : "STARTED");
                                    }
                                    String stageStatusFromTag = stageNode.getStageStatusFromTag();
                                    if (stageStatusFromTag != null && !stageStatusFromTag.isEmpty()) {
                                        stageObject.put("stageStatusFromTag", stageStatusFromTag);
                                    }
                                    stageObject.put("waitForChildExecutions", parentId != null && !parentId.isEmpty() ? "true" : "false");
                                    this.addTaskResultsToStage(stageObject, stageNode.getId(), pipelineGraph, mapper);
                                    stagesArray.add((JsonNode)stageObject);
                                }
                                catch (IllegalArgumentException | NullPointerException | SecurityException ex) {
                                    GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Error processing individual pipeline node: " + ex.getMessage(), Level.WARNING);
                                }
                            }
                        }
                        pipelineGraphDetails.set("nodes", (JsonNode)stagesArray);
                        pipelineExecutionDetails.set("pipelineGraphDetails", (JsonNode)pipelineGraphDetails);
                        GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Pipeline graph details already contain stage-specific results - avoiding duplication", Level.INFO);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Error accessing field via reflection: " + e.getMessage(), Level.WARNING);
                    }
                    catch (ClassCastException | NullPointerException e) {
                        GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Error processing pipeline graph data: " + e.getMessage(), Level.WARNING);
                    }
                } else if (isPipeline) {
                    GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "No pipeline graph found in DevOpsRunStatusAction", Level.WARNING);
                    pipelineExecutionDetails.put("error", "Pipeline is either not tracked or Jenkins is not configured with proper ServiceNow Instance credentials. Please ensure Jenkins is properly configured with ServiceNow Instance credentials, verify the pipeline is tracked, and then run the pipeline again before attempting to import data.");
                } else {
                    GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Non-pipeline job detected", Level.INFO);
                    pipelineExecutionDetails.put("message", "This is not a pipeline job. Only pipeline jobs can be tracked in ServiceNow DevOps.");
                }
            } else {
                GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "No DevOpsRunStatusAction found for build", Level.WARNING);
                if (isPipeline) {
                    pipelineExecutionDetails.put("error", "ServiceNow DevOps integration plugin is not installed or configured for this Jenkins instance. Please install the ServiceNow DevOps plugin, configure it with your ServiceNow Instance credentials, and ensure pipeline tracking is enabled before attempting to import data.");
                } else {
                    pipelineExecutionDetails.put("message", "This is not a pipeline job. Only pipeline jobs can be tracked in ServiceNow DevOps.");
                }
            }
            result.set("pipelineExecutionDetails", (JsonNode)pipelineExecutionDetails);
            result.put("status", "success");
            result.put("code", 200);
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Successfully generated pipeline details", Level.INFO);
        }
        catch (NullPointerException e) {
            String errorMsg = "Error generating pipeline details (null value encountered): " + e.getMessage();
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, errorMsg, Level.SEVERE);
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, GenericUtils.getStackTraceAsString(e), Level.SEVERE);
            result.put("error", errorMsg);
        }
        catch (RuntimeException e) {
            String errorMsg = "Error generating pipeline details: " + e.getMessage();
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, errorMsg, Level.SEVERE);
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, GenericUtils.getStackTraceAsString(e), Level.SEVERE);
            result.put("error", errorMsg);
        }
        return result;
    }

    private void addTaskResultsToStage(ObjectNode stageObject, String stageNodeId, DevOpsPipelineGraph pipelineGraph, ObjectMapper mapper) {
        ArrayNode jfrogResults;
        int jfrogCount;
        int securityCount;
        int sonarCount;
        int testCount;
        ArrayNode securityResultsArray;
        ArrayNode sonarResults;
        ArrayNode testResults;
        Map<String, Field> reflectionCache;
        String methodName;
        block27: {
            methodName = "addTaskResultsToStage";
            reflectionCache = this.getReflectionCache();
            testResults = mapper.createArrayNode();
            sonarResults = mapper.createArrayNode();
            securityResultsArray = mapper.createArrayNode();
            testCount = 0;
            sonarCount = 0;
            securityCount = 0;
            jfrogCount = 0;
            jfrogResults = mapper.createArrayNode();
            try {
                Set testResultsSet;
                Field testResultsField = reflectionCache.get("jobTestResults");
                if (testResultsField == null) {
                    testResultsField = DevOpsPipelineGraph.class.getDeclaredField("jobTestResults");
                    testResultsField.setAccessible(true);
                    reflectionCache.put("jobTestResults", testResultsField);
                }
                if ((testResultsSet = (Set)testResultsField.get(pipelineGraph)) != null && !testResultsSet.isEmpty()) {
                    for (DevOpsTestSummary testSummary : testResultsSet) {
                        if (!stageNodeId.equals(testSummary.getStageNodeId())) continue;
                        ObjectNode testNode = mapper.createObjectNode();
                        testNode.put("name", testSummary.getName());
                        testNode.put("passedTests", testSummary.getPassedTests());
                        testNode.put("failedTests", testSummary.getFailedTests());
                        testNode.put("skippedTests", testSummary.getSkippedTests());
                        testNode.put("totalTests", testSummary.getTotalTests());
                        testNode.put("duration", testSummary.getDuration());
                        testNode.put("url", testSummary.getUrl());
                        testResults.add((JsonNode)testNode);
                        ++testCount;
                    }
                }
            }
            catch (Exception e) {
                GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Could not access test results: " + e.getMessage(), Level.WARNING);
            }
            try {
                Set sonarResultsSet;
                Field sonarResultsField = reflectionCache.get("jobSonarQubeModelResults");
                if (sonarResultsField == null) {
                    sonarResultsField = DevOpsPipelineGraph.class.getDeclaredField("jobSonarQubeModelResults");
                    sonarResultsField.setAccessible(true);
                    reflectionCache.put("jobSonarQubeModelResults", sonarResultsField);
                }
                if ((sonarResultsSet = (Set)sonarResultsField.get(pipelineGraph)) != null && !sonarResultsSet.isEmpty()) {
                    for (DevOpsSonarQubeModel sonarModel : sonarResultsSet) {
                        if (!stageNodeId.equals(sonarModel.getStageNodeId())) continue;
                        ObjectNode sonarNode = mapper.createObjectNode();
                        sonarNode.put("scanID", sonarModel.getScanID());
                        sonarNode.put("url", sonarModel.getUrl());
                        sonarResults.add((JsonNode)sonarNode);
                        ++sonarCount;
                    }
                }
            }
            catch (Exception e) {
                GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Could not access SonarQube results: " + e.getMessage(), Level.WARNING);
            }
            try {
                Set securityResultsSet;
                Field securityResultsField = reflectionCache.get("jobSecurityResults");
                if (securityResultsField == null) {
                    securityResultsField = DevOpsPipelineGraph.class.getDeclaredField("jobSecurityResults");
                    securityResultsField.setAccessible(true);
                    reflectionCache.put("jobSecurityResults", securityResultsField);
                }
                if ((securityResultsSet = (Set)securityResultsField.get(pipelineGraph)) == null || securityResultsSet.isEmpty()) break block27;
                for (DevOpsSecurityResultModel securityModel : securityResultsSet) {
                    if (!stageNodeId.equals(securityModel.getStageNodeId())) continue;
                    ObjectNode securityNode = mapper.createObjectNode();
                    try {
                        String attributesJson = securityModel.getSecurityResultAttributes().toString();
                        JsonNode attributesNode = mapper.readTree(attributesJson);
                        securityNode.set("attributes", attributesNode);
                    }
                    catch (Exception ex) {
                        securityNode.put("attributes", securityModel.getSecurityResultAttributes().toString());
                        GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Error parsing security attributes as JSON: " + ex.getMessage(), Level.FINE);
                    }
                    securityResultsArray.add((JsonNode)securityNode);
                    ++securityCount;
                }
            }
            catch (Exception e) {
                GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Could not access security results: " + e.getMessage(), Level.WARNING);
            }
        }
        try {
            Set jfrogResultsSet;
            Field jfrogResultsField = reflectionCache.get("jobJFrogModelResults");
            if (jfrogResultsField == null) {
                jfrogResultsField = DevOpsPipelineGraph.class.getDeclaredField("jobJFrogModelResults");
                jfrogResultsField.setAccessible(true);
                reflectionCache.put("jobJFrogModelResults", jfrogResultsField);
            }
            if ((jfrogResultsSet = (Set)jfrogResultsField.get(pipelineGraph)) != null && !jfrogResultsSet.isEmpty()) {
                for (DevOpsJFrogModel jfrogModel : jfrogResultsSet) {
                    if (!Objects.equals(stageNodeId, jfrogModel.getStageNodeId()) && jfrogModel.getStageNodeId() != null) continue;
                    ObjectNode jfrogNode = mapper.createObjectNode();
                    jfrogNode.put("buildName", jfrogModel.getBuildName());
                    jfrogNode.put("buildNumber", jfrogModel.getBuildNumber());
                    jfrogNode.put("startedTimeStamp", jfrogModel.getStartedTimeStamp());
                    jfrogNode.put("artifactoryUrl", jfrogModel.getArtifactoryUrl());
                    if (jfrogModel.getArtifactoryUrl() == null || jfrogModel.getArtifactoryUrl().isEmpty()) {
                        GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Warning: Empty artifactoryUrl for JFrog build " + jfrogModel.getBuildName() + ":" + jfrogModel.getBuildNumber(), Level.WARNING);
                    }
                    jfrogResults.add((JsonNode)jfrogNode);
                    ++jfrogCount;
                }
            }
        }
        catch (Exception e) {
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, "Could not access JFrog results: " + e.getMessage(), Level.WARNING);
        }
        if (testResults.size() > 0) {
            stageObject.set("testResults", (JsonNode)testResults);
        }
        if (sonarResults.size() > 0) {
            stageObject.set("sonarResults", (JsonNode)sonarResults);
        }
        if (securityResultsArray.size() > 0) {
            stageObject.set("securityResults", (JsonNode)securityResultsArray);
        }
        if (jfrogResults.size() > 0) {
            stageObject.set("jfrogResults", (JsonNode)jfrogResults);
        }
        if (testCount > 0 || sonarCount > 0 || securityCount > 0 || jfrogCount > 0) {
            GenericUtils.printDebug(DevOpsDataApiAction.class.getName(), methodName, String.format("Stage %s: Added %d test results, %d SonarQube results, %d security results, %d JFrog results", stageNodeId, testCount, sonarCount, securityCount, jfrogCount), Level.FINE);
        }
    }

    private String sanitizeJobPath(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.replaceAll("\\/+", "/")).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private Map<String, Field> getReflectionCache() {
        return reflectionFieldCache;
    }
}

