/*
 * Decompiled with CFR 0.152.
 */
package jp.ikedam.jenkins.plugins.scoringloadbalancer.rules;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.queue.MappingWorksheet;
import hudson.model.queue.SubTask;
import hudson.util.FormValidation;
import java.util.HashSet;
import jenkins.model.Jenkins;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.ScoringLoadBalancer;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.ScoringRule;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.rules.Messages;
import jp.ikedam.jenkins.plugins.scoringloadbalancer.util.ValidationUtil;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class BuildResultScoringRule
extends ScoringRule {
    private int numberOfBuilds;
    private int scale;
    private int scaleAdjustForOlder;
    private int scoreForSuccess;
    private int scoreForUnstable;
    private int scoreForFailure;

    public int getNumberOfBuilds() {
        return this.numberOfBuilds;
    }

    public int getScale() {
        return this.scale;
    }

    public int getScaleAdjustForOlder() {
        return this.scaleAdjustForOlder;
    }

    public int getScoreForSuccess() {
        return this.scoreForSuccess;
    }

    public int getScoreForUnstable() {
        return this.scoreForUnstable;
    }

    public int getScoreForFailure() {
        return this.scoreForFailure;
    }

    @DataBoundConstructor
    public BuildResultScoringRule(int numberOfBuilds, int scale, int scaleAdjustForOlder, int scoreForSuccess, int scoreForUnstable, int scoreForFailure) {
        this.numberOfBuilds = numberOfBuilds;
        this.scale = scale;
        this.scaleAdjustForOlder = scaleAdjustForOlder;
        this.scoreForSuccess = scoreForSuccess;
        this.scoreForUnstable = scoreForUnstable;
        this.scoreForFailure = scoreForFailure;
    }

    @Override
    public boolean updateScores(Queue.Task task, MappingWorksheet.WorkChunk wc, MappingWorksheet.Mapping m, ScoringLoadBalancer.NodesScore nodesScore) {
        for (SubTask subtask : wc) {
            if (!(subtask instanceof AbstractProject)) {
                return true;
            }
            AbstractProject project = (AbstractProject)subtask;
            HashSet<Node> nodeSet = new HashSet<Node>(nodesScore.getNodes());
            AbstractBuild build = project.getLastBuild();
            for (int pastNum = 0; pastNum < this.getNumberOfBuilds() && build != null; ++pastNum, build = build.getPreviousBuild()) {
                Node node = build.getBuiltOn();
                if (!nodeSet.contains(node)) continue;
                int scale = this.getScale() + this.getScaleAdjustForOlder() * pastNum;
                if (Result.SUCCESS == build.getResult()) {
                    nodesScore.addScore(node, this.getScoreForSuccess() * scale);
                    nodeSet.remove(node);
                    continue;
                }
                if (Result.FAILURE == build.getResult()) {
                    nodesScore.addScore(node, this.getScoreForFailure() * scale);
                    nodeSet.remove(node);
                    continue;
                }
                if (Result.UNSTABLE != build.getResult()) continue;
                nodesScore.addScore(node, this.getScoreForUnstable() * scale);
                nodeSet.remove(node);
            }
        }
        return true;
    }

    @Extension
    @Symbol(value={"buildResultScoringRule"})
    public static class DescriptorImpl
    extends Descriptor<ScoringRule> {
        public String getDisplayName() {
            return Messages.BuildResultScoringRule_DisplayName();
        }

        @POST
        public FormValidation doCheckNumberOfBuilds(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.READ);
            if (value == null || value.isBlank()) {
                return FormValidation.error((String)Messages.BuildResultScoringRule_numberOfBuilds_required());
            }
            try {
                int num = Integer.parseInt(value.trim());
                if (num <= 0) {
                    return FormValidation.error((String)Messages.BuildResultScoringRule_numberOfBuilds_invalid());
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((Throwable)e, (String)Messages.BuildResultScoringRule_numberOfBuilds_invalid());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckScale(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return ValidationUtil.doCheckInteger(value);
        }

        @POST
        public FormValidation doCheckScaleAdjustForOlder(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return ValidationUtil.doCheckInteger(value);
        }

        @POST
        public FormValidation doCheckScoreForSuccess(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return ValidationUtil.doCheckInteger(value);
        }

        @POST
        public FormValidation doCheckScoreForUnstable(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return ValidationUtil.doCheckInteger(value);
        }

        @POST
        public FormValidation doCheckScoreForFailure(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return ValidationUtil.doCheckInteger(value);
        }
    }
}

