/*
 * Decompiled with CFR 0.152.
 */
package net.plavcak.jenkins.plugins.scmskip;

import hudson.AbortException;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.scm.RunWithSCM;
import net.plavcak.jenkins.plugins.scmskip.GitMessageExtractor;
import net.plavcak.jenkins.plugins.scmskip.SCMSkipDeleteEnvironmentAction;
import net.plavcak.jenkins.plugins.scmskip.SCMSkipMatcher;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;

public class SCMSkipTools {
    private static final Logger LOGGER = Logger.getLogger(SCMSkipTools.class.getName());

    private SCMSkipTools() {
    }

    public static void deleteBuild(AbstractBuild<?, ?> build) throws IOException {
        LOGGER.log(Level.FINE, () -> "Deleting AbstractBuild: '" + build.getId() + "'");
        build.delete();
        AbstractProject project = build.getProject();
        project.updateNextBuildNumber(build.getNumber());
        project.save();
    }

    public static void deleteRun(Run<?, ?> run) throws IOException {
        LOGGER.log(Level.FINE, () -> "Deleting Run: '" + run.getId() + "'");
        run.delete();
        Job job = run.getParent();
        job.updateNextBuildNumber(run.number);
        job.save();
    }

    public static void tagRunForDeletion(Run<?, ?> run, boolean deleteBuild) throws IOException {
        LOGGER.log(Level.FINE, () -> "Build '" + run.getDisplayName() + "' set to delete: " + deleteBuild);
        run.addAction((Action)new SCMSkipDeleteEnvironmentAction(deleteBuild));
        run.save();
    }

    public static boolean isBuildToDelete(Run<?, ?> run) {
        SCMSkipDeleteEnvironmentAction action = (SCMSkipDeleteEnvironmentAction)run.getAction(SCMSkipDeleteEnvironmentAction.class);
        return action != null && action.isDeleteBuild();
    }

    public static boolean inspectChangeSetAndCause(Run<?, ?> run, SCMSkipMatcher matcher, TaskListener listener) {
        if (run.getCauses().stream().anyMatch(cause -> cause instanceof Cause.UserIdCause)) {
            return false;
        }
        if (run instanceof RunWithSCM) {
            return SCMSkipTools.inspectChangeSet(((RunWithSCM)run).getChangeSets(), matcher, listener.getLogger());
        }
        return false;
    }

    private static boolean inspectChangeSet(List<ChangeLogSet<? extends ChangeLogSet.Entry>> changeLogSets, SCMSkipMatcher matcher, PrintStream logger) {
        if (changeLogSets.isEmpty()) {
            SCMSkipTools.logEmptyChangeLog(logger);
            return false;
        }
        ChangeLogSet<? extends ChangeLogSet.Entry> changeLogSet = changeLogSets.get(changeLogSets.size() - 1);
        if (changeLogSet.isEmptySet()) {
            SCMSkipTools.logEmptyChangeLog(logger);
        }
        String notMatched = "";
        boolean allSkipped = true;
        for (ChangeLogSet.Entry entry : changeLogSet) {
            String fullMessage = SCMSkipTools.getFullMessage(entry);
            if (matcher.match(fullMessage)) continue;
            allSkipped = false;
            notMatched = fullMessage;
            break;
        }
        String commitMessage = SCMSkipTools.combineChangeLogMessages(changeLogSet);
        String logMessage = !allSkipped ? "SCM Skip: Pattern " + matcher.getPattern().pattern() + " NOT matched on message: " + notMatched : "SCM Skip: Pattern " + matcher.getPattern().pattern() + " matched on message: " + commitMessage;
        logger.println(logMessage);
        LOGGER.log(Level.FINE, logMessage);
        return allSkipped;
    }

    public static void stopBuild(Run<?, ?> run) throws IOException, ServletException, FlowInterruptedException {
        run.setDescription("SCM Skip - build skipped");
        run.setResult(Result.ABORTED);
        run.save();
        LOGGER.log(Level.FINE, () -> "Stopping build: '" + run.getId() + "'");
        if (run instanceof WorkflowRun) {
            throw new FlowInterruptedException(Result.NOT_BUILT, true, new CauseOfInterruption[]{new CauseOfInterruption(){

                public String getShortDescription() {
                    return "Skipped because of SCM message";
                }
            }});
        }
        if (!(run instanceof AbstractBuild)) {
            throw new AbortException("SCM Skip: Build has been skipped due to SCM Skip Plugin!");
        }
        AbstractBuild build = (AbstractBuild)run;
        build.doStop();
    }

    private static String combineChangeLogMessages(ChangeLogSet<?> changeLogSet) {
        return StreamSupport.stream(changeLogSet.spliterator(), false).map(SCMSkipTools::getFullMessage).collect(Collectors.joining(" "));
    }

    private static void logEmptyChangeLog(PrintStream logger) {
        logger.println("SCM Skip: Changelog is empty!");
        LOGGER.log(Level.FINE, "Changelog is empty!");
    }

    private static String getFullMessage(ChangeLogSet.Entry entry) {
        if (Jenkins.get().getPlugin("git") != null) {
            return GitMessageExtractor.getFullMessage(entry);
        }
        return entry.getMsg();
    }
}

