/*
 * Decompiled with CFR 0.152.
 */
package net.plavcak.jenkins.plugins.scmskip;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.plavcak.jenkins.plugins.scmskip.SCMSkipMatcher;
import net.plavcak.jenkins.plugins.scmskip.SCMSkipTools;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

public class SCMSkipBuildWrapper
extends BuildWrapper {
    private static final Logger LOGGER = Logger.getLogger(SCMSkipBuildWrapper.class.getName());
    private SCMSkipMatcher skipMatcher;
    private boolean deleteBuild;
    private String skipPattern;

    @DataBoundConstructor
    public SCMSkipBuildWrapper(boolean deleteBuild, String skipPattern) {
        this.deleteBuild = deleteBuild;
        this.skipPattern = skipPattern;
        if (this.skipPattern == null) {
            this.skipPattern = ".*\\[ci skip\\].*";
        }
        this.skipMatcher = new SCMSkipMatcher(this.getSkipPattern());
    }

    public boolean isDeleteBuild() {
        return this.deleteBuild;
    }

    @DataBoundSetter
    public void setDeleteBuild(boolean deleteBuild) {
        this.deleteBuild = deleteBuild;
    }

    public String getSkipPattern() {
        if (StringUtils.isEmpty((String)this.skipPattern)) {
            return this.getDescriptor().getSkipPattern();
        }
        return this.skipPattern;
    }

    @DataBoundSetter
    public void setSkipPattern(String skipPattern) {
        this.skipPattern = skipPattern;
        this.skipMatcher.setPattern(this.skipPattern);
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, FlowInterruptedException {
        if (SCMSkipTools.inspectChangeSetAndCause(build, this.skipMatcher, (TaskListener)listener)) {
            SCMSkipTools.tagRunForDeletion(build, this.deleteBuild);
            try {
                SCMSkipTools.stopBuild(build);
            }
            catch (AbortException | FlowInterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "SCM Skip Build Wrapper", e);
            }
        } else {
            SCMSkipTools.tagRunForDeletion(build, false);
        }
        return new BuildWrapper.Environment(){};
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private String skipPattern = ".*\\[ci skip\\].*";

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return "SCM Skip";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) {
            req.bindJSON((Object)this, json.getJSONObject("scmSkip"));
            this.save();
            return true;
        }

        public String getSkipPattern() {
            return this.skipPattern;
        }

        @DataBoundSetter
        public void setSkipPattern(String skipPattern) {
            this.skipPattern = skipPattern;
        }
    }
}

